/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.IndexSync;
import it.auties.whatsapp.model.sync.IndexSyncSpec;
import it.auties.whatsapp.model.sync.KeyId;
import it.auties.whatsapp.model.sync.KeyIdSpec;
import it.auties.whatsapp.model.sync.RecordSync;
import it.auties.whatsapp.model.sync.ValueSync;
import it.auties.whatsapp.model.sync.ValueSyncSpec;

public class RecordSyncSpec {
    public static byte[] encode(RecordSync protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)RecordSyncSpec.sizeOf(protoInputObject));
        RecordSyncSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(RecordSync protoInputObject, ProtobufOutputStream protoOutputStream) {
        KeyId keyId;
        ValueSync value;
        if (protoInputObject == null) {
            return;
        }
        IndexSync index = protoInputObject.index();
        if (index != null) {
            protoOutputStream.writeMessage(1, IndexSyncSpec.sizeOf(index));
            IndexSyncSpec.encode(index, protoOutputStream);
        }
        if ((value = protoInputObject.value()) != null) {
            protoOutputStream.writeMessage(2, ValueSyncSpec.sizeOf(value));
            ValueSyncSpec.encode(value, protoOutputStream);
        }
        if ((keyId = protoInputObject.keyId()) != null) {
            protoOutputStream.writeMessage(3, KeyIdSpec.sizeOf(keyId));
            KeyIdSpec.encode(keyId, protoOutputStream);
        }
    }

    public static RecordSync decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return RecordSyncSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static RecordSync decode(ProtobufInputStream protoInputStream) {
        IndexSync index = null;
        ValueSync value = null;
        KeyId keyId = null;
        block5: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    index = IndexSyncSpec.decode(protoInputStream.readLengthDelimited());
                    continue block5;
                }
                case 2: {
                    value = ValueSyncSpec.decode(protoInputStream.readLengthDelimited());
                    continue block5;
                }
                case 3: {
                    keyId = KeyIdSpec.decode(protoInputStream.readLengthDelimited());
                    continue block5;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new RecordSync(index, value, keyId);
    }

    public static int sizeOf(RecordSync protoInputObject) {
        KeyId keyId;
        ValueSync value;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        IndexSync index = protoInputObject.index();
        if (index != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int indexSerializedSize = IndexSyncSpec.sizeOf(index);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)indexSerializedSize);
            protoOutputSize += indexSerializedSize;
        }
        if ((value = protoInputObject.value()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            int valueSerializedSize = ValueSyncSpec.sizeOf(value);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)valueSerializedSize);
            protoOutputSize += valueSerializedSize;
        }
        if ((keyId = protoInputObject.keyId()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            int keyIdSerializedSize = KeyIdSpec.sizeOf(keyId);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)keyIdSerializedSize);
            protoOutputSize += keyIdSerializedSize;
        }
        return protoOutputSize;
    }
}

