/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufRepeatedMixin;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.KeyId;
import it.auties.whatsapp.model.sync.KeyIdSpec;
import it.auties.whatsapp.model.sync.RecordSync;
import it.auties.whatsapp.model.sync.RecordSyncSpec;
import it.auties.whatsapp.model.sync.SnapshotSync;
import it.auties.whatsapp.model.sync.VersionSync;
import it.auties.whatsapp.model.sync.VersionSyncSpec;
import java.nio.ByteBuffer;
import java.util.List;

public class SnapshotSyncSpec {
    public static byte[] encode(SnapshotSync protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)SnapshotSyncSpec.sizeOf(protoInputObject));
        SnapshotSyncSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(SnapshotSync protoInputObject, ProtobufOutputStream protoOutputStream) {
        KeyId keyId;
        ByteBuffer mac0;
        byte[] mac;
        if (protoInputObject == null) {
            return;
        }
        VersionSync version = protoInputObject.version();
        if (version != null) {
            protoOutputStream.writeMessage(1, VersionSyncSpec.sizeOf(version));
            VersionSyncSpec.encode(version, protoOutputStream);
        }
        if (protoInputObject.records() != null) {
            for (RecordSync recordsEntry : protoInputObject.records()) {
                if (recordsEntry == null) continue;
                protoOutputStream.writeMessage(2, RecordSyncSpec.sizeOf(recordsEntry));
                RecordSyncSpec.encode(recordsEntry, protoOutputStream);
            }
        }
        if ((mac = protoInputObject.mac()) != null && (mac0 = ProtobufLazyMixin.toValue((byte[])mac)) != null) {
            protoOutputStream.writeBytes(3, mac0);
        }
        if ((keyId = protoInputObject.keyId()) != null) {
            protoOutputStream.writeMessage(4, KeyIdSpec.sizeOf(keyId));
            KeyIdSpec.encode(keyId, protoOutputStream);
        }
    }

    public static SnapshotSync decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return SnapshotSyncSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static SnapshotSync decode(ProtobufInputStream protoInputStream) {
        VersionSync version = null;
        List records = ProtobufRepeatedMixin.newList();
        byte[] mac = null;
        KeyId keyId = null;
        block6: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    version = VersionSyncSpec.decode(protoInputStream.readLengthDelimited());
                    continue block6;
                }
                case 2: {
                    records.add(RecordSyncSpec.decode(protoInputStream.readLengthDelimited()));
                    continue block6;
                }
                case 3: {
                    mac = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block6;
                }
                case 4: {
                    keyId = KeyIdSpec.decode(protoInputStream.readLengthDelimited());
                    continue block6;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new SnapshotSync(version, records, mac, keyId);
    }

    public static int sizeOf(SnapshotSync protoInputObject) {
        KeyId keyId;
        ByteBuffer mac0;
        byte[] mac;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        VersionSync version = protoInputObject.version();
        if (version != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int versionSerializedSize = VersionSyncSpec.sizeOf(version);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)versionSerializedSize);
            protoOutputSize += versionSerializedSize;
        }
        if (protoInputObject.records() != null) {
            for (RecordSync recordsEntry : protoInputObject.records()) {
                if (recordsEntry == null) continue;
                protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
                int recordsEntrySerializedSize = RecordSyncSpec.sizeOf(recordsEntry);
                protoOutputSize += ProtobufOutputStream.getVarIntSize((long)recordsEntrySerializedSize);
                protoOutputSize += recordsEntrySerializedSize;
            }
        }
        if ((mac = protoInputObject.mac()) != null && (mac0 = ProtobufLazyMixin.toValue((byte[])mac)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)mac0);
        }
        if ((keyId = protoInputObject.keyId()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            int keyIdSerializedSize = KeyIdSpec.sizeOf(keyId);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)keyIdSerializedSize);
            protoOutputSize += keyIdSerializedSize;
        }
        return protoOutputSize;
    }
}

