/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.StickerMetadata;
import java.nio.ByteBuffer;

public class StickerMetadataSpec {
    public static byte[] encode(StickerMetadata protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)StickerMetadataSpec.sizeOf(protoInputObject));
        StickerMetadataSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(StickerMetadata protoInputObject, ProtobufOutputStream protoOutputStream) {
        ProtobufString directPath0;
        ProtobufString mimetype0;
        String mimetype;
        ByteBuffer mediaKey0;
        byte[] mediaKey;
        ByteBuffer fileEncSha2560;
        byte[] fileEncSha256;
        ByteBuffer fileSha2560;
        byte[] fileSha256;
        ProtobufString url0;
        if (protoInputObject == null) {
            return;
        }
        String url = protoInputObject.url();
        if (url != null && (url0 = ProtobufLazyMixin.toValue((String)url)) != null) {
            protoOutputStream.writeString(1, url0);
        }
        if ((fileSha256 = protoInputObject.fileSha256()) != null && (fileSha2560 = ProtobufLazyMixin.toValue((byte[])fileSha256)) != null) {
            protoOutputStream.writeBytes(2, fileSha2560);
        }
        if ((fileEncSha256 = protoInputObject.fileEncSha256()) != null && (fileEncSha2560 = ProtobufLazyMixin.toValue((byte[])fileEncSha256)) != null) {
            protoOutputStream.writeBytes(3, fileEncSha2560);
        }
        if ((mediaKey = protoInputObject.mediaKey()) != null && (mediaKey0 = ProtobufLazyMixin.toValue((byte[])mediaKey)) != null) {
            protoOutputStream.writeBytes(4, mediaKey0);
        }
        if ((mimetype = protoInputObject.mimetype()) != null && (mimetype0 = ProtobufLazyMixin.toValue((String)mimetype)) != null) {
            protoOutputStream.writeString(5, mimetype0);
        }
        int height = protoInputObject.height();
        protoOutputStream.writeUInt32(6, Integer.valueOf(height));
        int width = protoInputObject.width();
        protoOutputStream.writeUInt32(7, Integer.valueOf(width));
        String directPath = protoInputObject.directPath();
        if (directPath != null && (directPath0 = ProtobufLazyMixin.toValue((String)directPath)) != null) {
            protoOutputStream.writeString(8, directPath0);
        }
        long fileLength = protoInputObject.fileLength();
        protoOutputStream.writeUInt64(9, Long.valueOf(fileLength));
        float weight = protoInputObject.weight();
        protoOutputStream.writeFloat(10, Float.valueOf(weight));
        long lastStickerSentTs = protoInputObject.lastStickerSentTs();
        protoOutputStream.writeInt64(11, Long.valueOf(lastStickerSentTs));
    }

    public static StickerMetadata decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return StickerMetadataSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static StickerMetadata decode(ProtobufInputStream protoInputStream) {
        String url = null;
        byte[] fileSha256 = null;
        byte[] fileEncSha256 = null;
        byte[] mediaKey = null;
        String mimetype = null;
        int height = 0;
        int width = 0;
        String directPath = null;
        long fileLength = 0L;
        float weight = 0.0f;
        long lastStickerSentTs = 0L;
        block13: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    url = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block13;
                }
                case 2: {
                    fileSha256 = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block13;
                }
                case 3: {
                    fileEncSha256 = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block13;
                }
                case 4: {
                    mediaKey = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block13;
                }
                case 5: {
                    mimetype = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block13;
                }
                case 6: {
                    height = protoInputStream.readInt32();
                    continue block13;
                }
                case 7: {
                    width = protoInputStream.readInt32();
                    continue block13;
                }
                case 8: {
                    directPath = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block13;
                }
                case 9: {
                    fileLength = protoInputStream.readInt64();
                    continue block13;
                }
                case 10: {
                    weight = protoInputStream.readFloat();
                    continue block13;
                }
                case 11: {
                    lastStickerSentTs = protoInputStream.readInt64();
                    continue block13;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new StickerMetadata(url, fileSha256, fileEncSha256, mediaKey, mimetype, height, width, directPath, fileLength, weight, lastStickerSentTs);
    }

    public static int sizeOf(StickerMetadata protoInputObject) {
        ProtobufString directPath0;
        ProtobufString mimetype0;
        String mimetype;
        ByteBuffer mediaKey0;
        byte[] mediaKey;
        ByteBuffer fileEncSha2560;
        byte[] fileEncSha256;
        ByteBuffer fileSha2560;
        byte[] fileSha256;
        ProtobufString url0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        String url = protoInputObject.url();
        if (url != null && (url0 = ProtobufLazyMixin.toValue((String)url)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)url0);
        }
        if ((fileSha256 = protoInputObject.fileSha256()) != null && (fileSha2560 = ProtobufLazyMixin.toValue((byte[])fileSha256)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)fileSha2560);
        }
        if ((fileEncSha256 = protoInputObject.fileEncSha256()) != null && (fileEncSha2560 = ProtobufLazyMixin.toValue((byte[])fileEncSha256)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)fileEncSha2560);
        }
        if ((mediaKey = protoInputObject.mediaKey()) != null && (mediaKey0 = ProtobufLazyMixin.toValue((byte[])mediaKey)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)mediaKey0);
        }
        if ((mimetype = protoInputObject.mimetype()) != null && (mimetype0 = ProtobufLazyMixin.toValue((String)mimetype)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)mimetype0);
        }
        int height = protoInputObject.height();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)height);
        int width = protoInputObject.width();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)width);
        String directPath = protoInputObject.directPath();
        if (directPath != null && (directPath0 = ProtobufLazyMixin.toValue((String)directPath)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)directPath0);
        }
        long fileLength = protoInputObject.fileLength();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)9, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)fileLength);
        float weight = protoInputObject.weight();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)10, (int)5);
        protoOutputSize += 4;
        long lastStickerSentTs = protoInputObject.lastStickerSentTs();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)11, (int)0);
        return protoOutputSize += ProtobufOutputStream.getVarIntSize((long)lastStickerSentTs);
    }
}

