/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.sync.SyncActionMessage;

public class SyncActionMessageSpec {
    public static byte[] encode(SyncActionMessage protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)SyncActionMessageSpec.sizeOf(protoInputObject));
        SyncActionMessageSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(SyncActionMessage protoInputObject, ProtobufOutputStream protoOutputStream) {
        Long timestamp;
        if (protoInputObject == null) {
            return;
        }
        ChatMessageKey key = protoInputObject.key();
        if (key != null) {
            protoOutputStream.writeMessage(1, ChatMessageKeySpec.sizeOf(key));
            ChatMessageKeySpec.encode(key, protoOutputStream);
        }
        if ((timestamp = protoInputObject.timestamp()) != null) {
            protoOutputStream.writeInt64(2, timestamp);
        }
    }

    public static SyncActionMessage decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return SyncActionMessageSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static SyncActionMessage decode(ProtobufInputStream protoInputStream) {
        ChatMessageKey key = null;
        Long timestamp = null;
        block4: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    key = ChatMessageKeySpec.decode(protoInputStream.readLengthDelimited());
                    continue block4;
                }
                case 2: {
                    timestamp = protoInputStream.readInt64();
                    continue block4;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new SyncActionMessage(key, timestamp);
    }

    public static int sizeOf(SyncActionMessage protoInputObject) {
        Long timestamp;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        ChatMessageKey key = protoInputObject.key();
        if (key != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int keySerializedSize = ChatMessageKeySpec.sizeOf(key);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)keySerializedSize);
            protoOutputSize += keySerializedSize;
        }
        if ((timestamp = protoInputObject.timestamp()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)timestamp);
        }
        return protoOutputSize;
    }
}

