/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.registration;

import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.crypto.MD5;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateBuilder;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetails;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetailsBuilder;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetailsSpec;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.util.Json;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HexFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class WhatsappMetadata {
    private static final Version MOBILE_BUSINESS_IOS_VERSION = Version.of("2.24.16.78");
    private static final Version MOBILE_PERSONAL_IOS_VERSION = Version.of("2.24.17.71");
    private static final URI WEB_UPDATE_URL = URI.create("https://web.whatsapp.com/check-update?version=2.2245.9&platform=web");
    private static final String MOBILE_IOS_STATIC = "0a1mLfGUIBVrMKF1RdvLI5lkRBvof6vn0fD2QRSM";
    private static final String MOBILE_BUSINESS_IOS_STATIC = "USUDuDYDeQhY4RF2fCSp5m3F6kJ1M2J8wS7bbNA2";
    private static volatile Version webVersion;

    public static CompletableFuture<Version> getVersion(UserAgent.PlatformType platform) {
        return switch (platform) {
            case UserAgent.PlatformType.WEB, UserAgent.PlatformType.WINDOWS, UserAgent.PlatformType.MACOS -> WhatsappMetadata.getWebVersion();
            case UserAgent.PlatformType.IOS -> CompletableFuture.completedFuture(MOBILE_PERSONAL_IOS_VERSION);
            case UserAgent.PlatformType.IOS_BUSINESS -> CompletableFuture.completedFuture(MOBILE_BUSINESS_IOS_VERSION);
            default -> throw new IllegalStateException("Unsupported mobile os: " + String.valueOf((Object)platform));
        };
    }

    private static CompletableFuture<Version> getWebVersion() {
        if (webVersion != null) {
            return CompletableFuture.completedFuture(webVersion);
        }
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(WEB_UPDATE_URL).build();
            CompletionStage completionStage = client.sendAsync(request, HttpResponse.BodyHandlers.ofByteArray()).thenApplyAsync(response -> {
                WebVersionResponse webVersionResponse = Json.readValue((byte[])response.body(), WebVersionResponse.class);
                webVersion = Version.of(webVersionResponse.currentVersion());
                return webVersion;
            });
            return completionStage;
        }
    }

    public static CompletableFuture<String> getToken(long phoneNumber, UserAgent.PlatformType platform, Version appVersion) {
        switch (platform) {
            case IOS: 
            case IOS_BUSINESS: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mobile os: " + String.valueOf((Object)platform));
            }
        }
        return WhatsappMetadata.getIosToken(phoneNumber, appVersion, platform.isBusiness());
    }

    private static CompletableFuture<String> getIosToken(long phoneNumber, Version version, boolean business) {
        String staticToken = business ? MOBILE_BUSINESS_IOS_STATIC : MOBILE_IOS_STATIC;
        String token = staticToken + HexFormat.of().formatHex(version.toHash()) + phoneNumber;
        return CompletableFuture.completedFuture(HexFormat.of().formatHex(MD5.calculate(token)));
    }

    public static String generateBusinessCertificate(Keys keys) {
        BusinessVerifiedNameDetails details = new BusinessVerifiedNameDetailsBuilder().name("").issuer("smb:wa").serial(Math.abs(new SecureRandom().nextLong())).build();
        byte[] encodedDetails = BusinessVerifiedNameDetailsSpec.encode(details);
        BusinessVerifiedNameCertificate certificate = new BusinessVerifiedNameCertificateBuilder().encodedDetails(encodedDetails).signature(Curve25519.sign((byte[])keys.identityKeyPair().privateKey(), (byte[])encodedDetails, (boolean)true)).build();
        return Base64.getUrlEncoder().encodeToString(BusinessVerifiedNameCertificateSpec.encode(certificate));
    }

    private record WebVersionResponse(@JsonProperty(value="isBroken") boolean broken, @JsonProperty(value="isBelowSoft") boolean outdatedSoft, @JsonProperty(value="isBelowHard") boolean outdatedHard, @JsonProperty(value="hardUpdateTime") long outdatedUpdateTime, @JsonProperty(value="beta") String beta, @JsonProperty(value="currentVersion") String currentVersion) {
    }
}

