/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ConcurrentLinkedSet<E>
extends AbstractCollection<E>
implements Set<E>,
Deque<E> {
    private Node<E> head;
    private Node<E> tail;
    private final ReentrantLock lock;
    private final Set<Integer> hashes = ConcurrentHashMap.newKeySet();

    public ConcurrentLinkedSet() {
        this.lock = new ReentrantLock(true);
    }

    @Override
    public void push(E e) {
        this.add(e);
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.add(e);
    }

    @Override
    public void addLast(E message) {
        this.add(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        try {
            this.lock.lock();
            int hash = Objects.hashCode(e);
            if (this.hashes.contains(hash)) {
                boolean bl = false;
                return bl;
            }
            Node<E> newNode = new Node<E>(e);
            if (this.tail == null) {
                this.head = newNode;
            } else {
                this.tail.next = newNode;
                newNode.prev = this.tail;
            }
            this.tail = newNode;
            this.hashes.add(hash);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFirst(E message) {
        try {
            this.lock.lock();
            int hash = Objects.hashCode(message);
            if (this.hashes.contains(hash)) {
                return;
            }
            Node<E> newNode = new Node<E>(message);
            if (this.head == null) {
                this.tail = newNode;
            } else {
                this.head.prev = newNode;
                newNode.next = this.head;
            }
            this.head = newNode;
            this.hashes.add(hash);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E removeLast() {
        return this.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        try {
            this.lock.lock();
            int hash = Objects.hashCode(o);
            if (!this.hashes.contains(hash)) {
                boolean bl = false;
                return bl;
            }
            Node<E> node = this.head;
            while (node != null) {
                if (node.item.equals(o)) {
                    this.removeNode(node, hash);
                    boolean bl = true;
                    return bl;
                }
                node = node.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        try {
            if (collection.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            this.lock.lock();
            Set hashCodes = collection.stream().map(Objects::hashCode).collect(Collectors.toSet());
            Node<E> node = this.head;
            while (node != null && !hashCodes.isEmpty()) {
                int hash = Objects.hashCode(node.item);
                if (hashCodes.remove(hash)) {
                    this.removeNode(node, hash);
                }
                node = node.next;
            }
            boolean bl = hashCodes.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFirstOccurrence(Object o) {
        try {
            this.lock.lock();
            Node<E> node = this.head;
            while (node != null) {
                if (node.item.equals(o)) {
                    int hash = Objects.hashCode(node.item);
                    this.removeNode(node, hash);
                    boolean bl = true;
                    return bl;
                }
                node = node.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        try {
            this.lock.lock();
            Node<E> node = this.tail;
            while (node != null) {
                if (filter.test(node.item)) {
                    int hash = Objects.hashCode(node.item);
                    this.removeNode(node, hash);
                    boolean bl = true;
                    return bl;
                }
                node = node.prev;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object o) {
        try {
            this.lock.lock();
            Node<E> node = this.tail;
            while (node != null) {
                if (node.item.equals(o)) {
                    int hash = Objects.hashCode(node.item);
                    this.removeNode(node, hash);
                    boolean bl = true;
                    return bl;
                }
                node = node.prev;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E poll() {
        return this.remove();
    }

    @Override
    public E pollLast() {
        return this.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove() {
        try {
            this.lock.lock();
            Node<E> tailItem = this.tail;
            if (tailItem == null) {
                E e = null;
                return e;
            }
            if (this.head == this.tail) {
                this.head = tailItem.prev;
            }
            Object result = this.tail.item;
            this.hashes.remove(Objects.hashCode(result));
            this.tail = tailItem.prev;
            Object e = result;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeNode(Node<E> node, int hash) {
        try {
            this.lock.lock();
            if (node == this.head) {
                if (this.head == this.tail) {
                    this.tail = this.head.prev;
                }
                this.head = this.head.next;
            } else if (node == this.tail) {
                this.tail = this.tail.next;
            } else {
                node.prev.next = node.next;
                node.next.prev = node.prev;
            }
            this.hashes.remove(hash);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E pollFirst() {
        return this.removeFirst();
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public E removeFirst() {
        try {
            this.lock.lock();
            if (this.head == this.tail) {
                this.tail = this.head.prev;
            }
            Object result = this.head.item;
            this.hashes.remove(Objects.hashCode(result));
            this.head = this.head.next;
            Object e = result;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.hashes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public boolean contains(Object o) {
        return this.hashes.contains(Objects.hashCode(o));
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Node<E> nextNode;
            {
                this.nextNode = ConcurrentLinkedSet.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.nextNode != null;
            }

            @Override
            public E next() {
                if (this.nextNode == null) {
                    throw new NoSuchElementException();
                }
                Object item = this.nextNode.item;
                this.nextNode = this.nextNode.next;
                return item;
            }
        };
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new Iterator<E>(){
            private Node<E> previousNode;
            {
                this.previousNode = ConcurrentLinkedSet.this.tail;
            }

            @Override
            public boolean hasNext() {
                return this.previousNode != null;
            }

            @Override
            public E next() {
                if (this.previousNode == null) {
                    throw new NoSuchElementException();
                }
                Object item = this.previousNode.item;
                this.previousNode = this.previousNode.prev;
                return item;
            }
        };
    }

    @Override
    public E element() {
        return this.peek();
    }

    @Override
    public E peekFirst() {
        return this.peek();
    }

    @Override
    public E peek() {
        try {
            this.lock.lock();
            if (this.head == null) {
                E e = null;
                return e;
            }
            Object e = this.head.item;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E peekLast() {
        try {
            this.lock.lock();
            if (this.tail == null) {
                E e = null;
                return e;
            }
            Object e = this.tail.item;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E getFirst() {
        try {
            this.lock.lock();
            if (this.head == null) {
                throw new NoSuchElementException();
            }
            Object e = this.head.item;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E getLast() {
        try {
            this.lock.lock();
            if (this.tail == null) {
                throw new NoSuchElementException();
            }
            Object e = this.tail.item;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.lock();
            this.tail = null;
            this.head = null;
            this.hashes.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class Node<E> {
        final E item;
        Node<E> next;
        Node<E> prev;

        Node(E item) {
            this.item = item;
        }
    }
}

