/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import com.aspose.words.Document;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.SaveOptions;
import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffmpeg.FFmpeg;
import com.github.kokorin.jaffree.ffmpeg.Input;
import com.github.kokorin.jaffree.ffmpeg.Output;
import com.github.kokorin.jaffree.ffmpeg.PipeInput;
import com.github.kokorin.jaffree.ffmpeg.PipeOutput;
import com.github.kokorin.jaffree.ffprobe.FFprobe;
import com.github.kokorin.jaffree.ffprobe.FFprobeResult;
import it.auties.whatsapp.crypto.AesCbc;
import it.auties.whatsapp.crypto.Hmac;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.exception.HmacValidationException;
import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.model.media.MediaConnection;
import it.auties.whatsapp.model.media.MediaDimensions;
import it.auties.whatsapp.model.media.MediaFile;
import it.auties.whatsapp.model.media.MediaKeys;
import it.auties.whatsapp.model.media.MediaUpload;
import it.auties.whatsapp.model.media.MutableAttachmentProvider;
import it.auties.whatsapp.util.Bytes;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.Validate;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;

public final class Medias {
    public static final String WEB_ORIGIN = "https://web.whatsapp.com";
    private static final String MOBILE_ANDROID_USER_AGENT = "Mozilla/5.0 (Linux; Android 13) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.5735.57 Mobile Safari/537.36";
    private static final int WAVEFORM_SAMPLES = 64;
    private static final int PROFILE_PIC_SIZE = 640;
    private static final String DEFAULT_HOST = "mmg.whatsapp.net";
    private static final int THUMBNAIL_SIZE = 32;
    private static volatile HttpClient httpClient;
    private static final Object httpClientLock;

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] getProfilePic(byte[] file) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(file);){
            byte[] byArray;
            BufferedImage inputImage = ImageIO.read(inputStream);
            Image scaledImage = inputImage.getScaledInstance(640, 640, 4);
            BufferedImage outputImage = new BufferedImage(640, 640, 1);
            Graphics2D graphics2D = outputImage.createGraphics();
            graphics2D.drawImage(scaledImage, 0, 0, null);
            graphics2D.dispose();
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)outputImage, "jpg", outputStream);
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (Throwable exception) {
            return file;
        }
    }

    @SafeVarargs
    public static CompletableFuture<byte[]> downloadAsync(URI uri, Map.Entry<String, String> ... headers) {
        return Medias.downloadAsync(uri, MOBILE_ANDROID_USER_AGENT, headers);
    }

    @SafeVarargs
    public static CompletableFuture<byte[]> downloadAsync(URI uri, String userAgent, Map.Entry<String, String> ... headers) {
        if (uri == null) {
            return CompletableFuture.completedFuture(null);
        }
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(uri);
        if (userAgent != null) {
            request.header("User-Agent", userAgent);
        }
        for (Map.Entry<String, String> header : headers) {
            request.header(header.getKey(), header.getValue());
        }
        return Medias.getOrCreateClient().sendAsync(request.build(), HttpResponse.BodyHandlers.ofByteArray()).thenApplyAsync(HttpResponse::body);
    }

    public static CompletableFuture<MediaFile> upload(byte[] file, AttachmentType type, MediaConnection mediaConnection, String userAgent, URI proxy) {
        String auth = URLEncoder.encode(mediaConnection.auth(), StandardCharsets.UTF_8);
        byte[] uploadData = type.inflatable() ? Bytes.compress(file) : file;
        MediaFile mediaFile = Medias.prepareMediaFile(type, uploadData);
        String path = type.path().orElseThrow(() -> new UnsupportedOperationException(String.valueOf((Object)type) + " cannot be uploaded"));
        String token = Base64.getUrlEncoder().withoutPadding().encodeToString(Objects.requireNonNullElse(mediaFile.fileEncSha256(), mediaFile.fileSha256()));
        URI uri = URI.create("https://%s/%s/%s?auth=%s&token=%s".formatted(DEFAULT_HOST, path, token, auth, token));
        byte[] body = Objects.requireNonNullElse(mediaFile.encryptedFile(), file);
        HttpRequest.Builder request = HttpRequest.newBuilder().uri(uri).POST(HttpRequest.BodyPublishers.ofByteArray(body));
        if (userAgent != null) {
            request.header("User-Agent", userAgent);
        }
        request.header("Content-Type", "application/octet-stream").header("Accept", "application/json").headers("Origin", WEB_ORIGIN).build();
        return Medias.getOrCreateClient().sendAsync(request.build(), HttpResponse.BodyHandlers.ofByteArray()).thenApplyAsync(response -> {
            MediaUpload upload = Json.readValue((byte[])response.body(), MediaUpload.class);
            return new MediaFile(mediaFile.encryptedFile(), mediaFile.fileSha256(), mediaFile.fileEncSha256(), mediaFile.mediaKey(), mediaFile.fileLength(), upload.directPath(), upload.url(), upload.handle(), mediaFile.timestamp());
        });
    }

    private static MediaFile prepareMediaFile(AttachmentType type, byte[] uploadData) {
        byte[] fileSha256 = Sha256.calculate(uploadData);
        if (type.keyName().isEmpty()) {
            return new MediaFile(null, fileSha256, null, null, uploadData.length, null, null, null, null);
        }
        MediaKeys keys = MediaKeys.random(type.keyName().orElseThrow());
        byte[] encryptedMedia = AesCbc.encrypt(keys.iv(), uploadData, keys.cipherKey());
        byte[] hmac = Medias.calculateMac(encryptedMedia, keys);
        byte[] encrypted = Bytes.concat(encryptedMedia, hmac);
        byte[] fileEncSha256 = Sha256.calculate(encrypted);
        return new MediaFile(encrypted, fileSha256, fileEncSha256, keys.mediaKey(), uploadData.length, null, null, null, Clock.nowSeconds());
    }

    private static byte[] calculateMac(byte[] encryptedMedia, MediaKeys keys) {
        byte[] hmacInput = Bytes.concat(keys.iv(), encryptedMedia);
        byte[] hmac = Hmac.calculateSha256(hmacInput, keys.macKey());
        return Arrays.copyOf(hmac, 10);
    }

    public static CompletableFuture<Optional<byte[]>> downloadAsync(MutableAttachmentProvider<?> provider) {
        return provider.mediaUrl().or(() -> provider.mediaDirectPath().map(Medias::createMediaUrl)).map(url -> {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
            return Medias.getOrCreateClient().sendAsync(request, HttpResponse.BodyHandlers.ofByteArray()).thenApplyAsync(response -> Medias.handleResponse(provider, (byte[])response.body()));
        }).orElseGet(() -> CompletableFuture.failedFuture(new NoSuchElementException("Missing url and path from media")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpClient getOrCreateClient() {
        if (httpClient != null) {
            return httpClient;
        }
        Object object = httpClientLock;
        synchronized (object) {
            if (httpClient != null) {
                return httpClient;
            }
            httpClient = HttpClient.newHttpClient();
            return httpClient;
        }
    }

    public static String createMediaUrl(String directPath) {
        return "https://%s%s".formatted(DEFAULT_HOST, directPath);
    }

    private static Optional<byte[]> handleResponse(MutableAttachmentProvider<?> provider, byte[] body) {
        byte[] sha256 = Sha256.calculate(body);
        Validate.isTrue(provider.mediaEncryptedSha256().isEmpty() || Arrays.equals(sha256, provider.mediaEncryptedSha256().get()), "Cannot decode media: Invalid sha256 signature", SecurityException.class, new Object[0]);
        byte[] encryptedMedia = Arrays.copyOf(body, body.length - 10);
        byte[] mediaMac = Arrays.copyOfRange(body, body.length - 10, body.length);
        Optional<String> keyName = provider.attachmentType().keyName();
        if (keyName.isEmpty()) {
            return Optional.of(encryptedMedia);
        }
        Optional<byte[]> mediaKey = provider.mediaKey();
        if (mediaKey.isEmpty()) {
            return Optional.of(encryptedMedia);
        }
        MediaKeys keys = MediaKeys.of(mediaKey.get(), keyName.get());
        byte[] hmac = Medias.calculateMac(encryptedMedia, keys);
        Validate.isTrue(Arrays.equals(hmac, mediaMac), "media_decryption", HmacValidationException.class, new Object[0]);
        byte[] decrypted = AesCbc.decrypt(keys.iv(), encryptedMedia, keys.cipherKey());
        return Optional.of(decrypted);
    }

    public static Optional<String> getMimeType(String name) {
        return Medias.getExtension(name).map(extension -> Path.of("bogus%s".formatted(extension), new String[0])).flatMap(Medias::getMimeType);
    }

    private static Optional<String> getExtension(String name) {
        if (name == null) {
            return Optional.empty();
        }
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return Optional.empty();
        }
        return Optional.of(name.substring(index));
    }

    public static Optional<String> getMimeType(Path path) {
        try {
            return Optional.ofNullable(Files.probeContentType(path));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    public static Optional<String> getMimeType(byte[] media) {
        try {
            return Optional.ofNullable(URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(media)));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    public static OptionalInt getPagesCount(byte[] file) {
        try {
            Document document = new Document((InputStream)new ByteArrayInputStream(file));
            return OptionalInt.of(document.getPageCount());
        }
        catch (Throwable ignored) {
            return OptionalInt.empty();
        }
    }

    public static int getDuration(byte[] file) {
        try {
            FFprobeResult result = FFprobe.atPath().setShowEntries("format=duration").setSelectStreams(StreamType.VIDEO).setInput((InputStream)new ByteArrayInputStream(file)).execute();
            return Math.round(result.getFormat().getDuration().floatValue());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public static MediaDimensions getDimensions(byte[] file, boolean video) {
        try {
            if (!video) {
                BufferedImage originalImage = ImageIO.read(new ByteArrayInputStream(file));
                return new MediaDimensions(originalImage.getWidth(), originalImage.getHeight());
            }
            FFprobeResult result = FFprobe.atPath().setShowEntries("stream=width,height").setSelectStreams(StreamType.VIDEO).setInput((InputStream)new ByteArrayInputStream(file)).execute();
            return result.getStreams().stream().filter(entry -> entry.getCodecType() == StreamType.VIDEO).findFirst().map(stream -> new MediaDimensions(stream.getWidth(), stream.getHeight())).orElseGet(MediaDimensions::defaultDimensions);
        }
        catch (Exception throwable) {
            return MediaDimensions.defaultDimensions();
        }
    }

    public static Optional<byte[]> getDocumentThumbnail(byte[] file) {
        Optional<byte[]> optional;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            Document document = new Document((InputStream)new ByteArrayInputStream(file));
            ImageSaveOptions options = new ImageSaveOptions(104);
            document.save((OutputStream)stream, (SaveOptions)options);
            optional = Optional.of(stream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable ignored) {
                return Optional.empty();
            }
        }
        stream.close();
        return optional;
    }

    public static Optional<byte[]> getImageThumbnail(byte[] file, boolean jpg) {
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(file));
            if (image == null) {
                return Optional.empty();
            }
            int type = image.getType() == 0 ? 2 : image.getType();
            BufferedImage resizedImage = new BufferedImage(32, 32, type);
            Graphics2D graphics = resizedImage.createGraphics();
            graphics.drawImage(image, 0, 0, 32, 32, null);
            graphics.dispose();
            graphics.setComposite(AlphaComposite.Src);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)resizedImage, jpg ? "jpg" : "png", outputStream);
            return Optional.of(outputStream.toByteArray());
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    public static Optional<byte[]> getVideoThumbnail(byte[] file) {
        Optional<byte[]> optional;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            FFmpeg.atPath().addInput((Input)PipeInput.pumpFrom((InputStream)new ByteArrayInputStream(file))).setFilter(StreamType.VIDEO, "scale=%s:-1".formatted(32)).addOutput((Output)((PipeOutput)((PipeOutput)((PipeOutput)PipeOutput.pumpTo((OutputStream)outputStream).setFrameCount(StreamType.VIDEO, Long.valueOf(1L))).setFormat("image2")).disableStream(StreamType.AUDIO)).disableStream(StreamType.SUBTITLE)).execute();
            optional = Optional.of(outputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                return Optional.empty();
            }
        }
        outputStream.close();
        return optional;
    }

    public static Optional<byte[]> getAudioWaveForm(byte[] audioData) {
        try {
            float[] rawData = Medias.toFloatArray(audioData);
            int blockSize = rawData.length / 64;
            List<Integer> filteredData = IntStream.range(0, 64).map(i -> blockSize * i).map(blockStart -> IntStream.range(0, blockSize).map(j -> (int)Math.abs(rawData[blockStart + j])).sum()).mapToObj(sum -> sum / blockSize).toList();
            double multiplier = Math.pow(Collections.max(filteredData).intValue(), -1.0);
            List<Byte> normalizedData = filteredData.stream().map(data -> (byte)Math.abs((double)(100 * data) * multiplier)).toList();
            byte[] waveform = new byte[normalizedData.size()];
            for (int i2 = 0; i2 < normalizedData.size(); ++i2) {
                waveform[i2] = normalizedData.get(i2);
            }
            return Optional.of(waveform);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    private static float[] toFloatArray(byte[] audioData) {
        float[] rawData = new float[audioData.length / 4];
        ByteBuffer.wrap(audioData).asFloatBuffer().get(rawData);
        return rawData;
    }

    static {
        httpClientLock = new Object();
    }
}

