/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import it.auties.whatsapp.util.Validate;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Objects;
import java.util.OptionalInt;

public final class Proxies {
    public static ProxySelector toProxySelector(URI uri) {
        if (uri == null) {
            return null;
        }
        String scheme = Objects.requireNonNull(uri.getScheme(), "Invalid proxy, expected a scheme: %s".formatted(uri));
        Validate.isTrue(scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https"), "Only HTTP and HTTPS proxies are supported in this context", new Object[0]);
        String host = Objects.requireNonNull(uri.getHost(), "Invalid proxy, expected a host: %s".formatted(uri));
        int port = Proxies.getDefaultPort(scheme, uri.getPort()).orElseThrow(() -> new NullPointerException("Invalid proxy, expected a port: %s".formatted(uri)));
        return ProxySelector.of(InetSocketAddress.createUnresolved(host, port));
    }

    public static Proxy toProxy(URI uri) {
        if (uri == null) {
            return Proxy.NO_PROXY;
        }
        String scheme = Objects.requireNonNull(uri.getScheme(), "Invalid proxy, expected a scheme: %s".formatted(uri));
        String host = Objects.requireNonNull(uri.getHost(), "Invalid proxy, expected a host: %s".formatted(uri));
        int port = Proxies.getDefaultPort(scheme, uri.getPort()).orElseThrow(() -> new NullPointerException("Invalid proxy, expected a port: %s".formatted(uri)));
        return switch (scheme.toLowerCase()) {
            case "http", "https" -> new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(host, port));
            case "socks5", "socks5h" -> new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved(host, port));
            default -> throw new IllegalStateException("Unexpected scheme: " + scheme);
        };
    }

    private static OptionalInt getDefaultPort(String scheme, int port) {
        OptionalInt optionalInt;
        if (port != -1) {
            optionalInt = OptionalInt.of(port);
        } else {
            switch (scheme.toLowerCase()) {
                case "http": {
                    optionalInt = OptionalInt.of(80);
                    break;
                }
                case "https": {
                    optionalInt = OptionalInt.of(443);
                    break;
                }
                default: {
                    optionalInt = OptionalInt.empty();
                }
            }
        }
        return optionalInt;
    }

    public static UserInfo parseUserInfo(String userInfo) {
        if (userInfo == null || userInfo.isEmpty()) {
            return null;
        }
        String[] data = userInfo.split(":", 2);
        if (data.length > 2) {
            throw new IllegalArgumentException("Invalid proxy authentication: " + userInfo);
        }
        return new UserInfo(data[0], data.length == 2 ? data[1] : "");
    }

    public static Authenticator toAuthenticator(final URI proxy) {
        if (proxy == null) {
            return null;
        }
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                Validate.isTrue(Objects.equals(this.getRequestingHost(), proxy.getHost()) && Objects.equals(this.getRequestingPort(), proxy.getPort()), "Unexpected proxy request: %s:%s", this.getRequestingHost(), this.getRequestingPort());
                UserInfo userInfo = Proxies.parseUserInfo(proxy.getUserInfo());
                if (userInfo == null) {
                    return null;
                }
                return new PasswordAuthentication(userInfo.username(), userInfo.password().toCharArray());
            }
        };
    }

    static {
        System.setProperty("jdk.http.auth.proxying.disabledSchemes", "");
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
    }

    public record UserInfo(String username, String password) {
    }
}

