/*
 * Decompiled with CFR 0.152.
 */
package it.auties.delombok;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Lombok;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="delombok")
public class DelombokMojo
extends AbstractMojo {
    private static final String JAVA_COMMAND = "java -jar %s delombok %s -d %s";
    @Parameter(required=true)
    private File rootDirectory;
    @Parameter(required=true)
    private File outputDirectory;
    @Parameter
    private final Set<String> excludedFiles = Set.of("module-info.java");

    public void execute() {
        long start = System.currentTimeMillis();
        this.getLog().info((CharSequence)"Starting delombok process...");
        List<Path> sources = this.findJavaSources();
        this.getLog().info((CharSequence)String.format("Detected %s files", sources.size()));
        String transform = this.generateDelombokInput(sources);
        this.runDelombok(transform);
        this.moveOutputToCorrectDir(sources);
        this.getLog().info((CharSequence)String.format("Finished delombok process, took %s ms", System.currentTimeMillis() - start));
    }

    private void moveOutputToCorrectDir(List<Path> sources) {
        Files.walk(this.outputDirectory.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
            String fileName = path.getFileName().toString();
            String outputFileName = this.findMatchingSourceFile(sources, fileName);
            Path outputPath = Path.of(this.outputDirectory.getPath(), outputFileName);
            this.createDirectories(outputPath);
            this.moveFile((Path)path, outputPath);
        });
    }

    private String findMatchingSourceFile(List<Path> sources, String fileName) {
        return sources.stream().filter(originalFile -> originalFile.getFileName().toString().equals(fileName)).findFirst().orElseThrow().toString().replace(this.rootDirectory.getPath(), "");
    }

    private String generateDelombokInput(List<Path> sources) {
        return sources.stream().filter(this::filterPath).map(Path::toString).collect(Collectors.joining(" "));
    }

    private void runDelombok(String transform) {
        new ProcessBuilder(String.format(JAVA_COMMAND, Path.of(Lombok.class.getProtectionDomain().getCodeSource().getLocation().toURI()), transform, this.outputDirectory.getPath()).split(" ")).redirectError(ProcessBuilder.Redirect.DISCARD).start().waitFor();
    }

    private List<Path> findJavaSources() {
        return Files.walk(this.rootDirectory.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
    }

    private void createDirectories(Path outputPath) {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
    }

    private void moveFile(Path path, Path outputPath) {
        Files.move(path, outputPath, StandardCopyOption.REPLACE_EXISTING);
    }

    private boolean filterPath(Path path) {
        if (this.excludedFiles.stream().anyMatch(path.getFileName().toString()::equals)) {
            Path outputPath = Path.of(this.outputDirectory.getPath(), path.getFileName().toString());
            this.createDirectories(outputPath);
            Files.write(outputPath, Files.readAllBytes(path), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return false;
        }
        return true;
    }
}

