/*
 * Decompiled with CFR 0.152.
 */
package it.auties.optional.plugin;

import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Names;
import it.auties.optional.plugin.OptionalTranslator;
import it.auties.optional.transformer.BangTransformer;
import it.auties.optional.transformer.ConditionalTransformer;
import it.auties.optional.transformer.ElvisTransformer;
import it.auties.optional.transformer.FilterTransformer;
import it.auties.optional.transformer.MapTransformer;
import it.auties.optional.transformer.NamedConstructorTransformer;
import it.auties.optional.transformer.OrTransformer;
import it.auties.optional.transformer.StreamTransformer;
import it.auties.optional.transformer.ValueTransformer;
import it.auties.optional.tree.Maker;
import it.auties.optional.util.DebugTools;
import it.auties.optional.util.IllegalReflection;
import it.auties.optional.util.OptionalManager;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;

@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class OptionalPlugin
implements Plugin,
TaskListener {
    private OptionalTranslator translator;
    private DebugTools debugTools;

    @Override
    public String getName() {
        return "Optional";
    }

    @Override
    public void init(JavacTask task, String ... args) {
        IllegalReflection.openJavac();
        Context context = ((BasicJavacTask)task).getContext();
        Names names = Names.instance(context);
        Types types = Types.instance(context);
        Symtab symtab = Symtab.instance(context);
        Operators operators = Operators.instance(context);
        TreeMaker maker = TreeMaker.instance(context);
        Attr attr = Attr.instance(context);
        Maker simpleMaker = new Maker(maker, names, symtab, attr, types, operators);
        OptionalManager manager = this.initializeManager(simpleMaker);
        this.translator = new OptionalTranslator(simpleMaker, types, manager);
        this.debugTools = new DebugTools(args);
        task.addTaskListener(this);
    }

    @Override
    public void finished(TaskEvent event) {
        if (event.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)event.getCompilationUnit();
        if (this.debugTools.skip()) {
            return;
        }
        this.translator.translate(unit);
        this.debugTools.debug(() -> System.err.println(unit));
    }

    @Override
    public boolean autoStart() {
        return true;
    }

    private OptionalManager initializeManager(Maker simpleMaker) {
        return OptionalManager.instance().addTransformer(new BangTransformer(simpleMaker)).addTransformer(new ConditionalTransformer(simpleMaker)).addTransformer(new ValueTransformer(simpleMaker)).addTransformer(new ElvisTransformer(simpleMaker)).addTransformer(new FilterTransformer(simpleMaker)).addTransformer(new MapTransformer(simpleMaker)).addTransformer(new NamedConstructorTransformer(simpleMaker)).addTransformer(new OrTransformer(simpleMaker)).addTransformer(new StreamTransformer(simpleMaker));
    }
}

