/*
 * Decompiled with CFR 0.152.
 */
package it.auties.optional.plugin;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import it.auties.optional.transformer.OptionalTransformer;
import it.auties.optional.tree.Elements;
import it.auties.optional.tree.Maker;
import it.auties.optional.util.OptionalManager;
import java.util.Objects;
import java.util.Optional;

public class OptionalTranslator
extends TreeTranslator {
    private final Maker maker;
    private final Types types;
    private final OptionalManager manager;
    private JCTree.JCClassDecl enclosingClass;
    private JCTree.JCMethodDecl enclosingMethod;

    @Override
    public <T extends JCTree> T translate(T tree) {
        this.removeOptional(tree);
        return super.translate(tree);
    }

    @Override
    public <T extends JCTree> List<T> translate(List<T> trees) {
        trees.forEach(this::removeOptional);
        return super.translate(trees);
    }

    @Override
    public List<JCTree.JCTypeParameter> translateTypeParams(List<JCTree.JCTypeParameter> trees) {
        trees.forEach(this::removeOptional);
        return super.translateTypeParams(trees);
    }

    @Override
    public List<JCTree.JCVariableDecl> translateVarDefs(List<JCTree.JCVariableDecl> trees) {
        trees.forEach(this::removeOptional);
        return super.translateVarDefs(trees);
    }

    private void removeOptional(JCTree tree) {
        if (tree == null) {
            return;
        }
        Type type = tree.type;
        if (type == null) {
            return;
        }
        Symbol.TypeSymbol element = type.asElement();
        if (element == null || !this.maker.hasOptionalName(element.getQualifiedName())) {
            return;
        }
        tree.type = this.maker.unboxWrapper(tree.type);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.enclosingClass = tree;
        super.visitClassDef(tree);
        tree.defs = tree.defs.appendList(List.from(this.manager.generatedLambdas()));
        this.manager.generatedLambdas().forEach(lambda -> tree.sym.members().enter(lambda.sym));
        this.manager.cleanLambdas();
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        Type optionalType;
        super.visitVarDef(tree);
        if (!this.isOptionalClass(tree.sym)) {
            return;
        }
        tree.sym.type = optionalType = this.findOptionalVariableType(tree);
        tree.vartype = this.maker.typeExpression(optionalType);
    }

    private Type findOptionalVariableType(JCTree.JCVariableDecl variable) {
        Type optionalType = this.maker.unboxWrapper(variable.type);
        if (optionalType != null) {
            return this.types.removeWildcards(optionalType);
        }
        JCTree.JCExpression initializer = Objects.requireNonNull(variable.getInitializer(), "findOptionalVariableType: null initializer");
        return this.types.removeWildcards(this.maker.unboxWrapper(initializer.type));
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        this.enclosingMethod = tree;
        super.visitMethodDef(tree);
        Type returnType = this.findMethodReturnType(tree);
        if (!this.isOptionalClass(returnType.asElement())) {
            return;
        }
        Type optionalType = this.maker.unboxWrapper(returnType);
        tree.restype = this.maker.typeExpression(optionalType);
        ((Type.MethodType)tree.type).restype = optionalType;
        ((Type.MethodType)tree.sym.type).restype = optionalType;
    }

    private Type findMethodReturnType(JCTree.JCMethodDecl method) {
        return Optional.of(method.sym.getReturnType()).map(this.types::removeWildcards).orElseThrow();
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        super.visitApply(tree);
        Symbol selected = TreeInfo.symbolFor(tree);
        if (!this.isOwnedByOptional(selected)) {
            return;
        }
        JCTree.JCExpression caller = Elements.getCallerExpression(tree);
        this.result = this.desugarOptionalInvocation(caller, caller.type, selected, (List<JCTree.JCExpression>)tree.getArguments());
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        super.visitReference(tree);
        if (!this.isOwnedByOptional(tree.sym)) {
            return;
        }
        JCTree.JCExpression invocation = this.desugarOptionalInvocation(null, Elements.getReturnType(tree.referentType), tree.sym, List.nil());
        Symbol invocationSymbol = TreeInfo.symbolFor(invocation);
        JCTree.JCMemberReference reference = this.maker.reference(invocationSymbol, this.enclosingClass.sym);
        Type.ClassType referenceType = (Type.ClassType)tree.type;
        referenceType.typarams_field = this.translateReferenceType(invocation, referenceType);
        reference.type = referenceType;
        reference.target = referenceType;
        reference.referentType = invocation.type;
        reference.sym = invocationSymbol;
        reference.ownerAccessible = true;
        this.result = reference;
    }

    private List<Type> translateReferenceType(JCTree.JCExpression invocation, Type.ClassType referenceType) {
        return referenceType.typarams_field.stream().map(type -> this.maker.hasOptionalName(type.asElement().getQualifiedName()) ? this.maker.boxed(Elements.getReturnType(invocation.type)) : type).collect(List.collector());
    }

    private JCTree.JCExpression desugarOptionalInvocation(JCTree.JCExpression caller, Type callerType, Symbol selected, List<JCTree.JCExpression> arguments) {
        String selectedName = selected.getSimpleName().toString();
        return this.manager.transformers().stream().filter(transformer -> transformer.supportedInstructions().contains(selectedName)).findFirst().map(transformer -> this.transformTree((OptionalTransformer)transformer, caller, callerType, selectedName, arguments)).orElseThrow(() -> new UnsupportedOperationException("No transformer could transform %s".formatted(selectedName)));
    }

    private JCTree.JCExpression transformTree(OptionalTransformer transformer, JCTree.JCExpression caller, Type callerType, String selectedName, List<JCTree.JCExpression> arguments) {
        return transformer.instruction(selectedName).enclosingClass(this.enclosingClass.sym).enclosingMethod(this.enclosingMethod).invocationCaller(caller).invocationCallerType(callerType).invocationArguments(arguments).transform();
    }

    private boolean isOwnedByOptional(Symbol selected) {
        Symbol.ClassSymbol classSymbol;
        Symbol symbol = selected.getEnclosingElement();
        return symbol instanceof Symbol.ClassSymbol && this.maker.hasOptionalName((classSymbol = (Symbol.ClassSymbol)symbol).getQualifiedName());
    }

    private boolean isOptionalClass(Symbol symbol) {
        if (symbol == null) {
            return false;
        }
        if (symbol instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol method = (Symbol.MethodSymbol)symbol;
            return this.maker.hasOptionalName(method.getReturnType().asElement().getQualifiedName());
        }
        if (symbol instanceof Symbol.VarSymbol) {
            Symbol.VarSymbol variable = (Symbol.VarSymbol)symbol;
            return this.maker.hasOptionalName(((Type)variable.asType()).asElement().getQualifiedName());
        }
        return this.maker.hasOptionalName(symbol.getQualifiedName()) || this.isOptionalClass(symbol.getEnclosingElement());
    }

    public OptionalTranslator(Maker maker, Types types, OptionalManager manager) {
        this.maker = maker;
        this.types = types;
        this.manager = manager;
    }
}

