/*
 * Decompiled with CFR 0.152.
 */
package it.auties.optional.transformer;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.List;
import it.auties.optional.transformer.OptionalTransformer;
import it.auties.optional.tree.Elements;
import it.auties.optional.tree.FunctionalExpressionDesugarer;
import it.auties.optional.tree.Maker;
import java.util.stream.Stream;

public abstract class FunctionalTransformer
extends OptionalTransformer {
    protected JCTree.JCMethodDecl generatedMethod;
    protected List<JCTree.JCMethodDecl> generatedLambdas;
    protected List<JCTree.JCMethodInvocation> generatedInvocations;

    public FunctionalTransformer(Maker callMaker) {
        super(callMaker);
    }

    @Override
    public JCTree.JCExpression transform() {
        this.generatedLambdas = this.generateFunctionalExpressions();
        this.generatedMethod = this.generateMethod();
        this.generatedInvocations = this.generateFunctionalCalls();
        this.generatedMethod.body = this.createBody();
        this.attributeGeneratedMethodType();
        return this.maker.createCallOnIdentifier(this.generatedMethod, this.createRootArguments());
    }

    private JCTree.JCMethodDecl generateMethod() {
        return this.maker.newMethod().enclosingClass(this.enclosingClass).modelMethod(this.enclosingMethod).name(this.instruction).parameters(this.createRootParameters()).toTree();
    }

    private void attributeGeneratedMethodType() {
        Type type;
        Type.MethodType methodType = (Type.MethodType)this.generatedMethod.type;
        methodType.restype = type = this.maker.eraseAndBox(this.generatedMethod.getBody().type, false);
        this.generatedMethod.restype = this.maker.typeExpression(type);
    }

    private JCTree.JCBlock createBody() {
        JCTree.JCStatement body = this.body();
        return (JCTree.JCBlock)this.maker.trees().at(this.generatedMethod.pos()).Block(0L, List.of(body)).setType(body.type);
    }

    private List<JCTree.JCExpression> createRootArguments() {
        List explicitArguments = this.invocationArguments.stream().filter(argument -> !(TreeInfo.skipParens(argument) instanceof JCTree.JCFunctionalExpression)).map(this::createRootArgument).collect(List.collector());
        List deducedArguments = this.generatedMethod.getParameters().stream().skip(1L).limit(((List)this.generatedMethod.getParameters()).size() - 1 - explicitArguments.size()).map(parameter -> this.maker.identifier(parameter.sym)).collect(List.collector());
        return this.isMemberReferenceScoped() ? explicitArguments.appendList(deducedArguments) : explicitArguments.prepend(this.invocationCaller).appendList(deducedArguments);
    }

    private JCTree.JCExpression createRootArgument(JCTree.JCExpression parameter) {
        Type type = Elements.getReturnType(parameter.type);
        if (!this.maker.types().isFunctionalInterface(type)) {
            return parameter;
        }
        Symbol.MethodSymbol method = Elements.getFunctionalInterfaceMethod(type.asElement());
        return this.maker.trees().App(this.maker.trees().Select(parameter, method), this.isMemberReferenceScoped() ? List.nil() : List.of(this.invocationCaller));
    }

    private List<JCTree.JCMethodInvocation> generateFunctionalCalls() {
        return this.generatedLambdas.map(lambda -> {
            List<JCTree.JCExpression> arguments = this.generatedMethod.getParameters().stream().limit(((List)lambda.getParameters()).size()).map(parameter -> this.maker.identifier(parameter.sym)).collect(List.collector());
            return this.maker.createCallOnIdentifier((JCTree.JCMethodDecl)lambda, arguments);
        });
    }

    private List<JCTree.JCMethodDecl> generateFunctionalExpressions() {
        return this.invocationArguments.stream().map(TreeInfo::skipParens).filter(argument -> argument instanceof JCTree.JCFunctionalExpression).map(argument -> this.maker.createMethodFromLambda(this.enclosingClass, this.enclosingMethod, (JCTree.JCExpression)argument)).collect(List.collector());
    }

    private List<JCTree.JCVariableDecl> createRootParameters() {
        return this.generatedLambdas.isEmpty() ? this.createRootParametersFromInvocation() : this.createRootParametersFromLambdas();
    }

    private List<JCTree.JCVariableDecl> createRootParametersFromInvocation() {
        return this.invocationArguments.stream().map(expression -> this.maker.createInferredParameter(expression.type)).collect(List.collector()).prepend(this.maker.createInferredParameter(this.maker.boxed(this.invocationCallerType)));
    }

    private List<JCTree.JCVariableDecl> createRootParametersFromLambdas() {
        return this.generatedLambdas.stream().flatMap(this::removeErasedTypeArguments).collect(List.collector()).prepend(this.maker.createInferredParameter(this.maker.boxed(this.invocationCallerType)));
    }

    private Stream<JCTree.JCVariableDecl> removeErasedTypeArguments(JCTree.JCMethodDecl lambda) {
        Type erased = ((FunctionalExpressionDesugarer.FunctionalExpressionType)lambda.type).erased();
        return lambda.getParameters().stream().skip(erased.getTypeArguments().size());
    }

    protected JCTree.JCIdent createIdentifierForParameter(int index) {
        if (index >= ((List)this.generatedMethod.getParameters()).size()) {
            return null;
        }
        Symbol.VarSymbol symbol = ((JCTree.JCVariableDecl)((List)this.generatedMethod.getParameters()).get((int)index)).sym;
        return this.maker.identifier(symbol);
    }

    protected abstract JCTree.JCStatement body();
}

