/*
 * Decompiled with CFR 0.152.
 */
package it.auties.optional.transformer;

import com.sun.tools.javac.tree.JCTree;
import it.auties.optional.transformer.OptionalTransformer;
import it.auties.optional.tree.Maker;
import java.util.Set;

public class NamedConstructorTransformer
extends OptionalTransformer {
    public NamedConstructorTransformer(Maker callMaker) {
        super(callMaker);
    }

    @Override
    public JCTree.JCExpression transform() {
        return switch (this.instruction) {
            case "empty" -> this.maker.createNullType();
            case "of" -> {
                JCTree.JCExpression parameter = (JCTree.JCExpression)this.invocationArguments.head;
                if (parameter.type.isPrimitive()) {
                    yield parameter;
                }
                yield this.maker.createNullAssert(parameter);
            }
            case "ofNullable" -> (JCTree.JCExpression)this.invocationArguments.head;
            default -> throw new IllegalStateException("NamedConstructorTransformer: %s is not a supported instruction".formatted(this.instruction));
        };
    }

    @Override
    public Set<String> supportedInstructions() {
        return Set.of("of", "ofNullable", "empty");
    }
}

