/*
 * Decompiled with CFR 0.152.
 */
package it.auties.optional.tree;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;

public final class Elements {
    public static JCTree.JCExpression getCallerExpression(JCTree.JCMethodInvocation invocation) {
        JCTree.JCExpression skipped = TreeInfo.skipParens(invocation.getMethodSelect());
        if (skipped instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)skipped;
            return fieldAccess.getExpression();
        }
        if (skipped instanceof JCTree.JCMemberReference) {
            JCTree.JCMemberReference memberReference = (JCTree.JCMemberReference)skipped;
            return memberReference.getQualifierExpression();
        }
        throw new IllegalArgumentException("Unexpected tree %s".formatted(skipped));
    }

    public static long createModifiers(JCTree.JCMethodDecl enclosingMethod) {
        return enclosingMethod.mods.flags & 0xFFFFFFFFFFFFFFFEL & 0xFFFFFFFFFFFFFFFDL & 0xFFFFFFFFFFFFFFFBL | 2L;
    }

    public static boolean isVoid(Symbol symbol) {
        return symbol != null && Elements.getReturnType(symbol.asType()).getTag() == TypeTag.VOID;
    }

    public static Type getReturnType(Type type) {
        Type type2;
        if (type instanceof Type.MethodType) {
            Type.MethodType methodType = (Type.MethodType)type;
            type2 = methodType.getReturnType();
        } else {
            type2 = type;
        }
        return type2;
    }

    public static Symbol.MethodSymbol getFunctionalInterfaceMethod(Symbol.TypeSymbol type) {
        return (Symbol.MethodSymbol)type.members().getSymbols(Elements::isFunctionalInterfaceMethod).iterator().next();
    }

    private static boolean isFunctionalInterfaceMethod(Symbol symbol) {
        return symbol.kind == Kinds.Kind.MTH && Elements.noFlag(symbol, 2L) && Elements.noFlag(symbol, 4096L) && Elements.noFlag(symbol, 8L) && Elements.noFlag(symbol, 0x80000000000L);
    }

    private static boolean noFlag(Symbol symbol, long flag) {
        return (symbol.flags() & flag) != flag;
    }

    private Elements() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

