/*
 * Decompiled with CFR 0.152.
 */
package it.auties.optional.tree;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import it.auties.optional.tree.Elements;
import it.auties.optional.tree.Maker;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class FunctionalExpressionDesugarer
extends TreeScanner<JCTree.JCMethodDecl, Void> {
    private final Maker maker;
    private final Symbol.ClassSymbol enclosingClass;
    private final JCTree.JCMethodDecl enclosingMethod;
    private final IdentifierTranslator identifierTranslator = new IdentifierTranslator();

    @Override
    public JCTree.JCMethodDecl visitLambdaExpression(LambdaExpressionTree node, Void unused) {
        JCTree.JCLambda lambda = (JCTree.JCLambda)node;
        List<JCTree.JCVariableDecl> parameters = this.createParameters(lambda);
        JCTree.JCBlock body = this.createBody(lambda);
        JCTree.JCMethodDecl method = this.maker.newMethod().enclosingClass(this.enclosingClass).modelMethod(this.enclosingMethod).originalType(lambda.type).returnType(this.maker.unboxWrapper(lambda.type)).name("lambda").parameters(parameters).body(body).toTree();
        return this.identifierTranslator.redefine(method);
    }

    @Override
    public JCTree.JCMethodDecl visitMemberReference(MemberReferenceTree node, Void unused) {
        JCTree.JCMemberReference reference = (JCTree.JCMemberReference)node;
        List<JCTree.JCVariableDecl> parameters = this.createParameters(reference);
        JCTree.JCStatement body = this.createBody(reference, parameters);
        JCTree.JCMethodDecl method = this.maker.newMethod().enclosingClass(this.enclosingClass).modelMethod(this.enclosingMethod).originalType(reference.type).returnType(this.maker.unboxWrapper(reference.type)).name("reference").parameters(parameters).body(this.maker.trees().Block(0L, List.of(body))).toTree();
        return this.identifierTranslator.redefine(method);
    }

    private List<JCTree.JCVariableDecl> createParameters(JCTree.JCFunctionalExpression expression) {
        Collection<JCTree.JCVariableDecl> parameters = this.createMutableParameters(expression);
        this.completeWithScopedParameters(expression, parameters);
        return List.from(parameters);
    }

    private Collection<JCTree.JCVariableDecl> createMutableParameters(JCTree.JCFunctionalExpression expression) {
        if (expression instanceof JCTree.JCLambda) {
            JCTree.JCLambda lambda = (JCTree.JCLambda)expression;
            Iterator<JCTree.JCVariableDecl> paramsIterator = lambda.params.iterator();
            return lambda.getDescriptorType(this.maker.types()).getParameterTypes().stream().map(parameter -> this.createLambdaParameter(paramsIterator, (Type)parameter)).collect(Collectors.toList());
        }
        if (expression instanceof JCTree.JCMemberReference) {
            JCTree.JCMemberReference reference = (JCTree.JCMemberReference)expression;
            java.util.List referenceParameters = ((Symbol.MethodSymbol)reference.sym).getParameters();
            return referenceParameters.stream().map(parameter -> this.maker.createInferredParameter(parameter.type)).collect(Collectors.toList());
        }
        throw new IllegalStateException("Cannot create parameters for unknown functional expression: " + expression);
    }

    private void completeWithScopedParameters(JCTree.JCFunctionalExpression expression, Collection<JCTree.JCVariableDecl> parameters) {
        new ContextualIdentityScanner().scan((Tree)expression, null).stream().filter(identifier -> this.noMatchingParameter(parameters, (JCTree.JCIdent)identifier)).map(this.maker::createParameterFromIdentifier).forEachOrdered(parameters::add);
    }

    private boolean noMatchingParameter(Collection<JCTree.JCVariableDecl> parameters, JCTree.JCIdent identifier) {
        return parameters.stream().noneMatch(result -> Objects.equals(result.getName(), identifier.getName()) || this.maker.types().isSameType((Type)result.sym.asType(), identifier.type));
    }

    private JCTree.JCVariableDecl createLambdaParameter(Iterator<JCTree.JCVariableDecl> paramsIterator, Type type) {
        Name parameter = paramsIterator.hasNext() ? paramsIterator.next().getName() : null;
        return this.maker.createInferredParameter(parameter, type);
    }

    private JCTree.JCBlock createBody(JCTree.JCLambda lambda) {
        return switch (lambda.getBodyKind()) {
            default -> throw new IncompatibleClassChangeError();
            case LambdaExpressionTree.BodyKind.STATEMENT -> (JCTree.JCBlock)lambda.getBody();
            case LambdaExpressionTree.BodyKind.EXPRESSION -> {
                JCTree.JCExpression expression = (JCTree.JCExpression)lambda.getBody();
                JCTree.JCStatement parsedExpression = Elements.isVoid(expression.type.asElement()) ? this.maker.trees().Exec(expression) : this.maker.trees().Return(expression);
                yield this.maker.trees().Block(0L, List.of(parsedExpression.setType(expression.type)));
            }
        };
    }

    private JCTree.JCStatement createBody(JCTree.JCMemberReference reference, List<JCTree.JCVariableDecl> parameters) {
        if (reference.sym.getSimpleName().equals(this.maker.names().init)) {
            JCTree.JCExpression newInstance = this.maker.trees().Create(reference.sym, parameters.map(this.maker.trees()::Ident));
            return this.maker.trees().Return(newInstance);
        }
        JCTree.JCExpression selected = this.maker.trees().Select(reference.getQualifierExpression(), reference.sym);
        JCTree.JCMethodInvocation result = this.maker.trees().App(selected, parameters.map(this.maker.trees()::Ident));
        return Elements.isVoid(reference.sym) ? this.maker.trees().Exec(result) : this.maker.trees().Return(result);
    }

    public FunctionalExpressionDesugarer(Maker maker, Symbol.ClassSymbol enclosingClass, JCTree.JCMethodDecl enclosingMethod) {
        this.maker = maker;
        this.enclosingClass = enclosingClass;
        this.enclosingMethod = enclosingMethod;
    }

    private class IdentifierTranslator
    extends TreeTranslator {
        private JCTree.JCMethodDecl method;

        private IdentifierTranslator() {
        }

        public JCTree.JCMethodDecl redefine(JCTree.JCMethodDecl method) {
            this.method = method;
            return this.translate(method);
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            super.visitIdent(tree);
            Symbol owner = tree.sym.getEnclosingElement();
            if (!Objects.equals(owner, FunctionalExpressionDesugarer.this.enclosingClass) && !Objects.equals(owner, FunctionalExpressionDesugarer.this.enclosingMethod.sym)) {
                return;
            }
            this.findMatchingParameter(tree).map(FunctionalExpressionDesugarer.this.maker::identifier).ifPresent(identifier -> {
                this.result = identifier;
            });
        }

        private Optional<Symbol.VarSymbol> findMatchingParameter(JCTree.JCIdent tree) {
            return this.method.params.stream().filter(parameter -> parameter.getName().contentEquals(tree.name)).map(parameter -> parameter.sym).findFirst();
        }
    }

    private class ContextualIdentityScanner
    extends TreeScanner<List<JCTree.JCIdent>, Void> {
        private final ListBuffer<JCTree.JCIdent> identifiers = new ListBuffer();

        private ContextualIdentityScanner() {
        }

        @Override
        public List<JCTree.JCIdent> visitIdentifier(IdentifierTree node, Void unused) {
            JCTree.JCIdent tree = (JCTree.JCIdent)node;
            if (!(tree.sym instanceof Symbol.VarSymbol)) {
                return (List)super.visitIdentifier(node, unused);
            }
            if (!Objects.equals(tree.sym.owner, FunctionalExpressionDesugarer.this.enclosingMethod.sym)) {
                return (List)super.visitIdentifier(node, unused);
            }
            this.identifiers.add(tree);
            return (List)super.visitIdentifier(node, unused);
        }

        @Override
        public List<JCTree.JCIdent> scan(Tree tree, Void unused) {
            this.identifiers.clear();
            super.scan(tree, unused);
            return this.identifiers.toList();
        }

        @Override
        public List<JCTree.JCIdent> scan(Iterable<? extends Tree> nodes, Void unused) {
            this.identifiers.clear();
            super.scan(nodes, unused);
            return this.identifiers.toList();
        }
    }

    public static final class FunctionalExpressionType
    extends Type.MethodType {
        private final Type erased;

        public FunctionalExpressionType(Type.MethodType type, Type erased) {
            super(type.argtypes, type.restype, type.thrown, type.tsym);
            this.erased = erased;
        }

        public Type erased() {
            return this.erased;
        }

        @Override
        public String toString() {
            return "FunctionalExpressionDesugarer.FunctionalExpressionType(erased=" + this.erased() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionalExpressionType)) {
                return false;
            }
            FunctionalExpressionType other = (FunctionalExpressionType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Type this$erased = this.erased();
            Type other$erased = other.erased();
            return !(this$erased == null ? other$erased != null : !((Object)this$erased).equals(other$erased));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionalExpressionType;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Type $erased = this.erased();
            result = result * 59 + ($erased == null ? 43 : ((Object)$erased).hashCode());
            return result;
        }
    }
}

