/*
 * Decompiled with CFR 0.152.
 */
package it.auties.optional.tree;

import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import it.auties.optional.tree.Elements;
import it.auties.optional.tree.FunctionalExpressionDesugarer;
import it.auties.optional.util.IllegalReflection;
import it.auties.optional.util.OptionalManager;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.lang.model.type.TypeMirror;

public class Maker {
    private final TreeMaker trees;
    protected final Names names;
    protected final Symtab symtab;
    protected final Attr attr;
    protected final Types types;
    private final Operators operators;
    private Type streamType;
    private Symbol.ClassSymbol noSuchElementSymbol;

    public Maker(TreeMaker trees, Names names, Symtab symtab, Attr attr, Types types, Operators operators) {
        this(trees, names, symtab, attr, types, operators, null, null);
    }

    public JCTree.JCExpression thisIdentifier(Type type) {
        return this.trees.This(type);
    }

    public JCTree.JCIdent identifier(Symbol symbol) {
        return this.trees.Ident(symbol);
    }

    public JCTree.JCExpression typeExpression(Type type) {
        return this.trees.Type(type);
    }

    public JCTree.JCMethodInvocation createCallOnIdentifier(JCTree.JCMethodDecl method, List<JCTree.JCExpression> parameters) {
        JCTree.JCIdent identifier = this.identifier(Objects.requireNonNull(method.sym, "Invalid symbol"));
        return this.trees.App(identifier, parameters);
    }

    public JCTree.JCStatement createThrowNoSuchElementException() {
        if (this.noSuchElementSymbol == null) {
            this.noSuchElementSymbol = this.findBaseModuleClassSymbol(NoSuchElementException.class);
        }
        Symbol constructor = this.noSuchElementSymbol.members().findFirst(this.names.init);
        JCTree.JCNewClass instance = (JCTree.JCNewClass)this.trees.Create(constructor, List.of(this.trees.Literal("No value present")));
        instance.constructorType = this.noSuchElementSymbol.asType();
        return this.trees.Throw(instance).setType((Type)this.noSuchElementSymbol.asType());
    }

    public JCTree.JCMethodInvocation makeStream(JCTree.JCExpression argument) {
        if (this.streamType == null) {
            this.streamType = this.findBaseModuleClassSymbol(Stream.class).asType();
        }
        Scope.WriteableScope members = Objects.requireNonNull(this.streamType.asElement().members(), "The stream class has no members");
        Symbol methodSymbol = members.findFirst(this.names.fromString("ofNullable"));
        JCTree.JCExpression selected = this.trees.Select(this.typeExpression(this.streamType), methodSymbol);
        return this.trees.App(selected, argument == null ? List.nil() : List.of(argument));
    }

    public JCTree.JCVariableDecl createInferredParameter(Type type) {
        return this.createInferredParameter(null, type);
    }

    public JCTree.JCVariableDecl createInferredParameter(Name name, Type type) {
        JCTree.JCVariableDecl param = this.trees.Param(Objects.requireNonNullElse(name, this.uniqueName("inferred")), this.unboxWrapper(type), null);
        param.sym.adr = 0;
        return param;
    }

    public JCTree.JCVariableDecl createParameterFromIdentifier(JCTree.JCIdent identifier) {
        JCTree.JCVariableDecl param = this.trees.Param(identifier.getName(), identifier.type, null);
        param.sym.adr = 0;
        return param;
    }

    public Type unboxWrapper(Type type) {
        if (type == null) {
            return null;
        }
        if (type.getTypeArguments().isEmpty()) {
            return this.types.erasure(type);
        }
        if (this.types.isFunctionalInterface(type)) {
            return this.unboxWrapper(this.unboxFunctionalInterface(type));
        }
        Type erased = this.types.erasure((Type)type.getTypeArguments().head);
        if (this.hasOptionalName(erased.asElement().getQualifiedName())) {
            return this.unboxWrapper(erased);
        }
        return erased;
    }

    private Type unboxFunctionalInterface(Type wrapperType) {
        TypeMirror functionalInterfaceType = wrapperType.asElement().asType();
        Type functionalInterfaceMethod = Elements.getFunctionalInterfaceMethod(wrapperType.asElement()).getReturnType();
        return IntStream.range(0, ((Type)functionalInterfaceType).getTypeArguments().size()).filter(arg_0 -> this.lambda$unboxFunctionalInterface$0(functionalInterfaceMethod, (Type)functionalInterfaceType, arg_0)).mapToObj(wrapperType.getTypeArguments()::get).findFirst().orElse(functionalInterfaceMethod);
    }

    public boolean hasOptionalName(Name name) {
        return name.startsWith(this.names.fromString(Optional.class.getName()));
    }

    public JCTree.JCLiteral createNullType() {
        return this.trees.Literal(TypeTag.BOT, null).setType(this.symtab.botType);
    }

    private Symbol.ClassSymbol findBaseModuleClassSymbol(Class<?> clazz) {
        Symbol.ModuleSymbol baseModule = this.symtab.getModule(this.names.fromString("java.base"));
        Name className = this.names.fromString(clazz.getName());
        return this.symtab.getClass(baseModule, className);
    }

    private void eraseAndBoxParameters(List<JCTree.JCVariableDecl> parameters, boolean box) {
        parameters.forEach(parameter -> {
            parameter.type = this.eraseAndBox(parameter.type, box);
            parameter.sym.type = this.eraseAndBox(parameter.sym.type, box);
        });
    }

    public Type eraseAndBox(Type type, boolean box) {
        return Optional.ofNullable(type).map(safeType -> box ? this.types.boxedTypeOrType(this.types.erasure((Type)safeType)) : this.types.erasure((Type)safeType)).orElse(null);
    }

    public JCTree.JCExpression createNullAssert(JCTree.JCExpression left) {
        return this.attr.makeNullCheck(left);
    }

    public JCTree.JCBinary createNullCheck(JCTree.JCExpression left, boolean nonNull) {
        left.type = this.eraseAndBox(left.type, true);
        JCTree.Tag tag = nonNull ? JCTree.Tag.NE : JCTree.Tag.EQ;
        JCTree.JCLiteral nullType = this.createNullType();
        JCTree.JCBinary binary = this.trees.Binary(tag, left, nullType);
        binary.operator = this.resolveBinary(left, nullType, tag);
        binary.type = this.symtab.booleanType;
        return binary;
    }

    public JCTree.JCExpression createDummyNullCheck(boolean nonNull) {
        Symbol checkMethod = this.symtab.objectsType.asElement().members().findFirst(this.names.fromString(nonNull ? "nonNull" : "isNull"));
        return this.trees.App(this.trees.Select(this.trees.Type(this.symtab.objectsType), checkMethod), List.nil());
    }

    private Symbol.OperatorSymbol resolveBinary(JCTree.JCExpression left, JCTree.JCExpression right, JCTree.Tag tag) {
        return (Symbol.OperatorSymbol)IllegalReflection.opened(this.operators.getClass().getDeclaredMethod("resolveBinary", JCDiagnostic.DiagnosticPosition.class, JCTree.Tag.class, Type.class, Type.class)).invoke((Object)this.operators, new Object[]{left.pos(), tag, left.type, right.type});
    }

    public JCTree.JCMethodDecl createMethodFromLambda(Symbol.ClassSymbol enclosingClass, JCTree.JCMethodDecl enclosingMethod, JCTree.JCExpression expression) {
        FunctionalExpressionDesugarer desugarer = new FunctionalExpressionDesugarer(this, enclosingClass, enclosingMethod);
        return (JCTree.JCMethodDecl)desugarer.scan(expression, null);
    }

    public Name uniqueName(String name) {
        int counter = OptionalManager.instance().counter().getAndIncrement();
        return this.names.fromString(name + "$" + counter);
    }

    public Type boxed(Type type) {
        return this.types.boxedTypeOrType(type);
    }

    public JCTree.JCMemberReference reference(Symbol selected, Symbol.ClassSymbol enclosingClass) {
        boolean thisScope = selected.getEnclosingElement().equals(enclosingClass);
        JCTree.JCExpression caller = this.referenceCaller(selected, thisScope);
        JCTree.JCMemberReference reference = this.trees.Reference(MemberReferenceTree.ReferenceMode.INVOKE, selected.getSimpleName(), caller, null);
        reference.kind = thisScope ? JCTree.JCMemberReference.ReferenceKind.BOUND : JCTree.JCMemberReference.ReferenceKind.UNBOUND;
        return reference;
    }

    private JCTree.JCExpression referenceCaller(Symbol selected, boolean thisScope) {
        return thisScope ? this.thisIdentifier(selected.getEnclosingElement().asType()) : this.typeExpression(selected.getEnclosingElement().asType());
    }

    public MethodBuilder newMethod() {
        return new MethodBuilder();
    }

    public Maker(TreeMaker trees, Names names, Symtab symtab, Attr attr, Types types, Operators operators, Type streamType, Symbol.ClassSymbol noSuchElementSymbol) {
        this.trees = trees;
        this.names = names;
        this.symtab = symtab;
        this.attr = attr;
        this.types = types;
        this.operators = operators;
        this.streamType = streamType;
        this.noSuchElementSymbol = noSuchElementSymbol;
    }

    public TreeMaker trees() {
        return this.trees;
    }

    public Names names() {
        return this.names;
    }

    public Symtab symtab() {
        return this.symtab;
    }

    public Attr attr() {
        return this.attr;
    }

    public Types types() {
        return this.types;
    }

    public Operators operators() {
        return this.operators;
    }

    public Type streamType() {
        return this.streamType;
    }

    public Symbol.ClassSymbol noSuchElementSymbol() {
        return this.noSuchElementSymbol;
    }

    public Maker streamType(Type streamType) {
        this.streamType = streamType;
        return this;
    }

    public Maker noSuchElementSymbol(Symbol.ClassSymbol noSuchElementSymbol) {
        this.noSuchElementSymbol = noSuchElementSymbol;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Maker)) {
            return false;
        }
        Maker other = (Maker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TreeMaker this$trees = this.trees();
        TreeMaker other$trees = other.trees();
        if (this$trees == null ? other$trees != null : !this$trees.equals(other$trees)) {
            return false;
        }
        Names this$names = this.names();
        Names other$names = other.names();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) {
            return false;
        }
        Symtab this$symtab = this.symtab();
        Symtab other$symtab = other.symtab();
        if (this$symtab == null ? other$symtab != null : !this$symtab.equals(other$symtab)) {
            return false;
        }
        Attr this$attr = this.attr();
        Attr other$attr = other.attr();
        if (this$attr == null ? other$attr != null : !this$attr.equals(other$attr)) {
            return false;
        }
        Types this$types = this.types();
        Types other$types = other.types();
        if (this$types == null ? other$types != null : !this$types.equals(other$types)) {
            return false;
        }
        Operators this$operators = this.operators();
        Operators other$operators = other.operators();
        if (this$operators == null ? other$operators != null : !this$operators.equals(other$operators)) {
            return false;
        }
        Type this$streamType = this.streamType();
        Type other$streamType = other.streamType();
        if (this$streamType == null ? other$streamType != null : !((Object)this$streamType).equals(other$streamType)) {
            return false;
        }
        Symbol.ClassSymbol this$noSuchElementSymbol = this.noSuchElementSymbol();
        Symbol.ClassSymbol other$noSuchElementSymbol = other.noSuchElementSymbol();
        return !(this$noSuchElementSymbol == null ? other$noSuchElementSymbol != null : !this$noSuchElementSymbol.equals(other$noSuchElementSymbol));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Maker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeMaker $trees = this.trees();
        result = result * 59 + ($trees == null ? 43 : $trees.hashCode());
        Names $names = this.names();
        result = result * 59 + ($names == null ? 43 : $names.hashCode());
        Symtab $symtab = this.symtab();
        result = result * 59 + ($symtab == null ? 43 : $symtab.hashCode());
        Attr $attr = this.attr();
        result = result * 59 + ($attr == null ? 43 : $attr.hashCode());
        Types $types = this.types();
        result = result * 59 + ($types == null ? 43 : $types.hashCode());
        Operators $operators = this.operators();
        result = result * 59 + ($operators == null ? 43 : $operators.hashCode());
        Type $streamType = this.streamType();
        result = result * 59 + ($streamType == null ? 43 : ((Object)$streamType).hashCode());
        Symbol.ClassSymbol $noSuchElementSymbol = this.noSuchElementSymbol();
        result = result * 59 + ($noSuchElementSymbol == null ? 43 : $noSuchElementSymbol.hashCode());
        return result;
    }

    public String toString() {
        return "Maker(trees=" + this.trees() + ", names=" + this.names() + ", symtab=" + this.symtab() + ", attr=" + this.attr() + ", types=" + this.types() + ", operators=" + this.operators() + ", streamType=" + this.streamType() + ", noSuchElementSymbol=" + this.noSuchElementSymbol() + ")";
    }

    private /* synthetic */ boolean lambda$unboxFunctionalInterface$0(Type functionalInterfaceMethod, Type functionalInterfaceType, int index) {
        return this.types.isSameType(functionalInterfaceMethod, functionalInterfaceType.getTypeArguments().get(index));
    }

    public class MethodBuilder {
        Symbol.ClassSymbol enclosingClass;
        JCTree.JCMethodDecl modelMethod;
        Type originalType;
        Type returnType;
        String name;
        List<JCTree.JCVariableDecl> parameters;
        JCTree.JCBlock body;

        public JCTree.JCMethodDecl toTree() {
            Maker.this.eraseAndBoxParameters(this.parameters, false);
            Type.MethodType methodType = this.createMethodType();
            Symbol.MethodSymbol methodSymbol = this.createMethodSymbol(methodType);
            methodSymbol.params = this.parameters.map(parameter -> parameter.sym);
            JCTree.JCMethodDecl method = Maker.this.trees.at(this.modelMethod.pos()).MethodDef(methodSymbol, this.body);
            this.parameters.forEach(param -> {
                param.sym.owner = methodSymbol;
            });
            return OptionalManager.instance().addLambda(method);
        }

        private Type.MethodType createMethodType() {
            Type.MethodType methodType = new Type.MethodType(this.parameters.map(param -> param.type), Maker.this.eraseAndBox(this.returnType, false), List.nil(), Maker.this.symtab.methodClass);
            if (this.originalType == null) {
                return methodType;
            }
            return new FunctionalExpressionDesugarer.FunctionalExpressionType(methodType, this.originalType);
        }

        private Symbol.MethodSymbol createMethodSymbol(Type.MethodType methodType) {
            long modifiers = Elements.createModifiers(this.modelMethod);
            return new Symbol.MethodSymbol(modifiers, Maker.this.uniqueName(this.name), methodType, this.enclosingClass);
        }

        public Symbol.ClassSymbol enclosingClass() {
            return this.enclosingClass;
        }

        public JCTree.JCMethodDecl modelMethod() {
            return this.modelMethod;
        }

        public Type originalType() {
            return this.originalType;
        }

        public Type returnType() {
            return this.returnType;
        }

        public String name() {
            return this.name;
        }

        public List<JCTree.JCVariableDecl> parameters() {
            return this.parameters;
        }

        public JCTree.JCBlock body() {
            return this.body;
        }

        public MethodBuilder enclosingClass(Symbol.ClassSymbol enclosingClass) {
            this.enclosingClass = enclosingClass;
            return this;
        }

        public MethodBuilder modelMethod(JCTree.JCMethodDecl modelMethod) {
            this.modelMethod = modelMethod;
            return this;
        }

        public MethodBuilder originalType(Type originalType) {
            this.originalType = originalType;
            return this;
        }

        public MethodBuilder returnType(Type returnType) {
            this.returnType = returnType;
            return this;
        }

        public MethodBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MethodBuilder parameters(List<JCTree.JCVariableDecl> parameters) {
            this.parameters = parameters;
            return this;
        }

        public MethodBuilder body(JCTree.JCBlock body) {
            this.body = body;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodBuilder)) {
                return false;
            }
            MethodBuilder other = (MethodBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Symbol.ClassSymbol this$enclosingClass = this.enclosingClass();
            Symbol.ClassSymbol other$enclosingClass = other.enclosingClass();
            if (this$enclosingClass == null ? other$enclosingClass != null : !this$enclosingClass.equals(other$enclosingClass)) {
                return false;
            }
            JCTree.JCMethodDecl this$modelMethod = this.modelMethod();
            JCTree.JCMethodDecl other$modelMethod = other.modelMethod();
            if (this$modelMethod == null ? other$modelMethod != null : !this$modelMethod.equals(other$modelMethod)) {
                return false;
            }
            Type this$originalType = this.originalType();
            Type other$originalType = other.originalType();
            if (this$originalType == null ? other$originalType != null : !((Object)this$originalType).equals(other$originalType)) {
                return false;
            }
            Type this$returnType = this.returnType();
            Type other$returnType = other.returnType();
            if (this$returnType == null ? other$returnType != null : !((Object)this$returnType).equals(other$returnType)) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<JCTree.JCVariableDecl> this$parameters = this.parameters();
            List<JCTree.JCVariableDecl> other$parameters = other.parameters();
            if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
                return false;
            }
            JCTree.JCBlock this$body = this.body();
            JCTree.JCBlock other$body = other.body();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Symbol.ClassSymbol $enclosingClass = this.enclosingClass();
            result = result * 59 + ($enclosingClass == null ? 43 : $enclosingClass.hashCode());
            JCTree.JCMethodDecl $modelMethod = this.modelMethod();
            result = result * 59 + ($modelMethod == null ? 43 : $modelMethod.hashCode());
            Type $originalType = this.originalType();
            result = result * 59 + ($originalType == null ? 43 : ((Object)$originalType).hashCode());
            Type $returnType = this.returnType();
            result = result * 59 + ($returnType == null ? 43 : ((Object)$returnType).hashCode());
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<JCTree.JCVariableDecl> $parameters = this.parameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            JCTree.JCBlock $body = this.body();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "Maker.MethodBuilder(enclosingClass=" + this.enclosingClass() + ", modelMethod=" + this.modelMethod() + ", originalType=" + this.originalType() + ", returnType=" + this.returnType() + ", name=" + this.name() + ", parameters=" + this.parameters() + ", body=" + this.body() + ")";
        }
    }
}

