/*
 * Decompiled with CFR 0.152.
 */
package it.auties.optional.util;

import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.NoSuchElementException;
import sun.misc.Unsafe;

public final class IllegalReflection {
    private static final Unsafe unsafe = IllegalReflection.openUnsafe();
    private static final long offset = IllegalReflection.findOffset();

    public static void openJavac() {
        try {
            Module jdkCompilerModule = IllegalReflection.findCompilerModule();
            Method addOpensMethod = Module.class.getDeclaredMethod("implAddOpens", String.class, Module.class);
            long addOpensMethodOffset = unsafe.objectFieldOffset(ModulePlaceholder.class.getDeclaredField("first"));
            unsafe.putBooleanVolatile(addOpensMethod, addOpensMethodOffset, true);
            Arrays.stream(Package.getPackages()).map(Package::getName).filter(pack -> pack.startsWith("com.sun.tools.javac")).forEach(pack -> IllegalReflection.invokeAccessibleMethod(addOpensMethod, jdkCompilerModule, pack, IllegalReflection.class.getModule()));
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException("Cannot open Javac Modules", throwable);
        }
    }

    private static Module findCompilerModule() {
        return ModuleLayer.boot().findModule("jdk.compiler").orElseThrow(() -> new ExceptionInInitializerError("Missing module: jdk.compiler"));
    }

    private static void invokeAccessibleMethod(Method method, Object caller, Object ... arguments) {
        try {
            method.invoke(caller, arguments);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Cannot invoke accessible method", throwable);
        }
    }

    private static long findOffset() {
        try {
            Field offsetField = AccessibleObject.class.getDeclaredField("override");
            return unsafe.objectFieldOffset(offsetField);
        }
        catch (Throwable throwable) {
            return IllegalReflection.findOffsetFallback();
        }
    }

    private static long findOffsetFallback() {
        try {
            return unsafe.objectFieldOffset(AccessibleObjectPlaceholder.class.getDeclaredField("override"));
        }
        catch (Throwable innerThrowable) {
            return -1L;
        }
    }

    private static Unsafe openUnsafe() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (NoSuchFieldException exception) {
            throw new NoSuchElementException("Cannot find unsafe field in wrapper class");
        }
        catch (IllegalAccessException exception) {
            throw new UnsupportedOperationException("Access to the unsafe wrapper has been blocked: the day has come. In this future has the OpenJDK team created a publicly available compiler api that can do something? Probably not", exception);
        }
    }

    public static <T extends AccessibleObject> T opened(T object) {
        if (offset != -1L) {
            unsafe.putBoolean(object, offset, true);
            return object;
        }
        object.setAccessible(true);
        return object;
    }

    private IllegalReflection() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class ModulePlaceholder {
        boolean first;
        static final Object staticObj = OutputStream.class;
        volatile Object second;
        private static volatile boolean staticSecond;
        private static volatile boolean staticThird;
    }

    private static class AccessibleObjectPlaceholder {
        boolean override;
        Object accessCheckCache;

        private AccessibleObjectPlaceholder() {
        }
    }
}

