/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.stream;

import it.auties.protobuf.model.ProtobufWireType;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public final class ProtobufOutputStream {
    private final byte[] buffer;
    private int position;

    public static int getFieldSize(int fieldNumber, int wireType) {
        return ProtobufOutputStream.getVarIntSizeUnsigned(ProtobufWireType.makeTag(fieldNumber, wireType));
    }

    public static int getVarIntSize(int value) {
        if (value >= 0) {
            return ProtobufOutputStream.getVarIntSizeUnsigned(value);
        }
        return ProtobufOutputStream.getVarIntSize((long)value);
    }

    public static int getVarIntSizeUnsigned(int value) {
        if (value >= 0 && value <= 127) {
            return 1;
        }
        if (value >= 128 && value <= 16383) {
            return 2;
        }
        if (value >= 16384 && value <= 0x1FFFFF) {
            return 3;
        }
        if (value >= 0x200000 && value <= 0xFFFFFFF) {
            return 4;
        }
        return 5;
    }

    public static int getVarIntSize(long value) {
        int counter = 0;
        while (true) {
            ++counter;
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                return counter;
            }
            value >>>= 7;
        }
    }

    public static int getStringSize(String value) {
        if (value == null) {
            return 0;
        }
        int length = value.getBytes(StandardCharsets.UTF_8).length;
        return ProtobufOutputStream.getVarIntSizeUnsigned(length) + length;
    }

    public static int getBytesSize(byte[] value) {
        if (value == null) {
            return 0;
        }
        return ProtobufOutputStream.getVarIntSizeUnsigned(value.length) + value.length;
    }

    public ProtobufOutputStream(int size) {
        this.buffer = new byte[size];
    }

    private void writeTag(int fieldNumber, int wireType) {
        this.writeUInt32NoTag(ProtobufWireType.makeTag(fieldNumber, wireType));
    }

    public void writeInt32(int fieldNumber, Collection<Integer> values) {
        if (values == null) {
            return;
        }
        for (Integer value : values) {
            this.writeInt32(fieldNumber, value);
        }
    }

    public void writeInt32(int fieldNumber, Integer value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.writeInt32NoTag(value);
    }

    public void writeUInt32(int fieldNumber, Collection<Integer> values) {
        if (values == null) {
            return;
        }
        for (Integer value : values) {
            this.writeUInt32(fieldNumber, value);
        }
    }

    public void writeUInt32(int fieldNumber, Integer value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value);
    }

    public void writeFloat(int fieldNumber, Collection<Float> values) {
        if (values == null) {
            return;
        }
        for (Float value : values) {
            this.writeFloat(fieldNumber, value);
        }
    }

    public void writeFloat(int fieldNumber, Float value) {
        if (value == null) {
            return;
        }
        this.writeFixed32(fieldNumber, Float.floatToRawIntBits(value.floatValue()));
    }

    public void writeFixed32(int fieldNumber, Collection<Integer> values) {
        if (values == null) {
            return;
        }
        for (Integer value : values) {
            this.writeFixed32(fieldNumber, value);
        }
    }

    public void writeFixed32(int fieldNumber, Integer value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 5);
        this.writeFixed32NoTag(value);
    }

    public void writeInt64(int fieldNumber, Collection<Long> values) {
        if (values == null) {
            return;
        }
        for (Long value : values) {
            this.writeInt64(fieldNumber, value);
        }
    }

    public void writeInt64(int fieldNumber, Long value) {
        if (value == null) {
            return;
        }
        this.writeUInt64(fieldNumber, value);
    }

    public void writeUInt64(int fieldNumber, Collection<Long> values) {
        if (values == null) {
            return;
        }
        for (Long value : values) {
            this.writeUInt64(fieldNumber, value);
        }
    }

    public void writeUInt64(int fieldNumber, Long value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.writeUInt64NoTag(value);
    }

    public void writeDouble(int fieldNumber, Collection<Double> values) {
        if (values == null) {
            return;
        }
        for (Double value : values) {
            this.writeDouble(fieldNumber, value);
        }
    }

    public void writeDouble(int fieldNumber, Double value) {
        if (value == null) {
            return;
        }
        this.writeFixed64(fieldNumber, Double.doubleToRawLongBits(value));
    }

    public void writeFixed64(int fieldNumber, Collection<Long> values) {
        if (values == null) {
            return;
        }
        for (Long value : values) {
            this.writeFixed64(fieldNumber, value);
        }
    }

    public void writeFixed64(int fieldNumber, Long value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 1);
        this.writeFixed64NoTag(value);
    }

    public void writeBool(int fieldNumber, Collection<Boolean> values) {
        if (values == null) {
            return;
        }
        for (Boolean value : values) {
            this.writeBool(fieldNumber, value);
        }
    }

    public void writeBool(int fieldNumber, Boolean value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.write((byte)(value != false ? 1 : 0));
    }

    public void writeString(int fieldNumber, Collection<String> values) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            this.writeString(fieldNumber, value);
        }
    }

    public void writeString(int fieldNumber, String value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 2);
        this.writeStringNoTag(value);
    }

    public void writeBytes(int fieldNumber, Collection<byte[]> values) {
        if (values == null) {
            return;
        }
        for (byte[] value : values) {
            this.writeBytes(fieldNumber, value);
        }
    }

    public void writeBytes(int fieldNumber, byte[] value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 2);
        this.writeBytesNoTag(value);
    }

    public byte[] toByteArray() {
        return this.buffer;
    }

    private void writeBytesNoTag(byte[] value) {
        this.writeUInt32NoTag(value.length);
        this.write(value);
    }

    private void writeInt32NoTag(int value) {
        if (value >= 0) {
            this.writeUInt32NoTag(value);
        } else {
            this.writeUInt64NoTag(value);
        }
    }

    private void writeUInt32NoTag(int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.write((byte)value);
                return;
            }
            this.write((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    private void writeFixed32NoTag(int value) {
        this.write((byte)(value & 0xFF));
        this.write((byte)(value >> 8 & 0xFF));
        this.write((byte)(value >> 16 & 0xFF));
        this.write((byte)(value >> 24 & 0xFF));
    }

    private void writeUInt64NoTag(long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.write((byte)value);
                return;
            }
            this.write((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    private void writeFixed64NoTag(long value) {
        this.write((byte)((int)value & 0xFF));
        this.write((byte)((int)(value >> 8) & 0xFF));
        this.write((byte)((int)(value >> 16) & 0xFF));
        this.write((byte)((int)(value >> 24) & 0xFF));
        this.write((byte)((int)(value >> 32) & 0xFF));
        this.write((byte)((int)(value >> 40) & 0xFF));
        this.write((byte)((int)(value >> 48) & 0xFF));
        this.write((byte)((int)(value >> 56) & 0xFF));
    }

    private void writeStringNoTag(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeUInt32NoTag(bytes.length);
        this.write(bytes);
    }

    private void write(byte value) {
        this.buffer[this.position++] = value;
    }

    private void write(byte[] values) {
        for (byte value : values) {
            this.buffer[this.position++] = value;
        }
    }
}

