/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.model;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

public enum ProtobufType {
    UNKNOWN(null, null, false),
    OBJECT(Object.class, Object.class, false),
    GROUP(Object.class, Object.class, false),
    MAP(Map.class, Map.class, false),
    FLOAT(Float.TYPE, Float.class, true),
    DOUBLE(Double.TYPE, Double.class, true),
    BOOL(Boolean.TYPE, Boolean.class, true),
    STRING(String.class, String.class, false),
    BYTES(byte[].class, byte[].class, false),
    INT32(Integer.TYPE, Integer.class, true),
    SINT32(Integer.TYPE, Integer.class, true),
    UINT32(Integer.TYPE, Integer.class, true),
    FIXED32(Integer.TYPE, Integer.class, true),
    SFIXED32(Integer.TYPE, Integer.class, true),
    INT64(Long.TYPE, Long.class, true),
    SINT64(Long.TYPE, Long.class, true),
    UINT64(Long.TYPE, Long.class, true),
    FIXED64(Long.TYPE, Long.class, true),
    SFIXED64(Long.TYPE, Long.class, true);

    private final Class<?> primitiveType;
    private final Class<?> wrappedType;
    private final boolean packable;

    private ProtobufType(Class<?> primitiveType, Class<?> wrappedType, boolean packable) {
        this.primitiveType = primitiveType;
        this.wrappedType = wrappedType;
        this.packable = packable;
    }

    public static Optional<ProtobufType> of(String name) {
        return Arrays.stream(ProtobufType.values()).filter(entry -> entry.name().toLowerCase().equals(name)).findFirst();
    }

    public Class<?> primitiveType() {
        if (this == UNKNOWN) {
            throw new UnsupportedOperationException();
        }
        return this.primitiveType;
    }

    public Class<?> wrappedType() {
        if (this == UNKNOWN) {
            throw new UnsupportedOperationException();
        }
        return this.wrappedType;
    }

    public boolean isPackable() {
        if (this == UNKNOWN) {
            throw new UnsupportedOperationException();
        }
        return this.packable;
    }
}

