/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.stream;

import it.auties.protobuf.exception.ProtobufDeserializationException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ProtobufInputStream {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private final byte[] buffer;
    private final int limit;
    private int wireType;
    private int index;
    private int pos;
    private Integer groupIndex;

    public ProtobufInputStream(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.limit = length;
        this.pos = offset;
    }

    public boolean readTag() {
        if (this.isAtEnd()) {
            this.wireType = 0;
            return false;
        }
        int rawTag = this.readInt32Unchecked();
        this.wireType = rawTag & 7;
        if (this.wireType > 5) {
            throw ProtobufDeserializationException.invalidWireType(this.wireType);
        }
        this.index = rawTag >>> 3;
        if (this.index == 0) {
            throw ProtobufDeserializationException.invalidFieldIndex(this.index);
        }
        if (rawTag == 3) {
            if (this.groupIndex != null) {
                throw ProtobufDeserializationException.invalidStartObject();
            }
            this.groupIndex = this.index;
        } else if (rawTag == 4) {
            if (this.groupIndex == null) {
                throw ProtobufDeserializationException.invalidEndObject();
            }
            if (this.index != this.groupIndex) {
                throw ProtobufDeserializationException.invalidEndObject(this.index, this.groupIndex);
            }
            this.groupIndex = null;
        }
        return true;
    }

    public List<Float> readFloatPacked() {
        return switch (this.wireType) {
            case 2 -> {
                ArrayList<Float> results = new ArrayList<Float>();
                ProtobufInputStream input = this.lengthDelimitedStream();
                this.wireType = 5;
                while (!input.isAtEnd()) {
                    results.add(Float.valueOf(input.readFloat()));
                }
                yield results;
            }
            case 5 -> List.of(Float.valueOf(this.readFloat()));
            default -> throw ProtobufDeserializationException.invalidWireType(this.wireType);
        };
    }

    public List<Double> readDoublePacked() {
        return switch (this.wireType) {
            case 2 -> {
                ArrayList<Double> results = new ArrayList<Double>();
                ProtobufInputStream input = this.lengthDelimitedStream();
                this.wireType = 1;
                while (!input.isAtEnd()) {
                    results.add(input.readDouble());
                }
                yield results;
            }
            case 1 -> List.of(Double.valueOf(this.readDouble()));
            default -> throw ProtobufDeserializationException.invalidWireType(this.wireType);
        };
    }

    public List<Integer> readInt32Packed() {
        return switch (this.wireType) {
            case 2 -> {
                ArrayList<Integer> results = new ArrayList<Integer>();
                ProtobufInputStream input = this.lengthDelimitedStream();
                this.wireType = 0;
                while (!input.isAtEnd()) {
                    results.add(input.readInt32());
                }
                yield results;
            }
            case 0 -> List.of(Integer.valueOf(this.readInt32()));
            default -> throw ProtobufDeserializationException.invalidWireType(this.wireType);
        };
    }

    public List<Long> readInt64Packed() {
        return switch (this.wireType) {
            case 2 -> {
                ArrayList<Long> results = new ArrayList<Long>();
                ProtobufInputStream input = this.lengthDelimitedStream();
                this.wireType = 0;
                while (!input.isAtEnd()) {
                    results.add(input.readInt64());
                }
                yield results;
            }
            case 0 -> List.of(Long.valueOf(this.readInt64()));
            default -> throw ProtobufDeserializationException.invalidWireType(this.wireType);
        };
    }

    public List<Integer> readFixed32Packed() {
        return switch (this.wireType) {
            case 2 -> {
                ArrayList<Integer> results = new ArrayList<Integer>();
                ProtobufInputStream input = this.lengthDelimitedStream();
                this.wireType = 5;
                while (!input.isAtEnd()) {
                    results.add(input.readFixed32());
                }
                yield results;
            }
            case 5 -> List.of(Integer.valueOf(this.readFixed32()));
            default -> throw ProtobufDeserializationException.invalidWireType(this.wireType);
        };
    }

    public List<Long> readFixed64Packed() {
        return switch (this.wireType) {
            case 2 -> {
                ArrayList<Long> results = new ArrayList<Long>();
                ProtobufInputStream input = this.lengthDelimitedStream();
                this.wireType = 1;
                while (!input.isAtEnd()) {
                    results.add(input.readFixed64());
                }
                yield results;
            }
            case 1 -> List.of(Long.valueOf(this.readFixed64()));
            default -> throw ProtobufDeserializationException.invalidWireType(this.wireType);
        };
    }

    public List<Boolean> readBoolPacked() {
        return switch (this.wireType) {
            case 2 -> {
                ArrayList<Boolean> results = new ArrayList<Boolean>();
                ProtobufInputStream input = this.lengthDelimitedStream();
                this.wireType = 0;
                while (!input.isAtEnd()) {
                    results.add(input.readBool());
                }
                yield results;
            }
            case 0 -> List.of(Boolean.valueOf(this.readBool()));
            default -> throw ProtobufDeserializationException.invalidWireType(this.wireType);
        };
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readFixed32());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readFixed64());
    }

    public boolean readBool() {
        return this.readInt64() == 1L;
    }

    public String readString() {
        return new String(this.readBytes(), StandardCharsets.UTF_8);
    }

    public int readInt32() {
        if (this.wireType != 0) {
            throw ProtobufDeserializationException.invalidWireType(this.wireType);
        }
        return this.readInt32Unchecked();
    }

    private int readInt32Unchecked() {
        block4: {
            int x;
            int tempPos;
            block6: {
                byte[] buffer;
                block8: {
                    block7: {
                        block5: {
                            tempPos = this.pos;
                            buffer = this.buffer;
                            if ((x = buffer[tempPos++]) >= 0) {
                                this.pos = tempPos;
                                return x;
                            }
                            if (this.limit - tempPos < 9) break block4;
                            if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                            x ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                        x ^= 0x3F80;
                        break block6;
                    }
                    if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                    x ^= 0xFFE03F80;
                    break block6;
                }
                byte y = buffer[tempPos++];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0) break block4;
            }
            this.pos = tempPos;
            return x;
        }
        return (int)this.readVarInt64Slow();
    }

    public long readInt64() {
        block5: {
            long x;
            int tempPos;
            block7: {
                byte[] buffer;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                int y;
                                block9: {
                                    block8: {
                                        block6: {
                                            if (this.wireType != 0) {
                                                throw ProtobufDeserializationException.invalidWireType(this.wireType);
                                            }
                                            tempPos = this.pos;
                                            buffer = this.buffer;
                                            if ((y = buffer[tempPos++]) >= 0) {
                                                this.pos = tempPos;
                                                return y;
                                            }
                                            if (this.limit - tempPos < 9) break block5;
                                            if ((y ^= buffer[tempPos++] << 7) >= 0) break block6;
                                            x = y ^ 0xFFFFFF80;
                                            break block7;
                                        }
                                        if ((y ^= buffer[tempPos++] << 14) < 0) break block8;
                                        x = y ^ 0x3F80;
                                        break block7;
                                    }
                                    if ((y ^= buffer[tempPos++] << 21) >= 0) break block9;
                                    x = y ^ 0xFFE03F80;
                                    break block7;
                                }
                                if ((x = (long)y ^ (long)buffer[tempPos++] << 28) < 0L) break block10;
                                x ^= 0xFE03F80L;
                                break block7;
                            }
                            if ((x ^= (long)buffer[tempPos++] << 35) >= 0L) break block11;
                            x ^= 0xFFFFFFF80FE03F80L;
                            break block7;
                        }
                        if ((x ^= (long)buffer[tempPos++] << 42) < 0L) break block12;
                        x ^= 0x3F80FE03F80L;
                        break block7;
                    }
                    if ((x ^= (long)buffer[tempPos++] << 49) >= 0L) break block13;
                    x ^= 0xFFFE03F80FE03F80L;
                    break block7;
                }
                x ^= (long)buffer[tempPos++] << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)buffer[tempPos++] < 0L) break block5;
            }
            this.pos = tempPos;
            return x;
        }
        return this.readVarInt64Slow();
    }

    private long readVarInt64Slow() {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw ProtobufDeserializationException.malformedVarInt();
    }

    public int readFixed32() {
        if (this.wireType != 5) {
            throw ProtobufDeserializationException.invalidWireType(this.wireType);
        }
        int tempPos = this.pos;
        if (this.limit - tempPos < 4) {
            throw ProtobufDeserializationException.truncatedMessage();
        }
        byte[] buffer = this.buffer;
        this.pos = tempPos + 4;
        return buffer[tempPos] & 0xFF | (buffer[tempPos + 1] & 0xFF) << 8 | (buffer[tempPos + 2] & 0xFF) << 16 | (buffer[tempPos + 3] & 0xFF) << 24;
    }

    public long readFixed64() {
        if (this.wireType != 1) {
            throw ProtobufDeserializationException.invalidWireType(this.wireType);
        }
        int tempPos = this.pos;
        if (this.limit - tempPos < 8) {
            throw ProtobufDeserializationException.truncatedMessage();
        }
        byte[] buffer = this.buffer;
        this.pos = tempPos + 8;
        return (long)buffer[tempPos] & 0xFFL | ((long)buffer[tempPos + 1] & 0xFFL) << 8 | ((long)buffer[tempPos + 2] & 0xFFL) << 16 | ((long)buffer[tempPos + 3] & 0xFFL) << 24 | ((long)buffer[tempPos + 4] & 0xFFL) << 32 | ((long)buffer[tempPos + 5] & 0xFFL) << 40 | ((long)buffer[tempPos + 6] & 0xFFL) << 48 | ((long)buffer[tempPos + 7] & 0xFFL) << 56;
    }

    public byte readByte() {
        return this.buffer[this.pos++];
    }

    public byte[] readBytes() {
        if (this.wireType != 2) {
            throw ProtobufDeserializationException.invalidWireType(this.wireType);
        }
        int size = this.readInt32Unchecked();
        if (size < 0) {
            throw ProtobufDeserializationException.negativeLength(size);
        }
        return this.readBytes(size);
    }

    public Object readUnknown() {
        return this.readUnknown(true);
    }

    public Object readUnknown(boolean allocate) {
        return switch (this.wireType) {
            case 0 -> (Object)this.readInt64();
            case 5 -> (Object)this.readFixed32();
            case 1 -> (Object)this.readFixed64();
            case 2 -> this.readBytes();
            case 3 -> (Object)this.readGroup(allocate);
            default -> throw ProtobufDeserializationException.invalidWireType(this.wireType);
        };
    }

    private HashMap<Integer, Object> readGroup(boolean allocate) {
        HashMap<Integer, Object> group;
        HashMap<Integer, Object> hashMap = group = allocate ? new HashMap<Integer, Object>() : null;
        while (!this.isAtEnd()) {
            Object value = this.readUnknown();
            if (group == null) continue;
            group.put(this.index, value);
        }
        this.assertGroupClosed();
        return group;
    }

    private void assertGroupClosed() {
        if (this.wireType != 4) {
            throw ProtobufDeserializationException.malformedGroup();
        }
    }

    private byte[] readBytes(int length) {
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        int tempPos = this.pos;
        this.pos += length;
        return Arrays.copyOfRange(this.buffer, tempPos, this.pos);
    }

    public boolean isAtEnd() {
        return this.pos >= this.limit;
    }

    public int index() {
        return this.index;
    }

    public ProtobufInputStream lengthDelimitedStream() {
        if (this.wireType != 2) {
            throw ProtobufDeserializationException.invalidWireType(this.wireType);
        }
        int size = this.readInt32Unchecked();
        if (size < 0) {
            throw ProtobufDeserializationException.negativeLength(size);
        }
        int tempPos = this.pos;
        this.pos += size;
        return new ProtobufInputStream(this.buffer, tempPos, this.pos);
    }
}

