/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.stream;

import it.auties.protobuf.exception.ProtobufSerializationException;
import it.auties.protobuf.model.ProtobufWireType;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public final class ProtobufOutputStream {
    private final byte[] buffer;
    private int position;

    public static int getFieldSize(int fieldNumber, int wireType) {
        return ProtobufOutputStream.getVarIntSize(ProtobufWireType.makeTag(fieldNumber, wireType));
    }

    public static int getVarIntSize(long value) {
        if (value < 0L) {
            return 10;
        }
        if (value < 128L) {
            return 1;
        }
        if (value < 16384L) {
            return 2;
        }
        if (value < 0x200000L) {
            return 3;
        }
        if (value < 0x10000000L) {
            return 4;
        }
        if (value < 0x800000000L) {
            return 5;
        }
        if (value < 0x40000000000L) {
            return 6;
        }
        if (value < 0x2000000000000L) {
            return 7;
        }
        if (value < 0x100000000000000L) {
            return 8;
        }
        return 9;
    }

    public static int getStringSize(String value) {
        if (value == null) {
            return 0;
        }
        int count = 0;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return ProtobufOutputStream.getVarIntSize(count) + count;
    }

    public static int getBytesSize(byte[] value) {
        if (value == null) {
            return 0;
        }
        return ProtobufOutputStream.getVarIntSize(value.length) + value.length;
    }

    public ProtobufOutputStream(int size) {
        this.buffer = new byte[size];
    }

    private void writeTag(int fieldNumber, int wireType) {
        this.writeVarIntNoTag(ProtobufWireType.makeTag(fieldNumber, wireType));
    }

    public void writeInt32(int fieldNumber, Collection<Integer> values) {
        if (values == null) {
            return;
        }
        for (Integer value : values) {
            this.writeInt32(fieldNumber, value);
        }
    }

    public void writeInt32(int fieldNumber, Integer value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.writeVarIntNoTag(value.intValue());
    }

    public void writeUInt32(int fieldNumber, Collection<Integer> values) {
        if (values == null) {
            return;
        }
        for (Integer value : values) {
            this.writeUInt32(fieldNumber, value);
        }
    }

    public void writeUInt32(int fieldNumber, Integer value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.writeVarIntNoTag(value.intValue());
    }

    public void writeFloat(int fieldNumber, Collection<Float> values) {
        if (values == null) {
            return;
        }
        for (Float value : values) {
            this.writeFloat(fieldNumber, value);
        }
    }

    public void writeFloat(int fieldNumber, Float value) {
        if (value == null) {
            return;
        }
        this.writeFixed32(fieldNumber, Float.floatToRawIntBits(value.floatValue()));
    }

    public void writeFixed32(int fieldNumber, Collection<Integer> values) {
        if (values == null) {
            return;
        }
        for (Integer value : values) {
            this.writeFixed32(fieldNumber, value);
        }
    }

    public void writeFixed32(int fieldNumber, Integer value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 5);
        this.write((byte)(value & 0xFF));
        this.write((byte)(value >> 8 & 0xFF));
        this.write((byte)(value >> 16 & 0xFF));
        this.write((byte)(value >> 24 & 0xFF));
    }

    public void writeInt64(int fieldNumber, Collection<Long> values) {
        if (values == null) {
            return;
        }
        for (Long value : values) {
            this.writeInt64(fieldNumber, value);
        }
    }

    public void writeInt64(int fieldNumber, Long value) {
        if (value == null) {
            return;
        }
        this.writeUInt64(fieldNumber, value);
    }

    public void writeUInt64(int fieldNumber, Collection<Long> values) {
        if (values == null) {
            return;
        }
        for (Long value : values) {
            this.writeUInt64(fieldNumber, value);
        }
    }

    public void writeUInt64(int fieldNumber, Long value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.writeVarIntNoTag(value);
    }

    public void writeDouble(int fieldNumber, Collection<Double> values) {
        if (values == null) {
            return;
        }
        for (Double value : values) {
            this.writeDouble(fieldNumber, value);
        }
    }

    public void writeDouble(int fieldNumber, Double value) {
        if (value == null) {
            return;
        }
        this.writeFixed64(fieldNumber, Double.doubleToRawLongBits(value));
    }

    public void writeFixed64(int fieldNumber, Collection<Long> values) {
        if (values == null) {
            return;
        }
        for (Long value : values) {
            this.writeFixed64(fieldNumber, value);
        }
    }

    public void writeFixed64(int fieldNumber, Long value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 1);
        this.write((byte)((int)value.longValue() & 0xFF));
        this.write((byte)((int)(value >> 8) & 0xFF));
        this.write((byte)((int)(value >> 16) & 0xFF));
        this.write((byte)((int)(value >> 24) & 0xFF));
        this.write((byte)((int)(value >> 32) & 0xFF));
        this.write((byte)((int)(value >> 40) & 0xFF));
        this.write((byte)((int)(value >> 48) & 0xFF));
        this.write((byte)((int)(value >> 56) & 0xFF));
    }

    public void writeBool(int fieldNumber, Collection<Boolean> values) {
        if (values == null) {
            return;
        }
        for (Boolean value : values) {
            this.writeBool(fieldNumber, value);
        }
    }

    public void writeBool(int fieldNumber, Boolean value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.write((byte)(value != false ? 1 : 0));
    }

    public void writeString(int fieldNumber, Collection<String> values) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            this.writeString(fieldNumber, value);
        }
    }

    public void writeString(int fieldNumber, String value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 2);
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeVarIntNoTag(bytes.length);
        this.write(bytes);
    }

    public void writeBytes(int fieldNumber, Collection<byte[]> values) {
        if (values == null) {
            return;
        }
        for (byte[] value : values) {
            this.writeBytes(fieldNumber, value);
        }
    }

    public void writeBytes(int fieldNumber, byte[] value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 2);
        this.writeVarIntNoTag(value.length);
        this.write(value);
    }

    public byte[] toByteArray() {
        if (this.position != this.buffer.length) {
            throw ProtobufSerializationException.sizeMismatch();
        }
        return this.buffer;
    }

    private void writeVarIntNoTag(long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.write((byte)value);
                return;
            }
            this.write((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    private void write(byte value) {
        this.buffer[this.position++] = value;
    }

    private void write(byte[] values) {
        for (byte value : values) {
            this.buffer[this.position++] = value;
        }
    }
}

