/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.Trees;
import it.auties.protobuf.annotation.ProtobufBuilder;
import it.auties.protobuf.annotation.ProtobufConverter;
import it.auties.protobuf.annotation.ProtobufEnumIndex;
import it.auties.protobuf.annotation.ProtobufGetter;
import it.auties.protobuf.annotation.ProtobufMixin;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.extension.OptionalExtension;
import it.auties.protobuf.model.ProtobufEnum;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufObject;
import it.auties.protobuf.model.ProtobufType;
import it.auties.protobuf.serialization.converter.ProtobufDeserializerElement;
import it.auties.protobuf.serialization.converter.ProtobufSerializerElement;
import it.auties.protobuf.serialization.instrumentation.ProtobufDeserializationVisitor;
import it.auties.protobuf.serialization.instrumentation.ProtobufSerializationVisitor;
import it.auties.protobuf.serialization.object.ProtobufBuilderElement;
import it.auties.protobuf.serialization.object.ProtobufEnumMetadata;
import it.auties.protobuf.serialization.object.ProtobufMessageElement;
import it.auties.protobuf.serialization.property.ProtobufPropertyStub;
import it.auties.protobuf.serialization.property.ProtobufPropertyType;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"it.auties.protobuf.annotation.ProtobufProperty", "it.auties.protobuf.annotation.ProtobufEnumIndex"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class ProtobufJavacPlugin
extends AbstractProcessor {
    private Trees trees;
    private DeclaredType protoObjectType;
    private DeclaredType protoMessageType;
    private DeclaredType protoMixinType;
    private DeclaredType objectType;
    private DeclaredType protoEnumType;
    private DeclaredType collectionType;
    private DeclaredType mapType;
    private DeclaredType concurrentMapType;
    private DeclaredType listType;
    private TypeElement arrayListTypeElement;
    private DeclaredType setType;
    private TypeElement hashSetTypeElement;
    private DeclaredType queueType;
    private DeclaredType dequeType;
    private TypeElement linkedListTypeElement;
    private TypeElement hashMapElement;
    private TypeElement concurrentHashMapElement;
    private PrimitiveType intType;
    private Map<String, ProtobufSerializerElement> optionalSerializers;
    private Map<String, ProtobufDeserializerElement> optionalDeserializers;
    private Map<String, ProtobufSerializerElement> atomicSerializers;
    private Map<String, ProtobufDeserializerElement> atomicDeserializers;

    @Override
    public synchronized void init(ProcessingEnvironment wrapperProcessingEnv) {
        ProcessingEnvironment unwrappedProcessingEnv = this.unwrapProcessingEnv(wrapperProcessingEnv);
        super.init(unwrappedProcessingEnv);
        this.trees = Trees.instance(this.processingEnv);
        this.initTypes();
        this.initOptionalConverters();
        this.initAtomicConverters();
    }

    private void initTypes() {
        this.protoObjectType = (DeclaredType)this.getType(ProtobufObject.class);
        this.protoMessageType = (DeclaredType)this.getType(ProtobufMessage.class);
        this.protoEnumType = (DeclaredType)this.getType(ProtobufEnum.class);
        this.objectType = (DeclaredType)this.getType(Object.class);
        this.intType = (PrimitiveType)this.getType(Integer.TYPE);
        this.collectionType = (DeclaredType)this.erase(this.getType(Collection.class));
        this.mapType = (DeclaredType)this.erase(this.getType(Map.class));
        this.concurrentMapType = (DeclaredType)this.erase(this.getType(ConcurrentMap.class));
        this.listType = (DeclaredType)this.erase(this.getType(List.class));
        DeclaredType arrayListType = (DeclaredType)this.erase(this.getType(ArrayList.class));
        this.arrayListTypeElement = (TypeElement)arrayListType.asElement();
        this.setType = (DeclaredType)this.erase(this.getType(Set.class));
        this.protoMixinType = (DeclaredType)this.erase(this.getType(ProtobufMixin.class));
        DeclaredType hashSetType = (DeclaredType)this.erase(this.getType(HashSet.class));
        this.arrayListTypeElement = (TypeElement)arrayListType.asElement();
        this.hashSetTypeElement = (TypeElement)hashSetType.asElement();
        this.queueType = (DeclaredType)this.erase(this.getType(Queue.class));
        this.dequeType = (DeclaredType)this.erase(this.getType(Deque.class));
        DeclaredType linkedListType = (DeclaredType)this.erase(this.getType(LinkedList.class));
        this.linkedListTypeElement = (TypeElement)linkedListType.asElement();
        DeclaredType hashMapType = (DeclaredType)this.erase(this.getType(HashMap.class));
        this.hashMapElement = (TypeElement)hashMapType.asElement();
        DeclaredType concurrentHashMapType = (DeclaredType)this.erase(this.getType(ConcurrentHashMap.class));
        this.concurrentHashMapElement = (TypeElement)concurrentHashMapType.asElement();
    }

    private void initAtomicConverters() {
        DeclaredType atomicReferenceType = (DeclaredType)this.getType(AtomicReference.class);
        ExecutableElement atomicReferenceDeserializer = this.getMandatoryMethod(atomicReferenceType, "<init>");
        ExecutableElement atomicReferenceSerializer = this.getMandatoryMethod(atomicReferenceType, "get");
        DeclaredType atomicIntegerType = (DeclaredType)this.getType(AtomicInteger.class);
        ExecutableElement atomicIntegerDeserializer = this.getMandatoryMethod(atomicIntegerType, "<init>");
        ExecutableElement atomicIntegerSerializer = this.getMandatoryMethod(atomicIntegerType, "get");
        DeclaredType atomicLongType = (DeclaredType)this.getType(AtomicLong.class);
        ExecutableElement atomicLongDeserializer = this.getMandatoryMethod(atomicLongType, "<init>");
        ExecutableElement atomicLongSerializer = this.getMandatoryMethod(atomicLongType, "get");
        DeclaredType atomicBooleanType = (DeclaredType)this.getType(AtomicBoolean.class);
        ExecutableElement atomicBooleanDeserializer = this.getMandatoryMethod(atomicBooleanType, "<init>");
        ExecutableElement atomicBooleanSerializer = this.getMandatoryMethod(atomicBooleanType, "get");
        this.atomicSerializers = Map.of(AtomicReference.class.getName(), new ProtobufSerializerElement(atomicReferenceSerializer, false, false, new String[0]), AtomicInteger.class.getName(), new ProtobufSerializerElement(atomicIntegerSerializer, true, false, new String[0]), AtomicLong.class.getName(), new ProtobufSerializerElement(atomicLongSerializer, true, false, new String[0]), AtomicBoolean.class.getName(), new ProtobufSerializerElement(atomicBooleanSerializer, true, false, new String[0]));
        this.atomicDeserializers = Map.of(AtomicReference.class.getName(), new ProtobufDeserializerElement(atomicReferenceDeserializer), AtomicInteger.class.getName(), new ProtobufDeserializerElement(atomicIntegerDeserializer), AtomicLong.class.getName(), new ProtobufDeserializerElement(atomicLongDeserializer), AtomicBoolean.class.getName(), new ProtobufDeserializerElement(atomicBooleanDeserializer));
    }

    private void initOptionalConverters() {
        DeclaredType optionalType = (DeclaredType)this.getType(Optional.class);
        DeclaredType optionalExtensionType = (DeclaredType)this.getType(OptionalExtension.class);
        ExecutableElement optionalDeserializer = this.getMandatoryMethod(optionalType, "ofNullable");
        ExecutableElement optionalSerializer = this.getMandatoryMethod(optionalType, "orElse");
        ExecutableElement optionalIntDeserializer = this.getMandatoryMethod(optionalExtensionType, "ofNullableInt");
        ExecutableElement optionalIntSerializer = this.getMandatoryMethod(optionalExtensionType, "toNullableInt");
        ExecutableElement optionalLongDeserializer = this.getMandatoryMethod(optionalExtensionType, "ofNullableLong");
        ExecutableElement optionalLongSerializer = this.getMandatoryMethod(optionalExtensionType, "toNullableLong");
        ExecutableElement optionalDoubleDeserializer = this.getMandatoryMethod(optionalExtensionType, "ofNullableDouble");
        ExecutableElement optionalDoubleSerializer = this.getMandatoryMethod(optionalExtensionType, "toNullableDouble");
        this.optionalSerializers = Map.of(Optional.class.getName(), new ProtobufSerializerElement(optionalSerializer, false, false, "null"), OptionalInt.class.getName(), new ProtobufSerializerElement(optionalIntSerializer, false, false, new String[0]), OptionalLong.class.getName(), new ProtobufSerializerElement(optionalLongSerializer, false, false, new String[0]), OptionalDouble.class.getName(), new ProtobufSerializerElement(optionalDoubleSerializer, false, false, new String[0]));
        this.optionalDeserializers = Map.of(Optional.class.getName(), new ProtobufDeserializerElement(optionalDeserializer), OptionalInt.class.getName(), new ProtobufDeserializerElement(optionalIntDeserializer), OptionalLong.class.getName(), new ProtobufDeserializerElement(optionalLongDeserializer), OptionalDouble.class.getName(), new ProtobufDeserializerElement(optionalDoubleDeserializer));
    }

    private ExecutableElement getMandatoryMethod(DeclaredType type, String method) {
        return type.asElement().getEnclosedElements().stream().filter(entry -> entry instanceof ExecutableElement).map(entry -> (ExecutableElement)entry).filter(entry -> entry.getSimpleName().contentEquals(method)).findFirst().orElseThrow(() -> new NoSuchMethodError("Missing method " + method));
    }

    private ProcessingEnvironment unwrapProcessingEnv(ProcessingEnvironment wrapper) {
        try {
            Class<?> apiWrappers = wrapper.getClass().getClassLoader().loadClass("org.jetbrains.jps.javac.APIWrappers");
            Method unwrapMethod = apiWrappers.getDeclaredMethod("unwrap", Class.class, Object.class);
            return (ProcessingEnvironment)unwrapMethod.invoke(null, ProcessingEnvironment.class, wrapper);
        }
        catch (ReflectiveOperationException exception) {
            return wrapper;
        }
    }

    private TypeMirror getType(Class<?> type) {
        if (type.isPrimitive()) {
            TypeKind kind = TypeKind.valueOf(type.getName().toUpperCase(Locale.ROOT));
            return this.processingEnv.getTypeUtils().getPrimitiveType(kind);
        }
        if (type.isArray()) {
            return this.processingEnv.getTypeUtils().getArrayType(this.getType(type.getComponentType()));
        }
        TypeElement result = this.processingEnv.getElementUtils().getTypeElement(type.getName());
        return result.asType();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.checkAnnotations(roundEnv);
        this.processObjects(roundEnv);
        return true;
    }

    private void checkAnnotations(RoundEnvironment roundEnv) {
        this.checkEnclosing(roundEnv, this.protoMessageType, ProtobufProperty.class, "Illegal enclosing class: a field annotated with @ProtobufProperty should be enclosed by a class or record that implements ProtobufMessage");
        this.checkEnclosing(roundEnv, this.protoMessageType, ProtobufGetter.class, "Illegal enclosing class: a method annotated with @ProtobufGetter should be enclosed by a class or record that implements ProtobufMessage");
        this.checkEnclosing(roundEnv, this.protoEnumType, ProtobufEnumIndex.class, "Illegal enclosing class: a field or parameter annotated with @ProtobufEnumIndex should be enclosed by an enum that implements ProtobufEnum");
        roundEnv.getElementsAnnotatedWith(ProtobufConverter.class).stream().map(entry -> (ExecutableElement)entry).forEach(this::checkConverter);
        roundEnv.getElementsAnnotatedWith(ProtobufBuilder.class).stream().map(entry -> (ExecutableElement)entry).forEach(this::checkBuilder);
    }

    private void checkBuilder(ExecutableElement entry) {
        if (entry.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.printError("Weak visibility: a method annotated with @ProtobufBuilder must have at least package-private visibility", entry);
            return;
        }
        if (entry.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        this.printError("Illegal method: a method annotated with @ProtobufBuilder must be static", entry);
    }

    private void checkConverter(ExecutableElement entry) {
        if (entry.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.printError("Weak visibility: a method annotated with @ProtobufConverter must have at least package-private visibility", entry);
            return;
        }
        boolean isStatic = entry.getModifiers().contains((Object)Modifier.STATIC);
        if (isStatic && entry.getParameters().size() != 1) {
            this.printError("Illegal method: a static method annotated with @ProtobufConverter must have a single parameter", entry);
        } else if (!isStatic && !entry.getParameters().isEmpty()) {
            this.printError("Illegal method: a non-static method annotated with @ProtobufConverter mustn't have parameters", entry);
        }
    }

    private void checkEnclosing(RoundEnvironment roundEnv, TypeMirror type, Class<? extends Annotation> annotation, String error) {
        roundEnv.getElementsAnnotatedWith(annotation).stream().filter(property -> !this.isSubType(this.getEnclosingTypeElement((Element)property).asType(), type)).forEach(property -> this.printError(error, (Element)property));
    }

    private TypeElement getEnclosingTypeElement(Element element) {
        Objects.requireNonNull(element);
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return typeElement;
        }
        return this.getEnclosingTypeElement(element.getEnclosingElement());
    }

    private void processObjects(RoundEnvironment roundEnv) {
        TypeElement currentElement = null;
        try {
            List<TypeElement> objects = this.getProtobufObjects(roundEnv);
            Iterator<TypeElement> iterator = objects.iterator();
            while (iterator.hasNext()) {
                TypeElement object;
                currentElement = object = iterator.next();
                Optional<ProtobufMessageElement> result = this.processElement(object);
                if (result.isEmpty()) continue;
                PackageElement packageName = this.processingEnv.getElementUtils().getPackageOf(result.get().element());
                this.createSpecClass(result.get(), packageName);
                if (result.get().isEnum()) continue;
                this.createBuilderClass(result.get(), null, packageName);
                for (ProtobufBuilderElement builder : result.get().builders()) {
                    this.createBuilderClass(result.get(), builder, packageName);
                }
            }
        }
        catch (IOException exception) {
            this.printWarning("An error occurred: " + exception.getMessage(), currentElement);
        }
    }

    private void createSpecClass(ProtobufMessageElement result, PackageElement packageName) throws IOException {
        String simpleGeneratedClassName = result.getGeneratedClassNameBySuffix("Spec");
        String qualifiedGeneratedClassName = packageName != null ? String.valueOf(packageName) + "." + simpleGeneratedClassName : simpleGeneratedClassName;
        JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(qualifiedGeneratedClassName, new Element[0]);
        try (PrintWriter writer = new PrintWriter(sourceFile.openWriter());){
            if (packageName != null) {
                writer.println("package %s;\n".formatted(packageName.getQualifiedName()));
            }
            List<String> imports = this.getSpecImports(result);
            imports.forEach(entry -> writer.println("import %s;".formatted(entry)));
            if (!imports.isEmpty()) {
                writer.println();
            }
            writer.println("public class %s {".formatted(simpleGeneratedClassName));
            ProtobufSerializationVisitor serializationVisitor = new ProtobufSerializationVisitor(result, writer);
            serializationVisitor.instrument();
            ProtobufDeserializationVisitor deserializationVisitor = new ProtobufDeserializationVisitor(result, writer);
            deserializationVisitor.instrument();
            writer.println("}");
        }
    }

    protected List<String> getSpecImports(ProtobufMessageElement message) {
        if (message.isEnum()) {
            return List.of(message.element().getQualifiedName().toString(), Arrays.class.getName(), Optional.class.getName());
        }
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(message.element().getQualifiedName().toString());
        imports.add(ProtobufInputStream.class.getName());
        imports.add(ProtobufOutputStream.class.getName());
        if (message.properties().stream().anyMatch(ProtobufPropertyStub::required)) {
            imports.add(Objects.class.getName());
        }
        return Collections.unmodifiableList(imports);
    }

    private void createBuilderClass(ProtobufMessageElement messageElement, ProtobufBuilderElement builderElement, PackageElement packageName) throws IOException {
        String simpleGeneratedClassName = builderElement != null ? messageElement.getGeneratedClassNameByName(builderElement.name()) : messageElement.getGeneratedClassNameBySuffix("Builder");
        String qualifiedGeneratedClassName = packageName != null ? String.valueOf(packageName) + "." + simpleGeneratedClassName : simpleGeneratedClassName;
        JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(qualifiedGeneratedClassName, new Element[0]);
        try (PrintWriter writer = new PrintWriter(sourceFile.openWriter());){
            if (packageName != null) {
                writer.println("package %s;\n".formatted(packageName.getQualifiedName()));
            }
            writer.println("public class %s {".formatted(simpleGeneratedClassName));
            ArrayList<String> invocationArgs = new ArrayList<String>();
            if (builderElement != null) {
                for (VariableElement variableElement : builderElement.parameters()) {
                    writer.println("    private %s %s;".formatted(variableElement.asType(), variableElement.getSimpleName()));
                    invocationArgs.add(variableElement.getSimpleName().toString());
                }
            } else {
                for (ProtobufPropertyStub protobufPropertyStub : messageElement.properties()) {
                    writer.println("    private %s %s;".formatted(protobufPropertyStub.type().fieldType(), protobufPropertyStub.name()));
                    invocationArgs.add(protobufPropertyStub.name());
                }
            }
            writer.println();
            writer.println("    public %s() {".formatted(simpleGeneratedClassName));
            if (builderElement == null) {
                for (ProtobufPropertyStub protobufPropertyStub : messageElement.properties()) {
                    writer.println("        %s = %s;".formatted(protobufPropertyStub.name(), protobufPropertyStub.defaultValue()));
                }
            }
            writer.println("    }");
            writer.println();
            if (builderElement != null) {
                for (VariableElement variableElement : builderElement.parameters()) {
                    this.writeBuilderSetter(writer, variableElement.getSimpleName().toString(), variableElement.asType(), simpleGeneratedClassName);
                }
            } else {
                for (ProtobufPropertyStub protobufPropertyStub : messageElement.properties()) {
                    this.writeBuilderSetter(writer, protobufPropertyStub.name(), protobufPropertyStub.type().fieldType(), simpleGeneratedClassName);
                }
            }
            writer.println();
            Name resultQualifiedName = messageElement.element().getQualifiedName();
            String string = String.join((CharSequence)", ", invocationArgs);
            writer.println("    public %s build() {".formatted(resultQualifiedName));
            String invocation = builderElement == null ? "new %s(%s)".formatted(resultQualifiedName, string) : "%s.%s(%s)".formatted(resultQualifiedName, builderElement.delegate().getSimpleName(), string);
            writer.println("        return %s;".formatted(invocation));
            writer.println("    }");
            writer.println("}");
        }
    }

    private void writeBuilderSetter(PrintWriter writer, String fieldName, TypeMirror fieldType, String className) {
        writer.println("    public %s %s(%s %s) {".formatted(className, fieldName, fieldType, fieldName));
        writer.println("        this.%s = %s;".formatted(fieldName, fieldName));
        writer.println("        return this;");
        writer.println("    }");
        if (!(fieldType instanceof DeclaredType)) {
            return;
        }
        DeclaredType declaredType = (DeclaredType)fieldType;
        Element element = declaredType.asElement();
        if (!(element instanceof TypeElement)) {
            return;
        }
        TypeElement typeElement = (TypeElement)element;
        ProtobufDeserializerElement optionalConverter = this.optionalDeserializers.get(typeElement.getQualifiedName().toString());
        if (optionalConverter != null) {
            Optional<TypeMirror> optionalValueType = this.getOptionalValueType(declaredType);
            if (optionalValueType.isEmpty()) {
                return;
            }
            writer.println("    public %s %s(%s %s) {".formatted(className, fieldName, optionalValueType.get(), fieldName));
            TypeElement converterWrapperClass = (TypeElement)optionalConverter.element().getEnclosingElement();
            writer.println("        this.%s = %s.%s(%s);".formatted(fieldName, converterWrapperClass.getQualifiedName(), optionalConverter.element().getSimpleName(), fieldName));
            writer.println("        return this;");
            writer.println("    }");
            return;
        }
        ProtobufDeserializerElement atomicConverter = this.atomicDeserializers.get(typeElement.getQualifiedName().toString());
        if (atomicConverter != null) {
            Optional<TypeMirror> atomicValueType = this.getAtomicValueType(declaredType);
            if (atomicValueType.isEmpty()) {
                return;
            }
            writer.println("    public %s %s(%s %s) {".formatted(className, fieldName, atomicValueType.get(), fieldName));
            TypeElement converterWrapperClass = (TypeElement)atomicConverter.element().getEnclosingElement();
            writer.println("        this.%s = new %s(%s);".formatted(fieldName, converterWrapperClass.getQualifiedName(), fieldName));
            writer.println("        return this;");
            writer.println("    }");
        }
    }

    private Optional<ProtobufMessageElement> processElement(TypeElement object) {
        if (object.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return Optional.empty();
        }
        return switch (object.getKind()) {
            case ElementKind.ENUM -> this.processEnum(object);
            case ElementKind.RECORD, ElementKind.CLASS -> this.processMessage(object);
            default -> Optional.empty();
        };
    }

    private Optional<ProtobufMessageElement> processMessage(TypeElement message) {
        ProtobufMessageElement messageElement = new ProtobufMessageElement(message, null);
        this.processMessage(messageElement, messageElement.element());
        if (messageElement.properties().isEmpty()) {
            this.printWarning("No properties found", message);
            return Optional.of(messageElement);
        }
        if (!this.hasPropertiesConstructor(messageElement)) {
            this.printError("Missing protobuf constructor: a protobuf message must provide a constructor that takes only its properties, following their declaration order, as parameters", message);
            return Optional.empty();
        }
        return Optional.of(messageElement);
    }

    private void processMessage(ProtobufMessageElement messageElement, TypeElement typeElement) {
        this.getSuperClass(typeElement).ifPresent(superClass -> this.processMessage(messageElement, (TypeElement)superClass));
        Iterator<? extends Element> iterator = typeElement.getEnclosedElements().iterator();
        while (iterator.hasNext()) {
            Element entry;
            Element element = entry = iterator.next();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableElement.class, ExecutableElement.class}, (Object)element, n)) {
                case 0: {
                    VariableElement variableElement = (VariableElement)element;
                    this.processProperty(messageElement, variableElement);
                    break;
                }
                case 1: {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    this.processMethod(messageElement, executableElement);
                    break;
                }
            }
        }
    }

    private Optional<TypeElement> getSuperClass(TypeElement typeElement) {
        TypeMirror superClass = typeElement.getSuperclass();
        if (superClass == null || superClass.getKind() == TypeKind.NONE) {
            return Optional.empty();
        }
        String superClassName = superClass.toString();
        int superClassTypeParametersStartIndex = superClassName.indexOf("<");
        String rawName = superClassTypeParametersStartIndex <= 0 ? superClassName : superClassName.substring(0, superClassTypeParametersStartIndex);
        TypeElement superClassElement = this.processingEnv.getElementUtils().getTypeElement(rawName);
        return Optional.ofNullable(superClassElement);
    }

    private void processMethod(ProtobufMessageElement messageElement, ExecutableElement executableElement) {
        ProtobufBuilder builder = executableElement.getAnnotation(ProtobufBuilder.class);
        if (builder != null) {
            messageElement.addBuilder(builder.className(), executableElement.getParameters(), executableElement);
        }
    }

    private boolean hasPropertiesConstructor(ProtobufMessageElement message) {
        return message.element().getEnclosedElements().stream().filter(entry -> entry instanceof ExecutableElement).map(entry -> (ExecutableElement)entry).filter(entry -> entry.getKind() == ElementKind.CONSTRUCTOR).anyMatch(constructor -> {
            List<? extends VariableElement> constructorParameters = constructor.getParameters();
            if (message.properties().size() != constructorParameters.size()) {
                return false;
            }
            Iterator<ProtobufPropertyStub> propertiesIterator = message.properties().iterator();
            Iterator<? extends VariableElement> constructorParametersIterator = constructorParameters.iterator();
            while (propertiesIterator.hasNext() && constructorParametersIterator.hasNext()) {
                ProtobufPropertyStub property = propertiesIterator.next();
                VariableElement constructorParameter = constructorParametersIterator.next();
                if (this.isSubType(property.type().fieldType(), constructorParameter.asType())) continue;
                return false;
            }
            return true;
        });
    }

    private void processProperty(ProtobufMessageElement messageElement, VariableElement variableElement) {
        ProtobufProperty propertyAnnotation = variableElement.getAnnotation(ProtobufProperty.class);
        if (propertyAnnotation == null) {
            return;
        }
        if (propertyAnnotation.required() && !this.isValidRequiredProperty(variableElement)) {
            return;
        }
        if (propertyAnnotation.packed() && !this.isValidPackedProperty(variableElement, propertyAnnotation)) {
            return;
        }
        Element accessor = this.getAccessor(variableElement, propertyAnnotation).orElse(null);
        if (accessor == null) {
            this.printError("Missing getter/accessor: a getter or accessor must be declared", variableElement);
            return;
        }
        if (accessor.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.printError("Weak visibility: the getter/accessor must have at least package-private visibility", accessor);
            return;
        }
        Optional<ProtobufPropertyType> type = this.getImplementationType(variableElement, variableElement.asType(), accessor, propertyAnnotation);
        if (type.isEmpty()) {
            return;
        }
        Optional<ProtobufPropertyStub> error = messageElement.addProperty(variableElement, accessor, type.get(), propertyAnnotation);
        if (error.isEmpty()) {
            return;
        }
        this.printError("Duplicated message property: %s and %s with index %s".formatted(variableElement.getSimpleName(), error.get().name(), propertyAnnotation.index()), variableElement);
    }

    private Optional<ProtobufPropertyType> getImplementationType(Element element, TypeMirror elementType, Element accessor, ProtobufProperty property) {
        Element mixin = this.getMirroredMixin(property).orElse(null);
        Optional<TypeMirror> override = this.getMirroredOverride(property);
        if (this.isSubType(elementType, this.collectionType)) {
            Optional<TypeMirror> collectionTypeParameter = this.getTypeParameter(elementType, this.collectionType, 0);
            if (collectionTypeParameter.isEmpty()) {
                this.printError("Type inference error: cannot determine collection's implementationType. Specify the implementation explicitly in @ProtobufProperty", element);
                return Optional.empty();
            }
            Optional<TypeMirror> concreteCollectionType = this.getConcreteCollectionType(elementType);
            if (concreteCollectionType.isEmpty()) {
                this.printError("Type inference error: no known implementation found for abstract implementationType. Use a concrete type for the property's field to fix this error", element);
                return Optional.empty();
            }
            ProtobufPropertyType.NormalType value = new ProtobufPropertyType.NormalType(property.type(), collectionTypeParameter.get(), override.orElse(collectionTypeParameter.get()), this.isEnum(collectionTypeParameter.get()));
            ProtobufPropertyType.CollectionType type = new ProtobufPropertyType.CollectionType(elementType, concreteCollectionType.get(), value);
            this.attributeConverters(element, property.type(), collectionTypeParameter.get(), value, mixin);
            return Optional.of(type);
        }
        if (this.isSubType(elementType, this.mapType)) {
            Optional<ProtobufPropertyType.MapType> implementation = this.getConcreteMapImplementation(element, elementType, property.keyType(), property.valueType());
            if (implementation.isEmpty()) {
                this.printError("Type inference error: no known implementation found for abstract implementationType. Use a concrete implementationType for the property's field to fix this error", element);
                return Optional.empty();
            }
            this.attributeConverters(element, implementation.get().keyType().protobufType(), implementation.get().keyType().fieldType(), implementation.get().keyType(), mixin);
            this.attributeConverters(element, implementation.get().valueType().protobufType(), implementation.get().valueType().fieldType(), implementation.get().valueType(), mixin);
            return Optional.of((ProtobufPropertyType)implementation.get());
        }
        Element element2 = accessor;
        Objects.requireNonNull(element2);
        Element concreteCollectionType = element2;
        int value = 0;
        TypeMirror rawAccessorType = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExecutableElement.class, VariableElement.class}, (Object)concreteCollectionType, value)) {
            case 0 -> {
                ExecutableElement executableElement = (ExecutableElement)concreteCollectionType;
                yield this.erase(executableElement.getReturnType());
            }
            case 1 -> {
                VariableElement variableElement = (VariableElement)concreteCollectionType;
                yield this.erase(variableElement.asType());
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(accessor));
        };
        TypeMirror rawFieldType = this.erase(elementType);
        ProtobufDeserializerElement optionalDeserializer = this.optionalDeserializers.get(rawFieldType.toString());
        if (optionalDeserializer != null) {
            DeclaredType declaredFieldType = (DeclaredType)elementType;
            Optional<TypeMirror> wrappedType = this.getOptionalValueType(declaredFieldType);
            if (wrappedType.isEmpty()) {
                return Optional.empty();
            }
            TypeMirror rawWrappedType = this.erase(wrappedType.get());
            ProtobufPropertyType.NormalType value2 = new ProtobufPropertyType.NormalType(property.type(), wrappedType.get(), override.orElse(wrappedType.get()), this.isEnum(wrappedType.get()));
            ProtobufPropertyType.OptionalType implementation = new ProtobufPropertyType.OptionalType(elementType, value2);
            value2.addNullableConverter(this.optionalSerializers.get(rawAccessorType.toString()));
            this.attributeConverters(element, property.type(), rawWrappedType, value2, mixin);
            value2.addNullableConverter(optionalDeserializer);
            return Optional.of(implementation);
        }
        ProtobufDeserializerElement atomicDeserializer = this.atomicDeserializers.get(rawFieldType.toString());
        if (atomicDeserializer != null) {
            DeclaredType declaredFieldType = (DeclaredType)elementType;
            Optional<TypeMirror> wrappedType = this.getAtomicValueType(declaredFieldType);
            if (wrappedType.isEmpty()) {
                return Optional.empty();
            }
            TypeMirror rawWrappedType = this.erase(wrappedType.get());
            ProtobufPropertyType.NormalType value3 = new ProtobufPropertyType.NormalType(property.type(), wrappedType.get(), override.orElse(wrappedType.get()), this.isEnum(wrappedType.get()));
            ProtobufPropertyType.AtomicType implementation = new ProtobufPropertyType.AtomicType(elementType, value3);
            value3.addNullableConverter(this.atomicSerializers.get(rawAccessorType.toString()));
            this.attributeConverters(element, property.type(), rawWrappedType, value3, mixin);
            value3.addNullableConverter(atomicDeserializer);
            return Optional.of(implementation);
        }
        ProtobufPropertyType.NormalType implementation = new ProtobufPropertyType.NormalType(property.type(), elementType, override.orElse(elementType), this.isEnum(rawFieldType));
        implementation.addNullableConverter(this.optionalSerializers.get(rawAccessorType.toString()));
        implementation.addNullableConverter(this.atomicSerializers.get(rawAccessorType.toString()));
        this.attributeConverters(element, property.type(), elementType, implementation, mixin);
        return Optional.of(implementation);
    }

    private Optional<Element> getMirroredMixin(ProtobufProperty property) {
        try {
            Class implementation = property.mixin();
            TypeElement type = this.processingEnv.getElementUtils().getTypeElement(implementation.getName());
            if (type == null || this.isSameType(type.asType(), this.protoMixinType)) {
                return Optional.empty();
            }
            return Optional.of(type);
        }
        catch (MirroredTypeException exception) {
            TypeMirror typeMirror = exception.getTypeMirror();
            if (!(typeMirror instanceof DeclaredType)) {
                return Optional.empty();
            }
            DeclaredType declaredType = (DeclaredType)typeMirror;
            if (this.isSameType(declaredType, this.protoMixinType)) {
                return Optional.empty();
            }
            return Optional.of(declaredType.asElement());
        }
    }

    private Optional<TypeMirror> getMirroredOverride(ProtobufProperty property) {
        try {
            Class implementation = property.overrideType();
            TypeElement type = this.processingEnv.getElementUtils().getTypeElement(implementation.getName());
            if (type == null || this.isSameType(type.asType(), this.objectType)) {
                return Optional.empty();
            }
            return Optional.of(type.asType());
        }
        catch (MirroredTypeException exception) {
            TypeMirror typeMirror = exception.getTypeMirror();
            if (!(typeMirror instanceof DeclaredType)) {
                return Optional.empty();
            }
            DeclaredType declaredType = (DeclaredType)typeMirror;
            if (this.isSameType(declaredType, this.objectType)) {
                return Optional.empty();
            }
            return Optional.of(declaredType);
        }
    }

    private Optional<? extends Element> getAccessor(VariableElement fieldElement, ProtobufProperty propertyAnnotation) {
        if (!fieldElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Optional.of(fieldElement);
        }
        List<ExecutableElement> methods = fieldElement.getEnclosingElement().getEnclosedElements().stream().filter(entry -> entry instanceof ExecutableElement).map(entry -> (ExecutableElement)entry).toList();
        return methods.stream().filter(entry -> this.isProtobufGetter((ExecutableElement)entry, propertyAnnotation)).findFirst().or(() -> this.inferAccessor(fieldElement, methods));
    }

    private Optional<ExecutableElement> inferAccessor(VariableElement fieldElement, List<ExecutableElement> methods) {
        String fieldName = fieldElement.getSimpleName().toString();
        return methods.stream().filter(entry -> this.isProtobufGetter((ExecutableElement)entry, fieldName)).findFirst();
    }

    private boolean isProtobufGetter(ExecutableElement entry, String fieldName) {
        String methodName = entry.getSimpleName().toString();
        return entry.getParameters().isEmpty() && (methodName.equalsIgnoreCase("get" + fieldName) || methodName.equalsIgnoreCase(fieldName));
    }

    private boolean isProtobufGetter(ExecutableElement entry, ProtobufProperty propertyAnnotation) {
        ProtobufGetter annotation = entry.getAnnotation(ProtobufGetter.class);
        return annotation != null && annotation.index() == propertyAnnotation.index();
    }

    private Optional<TypeMirror> getConcreteCollectionType(TypeMirror elementType) {
        TypeMirror[] typeArguments;
        if (!(elementType instanceof DeclaredType)) {
            return Optional.empty();
        }
        DeclaredType declaredFieldType = (DeclaredType)elementType;
        TypeElement fieldTypeElement = (TypeElement)declaredFieldType.asElement();
        if (!fieldTypeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return Optional.of(elementType);
        }
        TypeMirror[] typeMirrorArray = typeArguments = declaredFieldType.getTypeArguments() != null ? (TypeMirror[])declaredFieldType.getTypeArguments().toArray(TypeMirror[]::new) : new TypeMirror[]{};
        if (this.isSameType(elementType, this.collectionType) || this.isSameType(elementType, this.listType)) {
            return Optional.ofNullable(this.processingEnv.getTypeUtils().getDeclaredType(this.arrayListTypeElement, typeArguments));
        }
        if (this.isSameType(elementType, this.setType)) {
            return Optional.ofNullable(this.processingEnv.getTypeUtils().getDeclaredType(this.hashSetTypeElement, typeArguments));
        }
        if (this.isSameType(elementType, this.queueType) || this.isSameType(elementType, this.dequeType)) {
            return Optional.ofNullable(this.processingEnv.getTypeUtils().getDeclaredType(this.linkedListTypeElement, typeArguments));
        }
        return Optional.empty();
    }

    private Optional<ProtobufPropertyType.MapType> getConcreteMapImplementation(Element element, TypeMirror elementType, ProtobufType keyType, ProtobufType valueType) {
        TypeMirror[] typeArguments;
        if (!(elementType instanceof DeclaredType)) {
            return Optional.empty();
        }
        DeclaredType declaredFieldType = (DeclaredType)elementType;
        boolean error = false;
        Optional<TypeMirror> keyTypeParameter = this.getTypeParameter(elementType, this.mapType, 0);
        if (keyTypeParameter.isEmpty()) {
            this.printError("Type inference error: cannot determine map's key implementationType. Specify the implementation explicitly in @ProtobufProperty", element);
            error = true;
        }
        if (keyType == ProtobufType.MAP) {
            this.printError("Missing implementationType error: specify the implementationType of the map's key in @ProtobufProperty", element);
            error = true;
        }
        if (valueType == ProtobufType.MAP) {
            this.printError("Missing implementationType error: specify the implementationType of the map's value in @ProtobufProperty", element);
            error = true;
        }
        if (keyType == ProtobufType.OBJECT) {
            this.printError("Type error: unsupported map key implementationType", element);
            error = true;
        }
        if (error) {
            return Optional.empty();
        }
        ProtobufPropertyType.NormalType keyEntry = new ProtobufPropertyType.NormalType(keyType, keyTypeParameter.get(), keyTypeParameter.get(), false);
        Optional<TypeMirror> valueTypeParameter = this.getTypeParameter(elementType, this.mapType, 1);
        if (valueTypeParameter.isEmpty()) {
            this.printError("Type inference error: cannot determine map's value implementationType. Specify the implementation explicitly in @ProtobufProperty", element);
            return Optional.empty();
        }
        ProtobufPropertyType.NormalType valueEntry = new ProtobufPropertyType.NormalType(valueType, valueTypeParameter.get(), valueTypeParameter.get(), this.isEnum(valueTypeParameter.get()));
        TypeElement fieldTypeElement = (TypeElement)declaredFieldType.asElement();
        if (!fieldTypeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return Optional.of(new ProtobufPropertyType.MapType(elementType, elementType, keyEntry, valueEntry));
        }
        TypeMirror rawFieldType = this.erase(elementType);
        TypeMirror[] typeMirrorArray = typeArguments = declaredFieldType.getTypeArguments() != null ? (TypeMirror[])declaredFieldType.getTypeArguments().toArray(TypeMirror[]::new) : new TypeMirror[]{};
        if (this.isSameType(rawFieldType, this.mapType)) {
            DeclaredType hashMapType = this.processingEnv.getTypeUtils().getDeclaredType(this.hashMapElement, typeArguments);
            return Optional.of(new ProtobufPropertyType.MapType(elementType, hashMapType, keyEntry, valueEntry));
        }
        if (this.isSameType(rawFieldType, this.concurrentMapType)) {
            DeclaredType concurrentHashMapType = this.processingEnv.getTypeUtils().getDeclaredType(this.concurrentHashMapElement, typeArguments);
            return Optional.of(new ProtobufPropertyType.MapType(elementType, concurrentHashMapType, keyEntry, valueEntry));
        }
        return Optional.empty();
    }

    private Optional<TypeMirror> getAtomicValueType(DeclaredType declaredFieldType) {
        return switch (declaredFieldType.asElement().getSimpleName().toString()) {
            case "AtomicReference" -> {
                if (declaredFieldType.getTypeArguments().isEmpty()) {
                    yield Optional.empty();
                }
                yield Optional.of(declaredFieldType.getTypeArguments().getFirst());
            }
            case "AtomicInteger" -> Optional.of(this.getType(Integer.class));
            case "AtomicLong" -> Optional.of(this.getType(Long.class));
            case "AtomicBoolean" -> Optional.of(this.getType(Boolean.class));
            default -> Optional.empty();
        };
    }

    private Optional<TypeMirror> getOptionalValueType(DeclaredType declaredFieldType) {
        return switch (declaredFieldType.asElement().getSimpleName().toString()) {
            case "Optional" -> {
                if (declaredFieldType.getTypeArguments().isEmpty()) {
                    yield Optional.empty();
                }
                yield Optional.of(declaredFieldType.getTypeArguments().getFirst());
            }
            case "OptionalLong" -> Optional.of(this.getType(Long.class));
            case "OptionalInt" -> Optional.of(this.getType(Integer.class));
            case "OptionalDouble" -> Optional.of(this.getType(Double.class));
            default -> Optional.empty();
        };
    }

    private void attributeConverters(Element invoker, ProtobufType from, TypeMirror to, ProtobufPropertyType implementation, Element mixin) {
        TypeMirror fromType = this.getType(from.wrappedType());
        if (!(to instanceof DeclaredType)) {
            return;
        }
        DeclaredType declaredType = (DeclaredType)to;
        if (!this.isSubType(to, fromType) || from == ProtobufType.OBJECT && !this.isSubType(to, this.protoMessageType) && !this.isSubType(to, this.protoEnumType)) {
            ExecutableElement serializer = null;
            ExecutableElement deserializer = null;
            Element convertersWrapper = Objects.requireNonNullElse(mixin, declaredType.asElement());
            for (Element element : convertersWrapper.getEnclosedElements()) {
                if (serializer != null && deserializer != null) break;
                if (!(element instanceof ExecutableElement)) continue;
                ExecutableElement element2 = (ExecutableElement)element;
                if (this.isDeserializer(element2, fromType)) {
                    deserializer = element2;
                    continue;
                }
                if (!this.isSerializer(element2, to, fromType)) continue;
                serializer = element2;
            }
            if (serializer != null) {
                implementation.addNullableConverter(new ProtobufSerializerElement(serializer, serializer.getReturnType().getKind().isPrimitive(), this.isOptional(serializer), new String[0]));
            } else {
                this.printError("Missing converter: cannot find a serializer for %s".formatted(to), invoker);
            }
            if (deserializer != null) {
                implementation.addNullableConverter(new ProtobufDeserializerElement(deserializer));
            } else {
                this.printError("Missing converter: cannot find a deserializer for %s".formatted(fromType), invoker);
            }
        }
    }

    private boolean isOptional(ExecutableElement serializer) {
        return this.isOptional(serializer.getReturnType());
    }

    private boolean isOptional(TypeMirror typeMirror) {
        TypeMirror erased = this.erase(typeMirror);
        return this.optionalSerializers.get(erased.toString()) != null;
    }

    private boolean isDeserializer(ExecutableElement entry, TypeMirror from) {
        return entry.getAnnotation(ProtobufConverter.class) != null && entry.getModifiers().contains((Object)Modifier.STATIC) && entry.getParameters().size() == 1 && this.isSubType(from, entry.getParameters().getFirst().asType());
    }

    private boolean isSerializer(ExecutableElement entry, TypeMirror to, TypeMirror from) {
        boolean isStatic = entry.getModifiers().contains((Object)Modifier.STATIC);
        return entry.getAnnotation(ProtobufConverter.class) != null && entry.getParameters().size() == (isStatic ? 1 : 0) && (!isStatic || this.isSubType(to, entry.getParameters().getFirst().asType())) && this.isSubType(from, entry.getReturnType());
    }

    private boolean isEnum(TypeMirror mirror) {
        DeclaredType declaredType;
        return mirror instanceof DeclaredType && (declaredType = (DeclaredType)mirror).asElement().getKind() == ElementKind.ENUM;
    }

    private Optional<TypeMirror> getTypeParameter(TypeMirror mirror, TypeMirror targetType, int index) {
        if (!(mirror instanceof DeclaredType)) {
            return Optional.empty();
        }
        DeclaredType declaredType = (DeclaredType)mirror;
        if (this.isSameType(mirror, targetType)) {
            TypeMirror collectionTypeArgument = declaredType.getTypeArguments().get(index);
            return this.getConcreteTypeParameter(collectionTypeArgument, declaredType, index);
        }
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        return typeElement.getInterfaces().stream().filter(implemented -> implemented instanceof DeclaredType).map(implemented -> (DeclaredType)implemented).map(implemented -> this.getTypeParameterByImplement(declaredType, (DeclaredType)implemented, targetType, index)).flatMap(Optional::stream).findFirst().or(() -> this.getTypeParameterBySuperClass(declaredType, typeElement, targetType, index));
    }

    private Optional<TypeMirror> getTypeParameterByImplement(DeclaredType declaredType, DeclaredType implemented, TypeMirror targetType, int index) {
        if (this.isSameType(implemented, targetType)) {
            TypeMirror collectionTypeArgument = implemented.getTypeArguments().get(index);
            return this.getConcreteTypeParameter(collectionTypeArgument, declaredType, index);
        }
        return this.getTypeParameter(implemented, targetType, index).flatMap(result -> this.getConcreteTypeParameter((TypeMirror)result, declaredType, index));
    }

    private Optional<TypeMirror> getTypeParameterBySuperClass(DeclaredType declaredType, TypeElement typeElement, TypeMirror targetType, int index) {
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (!(typeMirror instanceof DeclaredType)) {
            return Optional.empty();
        }
        DeclaredType superDeclaredType = (DeclaredType)typeMirror;
        return this.getTypeParameter(superDeclaredType, targetType, index).flatMap(result -> this.getConcreteTypeParameter((TypeMirror)result, superDeclaredType, index)).flatMap(result -> this.getConcreteTypeParameter((TypeMirror)result, declaredType, index));
    }

    private Optional<TypeMirror> getConcreteTypeParameter(TypeMirror argumentMirror, DeclaredType previousType, int index) {
        TypeMirror typeMirror = argumentMirror;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DeclaredType.class, ArrayType.class, TypeVariable.class}, (Object)typeMirror, n)) {
            case 0 -> {
                DeclaredType declaredTypeArgument = (DeclaredType)typeMirror;
                yield Optional.of(declaredTypeArgument);
            }
            case 1 -> {
                ArrayType arrayType = (ArrayType)typeMirror;
                yield Optional.of(arrayType);
            }
            case 2 -> {
                TypeVariable typeVariableArgument = (TypeVariable)typeMirror;
                yield this.getConcreteTypeFromTypeVariable(typeVariableArgument, previousType, index);
            }
            default -> Optional.empty();
        };
    }

    private Optional<TypeMirror> getConcreteTypeFromTypeVariable(TypeVariable typeVariableArgument, DeclaredType previousType, int index) {
        Name currentTypeVarName = typeVariableArgument.asElement().getSimpleName();
        List<? extends TypeMirror> previousTypeArguments = previousType.getTypeArguments();
        TypeElement previousElement = (TypeElement)previousType.asElement();
        List<? extends TypeParameterElement> previousTypeParameters = previousElement.getTypeParameters();
        while (index < previousTypeParameters.size() && index < previousTypeArguments.size()) {
            if (previousTypeParameters.get(index).getSimpleName().equals(currentTypeVarName)) {
                return Optional.of(previousTypeArguments.get(index));
            }
            ++index;
        }
        return Optional.empty();
    }

    private boolean isSameType(TypeMirror firstType, TypeMirror secondType) {
        return this.processingEnv.getTypeUtils().isSameType(this.erase(firstType), secondType);
    }

    private TypeMirror erase(TypeMirror typeMirror) {
        TypeMirror result = this.processingEnv.getTypeUtils().erasure(typeMirror);
        return result == null ? typeMirror : result;
    }

    private boolean isSubType(TypeMirror child, TypeMirror parent) {
        TypeElement boxed;
        PrimitiveType primitiveType;
        if (child instanceof PrimitiveType) {
            primitiveType = (PrimitiveType)child;
            boxed = this.processingEnv.getTypeUtils().boxedClass(primitiveType);
            child = boxed.asType();
        }
        if (parent instanceof PrimitiveType) {
            primitiveType = (PrimitiveType)parent;
            boxed = this.processingEnv.getTypeUtils().boxedClass(primitiveType);
            parent = boxed.asType();
        }
        return this.processingEnv.getTypeUtils().isSubtype(this.erase(child), this.erase(parent));
    }

    private boolean isValidRequiredProperty(VariableElement variableElement) {
        if (variableElement.asType().getKind().isPrimitive()) {
            this.printError("Required properties cannot be primitives", variableElement);
            return false;
        }
        return true;
    }

    private boolean isValidPackedProperty(VariableElement variableElement, ProtobufProperty propertyAnnotation) {
        if (!propertyAnnotation.packed() || this.isSubType(variableElement.asType(), this.collectionType)) {
            return true;
        }
        this.printError("Only scalar properties can be packed", variableElement);
        return false;
    }

    private Optional<ProtobufMessageElement> processEnum(TypeElement enumElement) {
        Optional<ProtobufMessageElement> messageElement = this.createEnumElement(enumElement);
        if (messageElement.isEmpty()) {
            return messageElement;
        }
        long constantsCount = this.processEnumConstants(messageElement.get());
        if (constantsCount != 0L) {
            return messageElement;
        }
        this.printWarning("No constants found", enumElement);
        return messageElement;
    }

    private long processEnumConstants(ProtobufMessageElement messageElement) {
        ClassTree enumTree = this.trees.getTree(messageElement.element());
        return enumTree.getMembers().stream().filter(member -> member instanceof VariableTree).map(member -> (VariableTree)member).peek(variableTree -> this.processEnumConstant(messageElement, messageElement.element(), (VariableTree)variableTree)).count();
    }

    private Optional<ProtobufMessageElement> createEnumElement(TypeElement enumElement) {
        Optional<ProtobufEnumMetadata> metadata = this.getEnumMetadata(enumElement);
        if (metadata.isEmpty()) {
            this.printError("Missing protobuf enum constructor: an enum should provide a constructor with a scalar parameter annotated with @ProtobufEnumIndex", enumElement);
            return Optional.empty();
        }
        if (metadata.get().isUnknown()) {
            return Optional.empty();
        }
        ProtobufMessageElement result = new ProtobufMessageElement(enumElement, metadata.get());
        return Optional.of(result);
    }

    private Optional<ProtobufEnumMetadata> getEnumMetadata(TypeElement enumElement) {
        ProtobufEnumFields fields = this.getEnumFields(enumElement);
        return this.getConstructors(enumElement).stream().map(constructor -> this.getEnumMetadata((ExecutableElement)constructor, fields)).flatMap(Optional::stream).reduce((first, second) -> {
            this.printError("Duplicated protobuf constructor: an enum should provide only one constructor with a scalar parameter annotated with @ProtobufEnumIndex", second.constructor());
            return first;
        });
    }

    private Optional<ProtobufEnumMetadata> getEnumMetadata(ExecutableElement constructor, ProtobufEnumFields fields) {
        MethodTree constructorTree = this.trees.getTree(constructor);
        return IntStream.range(0, constructor.getParameters().size()).filter(index -> this.isImplicitEnumConstructor(constructor) || this.hasProtobufIndexAnnotation(constructor, index)).mapToObj(index -> this.getEnumMetadata(constructor, constructor.getParameters().get(index), index, constructorTree, fields)).reduce((first, second) -> {
            this.printError("Duplicated protobuf enum index: an enum constructor should provide only one parameter annotated with @ProtobufEnumIndex", second.parameter());
            return first;
        });
    }

    private boolean isImplicitEnumConstructor(ExecutableElement constructor) {
        return constructor.getParameters().size() == 1 && this.isSameType(constructor.getParameters().getFirst().asType(), this.intType);
    }

    private boolean hasProtobufIndexAnnotation(ExecutableElement constructor, int index) {
        return constructor.getParameters().get(index).getAnnotation(ProtobufEnumIndex.class) != null;
    }

    private ProtobufEnumMetadata getEnumMetadata(ExecutableElement constructor, VariableElement parameter, int index, MethodTree constructorTree, ProtobufEnumFields fields) {
        if (fields.enumIndexField() != null) {
            return new ProtobufEnumMetadata(constructor, fields.enumIndexField(), parameter, index);
        }
        return constructorTree.getBody().getStatements().stream().filter(constructorEntry -> constructorEntry instanceof ExpressionStatementTree).map(constructorEntry -> ((ExpressionStatementTree)constructorEntry).getExpression()).filter(constructorEntry -> constructorEntry instanceof AssignmentTree).map(constructorEntry -> (AssignmentTree)constructorEntry).filter(assignmentTree -> this.isEnumIndexParameterAssignment((AssignmentTree)assignmentTree, parameter)).map(this::getAssignmentExpressionName).flatMap(Optional::stream).map(fields.fields()::get).filter(Objects::nonNull).reduce((first, second) -> {
            this.printError("Duplicated assignment: the parameter annotated with @ProtobufEnumIndex must be assigned to a single local field", (Element)second);
            return first;
        }).map(fieldElement -> {
            this.checkProtobufEnumIndexField((VariableElement)fieldElement);
            return new ProtobufEnumMetadata(constructor, (VariableElement)fieldElement, parameter, index);
        }).orElseGet(() -> {
            this.printError("Missing or too complex assignment: the parameter annotated with @ProtobufEnumIndex should be assigned to a local field", constructor);
            this.printError("If the assignment is too complex for the compiler to evaluate, annotate the local field directly with @ProtobufEnumIndex", constructor);
            return ProtobufEnumMetadata.unknown();
        });
    }

    private boolean isEnumIndexParameterAssignment(AssignmentTree assignmentTree, VariableElement parameter) {
        IdentifierTree identifierTree;
        ExpressionTree expressionTree = assignmentTree.getExpression();
        return expressionTree instanceof IdentifierTree && (identifierTree = (IdentifierTree)expressionTree).getName().equals(parameter.getSimpleName());
    }

    private Optional<Name> getAssignmentExpressionName(AssignmentTree assignmentTree) {
        ExpressionTree expressionTree = assignmentTree.getExpression();
        if (expressionTree instanceof IdentifierTree) {
            IdentifierTree fieldIdentifier = (IdentifierTree)expressionTree;
            return Optional.of(fieldIdentifier.getName());
        }
        expressionTree = assignmentTree.getExpression();
        if (expressionTree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)expressionTree;
            return Optional.of(memberSelectTree.getIdentifier());
        }
        return Optional.empty();
    }

    private ProtobufEnumFields getEnumFields(TypeElement enumElement) {
        HashMap<Name, VariableElement> fields = new HashMap<Name, VariableElement>();
        for (Element element : enumElement.getEnclosedElements()) {
            if (!(element instanceof VariableElement)) continue;
            VariableElement variableElement = (VariableElement)element;
            if (variableElement.getAnnotation(ProtobufEnumIndex.class) != null) {
                this.checkProtobufEnumIndexField(variableElement);
                return new ProtobufEnumFields(variableElement, null);
            }
            fields.put(variableElement.getSimpleName(), variableElement);
        }
        return new ProtobufEnumFields(null, fields);
    }

    private void checkProtobufEnumIndexField(VariableElement variableElement) {
        if (!variableElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return;
        }
        this.printError("Weak visibility: the field annotated with @ProtobufEnumIndex must have at least package-private visibility", variableElement);
    }

    private List<ExecutableElement> getConstructors(TypeElement enumElement) {
        return enumElement.getEnclosedElements().stream().filter(entry -> entry instanceof ExecutableElement).map(entry -> (ExecutableElement)entry).filter(entry -> entry.getKind() == ElementKind.CONSTRUCTOR).toList();
    }

    private void processEnumConstant(ProtobufMessageElement messageElement, TypeElement enumElement, VariableTree enumConstantTree) {
        ExpressionTree expressionTree = enumConstantTree.getInitializer();
        if (!(expressionTree instanceof NewClassTree)) {
            return;
        }
        NewClassTree newClassTree = (NewClassTree)expressionTree;
        String newClassType = newClassTree.getIdentifier().toString();
        String simpleEnumName = enumElement.getSimpleName().toString();
        if (!newClassType.equals(simpleEnumName) && !newClassType.equals(messageElement.element().getQualifiedName().toString())) {
            return;
        }
        String variableName = enumConstantTree.getName().toString();
        if (newClassTree.getArguments().isEmpty()) {
            this.printError("%s doesn't specify an index".formatted(variableName), enumElement);
            return;
        }
        ExpressionTree indexArgument = newClassTree.getArguments().get(messageElement.enumMetadata().orElseThrow().parameterIndex());
        if (!(indexArgument instanceof LiteralTree)) {
            this.printError("%s's index must be a constant value".formatted(variableName), enumElement);
            return;
        }
        LiteralTree literalTree = (LiteralTree)indexArgument;
        int value = ((Number)literalTree.getValue()).intValue();
        if (value < 0) {
            this.printError("%s's index must be a positive".formatted(variableName), enumElement);
            return;
        }
        Optional<String> error = messageElement.addConstant(value, variableName);
        if (error.isEmpty()) {
            return;
        }
        this.printError("Duplicated enum constant: %s and %s with index %s".formatted(variableName, error.get(), value), enumElement);
    }

    private List<TypeElement> getProtobufObjects(RoundEnvironment roundEnv) {
        return this.getElements(roundEnv.getRootElements()).stream().filter(entry -> this.isSubType(entry.asType(), this.protoObjectType)).toList();
    }

    private Set<TypeElement> getElements(Collection<? extends Element> elements) {
        HashSet<TypeElement> results = new HashSet<TypeElement>();
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            results.add(typeElement);
            results.addAll(this.getElements(typeElement.getEnclosedElements()));
        }
        return results;
    }

    private void printWarning(String msg, Element constructor) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, constructor);
    }

    private void printError(String msg, Element constructor) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, constructor);
    }

    private record ProtobufEnumFields(VariableElement enumIndexField, Map<Name, VariableElement> fields) {
    }
}

