/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.instrumentation;

import it.auties.protobuf.model.ProtobufType;
import it.auties.protobuf.serialization.converter.ProtobufDeserializerElement;
import it.auties.protobuf.serialization.instrumentation.ProtobufInstrumentationVisitor;
import it.auties.protobuf.serialization.object.ProtobufMessageElement;
import it.auties.protobuf.serialization.property.ProtobufPropertyStub;
import it.auties.protobuf.serialization.property.ProtobufPropertyType;
import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

public class ProtobufDeserializationVisitor
extends ProtobufInstrumentationVisitor {
    private static final String DEFAULT_STREAM_NAME = "inputStream";

    public ProtobufDeserializationVisitor(ProtobufMessageElement element, PrintWriter writer) {
        super(element, writer);
    }

    @Override
    protected void doInstrumentation() {
        if (this.message.isEnum()) {
            this.createEnumDeserializer();
        } else {
            this.createMessageDeserializer();
        }
    }

    @Override
    public boolean shouldInstrument() {
        return true;
    }

    @Override
    protected List<String> modifiers() {
        return List.of("public", "static");
    }

    @Override
    protected String name() {
        return "decode";
    }

    @Override
    protected String returnType() {
        return this.message.isEnum() ? "Optional<%s>".formatted(this.message.element().getSimpleName()) : this.message.element().getSimpleName().toString();
    }

    @Override
    protected List<String> parametersTypes() {
        return this.message.isEnum() ? List.of("int") : List.of("byte[]");
    }

    @Override
    protected List<String> parametersNames() {
        return this.message.isEnum() ? List.of("index") : List.of("input");
    }

    private void createEnumDeserializer() {
        Name fieldName = this.message.enumMetadata().orElseThrow(() -> new NoSuchElementException("Missing metadata from enum")).field().getSimpleName();
        this.writer.println("        return Arrays.stream(%s.values())".formatted(this.message.element().getSimpleName()));
        this.writer.println("                .filter(entry -> entry.%s == index)".formatted(fieldName));
        this.writer.println("                .findFirst();");
    }

    private void createMessageDeserializer() {
        this.writer.println("        if(input == null) {");
        this.writer.println("            return null;");
        this.writer.println("        }");
        this.writer.println("        var %s = new ProtobufInputStream(input);".formatted(DEFAULT_STREAM_NAME));
        for (ProtobufPropertyStub property : this.message.properties()) {
            this.writer.println("        %s %s = %s;".formatted(property.type().fieldType(), property.name(), property.defaultValue()));
        }
        this.writer.println("        while(%s.readTag()) {".formatted(DEFAULT_STREAM_NAME));
        this.writer.println("            switch(%s.index()) {".formatted(DEFAULT_STREAM_NAME));
        ArrayList<String> argumentsList = new ArrayList<String>();
        for (ProtobufPropertyStub property : this.message.properties()) {
            ProtobufPropertyType protobufPropertyType;
            Objects.requireNonNull(property.type());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProtobufPropertyType.MapType.class, ProtobufPropertyType.CollectionType.class}, (Object)protobufPropertyType, n)) {
                case 0: {
                    ProtobufPropertyType.MapType mapType = (ProtobufPropertyType.MapType)protobufPropertyType;
                    this.writeMapSerializer(property, mapType);
                    break;
                }
                case 1: {
                    ProtobufPropertyType.CollectionType collectionType = (ProtobufPropertyType.CollectionType)protobufPropertyType;
                    this.writeDeserializer(property.name(), property.index(), collectionType.value(), true, property.packed());
                    break;
                }
                default: {
                    this.writeDeserializer(property.name(), property.index(), property.type(), false, property.packed());
                }
            }
            argumentsList.add(property.name());
        }
        this.writer.println("                default -> inputStream.skipBytes();");
        this.writer.println("            }");
        this.writer.println("        }");
        this.message.properties().stream().filter(ProtobufPropertyStub::required).forEach(this::checkRequiredProperty);
        this.writer.println("        return new %s(%s);".formatted(this.message.element(), String.join((CharSequence)", ", argumentsList)));
    }

    private void writeMapSerializer(ProtobufPropertyStub property, ProtobufPropertyType.MapType mapType) {
        this.writer.println("                case %s -> {".formatted(property.index()));
        String streamName = "%sInputStream".formatted(property.name());
        String keyName = "%sKey".formatted(property.name());
        String valueName = "%sValue".formatted(property.name());
        this.writer.println("                        var %s = new ProtobufInputStream(%s.readBytes());".formatted(streamName, DEFAULT_STREAM_NAME));
        this.writer.println("                        %s %s = null;".formatted(mapType.keyType().fieldType(), keyName));
        this.writer.println("                        %s %s = null;".formatted(mapType.valueType().fieldType(), valueName));
        String keyReadMethod = this.getDeserializerStreamMethod(mapType.keyType(), false);
        String keyReadValue = this.getReadValue(streamName, mapType.keyType(), keyReadMethod);
        String keyReadFunction = this.getConvertedValue(mapType.keyType(), keyReadValue);
        String valueReadMethod = this.getDeserializerStreamMethod(mapType.valueType(), false);
        String valueReadValue = this.getReadValue(streamName, mapType.valueType(), valueReadMethod);
        String valueReadFunction = this.getConvertedValue(mapType.valueType(), valueReadValue);
        this.writer.println("                        while(%s.readTag()) {".formatted(streamName));
        this.writer.println("                            switch(%s.index()) {".formatted(streamName));
        this.writer.println("                                case 1 -> %s = %s;".formatted(keyName, keyReadFunction));
        this.writer.println("                                case 2 -> %s = %s;".formatted(valueName, valueReadFunction));
        this.writer.println("                            }");
        this.writer.println("                        }");
        this.writer.println("                        %s.put(%s, %s);".formatted(property.name(), keyName, valueName));
        this.writer.println("                }");
    }

    private void writeDeserializer(String name, int index, ProtobufPropertyType type, boolean repeated, boolean packed) {
        String readMethod = this.getDeserializerStreamMethod(type, packed);
        String readValue = this.getReadValue(DEFAULT_STREAM_NAME, type, readMethod);
        String readFunction = this.getConvertedValue(type, readValue);
        String readAssignment = this.getReadAssignment(name, repeated, packed, readFunction);
        this.writer.println("                case %s -> %s;".formatted(index, readAssignment));
    }

    private void checkRequiredProperty(ProtobufPropertyStub property) {
        if (!(property.type() instanceof ProtobufPropertyType.CollectionType)) {
            this.writer.println("        Objects.requireNonNull(%s, \"Missing required property: %s\");".formatted(property.name(), property.name()));
            return;
        }
        this.writer.println("        if(!%s.isEmpty())".formatted(property.name()));
        this.writer.println("            throw new NullPointerException(\"Missing required property: %s\");".formatted(property.name()));
    }

    private String getReadAssignment(String name, boolean repeated, boolean packed, String readFunction) {
        if (!repeated) {
            return "%s = %s".formatted(name, readFunction);
        }
        String repeatedMethod = packed ? "addAll" : "add";
        return "%s.%s(%s)".formatted(name, repeatedMethod, readFunction);
    }

    private String getReadValue(String streamName, ProtobufPropertyType type, String readMethod) {
        String reader = "%s.%s()".formatted(streamName, readMethod);
        if (type.protobufType() != ProtobufType.OBJECT) {
            return reader;
        }
        String specName = this.getSpecName(type.implementationType());
        if (type.isEnum()) {
            return "%s.decode(%s).orElse(null)".formatted(specName, reader);
        }
        return "%s.decode(%s)".formatted(specName, reader);
    }

    private String getConvertedValue(ProtobufPropertyType implementation, String readValue) {
        String result = readValue;
        for (ProtobufDeserializerElement converter : implementation.deserializers()) {
            TypeElement converterWrapperClass;
            if (converter.element().getKind() == ElementKind.CONSTRUCTOR) {
                converterWrapperClass = (TypeElement)converter.element().getEnclosingElement();
                result = "new %s(%s)".formatted(converterWrapperClass.getQualifiedName(), result);
                continue;
            }
            converterWrapperClass = (TypeElement)converter.element().getEnclosingElement();
            Name converterMethodName = converter.element().getSimpleName();
            result = "%s.%s(%s)".formatted(converterWrapperClass.getQualifiedName(), converterMethodName, result);
        }
        return result;
    }

    private String getDeserializerStreamMethod(ProtobufPropertyType type, boolean packed) {
        if (type.isEnum()) {
            return packed ? "readInt32Packed" : "readInt32";
        }
        return switch (type.protobufType()) {
            case ProtobufType.STRING -> "readString";
            case ProtobufType.OBJECT, ProtobufType.BYTES -> "readBytes";
            case ProtobufType.BOOL -> {
                if (packed) {
                    yield "readBoolPacked";
                }
                yield "readBool";
            }
            case ProtobufType.INT32, ProtobufType.SINT32, ProtobufType.UINT32 -> {
                if (packed) {
                    yield "readInt32Packed";
                }
                yield "readInt32";
            }
            case ProtobufType.FLOAT -> {
                if (packed) {
                    yield "readFloatPacked";
                }
                yield "readFloat";
            }
            case ProtobufType.DOUBLE -> {
                if (packed) {
                    yield "readDoublePacked";
                }
                yield "readDouble";
            }
            case ProtobufType.FIXED32, ProtobufType.SFIXED32 -> {
                if (packed) {
                    yield "readFixed32Packed";
                }
                yield "readFixed32";
            }
            case ProtobufType.INT64, ProtobufType.SINT64, ProtobufType.UINT64 -> {
                if (packed) {
                    yield "readInt64Packed";
                }
                yield "readInt64";
            }
            case ProtobufType.FIXED64, ProtobufType.SFIXED64 -> {
                if (packed) {
                    yield "readFixed64Packed";
                }
                yield "readFixed64";
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(type.protobufType()));
        };
    }
}

