/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.instrumentation;

import it.auties.protobuf.serialization.object.ProtobufMessageElement;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public abstract class ProtobufInstrumentationVisitor {
    protected final ProtobufMessageElement message;
    protected final PrintWriter writer;

    protected ProtobufInstrumentationVisitor(ProtobufMessageElement message, PrintWriter writer) {
        this.message = message;
        this.writer = writer;
    }

    public void instrument() {
        if (!this.shouldInstrument()) {
            return;
        }
        this.writer.print("    ");
        this.writer.print(String.join((CharSequence)" ", this.modifiers()));
        this.writer.print(" ");
        this.writer.print(this.returnType());
        this.writer.print(" ");
        this.writer.print(this.name());
        this.writer.print("(");
        List<String> parametersTypes = this.parametersTypes();
        List<String> parametersNames = this.parametersNames();
        if (parametersTypes.size() != parametersNames.size()) {
            throw new IllegalArgumentException("Parameters mismatch");
        }
        Iterator<String> parametersTypesIterator = parametersTypes.iterator();
        Iterator<String> parametersNamesIterator = parametersNames.iterator();
        ArrayList<String> parameters = new ArrayList<String>();
        while (parametersTypesIterator.hasNext()) {
            parameters.add("%s %s".formatted(parametersTypesIterator.next(), parametersNamesIterator.next()));
        }
        this.writer.print(String.join((CharSequence)", ", parameters));
        this.writer.print(") {\n");
        this.doInstrumentation();
        this.writer.println("    }\n");
    }

    public abstract boolean shouldInstrument();

    protected abstract void doInstrumentation();

    protected abstract List<String> modifiers();

    protected abstract String returnType();

    protected abstract String name();

    protected abstract List<String> parametersTypes();

    protected abstract List<String> parametersNames();

    protected String getSpecName(TypeMirror typeMirror) {
        if (!(typeMirror instanceof DeclaredType)) {
            return "";
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        TypeElement element = (TypeElement)declaredType.asElement();
        String packageName = null;
        StringBuilder name = new StringBuilder();
        for (Element parent = element.getEnclosingElement(); parent != null; parent = parent.getEnclosingElement()) {
            if (parent instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)parent;
                name.append(typeElement.getSimpleName());
                continue;
            }
            if (!(parent instanceof PackageElement)) continue;
            PackageElement packageElement = (PackageElement)parent;
            packageName = packageElement.getQualifiedName().toString();
            break;
        }
        name.append(declaredType.asElement().getSimpleName());
        StringBuilder result = new StringBuilder();
        if (packageName != null) {
            result.append(packageName);
            result.append(".");
        }
        result.append((CharSequence)name);
        result.append("Spec");
        return result.toString();
    }
}

