/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.instrumentation;

import it.auties.protobuf.model.ProtobufType;
import it.auties.protobuf.serialization.converter.ProtobufSerializerElement;
import it.auties.protobuf.serialization.instrumentation.ProtobufInstrumentationVisitor;
import it.auties.protobuf.serialization.object.ProtobufMessageElement;
import it.auties.protobuf.serialization.property.ProtobufPropertyStub;
import it.auties.protobuf.serialization.property.ProtobufPropertyType;
import it.auties.protobuf.stream.ProtobufOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class ProtobufSerializationVisitor
extends ProtobufInstrumentationVisitor {
    private static final String DEFAULT_OUTPUT_STREAM_NAME = "outputStream";
    private static final String DEFAULT_PARAMETER_NAME = "protoInputObject";

    public ProtobufSerializationVisitor(ProtobufMessageElement element, PrintWriter writer) {
        super(element, writer);
    }

    @Override
    protected void doInstrumentation() {
        this.writer.println("      if(%s == null) {".formatted(DEFAULT_PARAMETER_NAME));
        this.writer.println("         return null;");
        this.writer.println("      }");
        if (this.message.isEnum()) {
            this.createEnumSerializer();
        } else {
            this.createMessageSerializer();
        }
    }

    private void createEnumSerializer() {
        Name fieldName = this.message.enumMetadata().orElseThrow(() -> new NoSuchElementException("Missing metadata from enum")).field().getSimpleName();
        this.writer.println("      return %s.%s;".formatted(DEFAULT_PARAMETER_NAME, fieldName));
    }

    private void createMessageSerializer() {
        this.createRequiredPropertiesNullCheck();
        this.writer.println("      var %s = new ProtobufOutputStream();".formatted(DEFAULT_OUTPUT_STREAM_NAME));
        this.message.properties().forEach(this::writeProperty);
        this.writer.println("      return %s.toByteArray();".formatted(DEFAULT_OUTPUT_STREAM_NAME));
    }

    private void createRequiredPropertiesNullCheck() {
        this.message.properties().stream().filter(ProtobufPropertyStub::required).forEach(entry -> this.writer.println("      Objects.requireNonNull(%s.%s(), \"Missing required property: %s\");".formatted(DEFAULT_PARAMETER_NAME, entry.name(), entry.name())));
    }

    @Override
    public boolean shouldInstrument() {
        return !this.message.isEnum() || !this.hasEnumSerializationMethod();
    }

    private boolean hasEnumSerializationMethod() {
        return this.message.element().getEnclosedElements().stream().anyMatch(this::isEnumSerializationMethod);
    }

    private boolean isEnumSerializationMethod(Element entry) {
        ExecutableElement executableElement;
        return entry instanceof ExecutableElement && (executableElement = (ExecutableElement)entry).getSimpleName().contentEquals(this.name()) && executableElement.getParameters().isEmpty();
    }

    @Override
    protected List<String> modifiers() {
        return List.of("public", "static");
    }

    @Override
    protected String returnType() {
        return this.message.isEnum() ? "Integer" : "byte[]";
    }

    @Override
    public String name() {
        return "encode";
    }

    @Override
    protected List<String> parametersTypes() {
        return List.of(this.message.element().getSimpleName().toString());
    }

    @Override
    protected List<String> parametersNames() {
        return List.of(DEFAULT_PARAMETER_NAME);
    }

    private void writeProperty(ProtobufPropertyStub property) {
        ProtobufPropertyType protobufPropertyType = property.type();
        Objects.requireNonNull(protobufPropertyType);
        ProtobufPropertyType protobufPropertyType2 = protobufPropertyType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProtobufPropertyType.CollectionType.class, ProtobufPropertyType.MapType.class}, (Object)protobufPropertyType2, n)) {
            case 0: {
                ProtobufPropertyType.CollectionType collectionType = (ProtobufPropertyType.CollectionType)protobufPropertyType2;
                this.writeRepeatedPropertySerializer(property, collectionType);
                break;
            }
            case 1: {
                ProtobufPropertyType.MapType mapType = (ProtobufPropertyType.MapType)protobufPropertyType2;
                this.writeMapSerializer(property, mapType);
                break;
            }
            default: {
                this.writeSerializer(property.index(), property.name(), this.getAccessorCall(property), property.type(), DEFAULT_OUTPUT_STREAM_NAME);
            }
        }
    }

    private String getAccessorCall(ProtobufPropertyStub property) {
        Element element = property.accessor();
        Objects.requireNonNull(element);
        Element element2 = element;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExecutableElement.class, VariableElement.class}, (Object)element2, n)) {
            case 0 -> {
                ExecutableElement executableElement = (ExecutableElement)element2;
                yield "%s.%s()".formatted(DEFAULT_PARAMETER_NAME, executableElement.getSimpleName());
            }
            case 1 -> {
                VariableElement variableElement = (VariableElement)element2;
                yield "%s.%s".formatted(DEFAULT_PARAMETER_NAME, variableElement.getSimpleName());
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(property.accessor()));
        };
    }

    private void writeRepeatedPropertySerializer(ProtobufPropertyStub property, ProtobufPropertyType.CollectionType collectionType) {
        this.writer.println("      if(%s.%s() != null) {".formatted(DEFAULT_PARAMETER_NAME, property.name()));
        String localVariableName = "%sEntry".formatted(property.name());
        this.writer.println("       for(var %s : %s.%s()) {".formatted(localVariableName, DEFAULT_PARAMETER_NAME, property.name()));
        this.writeSerializer(property.index(), property.name(), localVariableName, collectionType.value(), DEFAULT_OUTPUT_STREAM_NAME);
        this.writer.println("       }");
        this.writer.println("      }");
    }

    private void writeMapSerializer(ProtobufPropertyStub property, ProtobufPropertyType.MapType mapType) {
        this.writer.println("      if(%s.%s() != null) {".formatted(DEFAULT_PARAMETER_NAME, property.name()));
        String localStreamName = "%sOutputStream".formatted(property.name());
        String localVariableName = "%sEntry".formatted(property.name());
        this.writer.println("            for(var %s : %s.entrySet()) {".formatted(localVariableName, this.getAccessorCall(property)));
        this.writer.println("                var %s = new ProtobufOutputStream();".formatted(localStreamName));
        this.writeSerializer(1, property.name(), "%s.getKey()".formatted(localVariableName), mapType.keyType(), localStreamName);
        this.writeSerializer(2, property.name(), "%s.getValue()".formatted(localVariableName), mapType.valueType(), localStreamName);
        this.writer.println("                %s.writeBytes(%s, %s.toByteArray());".formatted(DEFAULT_OUTPUT_STREAM_NAME, property.index(), localStreamName));
        this.writer.println("            }");
        this.writer.println("      }");
    }

    private void writeSerializer(int index, String name, String caller, ProtobufPropertyType type, String streamName) {
        Method writeMethod = this.getSerializerStreamMethods(type);
        ProtobufPropertyVariables result = this.getVariables(name, caller, type);
        if (!result.hasConverter()) {
            String toWrite = result.variables().getFirst().value();
            String toWriteConverted = type.protobufType() != ProtobufType.OBJECT ? toWrite : "%s.encode(%s)".formatted(this.getSpecName(type.implementationType()), toWrite);
            this.writer.println("%s.%s(%s, %s);".formatted(streamName, writeMethod.getName(), index, toWriteConverted));
            return;
        }
        String propertyName = null;
        for (int i = 0; i < result.variables().size(); ++i) {
            ProtobufPropertyVariable variable = result.variables().get(i);
            this.writer.println(variable.value());
            propertyName = name + String.valueOf(i == 0 ? "" : Integer.valueOf(i - 1));
            if (variable.isPrimitive() || variable.isOptional()) continue;
            this.writer.println("if(%s != null) {".formatted(propertyName));
        }
        String toWriteConverted = type.protobufType() != ProtobufType.OBJECT ? propertyName : "%s.encode(%s)".formatted(this.getSpecName(type.implementationType()), propertyName);
        this.writer.println("%s.%s(%s, %s);".formatted(streamName, writeMethod.getName(), index, toWriteConverted));
        for (ProtobufPropertyVariable variable : result.variables()) {
            if (variable.isPrimitive() || variable.isOptional()) continue;
            this.writer.println("}");
        }
    }

    private ProtobufPropertyVariables getVariables(String name, String caller, ProtobufPropertyType type) {
        List<ProtobufSerializerElement> serializers = type.serializers();
        boolean isPrimitive = type.isPrimitive();
        boolean isOptional = type instanceof ProtobufPropertyType.OptionalType;
        if (serializers.isEmpty()) {
            ProtobufPropertyVariable variable = new ProtobufPropertyVariable(caller, isPrimitive, isOptional);
            return new ProtobufPropertyVariables(false, List.of(variable));
        }
        ArrayList<ProtobufPropertyVariable> results = new ArrayList<ProtobufPropertyVariable>();
        results.add(new ProtobufPropertyVariable("var %s = %s;".formatted(name, caller), isPrimitive, isOptional));
        boolean useMap = false;
        for (int index = 0; index < serializers.size(); ++index) {
            ProtobufSerializerElement serializerElement = serializers.get(index);
            String lastInitializer = index == 0 ? name : name + (index - 1);
            String currentInitializer = name + index;
            String convertedInitializer = this.getConvertedInitializer(serializerElement, lastInitializer, useMap);
            results.add(new ProtobufPropertyVariable("var %s = %s;".formatted(currentInitializer, convertedInitializer), serializerElement.primitive(), serializerElement.optional()));
            useMap |= serializerElement.optional();
        }
        return new ProtobufPropertyVariables(true, results);
    }

    private String getConvertedInitializer(ProtobufSerializerElement serializerElement, String lastInitializer, boolean useMap) {
        if (serializerElement.element().getKind() == ElementKind.CONSTRUCTOR) {
            TypeElement converterWrapperClass = (TypeElement)serializerElement.element().getEnclosingElement();
            return "new %s(%s)".formatted(converterWrapperClass.getQualifiedName(), lastInitializer);
        }
        if (serializerElement.element().getModifiers().contains((Object)Modifier.STATIC)) {
            TypeElement converterWrapperClass = (TypeElement)serializerElement.element().getEnclosingElement();
            if (!useMap) {
                return "%s.%s(%s)".formatted(converterWrapperClass.getQualifiedName(), serializerElement.element().getSimpleName(), lastInitializer);
            }
            String method = serializerElement.optional() ? "flatMap" : "map";
            return "%s.%s(lambdaArg -> %s.%s(lambdaArg))".formatted(lastInitializer, method, converterWrapperClass.getQualifiedName(), serializerElement.element().getSimpleName());
        }
        if (!useMap) {
            return "%s.%s(%s)".formatted(lastInitializer, serializerElement.element().getSimpleName(), String.join((CharSequence)", ", serializerElement.arguments()));
        }
        String method = serializerElement.optional() ? "flatMap" : "map";
        return "%s.%s(lambdaArg -> lambdaArg.%s(%s))".formatted(lastInitializer, method, serializerElement.element().getSimpleName(), String.join((CharSequence)", ", serializerElement.arguments()));
    }

    private Method getSerializerStreamMethods(ProtobufPropertyType type) {
        try {
            Class<ProtobufOutputStream> clazz = ProtobufOutputStream.class;
            return switch (type.protobufType()) {
                case ProtobufType.STRING -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeString", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeString", Integer.TYPE, String.class);
                }
                case ProtobufType.OBJECT -> {
                    if (type.isEnum()) {
                        yield clazz.getMethod("writeInt32", Integer.TYPE, Integer.class);
                    }
                    yield clazz.getMethod("writeBytes", Integer.TYPE, byte[].class);
                }
                case ProtobufType.BYTES -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeBytes", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeBytes", Integer.TYPE, byte[].class);
                }
                case ProtobufType.BOOL -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeBool", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeBool", Integer.TYPE, Boolean.class);
                }
                case ProtobufType.INT32, ProtobufType.SINT32 -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeInt32", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeInt32", Integer.TYPE, Integer.class);
                }
                case ProtobufType.UINT32 -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeUInt32", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeUInt32", Integer.TYPE, Integer.class);
                }
                case ProtobufType.FLOAT -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeFloat", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeFloat", Integer.TYPE, Float.class);
                }
                case ProtobufType.DOUBLE -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeDouble", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeDouble", Integer.TYPE, Double.class);
                }
                case ProtobufType.FIXED32, ProtobufType.SFIXED32 -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeFixed32", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeFixed32", Integer.TYPE, Integer.class);
                }
                case ProtobufType.INT64, ProtobufType.SINT64 -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeInt64", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeInt64", Integer.TYPE, Long.class);
                }
                case ProtobufType.UINT64 -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeUInt64", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeUInt64", Integer.TYPE, Long.class);
                }
                case ProtobufType.FIXED64, ProtobufType.SFIXED64 -> {
                    if (this.isRepeatedWithoutConversion(type)) {
                        yield clazz.getMethod("writeFixed64", Integer.TYPE, Collection.class);
                    }
                    yield clazz.getMethod("writeFixed64", Integer.TYPE, Long.class);
                }
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(type.protobufType()));
            };
        }
        catch (NoSuchMethodException exception) {
            throw new RuntimeException("Missing element method", exception);
        }
    }

    private boolean isRepeatedWithoutConversion(ProtobufPropertyType type) {
        return type instanceof ProtobufPropertyType.CollectionType && type.serializers().isEmpty();
    }

    private record ProtobufPropertyVariables(boolean hasConverter, List<ProtobufPropertyVariable> variables) {
    }

    private record ProtobufPropertyVariable(String value, boolean isPrimitive, boolean isOptional) {
    }
}

