/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.object;

import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.serialization.object.ProtobufBuilderElement;
import it.auties.protobuf.serialization.object.ProtobufEnumMetadata;
import it.auties.protobuf.serialization.property.ProtobufPropertyStub;
import it.auties.protobuf.serialization.property.ProtobufPropertyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class ProtobufMessageElement {
    private final TypeElement typeElement;
    private final Map<Integer, ProtobufPropertyStub> properties;
    private final List<ProtobufBuilderElement> builders;
    private final Map<Integer, String> constants;
    private final ProtobufEnumMetadata enumMetadata;

    public ProtobufMessageElement(TypeElement typeElement, ProtobufEnumMetadata enumMetadata) {
        this.typeElement = typeElement;
        this.enumMetadata = enumMetadata;
        this.builders = new ArrayList<ProtobufBuilderElement>();
        this.properties = new LinkedHashMap<Integer, ProtobufPropertyStub>();
        this.constants = new LinkedHashMap<Integer, String>();
    }

    public TypeElement element() {
        return this.typeElement;
    }

    public String getGeneratedClassNameBySuffix(String suffix) {
        return this.getGeneratedClassNameByName(String.valueOf(this.element().getSimpleName()) + suffix);
    }

    public String getGeneratedClassNameByName(String className) {
        Element element;
        StringBuilder name = new StringBuilder();
        TypeElement element2 = this.element();
        while ((element = element2.getEnclosingElement()) instanceof TypeElement) {
            TypeElement parent = (TypeElement)element;
            name.append(parent.getSimpleName());
            element2 = parent;
        }
        return String.valueOf(name) + className;
    }

    public Optional<ProtobufEnumMetadata> enumMetadata() {
        return Optional.of(this.enumMetadata);
    }

    public List<ProtobufPropertyStub> properties() {
        return List.copyOf(this.properties.values());
    }

    public boolean isEnum() {
        return this.typeElement.getKind() == ElementKind.ENUM;
    }

    public Map<Integer, String> constants() {
        return Collections.unmodifiableMap(this.constants);
    }

    public Optional<String> addConstant(int fieldIndex, String fieldName) {
        return Optional.ofNullable(this.constants.put(fieldIndex, fieldName));
    }

    public Optional<ProtobufPropertyStub> addProperty(Element element, Element accessor, ProtobufPropertyType type, ProtobufProperty property) {
        if (property.ignored()) {
            return Optional.empty();
        }
        String fieldName = element.getSimpleName().toString();
        ProtobufPropertyStub result = new ProtobufPropertyStub(fieldName, accessor, type, property);
        return Optional.ofNullable(this.properties.put(property.index(), result));
    }

    public void addBuilder(String className, List<? extends VariableElement> parameters, ExecutableElement executableElement) {
        this.builders.add(new ProtobufBuilderElement(className, parameters, executableElement));
    }

    public List<ProtobufBuilderElement> builders() {
        return Collections.unmodifiableList(this.builders);
    }
}

