/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.property;

import it.auties.protobuf.model.ProtobufType;
import it.auties.protobuf.serialization.converter.ProtobufConverterElement;
import it.auties.protobuf.serialization.converter.ProtobufDeserializerElement;
import it.auties.protobuf.serialization.converter.ProtobufSerializerElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public sealed interface ProtobufPropertyType {
    public ProtobufType protobufType();

    public List<ProtobufConverterElement> converters();

    public TypeMirror fieldType();

    public TypeMirror implementationType();

    public void addNullableConverter(ProtobufConverterElement var1);

    public boolean isPrimitive();

    public boolean isEnum();

    default public List<ProtobufSerializerElement> serializers() {
        return this.converters().stream().filter(entry -> entry instanceof ProtobufSerializerElement).map(entry -> (ProtobufSerializerElement)entry).toList();
    }

    default public List<ProtobufDeserializerElement> deserializers() {
        return this.converters().stream().filter(entry -> entry instanceof ProtobufDeserializerElement).map(entry -> (ProtobufDeserializerElement)entry).toList();
    }

    public record MapType(TypeMirror fieldType, TypeMirror mapType, NormalType keyType, NormalType valueType) implements ProtobufPropertyType
    {
        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isEnum() {
            return false;
        }

        @Override
        public TypeMirror implementationType() {
            return this.fieldType;
        }

        @Override
        public List<ProtobufConverterElement> converters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addNullableConverter(ProtobufConverterElement element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProtobufType protobufType() {
            return ProtobufType.MAP;
        }
    }

    public record CollectionType(TypeMirror fieldType, TypeMirror collectionType, NormalType value) implements ProtobufPropertyType
    {
        @Override
        public TypeMirror implementationType() {
            return this.value.implementationType();
        }

        @Override
        public ProtobufType protobufType() {
            return this.value.protobufType();
        }

        @Override
        public boolean isEnum() {
            return this.value.isEnum();
        }

        @Override
        public boolean isPrimitive() {
            return this.value.isPrimitive();
        }

        @Override
        public List<ProtobufConverterElement> converters() {
            return this.value.converters();
        }

        @Override
        public void addNullableConverter(ProtobufConverterElement element) {
            this.value.addNullableConverter(element);
        }
    }

    public record AtomicType(TypeMirror atomicType, NormalType value) implements ProtobufPropertyType
    {
        @Override
        public TypeMirror fieldType() {
            return this.atomicType;
        }

        @Override
        public TypeMirror implementationType() {
            return this.value.implementationType();
        }

        @Override
        public ProtobufType protobufType() {
            return this.value.protobufType();
        }

        @Override
        public boolean isEnum() {
            return this.value.isEnum();
        }

        @Override
        public boolean isPrimitive() {
            return this.value.isPrimitive();
        }

        @Override
        public List<ProtobufConverterElement> converters() {
            return this.value.converters();
        }

        @Override
        public void addNullableConverter(ProtobufConverterElement element) {
            this.value.addNullableConverter(element);
        }
    }

    public record OptionalType(TypeMirror optionalType, NormalType value) implements ProtobufPropertyType
    {
        @Override
        public TypeMirror fieldType() {
            return this.optionalType;
        }

        @Override
        public TypeMirror implementationType() {
            return this.value.implementationType();
        }

        @Override
        public ProtobufType protobufType() {
            return this.value.protobufType();
        }

        @Override
        public boolean isEnum() {
            return this.value.isEnum();
        }

        @Override
        public boolean isPrimitive() {
            return this.value.isPrimitive();
        }

        @Override
        public List<ProtobufConverterElement> converters() {
            return this.value.converters();
        }

        @Override
        public void addNullableConverter(ProtobufConverterElement element) {
            this.value.addNullableConverter(element);
        }
    }

    public record NormalType(ProtobufType protobufType, TypeMirror fieldType, TypeMirror implementationType, List<ProtobufConverterElement> converters, boolean isEnum) implements ProtobufPropertyType
    {
        private final List<ProtobufConverterElement> converters;

        public NormalType(ProtobufType protobufType, TypeMirror fieldType, TypeMirror implementationType, boolean isEnum) {
            this(protobufType, fieldType, implementationType, new ArrayList<ProtobufConverterElement>(), isEnum);
        }

        @Override
        public boolean isPrimitive() {
            return this.implementationType.getKind().isPrimitive();
        }

        @Override
        public List<ProtobufConverterElement> converters() {
            return Collections.unmodifiableList(this.converters);
        }

        @Override
        public void addNullableConverter(ProtobufConverterElement element) {
            if (element == null) {
                return;
            }
            this.converters.add(element);
        }
    }
}

