/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization;

import it.auties.protobuf.serialization.generator.method.ProtobufMethodGenerator;
import it.auties.protobuf.serialization.support.Types;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ProtobufConverterGraph {
    private final Types types;
    private final Set<Node> nodes;
    private int maxGenericLevel;

    public ProtobufConverterGraph(Types types) {
        this.types = types;
        this.nodes = new HashSet<Node>();
    }

    public void link(TypeMirror from, TypeMirror to, TypeMirror rawGroupParent, ExecutableElement arc) {
        this.link(from, to, rawGroupParent, arc, "");
    }

    public void link(TypeMirror from, TypeMirror to, TypeMirror rawGroupParent, ExecutableElement arc, String warning) {
        Node node = new Node(from, to, rawGroupParent, arc, warning);
        this.nodes.add(node);
        this.maxGenericLevel = Math.max(this.maxGenericLevel, this.count(from));
    }

    private int count(TypeMirror type) {
        if (type.getKind() == TypeKind.TYPEVAR || !(type instanceof DeclaredType)) {
            return 0;
        }
        DeclaredType declaredType = (DeclaredType)type;
        int counter = 0;
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            counter += 1 + this.count(typeMirror);
        }
        return counter;
    }

    public List<Arc> getPath(TypeMirror from, TypeMirror to, List<TypeElement> mixins) {
        Set<String> mixinsNames = mixins.stream().map(entry -> entry.getQualifiedName().toString()).collect(Collectors.toUnmodifiableSet());
        return this.getArcs(from, from, to, mixinsNames);
    }

    private List<Arc> getArcs(TypeMirror originalFrom, TypeMirror currentFrom, TypeMirror currentTo, Set<String> mixins) {
        for (Node entry : this.nodes) {
            if (!this.types.isAssignable(currentFrom, entry.from())) continue;
            if (this.isArcIllegal(originalFrom, currentFrom, currentTo, mixins, entry) || !this.types.isAssignable(currentTo, entry.to())) {
                List<Arc> results = this.getArcs(currentFrom, currentTo, mixins, entry, null);
                if (results.isEmpty()) continue;
                return results;
            }
            if (!this.types.isParametrized(entry.arc())) {
                return List.of(new Arc(entry.arc(), entry.warning()));
            }
            TypeMirror returnType = this.types.getReturnType(entry.arc(), List.of(currentFrom));
            if (this.types.isAssignable(currentTo, returnType, false)) {
                return List.of(new Arc(entry.arc(), returnType, entry.warning()));
            }
            List<Arc> results = this.getArcs(currentFrom, currentTo, mixins, entry, returnType);
            if (results.isEmpty()) continue;
            return results;
        }
        return List.of();
    }

    private boolean isArcIllegal(TypeMirror originalFrom, TypeMirror from, TypeMirror to, Set<String> mixins, Node entry) {
        String rawGroupQualifiedName;
        String toQualifiedSpecName;
        String fromQualifiedSpecName;
        String arcOwnerQualifiedName = this.getDeclaredTypeName(entry.arc().getEnclosingElement().asType());
        if (arcOwnerQualifiedName == null) {
            return true;
        }
        if (mixins.contains(arcOwnerQualifiedName)) {
            return false;
        }
        String fromQualifiedName = this.getDeclaredTypeName(from);
        String string = fromQualifiedSpecName = this.types.isObject(from) ? ProtobufMethodGenerator.getSpecFromObject(from) : null;
        if (Objects.equals(arcOwnerQualifiedName, fromQualifiedName) || Objects.equals(arcOwnerQualifiedName, fromQualifiedSpecName)) {
            return false;
        }
        String toQualifiedName = this.getDeclaredTypeName(to);
        String string2 = toQualifiedSpecName = this.types.isObject(to) ? ProtobufMethodGenerator.getSpecFromObject(to) : null;
        if (Objects.equals(arcOwnerQualifiedName, toQualifiedName) || Objects.equals(arcOwnerQualifiedName, toQualifiedSpecName)) {
            return false;
        }
        TypeMirror rawGroupOwner = entry.rawGroupOwner();
        if (rawGroupOwner == null) {
            return true;
        }
        String originalFromQualifiedName = this.getDeclaredTypeName(originalFrom);
        return !Objects.equals(originalFromQualifiedName, rawGroupQualifiedName = this.getDeclaredTypeName(rawGroupOwner)) && !Objects.equals(toQualifiedName, rawGroupQualifiedName);
    }

    private String getDeclaredTypeName(TypeMirror mirror) {
        DeclaredType declaredType;
        Element element;
        if (mirror instanceof DeclaredType && (element = (declaredType = (DeclaredType)mirror).asElement()) instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return typeElement.getQualifiedName().toString();
        }
        return null;
    }

    private List<Arc> getArcs(TypeMirror from, TypeMirror to, Set<String> mixins, Node entry, TypeMirror genericReturnType) {
        TypeMirror returnType;
        if (!this.types.isParametrized(entry.arc())) {
            List<Arc> nested = this.getArcs(from, entry.to(), to, mixins);
            if (nested.isEmpty()) {
                return List.of();
            }
            if (entry.rawGroupOwner() != null && this.isArcIllegal(from, from, to, mixins, entry)) {
                return List.of();
            }
            return this.getArcs(entry, entry.arc().getReturnType(), nested);
        }
        TypeMirror typeMirror = returnType = genericReturnType != null ? genericReturnType : this.types.getReturnType(entry.arc(), List.of(from));
        if (this.count(returnType) > this.maxGenericLevel) {
            return List.of();
        }
        List<Arc> nested = this.getArcs(from, returnType, to, mixins);
        if (nested.isEmpty()) {
            return List.of();
        }
        if (entry.rawGroupOwner() != null && this.isArcIllegal(from, from, to, mixins, entry)) {
            return List.of();
        }
        return this.getArcs(entry, returnType, nested);
    }

    private ArrayList<Arc> getArcs(Node entry, TypeMirror returnType, List<Arc> nested) {
        ArrayList<Arc> results = new ArrayList<Arc>();
        results.add(new Arc(entry.arc(), returnType, entry.warning()));
        results.addAll(nested);
        return results;
    }

    private record Node(TypeMirror from, TypeMirror to, TypeMirror rawGroupOwner, ExecutableElement arc, String warning) {
        @Override
        public int hashCode() {
            return (String.valueOf(this.from) + "_" + String.valueOf(this.to)).hashCode();
        }
    }

    public record Arc(ExecutableElement method, TypeMirror returnType, String warning) {
        public Arc(ExecutableElement method, String warning) {
            this(method, method.getReturnType(), warning);
        }
    }
}

