/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.Trees;
import it.auties.protobuf.annotation.ProtobufBuilder;
import it.auties.protobuf.annotation.ProtobufDefaultValue;
import it.auties.protobuf.annotation.ProtobufDeserializer;
import it.auties.protobuf.annotation.ProtobufEnum;
import it.auties.protobuf.annotation.ProtobufEnumIndex;
import it.auties.protobuf.annotation.ProtobufGetter;
import it.auties.protobuf.annotation.ProtobufGroup;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.annotation.ProtobufSerializer;
import it.auties.protobuf.annotation.ProtobufUnknownFields;
import it.auties.protobuf.builtin.ProtobufAtomicMixin;
import it.auties.protobuf.builtin.ProtobufFutureMixin;
import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufMapMixin;
import it.auties.protobuf.builtin.ProtobufOptionalMixin;
import it.auties.protobuf.builtin.ProtobufRepeatedMixin;
import it.auties.protobuf.builtin.ProtobufURIMixin;
import it.auties.protobuf.builtin.ProtobufUUIDMixin;
import it.auties.protobuf.model.ProtobufType;
import it.auties.protobuf.serialization.ProtobufConverterGraph;
import it.auties.protobuf.serialization.generator.clazz.group.ProtobufRawGroupSpecGenerator;
import it.auties.protobuf.serialization.generator.clazz.object.ProtobufObjectBuilderGenerator;
import it.auties.protobuf.serialization.generator.clazz.object.ProtobufObjectSpecGenerator;
import it.auties.protobuf.serialization.generator.method.ProtobufMethodGenerator;
import it.auties.protobuf.serialization.model.converter.ProtobufAttributedConverterElement;
import it.auties.protobuf.serialization.model.converter.ProtobufConverterElement;
import it.auties.protobuf.serialization.model.converter.ProtobufUnattributedConverterElement;
import it.auties.protobuf.serialization.model.object.ProtobufBuilderElement;
import it.auties.protobuf.serialization.model.object.ProtobufEnumMetadata;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.model.object.ProtobufUnknownFieldsElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyType;
import it.auties.protobuf.serialization.support.Checks;
import it.auties.protobuf.serialization.support.Messages;
import it.auties.protobuf.serialization.support.Types;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"it.auties.protobuf.annotation.ProtobufProperty", "it.auties.protobuf.annotation.ProtobufSerializer", "it.auties.protobuf.annotation.ProtobufDeserializer", "it.auties.protobuf.annotation.ProtobufObject", "it.auties.protobuf.annotation.ProtobufBuilder", "it.auties.protobuf.annotation.ProtobufEnumIndex"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
public class ProtobufJavacPlugin
extends AbstractProcessor {
    private static final Class<?>[] DEFAULT_MIXINS = new Class[]{ProtobufAtomicMixin.class, ProtobufOptionalMixin.class, ProtobufUUIDMixin.class, ProtobufURIMixin.class, ProtobufRepeatedMixin.class, ProtobufMapMixin.class, ProtobufFutureMixin.class, ProtobufLazyMixin.class};
    private static final Class<? extends Annotation>[] PARSABLE_ANNOTATIONS = new Class[]{ProtobufMessage.class, ProtobufGroup.class, ProtobufEnum.class};
    private Trees trees;
    private Types types;
    private Messages messages;
    private Checks checks;
    private ProtobufConverterGraph serializersGraph;
    private ProtobufConverterGraph deserializersGraph;
    private TypeMirror intType;
    private TypeMirror inputStreamType;
    private TypeMirror outputStreamType;
    private TypeMirror serializedGroupType;
    private TypeMirror serializedMessageType;
    private Set<String> linkedTypes;

    @Override
    public synchronized void init(ProcessingEnvironment wrapperProcessingEnv) {
        ProcessingEnvironment unwrappedProcessingEnv = this.unwrapProcessingEnv(wrapperProcessingEnv);
        super.init(unwrappedProcessingEnv);
        this.trees = Trees.instance(this.processingEnv);
        this.types = new Types(this.processingEnv);
        this.messages = new Messages(this.processingEnv);
        this.checks = new Checks(this.types, this.messages);
        this.serializersGraph = new ProtobufConverterGraph(this.types);
        this.deserializersGraph = new ProtobufConverterGraph(this.types);
        this.intType = this.types.getType(Integer.TYPE, new Class[0]);
        this.inputStreamType = this.types.getType(ProtobufInputStream.class, new Class[0]);
        this.outputStreamType = this.types.getType(ProtobufOutputStream.class, new Class[0]);
        this.serializedGroupType = this.types.getType(ProtobufType.GROUP.serializedType(), new Class[0]);
        this.serializedMessageType = this.types.getType(ProtobufType.MESSAGE.serializedType(), new Class[0]);
        this.linkedTypes = new HashSet<String>();
    }

    private ProcessingEnvironment unwrapProcessingEnv(ProcessingEnvironment wrapper) {
        try {
            Class<?> apiWrappers = wrapper.getClass().getClassLoader().loadClass("org.jetbrains.jps.javac.APIWrappers");
            Method unwrapMethod = apiWrappers.getDeclaredMethod("unwrap", Class.class, Object.class);
            return (ProcessingEnvironment)unwrapMethod.invoke(null, ProcessingEnvironment.class, wrapper);
        }
        catch (ReflectiveOperationException exception) {
            return wrapper;
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.checks.runChecks(roundEnv);
        List<ProtobufObjectElement> objects = this.processObjects(roundEnv);
        this.attributeObjects(objects);
        this.generateCode(objects);
        return true;
    }

    private void generateCode(List<ProtobufObjectElement> objects) {
        TypeElement currentElement = null;
        try {
            for (ProtobufObjectElement object : objects) {
                currentElement = object.element();
                PackageElement packageName = this.processingEnv.getElementUtils().getPackageOf(object.element());
                if (object.type() != ProtobufObjectElement.Type.SYNTHETIC) {
                    ProtobufObjectSpecGenerator specVisitor = new ProtobufObjectSpecGenerator(this.processingEnv.getFiler());
                    specVisitor.createClass(object, packageName);
                }
                if (object.type() == ProtobufObjectElement.Type.MESSAGE || object.type() == ProtobufObjectElement.Type.GROUP) {
                    ProtobufObjectBuilderGenerator buildVisitor = new ProtobufObjectBuilderGenerator(this.processingEnv.getFiler());
                    buildVisitor.createClass(object, null, packageName);
                    for (ProtobufBuilderElement builder : object.builders()) {
                        buildVisitor.createClass(object, builder, packageName);
                    }
                    continue;
                }
                if (object.type() != ProtobufObjectElement.Type.SYNTHETIC) continue;
                ProtobufRawGroupSpecGenerator creator = new ProtobufRawGroupSpecGenerator(this.processingEnv.getFiler());
                creator.createClass(object, packageName);
            }
        }
        catch (IOException throwable) {
            this.messages.printError("An error occurred while processing protobuf: " + Objects.requireNonNullElse(throwable.getMessage(), throwable.getClass().getName()), currentElement);
        }
    }

    private void attributeObjects(List<ProtobufObjectElement> objects) {
        for (ProtobufObjectElement object : objects) {
            this.attributeProperties(object);
        }
    }

    private void attributeProperties(ProtobufObjectElement object) {
        block5: for (ProtobufPropertyElement property : object.properties()) {
            ProtobufPropertyType protobufPropertyType;
            Objects.requireNonNull(property.type());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProtobufPropertyType.CollectionType.class, ProtobufPropertyType.MapType.class, ProtobufPropertyType.NormalType.class}, (Object)protobufPropertyType, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ProtobufPropertyType.CollectionType collectionType = (ProtobufPropertyType.CollectionType)protobufPropertyType;
                    this.attributeConverter(collectionType.valueType());
                    continue block5;
                }
                case 1: {
                    ProtobufPropertyType.MapType mapType = (ProtobufPropertyType.MapType)protobufPropertyType;
                    this.attributeConverter(mapType.keyType());
                    this.attributeConverter(mapType.valueType());
                    continue block5;
                }
                case 2: 
            }
            ProtobufPropertyType.NormalType normalType = (ProtobufPropertyType.NormalType)protobufPropertyType;
            this.attributeConverter(normalType);
        }
    }

    private void attributeConverter(ProtobufPropertyType type) {
        ArrayList<ProtobufAttributedConverterElement> attributed = new ArrayList<ProtobufAttributedConverterElement>();
        block4: for (ProtobufConverterElement protobufConverterElement : type.converters()) {
            ProtobufConverterElement protobufConverterElement2;
            Objects.requireNonNull(protobufConverterElement);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProtobufAttributedConverterElement.class, ProtobufUnattributedConverterElement.class}, (Object)protobufConverterElement2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ProtobufAttributedConverterElement attributedElement = (ProtobufAttributedConverterElement)protobufConverterElement2;
                    attributed.add(attributedElement);
                    continue block4;
                }
                case 1: 
            }
            ProtobufUnattributedConverterElement unattributedElement = (ProtobufUnattributedConverterElement)protobufConverterElement2;
            attributed.addAll(this.attributeConverter(unattributedElement));
        }
        type.clearConverters();
        for (ProtobufAttributedConverterElement protobufAttributedConverterElement : attributed) {
            type.addConverter(protobufAttributedConverterElement);
        }
    }

    private List<ProtobufAttributedConverterElement> attributeConverter(ProtobufUnattributedConverterElement unattributedElement) {
        TypeMirror from = unattributedElement.from();
        ArrayList<ProtobufAttributedConverterElement> results = new ArrayList<ProtobufAttributedConverterElement>();
        switch (unattributedElement.type()) {
            case SERIALIZER: {
                List<ProtobufConverterGraph.Arc> methodPath = this.serializersGraph.getPath(from, unattributedElement.to(), unattributedElement.mixins());
                if (methodPath.isEmpty()) {
                    Object toName = this.getProtobufTypeName(unattributedElement.protobufType());
                    this.messages.printError("Missing converter: cannot find a serializer from %s to %s".formatted(from, toName), unattributedElement.invoker());
                    break;
                }
                for (ProtobufConverterGraph.Arc element : methodPath) {
                    if (!element.warning().isEmpty()) {
                        this.messages.printWarning(element.warning(), unattributedElement.invoker());
                    }
                    ProtobufAttributedConverterElement.Serializer serializerElement = new ProtobufAttributedConverterElement.Serializer(element.method(), from, element.returnType());
                    results.add(serializerElement);
                    from = element.returnType();
                }
                break;
            }
            case DESERIALIZER: {
                List<ProtobufConverterGraph.Arc> methodPath = this.deserializersGraph.getPath(from, unattributedElement.to(), unattributedElement.mixins());
                if (methodPath.isEmpty()) {
                    Object fromName = this.getProtobufTypeName(unattributedElement.protobufType());
                    this.messages.printError("Missing converter: cannot find a deserializer from %s to %s".formatted(fromName, unattributedElement.to()), unattributedElement.invoker());
                    break;
                }
                for (ProtobufConverterGraph.Arc element : methodPath) {
                    if (!element.warning().isEmpty()) {
                        this.messages.printWarning(element.warning(), unattributedElement.invoker());
                    }
                    ProtobufDeserializer annotation = element.method().getAnnotation(ProtobufDeserializer.class);
                    ProtobufAttributedConverterElement.Deserializer deserializerElement = new ProtobufAttributedConverterElement.Deserializer(element.method(), from, element.returnType(), annotation.builderBehaviour());
                    results.add(deserializerElement);
                    from = element.returnType();
                }
                break;
            }
        }
        return results;
    }

    private List<ProtobufObjectElement> processObjects(RoundEnvironment roundEnv) {
        return Arrays.stream(PARSABLE_ANNOTATIONS).map(roundEnv::getElementsAnnotatedWith).flatMap(Collection::stream).filter(entry -> entry instanceof TypeElement).map(entry -> this.processElement((TypeElement)entry)).flatMap(Collection::stream).toList();
    }

    private Set<ProtobufObjectElement> processElement(TypeElement object) {
        if (object.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return Set.of();
        }
        return switch (object.getKind()) {
            case ElementKind.ENUM -> this.processEnum(object);
            case ElementKind.RECORD, ElementKind.CLASS -> this.processObject(object);
            default -> Set.of();
        };
    }

    private Set<ProtobufObjectElement> processObject(TypeElement typeElement) {
        boolean isGroup = typeElement.getAnnotation(ProtobufGroup.class) != null;
        ExecutableElement deserializer = this.getMessageDeserializer(typeElement).orElse(null);
        ProtobufObjectElement messageElement = isGroup ? ProtobufObjectElement.ofGroup(typeElement, deserializer) : ProtobufObjectElement.ofMessage(typeElement, deserializer);
        Set<ProtobufObjectElement> results = this.processObject(messageElement, messageElement.element());
        if (isGroup) {
            this.linkGroup(typeElement.asType());
        } else {
            this.linkMessage(typeElement.asType());
        }
        if (!this.hasPropertiesConstructor(messageElement)) {
            this.messages.printError("Missing protobuf constructor: a protobuf message must provide a constructor that takes only its properties, following their declaration order, and, if present, its unknown fields wrapper as parameters", messageElement.element());
        }
        return results;
    }

    private Optional<ExecutableElement> getMessageDeserializer(TypeElement message) {
        return message.getEnclosedElements().stream().filter(entry -> {
            ExecutableElement method;
            return entry instanceof ExecutableElement && (method = (ExecutableElement)entry).getAnnotation(ProtobufDeserializer.class) != null;
        }).map(entry -> (ExecutableElement)entry).reduce((first, second) -> {
            this.messages.printError("Duplicated protobuf builder delegate: a message should provide only one method annotated with @ProtobufDeserializer", (Element)second);
            return first;
        });
    }

    private Set<ProtobufObjectElement> processObject(ProtobufObjectElement messageElement, TypeElement typeElement) {
        HashSet<ProtobufObjectElement> results = new HashSet<ProtobufObjectElement>();
        if (messageElement.element() == typeElement) {
            results.add(messageElement);
        }
        this.types.getSuperClass(typeElement).ifPresent(superClass -> {
            Set<ProtobufObjectElement> superResults = this.processObject(messageElement, (TypeElement)superClass);
            results.addAll(superResults);
        });
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        Iterator<Element> iterator = typeElement.getEnclosedElements().iterator();
        while (iterator.hasNext()) {
            Element entry;
            Element element = entry = iterator.next();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableElement.class, ExecutableElement.class}, (Object)element, n)) {
                case 0: {
                    VariableElement variableElement = (VariableElement)element;
                    fields.add(variableElement);
                    break;
                }
                case 1: {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    methods.add(executableElement);
                    break;
                }
            }
        }
        for (VariableElement field : fields) {
            results.addAll(this.processObjectField(messageElement, field));
        }
        for (ExecutableElement method : methods) {
            Optional<ProtobufObjectElement> result = this.processObjectMethod(messageElement, method);
            result.ifPresent(results::add);
        }
        return results;
    }

    private Optional<ProtobufObjectElement> processObjectMethod(ProtobufObjectElement messageElement, ExecutableElement executableElement) {
        ProtobufBuilder builder = executableElement.getAnnotation(ProtobufBuilder.class);
        if (builder != null) {
            messageElement.addBuilder(builder.className(), executableElement.getParameters(), executableElement);
            return Optional.empty();
        }
        ProtobufGetter getter = executableElement.getAnnotation(ProtobufGetter.class);
        if (getter != null) {
            this.handleMessageGetter(messageElement, executableElement, getter);
            return Optional.empty();
        }
        if (this.processObjectDeserializer(executableElement)) {
            return Optional.empty();
        }
        return this.processObjectSerializer(executableElement);
    }

    private boolean processObjectDeserializer(ExecutableElement executableElement) {
        ProtobufDeserializer deserializer = executableElement.getAnnotation(ProtobufDeserializer.class);
        if (deserializer == null) {
            return false;
        }
        TypeMirror from = executableElement.getParameters().getFirst().asType();
        TypeMirror to = executableElement.getReturnType();
        this.deserializersGraph.link(from, to, null, executableElement, deserializer.warning());
        return true;
    }

    private Optional<ProtobufObjectElement> processObjectSerializer(ExecutableElement executableElement) {
        ProtobufSerializer serializer = executableElement.getAnnotation(ProtobufSerializer.class);
        if (serializer == null) {
            return Optional.empty();
        }
        TypeMirror from = !executableElement.getParameters().isEmpty() ? executableElement.getParameters().getFirst().asType() : executableElement.getEnclosingElement().asType();
        TypeMirror to = executableElement.getReturnType();
        this.serializersGraph.link(from, to, null, executableElement, serializer.warning());
        if (serializer.groupProperties().length == 0) {
            return Optional.empty();
        }
        for (ProtobufSerializer.GroupProperty rawGroupProperty : serializer.groupProperties()) {
            this.linkMixins(this.types.getMirroredTypes(() -> ((ProtobufSerializer.GroupProperty)rawGroupProperty).mixins()));
        }
        TypeElement groupElement = (TypeElement)executableElement.getEnclosingElement();
        TypeMirror groupType = groupElement.asType();
        String specName = ProtobufMethodGenerator.getSpecFromObject(groupType);
        ExecutableElement syntheticSerializer = this.types.createMethodStub(specName, "encode", this.types.voidType(), this.intType, this.types.rawGroupType(), this.outputStreamType);
        this.serializersGraph.link(this.types.rawGroupType(), this.serializedGroupType, groupType, syntheticSerializer);
        ExecutableElement syntheticDeserializer = this.types.createMethodStub(specName, "decode", this.types.rawGroupType(), this.intType, this.inputStreamType);
        this.deserializersGraph.link(this.serializedGroupType, this.types.rawGroupType(), groupType, syntheticDeserializer);
        ProtobufObjectElement syntheticGroup = ProtobufObjectElement.ofSynthetic(groupElement, syntheticSerializer, syntheticDeserializer);
        for (ProtobufSerializer.GroupProperty groupProperty : serializer.groupProperties()) {
            TypeMirror implementationType = this.types.getMirroredType(() -> ((ProtobufSerializer.GroupProperty)groupProperty).implementation()).asType();
            this.linkType(implementationType);
            TypeMirror actualType = this.types.isSameType(implementationType, Object.class) ? this.types.getType(groupProperty.type().wrapperType(), new Class[0]) : implementationType;
            TypeMirror repeatedValueType = this.types.getMirroredType(() -> ((ProtobufSerializer.GroupProperty)groupProperty).repeatedValueImplementation()).asType();
            this.linkType(repeatedValueType);
            TypeMirror mapValueType = this.types.getMirroredType(() -> ((ProtobufSerializer.GroupProperty)groupProperty).mapValueImplementation()).asType();
            this.linkType(mapValueType);
            Optional<? extends ProtobufPropertyType> protobufPropertyType = this.getPropertyType(executableElement, actualType, actualType, this.types.getProperty(groupProperty), repeatedValueType, mapValueType);
            if (protobufPropertyType.isEmpty()) {
                this.messages.printError("Type error: cannot determine type of group property with index %s".formatted(groupProperty.index()), executableElement);
                continue;
            }
            List<TypeElement> mixins = this.types.getMixins(groupProperty);
            this.linkMixins(mixins);
            Optional<ProtobufPropertyElement> error = syntheticGroup.addProperty(protobufPropertyType.get(), groupProperty);
            if (!error.isPresent()) continue;
            this.messages.printError("Duplicated group property with index %s".formatted(groupProperty.index()), executableElement);
        }
        return Optional.of(syntheticGroup);
    }

    private void handleMessageGetter(ProtobufObjectElement messageElement, ExecutableElement executableElement, ProtobufGetter getter) {
        Optional<ProtobufPropertyElement> error;
        if (this.hasMatchedProperty(messageElement, getter)) {
            if (getter.type() != ProtobufType.UNKNOWN) {
                this.messages.printError("Invalid metadata: only elements annotated with @ProtobufGetter that represent a standalone property can specify a type", executableElement);
            } else if (getter.packed()) {
                this.messages.printError("Invalid metadata: only elements annotated with @ProtobufGetter that represent a standalone property can specify whether they are packed", executableElement);
            } else if (this.isNonDefaultMixin(getter)) {
                this.messages.printError("Invalid metadata: only elements annotated with @ProtobufGetter that represent a standalone property can specify mixins", executableElement);
            }
            return;
        }
        ProtobufProperty property = this.types.getProperty(getter);
        if (getter.type() == ProtobufType.UNKNOWN) {
            this.messages.printError("Type error: standalone property getters must specify a valid protobuf type", executableElement);
            return;
        }
        if (getter.packed() && !this.checks.isValidPackedProperty(executableElement, property)) {
            return;
        }
        Optional<? extends ProtobufPropertyType> type = this.getPropertyType(executableElement, executableElement.getReturnType(), executableElement.getReturnType(), property, null, null);
        if (type.isEmpty()) {
            return;
        }
        String syntheticPropertyName = this.types.getPropertyName(executableElement.getSimpleName().toString());
        if (messageElement.isNameDisallowed(syntheticPropertyName)) {
            this.messages.printError("Restricted message property name: %s is not allowed as it's marked as reserved".formatted(syntheticPropertyName), executableElement);
        }
        if (messageElement.isIndexDisallowed(property.index())) {
            this.messages.printError("Restricted message property index: %s is not allowed as it's marked as reserved".formatted(property.index()), executableElement);
        }
        if ((error = messageElement.addProperty(executableElement, executableElement, type.get(), property)).isPresent()) {
            this.messages.printError("Duplicated message property: %s and %s with index %s".formatted(executableElement.getSimpleName(), error.get().name(), getter.index()), executableElement);
            return;
        }
        List<TypeElement> mixins = this.types.getMixins(getter);
        this.linkMixins(mixins);
    }

    private boolean isNonDefaultMixin(ProtobufGetter getter) {
        List<TypeElement> mixins = this.types.getMixins(getter);
        if (mixins.size() != DEFAULT_MIXINS.length) {
            return true;
        }
        Iterator<TypeElement> mixinsIterator = mixins.iterator();
        for (Class<?> expectedMixin : DEFAULT_MIXINS) {
            TypeElement actualMixin = mixinsIterator.next();
            if (actualMixin.getQualifiedName().contentEquals(expectedMixin.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedProperty(ProtobufObjectElement messageElement, ProtobufGetter getter) {
        return messageElement.properties().stream().anyMatch(entry -> !(entry.type().descriptorElementType() instanceof ExecutableElement) && entry.index() == getter.index());
    }

    private boolean hasPropertiesConstructor(ProtobufObjectElement message) {
        ProtobufUnknownFieldsElement unknownFieldsType = message.unknownFieldsElement().orElse(null);
        List<ProtobufPropertyElement> properties = message.properties().stream().filter(property -> !property.synthetic()).toList();
        return message.element().getEnclosedElements().stream().filter(entry -> entry.getKind() == ElementKind.CONSTRUCTOR).map(entry -> (ExecutableElement)entry).anyMatch(constructor -> {
            List<? extends VariableElement> constructorParameters = constructor.getParameters();
            if (properties.size() + (unknownFieldsType != null ? 1 : 0) != constructorParameters.size()) {
                return false;
            }
            Iterator propertiesIterator = properties.iterator();
            Iterator<? extends VariableElement> constructorParametersIterator = constructorParameters.iterator();
            boolean foundUnknownFieldsParam = false;
            while (propertiesIterator.hasNext() && constructorParametersIterator.hasNext()) {
                ProtobufPropertyElement property = (ProtobufPropertyElement)propertiesIterator.next();
                VariableElement constructorParameter = constructorParametersIterator.next();
                if (unknownFieldsType != null && this.types.isAssignable(constructorParameter.asType(), property.type().descriptorElementType())) {
                    if (foundUnknownFieldsParam) {
                        this.messages.printError("Duplicated protobuf unknown fields parameter: a protobuf constructor should provide only one parameter whose type can be assigned to the field annotated with @ProtobufUnknownFields", constructorParameter);
                    }
                    foundUnknownFieldsParam = true;
                    continue;
                }
                if (this.types.isAssignable(property.type().descriptorElementType(), constructorParameter.asType())) continue;
                return false;
            }
            return unknownFieldsType == null || foundUnknownFieldsParam;
        });
    }

    private Set<ProtobufObjectElement> processObjectField(ProtobufObjectElement messageElement, VariableElement variableElement) {
        ProtobufProperty propertyAnnotation = variableElement.getAnnotation(ProtobufProperty.class);
        if (propertyAnnotation != null) {
            return this.processMessageProperty(messageElement, variableElement, propertyAnnotation);
        }
        ProtobufUnknownFields unknownFieldsAnnotation = variableElement.getAnnotation(ProtobufUnknownFields.class);
        if (unknownFieldsAnnotation != null) {
            this.processMessageUnknownFields(messageElement, variableElement, unknownFieldsAnnotation);
        }
        return Set.of();
    }

    private void processMessageUnknownFields(ProtobufObjectElement messageElement, VariableElement variableElement, ProtobufUnknownFields unknownFieldsAnnotation) {
        if (messageElement.unknownFieldsElement().isPresent()) {
            this.messages.printError("Duplicated protobuf unknown fields: a message should provide only one method field annotated with @ProtobufUnknownFields", variableElement);
            return;
        }
        Optional<ProtobufUnknownFieldsElement> unknownFields = this.processUnknownFieldsField(variableElement, unknownFieldsAnnotation);
        if (unknownFields.isEmpty()) {
            return;
        }
        messageElement.setUnknownFieldsElement(unknownFields.get());
        List<TypeElement> mixins = this.types.getMixins(unknownFieldsAnnotation);
        this.linkMixins(mixins);
    }

    private Optional<ProtobufUnknownFieldsElement> processUnknownFieldsField(VariableElement variableElement, ProtobufUnknownFields unknownFieldsAnnotation) {
        TypeMirror unknownFieldsType = variableElement.asType();
        if (!(unknownFieldsType instanceof DeclaredType)) {
            this.messages.printError("Type error: variables annotated with @ProtobufUnknownFields must have an object type", variableElement);
            return Optional.empty();
        }
        DeclaredType unknownFieldsDeclaredType = (DeclaredType)unknownFieldsType;
        List<TypeElement> mixins = this.types.getMixins(unknownFieldsAnnotation);
        ExecutableElement setter = this.findUnknownFieldsSetterInType(unknownFieldsDeclaredType);
        if (setter != null) {
            return this.checkUnknownFieldsSetter(variableElement, setter, false).map(setterElement -> this.createUnknownFieldsElement(variableElement, unknownFieldsDeclaredType, (ExecutableElement)setterElement, unknownFieldsType, mixins));
        }
        ExecutableElement setterFromMixin = this.findUnknownFieldsSetterInMixins(variableElement, unknownFieldsType, mixins);
        if (setterFromMixin == null) {
            this.messages.printError("Type error: cannot find a @ProtobufUnknownFields.Setter for the provided type", variableElement);
            return Optional.empty();
        }
        return this.checkUnknownFieldsSetter(variableElement, setterFromMixin, true).map(setterElement -> this.createUnknownFieldsElement(variableElement, unknownFieldsDeclaredType, (ExecutableElement)setterElement, unknownFieldsType, mixins));
    }

    private ProtobufUnknownFieldsElement createUnknownFieldsElement(VariableElement variableElement, DeclaredType variableType, ExecutableElement setterElement, TypeMirror unknownFieldsType, List<TypeElement> mixins) {
        String defaultValue = this.getDefaultValue(variableElement, unknownFieldsType, mixins).orElse("new %s()".formatted(variableType));
        return new ProtobufUnknownFieldsElement(variableType, defaultValue, setterElement);
    }

    private ExecutableElement findUnknownFieldsSetterInType(DeclaredType unknownFieldsDeclaredType) {
        return unknownFieldsDeclaredType.asElement().getEnclosedElements().stream().filter(enclosedElement -> enclosedElement.getKind() == ElementKind.METHOD && enclosedElement.getAnnotation(ProtobufUnknownFields.Setter.class) != null).findFirst().orElse(null);
    }

    private ExecutableElement findUnknownFieldsSetterInMixins(VariableElement element, TypeMirror unknownFieldsType, List<TypeElement> mixins) {
        return mixins.stream().map(TypeElement::getEnclosedElements).flatMap(Collection::stream).filter(enclosedElement -> enclosedElement.getKind() == ElementKind.METHOD && enclosedElement.getAnnotation(ProtobufUnknownFields.Setter.class) != null).map(enclosedElement -> (ExecutableElement)enclosedElement).filter(enclosedMethod -> !enclosedMethod.getParameters().isEmpty() && this.types.isAssignable(enclosedMethod.getParameters().getFirst().asType(), unknownFieldsType)).reduce((first, second) -> {
            this.messages.printError("Duplicated protobuf unknown fields setter: only one setter for %s is allowed in the mixins".formatted(unknownFieldsType), element);
            return first;
        }).orElse(null);
    }

    private Optional<ExecutableElement> checkUnknownFieldsSetter(VariableElement variableElement, ExecutableElement setter, boolean fromMixin) {
        if (!setter.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.messages.printError("Type error: methods annotated with @ProtobufUnknownFields.Setter must have public visibility", variableElement);
            return Optional.empty();
        }
        if (fromMixin != setter.getModifiers().contains((Object)Modifier.STATIC)) {
            this.messages.printError("Type error: methods annotated with @ProtobufUnknownFields.Setter %s".formatted(fromMixin ? "in a mixin must be static" : "must not be static"), variableElement);
            return Optional.empty();
        }
        if (setter.getParameters().size() != (fromMixin ? 3 : 2)) {
            this.messages.printError("Type error: methods annotated with @ProtobufUnknownFields.Setter %smust take only %s parameters".formatted(fromMixin ? "in a mixin" : "", fromMixin ? "three" : "two"), variableElement);
            return Optional.empty();
        }
        VariableElement firstParameter = setter.getParameters().get(fromMixin ? 1 : 0);
        TypeMirror keyType = firstParameter.asType();
        if (!this.types.isAssignable(keyType, Integer.class) && !this.types.isSameType(keyType, Integer.TYPE)) {
            this.messages.printError("Type error: expected int type", setter);
            return Optional.empty();
        }
        VariableElement secondParameter = setter.getParameters().get(fromMixin ? 2 : 1);
        TypeMirror valueType = secondParameter.asType();
        if (!this.types.isSameType(valueType, Object.class)) {
            this.messages.printError("Type error: expected Object type", setter);
            return Optional.empty();
        }
        return Optional.of(setter);
    }

    private Set<ProtobufObjectElement> processMessageProperty(ProtobufObjectElement messageElement, VariableElement variableElement, ProtobufProperty propertyAnnotation) {
        if (propertyAnnotation.type() == ProtobufType.UNKNOWN) {
            this.messages.printError("Type error: properties must specify a valid protobuf type", variableElement);
            return Set.of();
        }
        if (propertyAnnotation.required() && !this.checks.isValidRequiredProperty(variableElement)) {
            return Set.of();
        }
        if (propertyAnnotation.packed() && !this.checks.isValidPackedProperty(variableElement, propertyAnnotation)) {
            return Set.of();
        }
        Element accessor = this.getAccessor(variableElement, propertyAnnotation).orElse(null);
        if (accessor == null) {
            this.messages.printError("Missing accessor: a non-private getter/accessor must be declared, or the property must have non-private visibility.", variableElement);
            return Set.of();
        }
        TypeMirror accessorType = this.getAccessorType(accessor);
        TypeMirror variableType = variableElement.asType();
        Optional<? extends ProtobufPropertyType> type = this.getPropertyType(variableElement, variableType, accessorType, propertyAnnotation, null, null);
        if (type.isEmpty()) {
            return Set.of();
        }
        String propertyName = variableElement.getSimpleName().toString();
        if (messageElement.isNameDisallowed(propertyName)) {
            this.messages.printError("Restricted message property name: %s is not allowed as it's marked as reserved".formatted(propertyName), variableElement);
        }
        if (messageElement.isIndexDisallowed(propertyAnnotation.index())) {
            this.messages.printError("Restricted message property index: %s is not allowed as it's marked as reserved".formatted(propertyAnnotation.index()), variableElement);
        }
        if (propertyAnnotation.ignored()) {
            return Set.of();
        }
        Optional<ProtobufPropertyElement> error = messageElement.addProperty(variableElement, accessor, type.get(), propertyAnnotation);
        if (error.isPresent()) {
            this.messages.printError("Duplicated message property: %s and %s with index %s".formatted(variableElement.getSimpleName(), error.get().name(), propertyAnnotation.index()), variableElement);
            return Set.of();
        }
        List<TypeElement> mixins = this.types.getMixins(propertyAnnotation);
        this.linkMixins(mixins);
        return this.linkType(variableType);
    }

    private Set<ProtobufObjectElement> linkType(TypeMirror variableType) {
        DeclaredType declaredType;
        Iterator<? extends TypeParameterElement> iterator;
        if (this.types.isGroup(variableType)) {
            this.linkGroup(variableType);
            return Set.of();
        }
        if (this.types.isMessage(variableType)) {
            this.linkMessage(variableType);
            return Set.of();
        }
        if (this.types.isEnum(variableType)) {
            this.linkEnum(variableType);
            return Set.of();
        }
        if (!(variableType instanceof DeclaredType) || !((iterator = (declaredType = (DeclaredType)variableType).asElement()) instanceof TypeElement)) {
            return Set.of();
        }
        TypeElement typeElement = (TypeElement)((Object)iterator);
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            this.linkType(typeMirror);
        }
        for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
            if (typeParameterElement.asType().getKind() == TypeKind.TYPEVAR) continue;
            this.linkType(typeParameterElement.asType());
        }
        HashSet<ProtobufObjectElement> results = new HashSet<ProtobufObjectElement>();
        String string = typeElement.getQualifiedName().toString();
        if (this.linkedTypes.add(string)) {
            for (Element element : typeElement.getEnclosedElements()) {
                ExecutableElement element2;
                if (!(element instanceof ExecutableElement) || this.processObjectDeserializer(element2 = (ExecutableElement)element)) continue;
                Optional<ProtobufObjectElement> syntheticElement = this.processObjectSerializer(element2);
                syntheticElement.ifPresent(results::add);
            }
        }
        return results;
    }

    private void linkEnum(TypeMirror type) {
        String specName = ProtobufMethodGenerator.getSpecFromObject(type);
        ExecutableElement serializer = this.types.createMethodStub(specName, "encode", this.intType, type);
        this.serializersGraph.link(type, this.intType, null, serializer);
        ExecutableElement deserializer = this.types.createMethodStub(specName, "decode", type, this.intType);
        this.deserializersGraph.link(this.intType, type, null, deserializer);
    }

    private void linkMessage(TypeMirror type) {
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                this.linkType(typeMirror);
            }
        }
        String specName = ProtobufMethodGenerator.getSpecFromObject(type);
        ExecutableElement serializer = this.types.createMethodStub(specName, "encode", this.serializedMessageType, type, this.outputStreamType);
        this.serializersGraph.link(type, this.serializedMessageType, null, serializer);
        ExecutableElement executableElement = this.types.createMethodStub(specName, "decode", type, this.serializedMessageType);
        this.deserializersGraph.link(this.serializedMessageType, type, null, executableElement);
    }

    private void linkGroup(TypeMirror type) {
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                this.linkType(typeMirror);
            }
        }
        String specName = ProtobufMethodGenerator.getSpecFromObject(type);
        ExecutableElement serializer = this.types.createMethodStub(specName, "encode", this.serializedGroupType, this.intType, type, this.outputStreamType);
        this.serializersGraph.link(type, this.serializedGroupType, null, serializer);
        ExecutableElement executableElement = this.types.createMethodStub(specName, "decode", type, this.intType, this.serializedGroupType);
        this.deserializersGraph.link(this.serializedGroupType, type, null, executableElement);
    }

    private void linkMixins(List<TypeElement> mixins) {
        for (TypeElement mixin : mixins) {
            for (Element element : mixin.getEnclosedElements()) {
                if (!(element instanceof ExecutableElement)) continue;
                ExecutableElement method = (ExecutableElement)element;
                this.processObjectSerializer(method);
                this.processObjectDeserializer(method);
            }
        }
    }

    private TypeMirror getAccessorType(Element accessor) {
        Element element = accessor;
        Objects.requireNonNull(element);
        Element element2 = element;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableElement.class, ExecutableElement.class}, (Object)element2, n)) {
            case 0 -> {
                VariableElement element = (VariableElement)element2;
                yield element.asType();
            }
            case 1 -> {
                ExecutableElement element = (ExecutableElement)element2;
                yield element.getReturnType();
            }
            default -> throw new IllegalStateException("Unexpected valueType: " + String.valueOf(accessor));
        };
    }

    private Optional<String> getCollectionDefaultValue(Element invoker, TypeMirror collectionType, List<TypeElement> mixins) {
        return this.types.getDefaultConstructor(collectionType).map(typeElement -> "new %s()".formatted(typeElement.getQualifiedName())).or(() -> this.getDefaultValue(invoker, collectionType, mixins));
    }

    private Optional<String> getDefaultValue(Element invoker, TypeMirror type, List<TypeElement> mixins) {
        TypeElement classType;
        Optional<String> selfDefaultValue;
        DeclaredType declaredType;
        Element element;
        if (type instanceof DeclaredType && (element = (declaredType = (DeclaredType)type).asElement()) instanceof TypeElement && (selfDefaultValue = this.getDefaultValueFromAnnotation(invoker, type, classType = (TypeElement)element)).isPresent()) {
            return selfDefaultValue;
        }
        for (TypeElement mixin : mixins) {
            Optional<String> mixinDefaultValue = this.getDefaultValueFromAnnotation(invoker, type, mixin);
            if (!mixinDefaultValue.isPresent()) continue;
            return mixinDefaultValue;
        }
        return switch (type.getKind()) {
            case TypeKind.INT, TypeKind.CHAR, TypeKind.SHORT, TypeKind.BYTE -> Optional.of("0");
            case TypeKind.BOOLEAN -> Optional.of("false");
            case TypeKind.FLOAT -> Optional.of("0f");
            case TypeKind.DOUBLE -> Optional.of("0d");
            case TypeKind.LONG -> Optional.of("0l");
            default -> Optional.empty();
        };
    }

    private Optional<String> getDefaultValueFromAnnotation(Element invoker, TypeMirror type, TypeElement provider) {
        if (provider.getKind() == ElementKind.ENUM) {
            return this.getEnumDefaultValueFromAnnotation(invoker, provider);
        }
        return this.getObjectDefaultValueFromAnnotation(invoker, type, provider);
    }

    private Optional<String> getObjectDefaultValueFromAnnotation(Element invoker, TypeMirror type, TypeElement provider) {
        ArrayList<ExecutableElement> defaultValueProviderCandidates = new ArrayList<ExecutableElement>();
        for (Element element : provider.getEnclosedElements()) {
            ExecutableElement executableElement;
            ProtobufDefaultValue annotation;
            if (!(element instanceof ExecutableElement) || (annotation = (executableElement = (ExecutableElement)element).getAnnotation(ProtobufDefaultValue.class)) == null || !this.types.isAssignable(executableElement.getReturnType(), type)) continue;
            defaultValueProviderCandidates.add(executableElement);
        }
        Optional bestMatch = defaultValueProviderCandidates.stream().reduce((first, second) -> {
            if (this.types.isSameType(first.getReturnType(), second.getReturnType())) {
                this.messages.printError("Duplicated protobuf default valueType: %s provides a default valueType that was already defined. Remove the conflicting mixins from the property or the enclosing message.".formatted(second), invoker);
            }
            return this.types.isAssignable(first.getReturnType(), second.getReturnType()) ? second : first;
        });
        if (bestMatch.isPresent()) {
            TypeElement typeElement = (TypeElement)((ExecutableElement)bestMatch.get()).getEnclosingElement();
            return Optional.of(String.valueOf(typeElement.getQualifiedName()) + "." + String.valueOf(((ExecutableElement)bestMatch.get()).getSimpleName()) + "()");
        }
        return Optional.empty();
    }

    private Optional<String> getEnumDefaultValueFromAnnotation(Element invoker, TypeElement provider) {
        ArrayList<VariableElement> defaultValueProviderCandidates = new ArrayList<VariableElement>();
        for (Element element : provider.getEnclosedElements()) {
            ProtobufDefaultValue annotation;
            VariableElement variableElement;
            if (!(element instanceof VariableElement) || (variableElement = (VariableElement)element).getKind() != ElementKind.ENUM_CONSTANT || (annotation = variableElement.getAnnotation(ProtobufDefaultValue.class)) == null) continue;
            defaultValueProviderCandidates.add(variableElement);
        }
        Optional bestMatch = defaultValueProviderCandidates.stream().reduce((first, second) -> {
            this.messages.printError("Duplicated protobuf default valueType: only one default valueType is allowed in an enum", invoker);
            return first;
        });
        if (bestMatch.isPresent()) {
            TypeElement typeElement = (TypeElement)((VariableElement)bestMatch.get()).getEnclosingElement();
            return Optional.of(String.valueOf(typeElement.getQualifiedName()) + "." + String.valueOf(((VariableElement)bestMatch.get()).getSimpleName()));
        }
        return Optional.empty();
    }

    private Optional<? extends ProtobufPropertyType> getPropertyType(Element invoker, TypeMirror elementType, TypeMirror accessorType, ProtobufProperty property, TypeMirror rawGroupRepeatedValueType, TypeMirror rawGroupMapValueType) {
        List<TypeElement> mixins = this.types.getMixins(property);
        if (rawGroupRepeatedValueType != null && !this.types.isSameType(rawGroupRepeatedValueType, Object.class) || this.types.isAssignable(elementType, Collection.class)) {
            return this.getConcreteCollectionType(invoker, property, elementType, mixins, rawGroupRepeatedValueType);
        }
        if (this.types.isAssignable(elementType, Map.class)) {
            return this.getConcreteMapType(property, invoker, elementType, mixins, rawGroupMapValueType);
        }
        if (property.mapKeyType() != ProtobufType.UNKNOWN || property.mapValueType() != ProtobufType.UNKNOWN) {
            if (property.mapKeyType() == ProtobufType.UNKNOWN) {
                this.messages.printError("Type error: mapKeyType cannot be unknown if mapValueType was specified", invoker);
            } else if (property.mapValueType() == ProtobufType.UNKNOWN) {
                this.messages.printError("Type error: mapValueType cannot be unknown if mapKeyType was specified", invoker);
            }
            return this.getConcreteMapType(property, invoker, elementType, mixins, rawGroupMapValueType);
        }
        String defaultValue = this.getDefaultValue(invoker, elementType, mixins).orElse("null");
        ProtobufPropertyType.NormalType implementation = new ProtobufPropertyType.NormalType(property.type(), elementType, accessorType, defaultValue, mixins);
        this.createUnattributedSerializer(invoker, implementation);
        this.createUnattributedDeserializer(invoker, implementation);
        if (!this.types.isSameType(implementation.serializedType(), implementation.descriptorElementType())) {
            String deserializedDefaultValue = this.getDefaultValue(invoker, implementation.deserializedType(), mixins).orElse("null");
            implementation.setDeserializedDefaultValue(deserializedDefaultValue);
        }
        return Optional.of(implementation);
    }

    private Optional<? extends ProtobufPropertyType> getConcreteCollectionType(Element invoker, ProtobufProperty property, TypeMirror elementType, List<TypeElement> mixins, TypeMirror rawGroupRepeatedValueType) {
        TypeMirror collectionTypeParameter;
        TypeMirror typeMirror = collectionTypeParameter = rawGroupRepeatedValueType != null && !this.types.isSameType(rawGroupRepeatedValueType, Object.class) ? rawGroupRepeatedValueType : (TypeMirror)this.types.getTypeParameter(elementType, this.types.getType(Collection.class, new Class[0]), 0).orElse(null);
        if (collectionTypeParameter == null) {
            this.messages.printError("Type inference error: cannot determine collection's type parameter", invoker);
            return Optional.empty();
        }
        Optional<String> collectionDefaultValue = this.getCollectionDefaultValue(invoker, rawGroupRepeatedValueType != null && !this.types.isSameType(rawGroupRepeatedValueType, Object.class) ? this.types.getType(Collection.class, new Class[0]) : elementType, mixins);
        if (collectionDefaultValue.isEmpty()) {
            this.messages.printError("Type inference error: cannot determine collection's default valueType, provide one either in the definition or using a mixin", invoker);
            return Optional.empty();
        }
        ProtobufPropertyType.NormalType collectionTypeParameterType = new ProtobufPropertyType.NormalType(property.type(), collectionTypeParameter, collectionTypeParameter, null, mixins);
        this.createUnattributedSerializer(invoker, collectionTypeParameterType);
        this.createUnattributedDeserializer(invoker, collectionTypeParameterType);
        ProtobufPropertyType.CollectionType type = new ProtobufPropertyType.CollectionType(elementType, collectionTypeParameterType, collectionDefaultValue.get(), mixins);
        return Optional.of(type);
    }

    private Optional<? extends Element> getAccessor(VariableElement fieldElement, ProtobufProperty propertyAnnotation) {
        if (!fieldElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Optional.of(fieldElement);
        }
        List<ExecutableElement> methods = fieldElement.getEnclosingElement().getEnclosedElements().stream().filter(entry -> entry instanceof ExecutableElement).map(entry -> (ExecutableElement)entry).filter(element -> !element.getModifiers().contains((Object)Modifier.PRIVATE)).toList();
        return methods.stream().filter(entry -> this.isProtobufGetter((ExecutableElement)entry, propertyAnnotation)).findFirst().or(() -> this.inferAccessor(fieldElement, methods));
    }

    private Optional<ExecutableElement> inferAccessor(VariableElement fieldElement, List<ExecutableElement> methods) {
        String fieldName = fieldElement.getSimpleName().toString();
        return methods.stream().filter(entry -> this.isProtobufGetter((ExecutableElement)entry, fieldName)).findFirst();
    }

    private boolean isProtobufGetter(ExecutableElement entry, String fieldName) {
        String methodName = entry.getSimpleName().toString();
        return entry.getParameters().isEmpty() && (methodName.equalsIgnoreCase("get" + fieldName) || methodName.equalsIgnoreCase(fieldName));
    }

    private boolean isProtobufGetter(ExecutableElement entry, ProtobufProperty propertyAnnotation) {
        ProtobufGetter annotation = entry.getAnnotation(ProtobufGetter.class);
        return annotation != null && annotation.index() == propertyAnnotation.index();
    }

    private Optional<ProtobufPropertyType.MapType> getConcreteMapType(ProtobufProperty property, Element invoker, TypeMirror elementType, List<TypeElement> mixins, TypeMirror rawGroupMapValueType) {
        Optional<String> mapDefaultValue;
        TypeMirror valueTypeParameter;
        if (property.mapKeyType() == ProtobufType.UNKNOWN || property.mapKeyType() == ProtobufType.MAP) {
            this.messages.printError("Missing type error: specify the type of the map's key in @%s with mapKeyType".formatted(invoker instanceof ExecutableElement ? "GroupProperty" : "ProtobufProperty"), invoker);
            return Optional.empty();
        }
        if (property.mapValueType() == ProtobufType.UNKNOWN || property.mapValueType() == ProtobufType.MAP) {
            this.messages.printError("Missing type error: specify the type of the map's valueType in @%s with mapValueType".formatted(invoker instanceof ExecutableElement ? "GroupProperty" : "ProtobufProperty"), invoker);
            return Optional.empty();
        }
        if (property.mapKeyType() == ProtobufType.MESSAGE || property.mapKeyType() == ProtobufType.ENUM || property.mapKeyType() == ProtobufType.GROUP) {
            this.messages.printError("Type error: protobuf doesn't support messages, enums or groups as keys in a map", invoker);
            return Optional.empty();
        }
        if (property.mapValueType() == ProtobufType.GROUP) {
            this.messages.printError("Type error: protobuf doesn't support groups as values in a map", invoker);
            return Optional.empty();
        }
        if ((property.mapValueType() == ProtobufType.MESSAGE || property.mapValueType() == ProtobufType.ENUM) && rawGroupMapValueType != null && this.types.isSameType(rawGroupMapValueType, Object.class)) {
            this.messages.printError("Type error: a property whose type is message or enum in a raw group serializer must specify mapValueImplementation", invoker);
            return Optional.empty();
        }
        TypeMirror keyTypeParameter = this.types.getTypeParameter(elementType, this.types.getType(Map.class, new Class[0]), 0).orElse(property.mapKeyType() != ProtobufType.MESSAGE && property.mapKeyType() != ProtobufType.ENUM ? this.types.getType(property.mapKeyType().wrapperType(), new Class[0]) : null);
        if (keyTypeParameter == null) {
            this.messages.printError("Type inference error: cannot determine map's key type", invoker);
            return Optional.empty();
        }
        ProtobufPropertyType.NormalType keyEntry = new ProtobufPropertyType.NormalType(property.mapKeyType(), keyTypeParameter, keyTypeParameter, null, mixins);
        this.createUnattributedSerializer(invoker, keyEntry);
        this.createUnattributedDeserializer(invoker, keyEntry);
        TypeMirror typeMirror = rawGroupMapValueType != null && !this.types.isSameType(rawGroupMapValueType, Object.class) ? rawGroupMapValueType : (valueTypeParameter = (TypeMirror)this.types.getTypeParameter(elementType, this.types.getType(Map.class, new Class[0]), 1).orElse(property.mapValueType() != ProtobufType.MESSAGE && property.mapValueType() != ProtobufType.ENUM ? this.types.getType(property.mapValueType().wrapperType(), new Class[0]) : null));
        if (valueTypeParameter == null) {
            this.messages.printError("Type inference error: cannot determine map's valueType type", invoker);
            return Optional.empty();
        }
        String valueDefaultValue = this.getDefaultValue(invoker, valueTypeParameter, mixins).orElse("null");
        ProtobufPropertyType.NormalType valueEntry = new ProtobufPropertyType.NormalType(property.mapValueType(), valueTypeParameter, valueTypeParameter, valueDefaultValue, mixins);
        this.createUnattributedSerializer(invoker, valueEntry);
        this.createUnattributedDeserializer(invoker, valueEntry);
        if (!this.types.isSameType(valueEntry.serializedType(), valueEntry.descriptorElementType())) {
            String deserializedDefaultValue = this.getDefaultValue(invoker, valueEntry.deserializedType(), mixins).orElse("null");
            valueEntry.setDeserializedDefaultValue(deserializedDefaultValue);
        }
        if ((mapDefaultValue = this.getCollectionDefaultValue(invoker, elementType, mixins)).isEmpty()) {
            this.messages.printError("Type inference error: cannot determine map default valueType", invoker);
            return Optional.empty();
        }
        return Optional.of(new ProtobufPropertyType.MapType(elementType, keyEntry, valueEntry, mapDefaultValue.get(), mixins));
    }

    private void createUnattributedSerializer(Element invoker, ProtobufPropertyType implementation) {
        this.createUnattributedSerializer(invoker, implementation.accessorType(), implementation);
    }

    private void createUnattributedSerializer(Element invoker, TypeMirror from, ProtobufPropertyType implementation) {
        ProtobufType to = implementation.protobufType();
        TypeMirror toWrapped = this.types.getType(to.wrapperType(), new Class[0]);
        if (to != ProtobufType.MESSAGE && to != ProtobufType.ENUM && to != ProtobufType.GROUP && this.types.isAssignable(from, toWrapped)) {
            return;
        }
        ProtobufUnattributedConverterElement unattributed = new ProtobufUnattributedConverterElement(invoker, from, toWrapped, to, implementation.mixins(), ProtobufUnattributedConverterElement.Type.SERIALIZER);
        implementation.addConverter(unattributed);
    }

    private void createUnattributedDeserializer(Element invoker, ProtobufPropertyType implementation) {
        this.createUnattributedDeserializer(invoker, implementation.descriptorElementType(), implementation);
    }

    private void createUnattributedDeserializer(Element invoker, TypeMirror to, ProtobufPropertyType implementation) {
        ProtobufType from = implementation.protobufType();
        TypeMirror fromType = this.types.getType(from.wrapperType(), new Class[0]);
        if (from != ProtobufType.MESSAGE && from != ProtobufType.ENUM && from != ProtobufType.GROUP && this.types.isAssignable(to, fromType)) {
            return;
        }
        ProtobufUnattributedConverterElement unattributed = new ProtobufUnattributedConverterElement(invoker, fromType, to, from, implementation.mixins(), ProtobufUnattributedConverterElement.Type.DESERIALIZER);
        implementation.addConverter(unattributed);
    }

    private Object getProtobufTypeName(ProtobufType type) {
        return switch (type) {
            case ProtobufType.MESSAGE -> "ProtobufMessage";
            case ProtobufType.ENUM -> "ProtobufEnum";
            case ProtobufType.GROUP -> "ProtobufGroup";
            default -> {
                String primitiveName = type.serializedType().getSimpleName();
                String wrappedName = type.wrapperType().getSimpleName();
                if (Objects.equals(primitiveName, wrappedName)) {
                    yield "%s(%s)".formatted(type.name(), primitiveName);
                }
                yield "%s(%s/%s)".formatted(type.name(), primitiveName, wrappedName);
            }
        };
    }

    private Set<ProtobufObjectElement> processEnum(TypeElement enumElement) {
        Optional<ProtobufObjectElement> messageElement = this.createEnumElement(enumElement);
        if (messageElement.isEmpty()) {
            return Set.of();
        }
        this.linkEnum(enumElement.asType());
        long constantsCount = this.processEnumConstants(messageElement.get());
        if (constantsCount == 0L) {
            this.messages.printWarning("No constants found", enumElement);
        }
        return Set.of(messageElement.get());
    }

    private long processEnumConstants(ProtobufObjectElement messageElement) {
        ClassTree enumTree = this.trees.getTree(messageElement.element());
        return enumTree.getMembers().stream().filter(member -> member instanceof VariableTree).map(member -> (VariableTree)member).peek(variableTree -> this.processEnumConstant(messageElement, messageElement.element(), (VariableTree)variableTree)).count();
    }

    private Optional<ProtobufObjectElement> createEnumElement(TypeElement enumElement) {
        Optional<ProtobufEnumMetadata> metadata = this.getEnumMetadata(enumElement);
        if (metadata.isEmpty()) {
            return Optional.of(ProtobufObjectElement.ofEnum(enumElement, ProtobufEnumMetadata.javaEnum()));
        }
        if (metadata.get().isUnknown()) {
            return Optional.empty();
        }
        ProtobufObjectElement result = ProtobufObjectElement.ofEnum(enumElement, metadata.get());
        return Optional.of(result);
    }

    private Optional<ProtobufEnumMetadata> getEnumMetadata(TypeElement enumElement) {
        ProtobufEnumFields fields = this.getEnumFields(enumElement);
        return this.getConstructors(enumElement).stream().map(constructor -> this.getEnumMetadata((ExecutableElement)constructor, fields)).flatMap(Optional::stream).reduce((first, second) -> {
            this.messages.printError("Duplicated protobuf constructor: an enum should provide only one constructor with a scalar parameter annotated with @ProtobufEnumIndex", second.constructor());
            return first;
        });
    }

    private Optional<ProtobufEnumMetadata> getEnumMetadata(ExecutableElement constructor, ProtobufEnumFields fields) {
        MethodTree constructorTree = this.trees.getTree(constructor);
        return IntStream.range(0, constructor.getParameters().size()).filter(index -> this.isImplicitEnumConstructor(constructor) || this.hasProtobufIndexAnnotation(constructor, index)).mapToObj(index -> this.getEnumMetadata(constructor, constructor.getParameters().get(index), index, constructorTree, fields)).reduce((first, second) -> {
            this.messages.printError("Duplicated protobuf enum index: an enum constructor should provide only one parameter annotated with @ProtobufEnumIndex", second.parameter());
            return first;
        });
    }

    private boolean isImplicitEnumConstructor(ExecutableElement constructor) {
        return constructor.getParameters().size() == 1 && this.types.isSameType(constructor.getParameters().getFirst().asType(), Integer.TYPE);
    }

    private boolean hasProtobufIndexAnnotation(ExecutableElement constructor, int index) {
        return constructor.getParameters().get(index).getAnnotation(ProtobufEnumIndex.class) != null;
    }

    private ProtobufEnumMetadata getEnumMetadata(ExecutableElement constructor, VariableElement parameter, int index, MethodTree constructorTree, ProtobufEnumFields fields) {
        if (fields.enumIndexField() != null) {
            return new ProtobufEnumMetadata(constructor, fields.enumIndexField(), parameter, index);
        }
        return constructorTree.getBody().getStatements().stream().filter(constructorEntry -> constructorEntry instanceof ExpressionStatementTree).map(constructorEntry -> ((ExpressionStatementTree)constructorEntry).getExpression()).filter(constructorEntry -> constructorEntry instanceof AssignmentTree).map(constructorEntry -> (AssignmentTree)constructorEntry).filter(assignmentTree -> this.isEnumIndexParameterAssignment((AssignmentTree)assignmentTree, parameter)).map(this::getAssignmentExpressionName).flatMap(Optional::stream).map(fields.fields()::get).filter(Objects::nonNull).reduce((first, second) -> {
            this.messages.printError("Duplicated assignment: the parameter annotated with @ProtobufEnumIndex must be assigned to a single local field", (Element)second);
            return first;
        }).map(fieldElement -> {
            this.checkProtobufEnumIndexField((VariableElement)fieldElement);
            return new ProtobufEnumMetadata(constructor, (VariableElement)fieldElement, parameter, index);
        }).orElseGet(() -> {
            this.messages.printError("Missing or too complex assignment: the parameter annotated with @ProtobufEnumIndex should be assigned to a local field", constructor);
            this.messages.printError("If the assignment is too complex for the compiler to evaluate, annotate the local field directly with @ProtobufEnumIndex", constructor);
            return ProtobufEnumMetadata.unknown();
        });
    }

    private boolean isEnumIndexParameterAssignment(AssignmentTree assignmentTree, VariableElement parameter) {
        IdentifierTree identifierTree;
        ExpressionTree expressionTree = assignmentTree.getExpression();
        return expressionTree instanceof IdentifierTree && (identifierTree = (IdentifierTree)expressionTree).getName().equals(parameter.getSimpleName());
    }

    private Optional<Name> getAssignmentExpressionName(AssignmentTree assignmentTree) {
        ExpressionTree expressionTree = assignmentTree.getExpression();
        if (expressionTree instanceof IdentifierTree) {
            IdentifierTree fieldIdentifier = (IdentifierTree)expressionTree;
            return Optional.of(fieldIdentifier.getName());
        }
        expressionTree = assignmentTree.getExpression();
        if (expressionTree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)expressionTree;
            return Optional.of(memberSelectTree.getIdentifier());
        }
        return Optional.empty();
    }

    private ProtobufEnumFields getEnumFields(TypeElement enumElement) {
        HashMap<Name, VariableElement> fields = new HashMap<Name, VariableElement>();
        for (Element element : enumElement.getEnclosedElements()) {
            if (!(element instanceof VariableElement)) continue;
            VariableElement variableElement = (VariableElement)element;
            if (variableElement.getAnnotation(ProtobufEnumIndex.class) != null) {
                this.checkProtobufEnumIndexField(variableElement);
                return new ProtobufEnumFields(variableElement, null);
            }
            fields.put(variableElement.getSimpleName(), variableElement);
        }
        return new ProtobufEnumFields(null, fields);
    }

    private void checkProtobufEnumIndexField(VariableElement variableElement) {
        if (!variableElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return;
        }
        this.messages.printError("Weak visibility: the field annotated with @ProtobufEnumIndex must have at least package-private visibility", variableElement);
    }

    private List<ExecutableElement> getConstructors(TypeElement enumElement) {
        return enumElement.getEnclosedElements().stream().filter(entry -> entry instanceof ExecutableElement).map(entry -> (ExecutableElement)entry).filter(entry -> entry.getKind() == ElementKind.CONSTRUCTOR).toList();
    }

    private void processEnumConstant(ProtobufObjectElement messageElement, TypeElement enumElement, VariableTree enumConstantTree) {
        ExpressionTree expressionTree = enumConstantTree.getInitializer();
        if (!(expressionTree instanceof NewClassTree)) {
            return;
        }
        NewClassTree newClassTree = (NewClassTree)expressionTree;
        String newClassType = newClassTree.getIdentifier().toString();
        String simpleEnumName = enumElement.getSimpleName().toString();
        if (!newClassType.equals(simpleEnumName) && !newClassType.equals(messageElement.element().getQualifiedName().toString())) {
            return;
        }
        String variableName = enumConstantTree.getName().toString();
        if (messageElement.enumMetadata().orElseThrow().isJavaEnum()) {
            Optional<String> error;
            int ordinal = messageElement.constants().size();
            if (messageElement.isIndexDisallowed(ordinal)) {
                this.messages.printError("Restricted message property index: %s is not allowed as it's marked as reserved".formatted(ordinal), enumElement);
            }
            if ((error = messageElement.addConstant(ordinal, variableName)).isEmpty()) {
                return;
            }
            this.messages.printError("Duplicated enum constant: %s and %s with index %s".formatted(variableName, error.get(), ordinal), enumElement);
        } else {
            Optional<String> error;
            if (newClassTree.getArguments().isEmpty()) {
                this.messages.printError("%s doesn't specify an index".formatted(variableName), enumElement);
                return;
            }
            ExpressionTree indexArgument = newClassTree.getArguments().get(messageElement.enumMetadata().orElseThrow().parameterIndex());
            if (!(indexArgument instanceof LiteralTree)) {
                this.messages.printError("%s's index must be a constant valueType".formatted(variableName), enumElement);
                return;
            }
            LiteralTree literalTree = (LiteralTree)indexArgument;
            int value = ((Number)literalTree.getValue()).intValue();
            if (value < 0) {
                this.messages.printError("%s's index must be positive".formatted(variableName), enumElement);
            }
            if (messageElement.isIndexDisallowed(value)) {
                this.messages.printError("Restricted message property index: %s is not allowed as it's marked as reserved".formatted(value), enumElement);
            }
            if ((error = messageElement.addConstant(value, variableName)).isEmpty()) {
                return;
            }
            this.messages.printError("Duplicated enum constant: %s and %s with index %s".formatted(variableName, error.get(), value), enumElement);
        }
    }

    private record ProtobufEnumFields(VariableElement enumIndexField, Map<Name, VariableElement> fields) {
    }
}

