/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.clazz.group;

import it.auties.protobuf.model.ProtobufWireType;
import it.auties.protobuf.serialization.generator.clazz.ProtobufClassGenerator;
import it.auties.protobuf.serialization.generator.method.deserialization.group.ProtobufRawGroupDeserializationGenerator;
import it.auties.protobuf.serialization.generator.method.serialization.group.ProtobufRawGroupSerializationGenerator;
import it.auties.protobuf.serialization.generator.method.serialization.group.ProtobufRawGroupSizeGenerator;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.support.JavaWriter;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

public class ProtobufRawGroupSpecGenerator
extends ProtobufClassGenerator {
    public ProtobufRawGroupSpecGenerator(Filer filer) {
        super(filer);
    }

    public void createClass(ProtobufObjectElement object, PackageElement packageName) throws IOException {
        String simpleGeneratedClassName = this.getGeneratedClassNameBySuffix(object.element(), "Spec");
        Object qualifiedGeneratedClassName = packageName != null ? String.valueOf(packageName) + "." + simpleGeneratedClassName : simpleGeneratedClassName;
        Optional<JavaFileObject> sourceFile = this.createSourceFile((String)qualifiedGeneratedClassName);
        if (sourceFile.isEmpty()) {
            return;
        }
        try (JavaWriter.CompilationUnit compilationUnitWriter = new JavaWriter.CompilationUnit(sourceFile.get().openWriter());){
            if (packageName != null) {
                compilationUnitWriter.printPackageDeclaration(packageName.getQualifiedName().toString());
            }
            List<String> imports = this.getSpecImports(object.element());
            imports.forEach(compilationUnitWriter::printImportDeclaration);
            compilationUnitWriter.printSeparator();
            try (JavaWriter.ClassWriter classWriter = compilationUnitWriter.printClassDeclaration(simpleGeneratedClassName);){
                ProtobufRawGroupSerializationGenerator serializationVisitor = new ProtobufRawGroupSerializationGenerator(object);
                serializationVisitor.generate(classWriter);
                ProtobufRawGroupDeserializationGenerator deserializationVisitor = new ProtobufRawGroupDeserializationGenerator(object);
                deserializationVisitor.generate(classWriter);
                ProtobufRawGroupSizeGenerator sizeVisitor = new ProtobufRawGroupSizeGenerator(object);
                sizeVisitor.generate(classWriter);
            }
        }
    }

    private Optional<JavaFileObject> createSourceFile(String qualifiedGeneratedClassName) throws IOException {
        try {
            return Optional.of(this.filer.createSourceFile(qualifiedGeneratedClassName, new Element[0]));
        }
        catch (FilerException filerException) {
            return Optional.empty();
        }
    }

    private List<String> getSpecImports(TypeElement rawGroup) {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(rawGroup.getQualifiedName().toString());
        imports.add(ProtobufInputStream.class.getName());
        imports.add(ProtobufOutputStream.class.getName());
        imports.add(ProtobufWireType.class.getName());
        imports.add(Map.class.getName());
        return Collections.unmodifiableList(imports);
    }
}

