/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.clazz.object;

import it.auties.protobuf.annotation.ProtobufDeserializer;
import it.auties.protobuf.serialization.generator.clazz.ProtobufClassGenerator;
import it.auties.protobuf.serialization.model.converter.ProtobufAttributedConverterElement;
import it.auties.protobuf.serialization.model.object.ProtobufBuilderElement;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyType;
import it.auties.protobuf.serialization.support.JavaWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;

public class ProtobufObjectBuilderGenerator
extends ProtobufClassGenerator {
    public ProtobufObjectBuilderGenerator(Filer filer) {
        super(filer);
    }

    public void createClass(ProtobufObjectElement objectElement, ProtobufBuilderElement builderElement, PackageElement packageName) throws IOException {
        String simpleGeneratedClassName = builderElement != null ? this.getGeneratedClassNameByName(objectElement.element(), builderElement.name()) : this.getGeneratedClassNameBySuffix(objectElement.element(), "Builder");
        String qualifiedGeneratedClassName = packageName != null ? String.valueOf(packageName) + "." + simpleGeneratedClassName : simpleGeneratedClassName;
        JavaFileObject sourceFile = this.filer.createSourceFile(qualifiedGeneratedClassName, new Element[0]);
        try (JavaWriter.CompilationUnit compilationUnitWriter = new JavaWriter.CompilationUnit(sourceFile.openWriter());){
            if (packageName != null) {
                compilationUnitWriter.printPackageDeclaration(packageName.getQualifiedName().toString());
            }
            try (JavaWriter.ClassWriter builderClassWriter = compilationUnitWriter.printClassDeclaration(simpleGeneratedClassName);){
                ArrayList<String> invocationArgs = new ArrayList<String>();
                if (builderElement != null) {
                    for (VariableElement variableElement : builderElement.parameters()) {
                        builderClassWriter.printFieldDeclaration(variableElement.asType().toString(), variableElement.getSimpleName().toString());
                        invocationArgs.add(variableElement.getSimpleName().toString());
                    }
                } else {
                    for (ProtobufPropertyElement protobufPropertyElement : objectElement.properties()) {
                        if (protobufPropertyElement.synthetic()) continue;
                        builderClassWriter.printFieldDeclaration(protobufPropertyElement.type().descriptorElementType().toString(), protobufPropertyElement.name());
                        invocationArgs.add(protobufPropertyElement.name());
                    }
                }
                compilationUnitWriter.printSeparator();
                try (Iterator<ProtobufPropertyElement> builderConstructorWriter = builderClassWriter.printConstructorDeclaration(simpleGeneratedClassName, new String[0]);){
                    if (builderElement == null) {
                        for (ProtobufPropertyElement property : objectElement.properties()) {
                            if (property.synthetic()) continue;
                            ((JavaWriter.BodyWriter)((Object)builderConstructorWriter)).printFieldAssignment(property.name(), property.type().descriptorDefaultValue());
                        }
                    }
                }
                if (builderElement != null) {
                    for (VariableElement variableElement : builderElement.parameters()) {
                        String fieldName = variableElement.getSimpleName().toString();
                        this.writeBuilderSetter(builderClassWriter, fieldName, fieldName, variableElement.asType(), simpleGeneratedClassName);
                    }
                } else {
                    for (ProtobufPropertyElement protobufPropertyElement : objectElement.properties()) {
                        if (protobufPropertyElement.synthetic()) continue;
                        List<ProtobufAttributedConverterElement.Deserializer> deserializers = protobufPropertyElement.type().deserializers();
                        boolean hasOverride = false;
                        if (protobufPropertyElement.type() instanceof ProtobufPropertyType.NormalType) {
                            for (int i = 0; i < deserializers.size(); ++i) {
                                ProtobufAttributedConverterElement.Deserializer deserializer = deserializers.get(i);
                                if (deserializer.behaviour() == ProtobufDeserializer.BuilderBehaviour.DISCARD) continue;
                                if (hasOverride) {
                                    hasOverride = deserializer.behaviour() == ProtobufDeserializer.BuilderBehaviour.OVERRIDE;
                                    continue;
                                }
                                String value = protobufPropertyElement.name();
                                for (int j = i; j < deserializers.size(); ++j) {
                                    ProtobufAttributedConverterElement.Deserializer override = deserializers.get(j);
                                    TypeElement enclosingElement = (TypeElement)override.delegate().getEnclosingElement();
                                    value = "%s.%s(%s)".formatted(enclosingElement.getQualifiedName(), override.delegate().getSimpleName(), value);
                                }
                                this.writeBuilderSetter(builderClassWriter, protobufPropertyElement.name(), value, deserializer.parameterType(), simpleGeneratedClassName);
                                hasOverride = deserializer.behaviour() == ProtobufDeserializer.BuilderBehaviour.OVERRIDE;
                            }
                        }
                        if (hasOverride) continue;
                        this.writeBuilderSetter(builderClassWriter, protobufPropertyElement.name(), protobufPropertyElement.name(), protobufPropertyElement.type().descriptorElementType(), simpleGeneratedClassName);
                    }
                }
                Name resultQualifiedName = objectElement.element().getQualifiedName();
                try (JavaWriter.ClassWriter.MethodWriter methodWriter = builderClassWriter.printMethodDeclaration(resultQualifiedName.toString(), "build", new String[0]);){
                    String unknownFieldsValue;
                    String invocationArgsJoined = String.join((CharSequence)", ", invocationArgs);
                    Optional<ExecutableElement> builderDelegate = objectElement.deserializer();
                    String string = unknownFieldsValue = objectElement.unknownFieldsElement().isEmpty() ? "" : ", " + objectElement.unknownFieldsElement().get().defaultValue();
                    if (builderDelegate.isEmpty() && (builderElement == null || builderElement.delegate().getKind() == ElementKind.CONSTRUCTOR)) {
                        methodWriter.printReturn("new %s(%s%s)".formatted(resultQualifiedName, invocationArgsJoined, unknownFieldsValue));
                    } else {
                        Name methodName = builderElement != null ? builderElement.delegate().getSimpleName() : builderDelegate.get().getSimpleName();
                        methodWriter.printReturn("%s.%s(%s%s)".formatted(resultQualifiedName, methodName, invocationArgsJoined, unknownFieldsValue));
                    }
                }
            }
        }
    }

    private void writeBuilderSetter(JavaWriter.ClassWriter writer, String fieldName, String fieldValue, TypeMirror fieldType, String className) {
        try (JavaWriter.ClassWriter.MethodWriter setterWriter = writer.printMethodDeclaration(className, fieldName, "%s %s".formatted(fieldType, fieldName));){
            setterWriter.printFieldAssignment("this." + fieldName, fieldValue);
            setterWriter.printReturn("this");
        }
    }
}

