/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.clazz.object;

import it.auties.protobuf.model.ProtobufWireType;
import it.auties.protobuf.serialization.generator.clazz.ProtobufClassGenerator;
import it.auties.protobuf.serialization.generator.method.deserialization.object.ProtobufObjectDeserializationGenerator;
import it.auties.protobuf.serialization.generator.method.deserialization.object.ProtobufObjectDeserializationOverloadGenerator;
import it.auties.protobuf.serialization.generator.method.serialization.object.ProtobufObjectSerializationGenerator;
import it.auties.protobuf.serialization.generator.method.serialization.object.ProtobufObjectSerializationOverloadGenerator;
import it.auties.protobuf.serialization.generator.method.serialization.object.ProtobufObjectSizeGenerator;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyElement;
import it.auties.protobuf.serialization.support.JavaWriter;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.JavaFileObject;

public class ProtobufObjectSpecGenerator
extends ProtobufClassGenerator {
    public ProtobufObjectSpecGenerator(Filer filer) {
        super(filer);
    }

    public void createClass(ProtobufObjectElement objectElement, PackageElement packageElement) throws IOException {
        String simpleGeneratedClassName = this.getGeneratedClassNameBySuffix(objectElement.element(), "Spec");
        String qualifiedGeneratedClassName = packageElement != null ? String.valueOf(packageElement) + "." + simpleGeneratedClassName : simpleGeneratedClassName;
        JavaFileObject sourceFile = this.filer.createSourceFile(qualifiedGeneratedClassName, new Element[0]);
        try (JavaWriter.CompilationUnit compilationUnitWriter = new JavaWriter.CompilationUnit(sourceFile.openWriter());){
            if (packageElement != null) {
                compilationUnitWriter.printPackageDeclaration(packageElement.getQualifiedName().toString());
            }
            List<String> imports = this.getSpecImports(objectElement);
            imports.forEach(compilationUnitWriter::printImportDeclaration);
            compilationUnitWriter.printSeparator();
            try (JavaWriter.ClassWriter classWriter = compilationUnitWriter.printClassDeclaration(simpleGeneratedClassName);){
                if (objectElement.type() == ProtobufObjectElement.Type.ENUM) {
                    String objectType = objectElement.element().getSimpleName().toString();
                    classWriter.println("private static final Map<Integer, %s> %s = new HashMap<>();".formatted(objectType, "VALUES"));
                    try (JavaWriter.ClassWriter.MethodWriter staticInitBlock = classWriter.printStaticBlock();){
                        for (Map.Entry<Integer, String> entry : objectElement.constants().entrySet()) {
                            staticInitBlock.println("%s.put(%s, %s.%s);".formatted("VALUES", entry.getKey(), objectType, entry.getValue()));
                        }
                    }
                }
                ProtobufObjectSerializationOverloadGenerator serializationOverloadVisitor = new ProtobufObjectSerializationOverloadGenerator(objectElement);
                serializationOverloadVisitor.generate(classWriter);
                ProtobufObjectSerializationGenerator serializationVisitor = new ProtobufObjectSerializationGenerator(objectElement);
                serializationVisitor.generate(classWriter);
                ProtobufObjectDeserializationOverloadGenerator deserializationOverloadVisitor = new ProtobufObjectDeserializationOverloadGenerator(objectElement);
                deserializationOverloadVisitor.generate(classWriter);
                ProtobufObjectDeserializationGenerator deserializationVisitor = new ProtobufObjectDeserializationGenerator(objectElement);
                deserializationVisitor.generate(classWriter);
                ProtobufObjectSizeGenerator sizeVisitor = new ProtobufObjectSizeGenerator(objectElement);
                sizeVisitor.generate(classWriter);
            }
        }
    }

    private List<String> getSpecImports(ProtobufObjectElement message) {
        if (message.type() == ProtobufObjectElement.Type.ENUM) {
            return List.of(message.element().getQualifiedName().toString(), Arrays.class.getName(), Optional.class.getName(), ProtobufOutputStream.class.getName(), Map.class.getName(), HashMap.class.getName());
        }
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(message.element().getQualifiedName().toString());
        imports.add(ProtobufInputStream.class.getName());
        imports.add(ProtobufOutputStream.class.getName());
        imports.add(ProtobufWireType.class.getName());
        if (message.properties().stream().anyMatch(ProtobufPropertyElement::required)) {
            imports.add(Objects.class.getName());
        }
        return Collections.unmodifiableList(imports);
    }
}

