/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.method;

import it.auties.protobuf.annotation.ProtobufEnum;
import it.auties.protobuf.annotation.ProtobufGroup;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.support.JavaWriter;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public abstract class ProtobufMethodGenerator {
    protected final ProtobufObjectElement objectElement;
    protected final List<Runnable> deferredOperations;

    protected ProtobufMethodGenerator(ProtobufObjectElement objectElement) {
        this.objectElement = objectElement;
        this.deferredOperations = new ArrayList<Runnable>();
    }

    public void generate(JavaWriter.ClassWriter writer) {
        if (!this.shouldInstrument()) {
            return;
        }
        List<String> parametersTypes = this.parametersTypes();
        List<String> parametersNames = this.parametersNames();
        if (parametersTypes.size() != parametersNames.size()) {
            throw new IllegalArgumentException("Parameters mismatch");
        }
        String[] parameters = (String[])IntStream.range(0, parametersTypes.size()).mapToObj(index -> (String)parametersTypes.get(index) + " " + (String)parametersNames.get(index)).toArray(String[]::new);
        try (JavaWriter.ClassWriter.MethodWriter methodWriter = writer.printMethodDeclaration(this.modifiers(), this.returnType(), this.name(), parameters);){
            this.doInstrumentation(writer, methodWriter);
        }
        while (!this.deferredOperations.isEmpty()) {
            ArrayList<Runnable> round = new ArrayList<Runnable>(this.deferredOperations);
            this.deferredOperations.clear();
            for (Runnable runnable : round) {
                runnable.run();
            }
        }
    }

    public abstract boolean shouldInstrument();

    protected abstract void doInstrumentation(JavaWriter.ClassWriter var1, JavaWriter.ClassWriter.MethodWriter var2);

    protected abstract List<String> modifiers();

    protected abstract String returnType();

    protected abstract String name();

    protected abstract List<String> parametersTypes();

    protected abstract List<String> parametersNames();

    public static String getSpecFromObject(TypeMirror typeMirror) {
        if (!(typeMirror instanceof DeclaredType)) {
            return "";
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        TypeElement element = (TypeElement)declaredType.asElement();
        String packageName = null;
        StringBuilder name = new StringBuilder();
        for (Element parent = element.getEnclosingElement(); parent != null; parent = parent.getEnclosingElement()) {
            if (parent instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)parent;
                name.append(typeElement.getSimpleName());
                continue;
            }
            if (!(parent instanceof PackageElement)) continue;
            PackageElement packageElement = (PackageElement)parent;
            packageName = packageElement.getQualifiedName().toString();
            break;
        }
        name.append(declaredType.asElement().getSimpleName());
        StringBuilder result = new StringBuilder();
        if (packageName != null) {
            result.append(packageName);
            result.append(".");
        }
        result.append((CharSequence)name);
        result.append("Spec");
        return result.toString();
    }

    protected String getAccessorCall(String object, Element accessor) {
        Element element = accessor;
        Objects.requireNonNull(element);
        Element element2 = element;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExecutableElement.class, VariableElement.class}, (Object)element2, n)) {
            case 0 -> {
                ExecutableElement executableElement = (ExecutableElement)element2;
                yield "%s.%s()".formatted(object, executableElement.getSimpleName());
            }
            case 1 -> {
                VariableElement variableElement = (VariableElement)element2;
                yield "%s.%s".formatted(object, variableElement.getSimpleName());
            }
            default -> throw new IllegalStateException("Unexpected valueType: " + String.valueOf(accessor));
        };
    }

    protected String getQualifiedName(TypeMirror type) {
        if (!(type instanceof DeclaredType)) {
            return type.toString();
        }
        DeclaredType declaredType = (DeclaredType)type;
        Element element = declaredType.asElement();
        if (!(element instanceof TypeElement)) {
            return declaredType.toString();
        }
        TypeElement typeElement = (TypeElement)element;
        return typeElement.getQualifiedName().toString();
    }

    protected String getSimpleName(TypeMirror type) {
        String[] parts = this.getQualifiedName(type).split("\\.");
        return parts[parts.length - 1].replaceAll("\\$", ".");
    }

    protected boolean isMessage(TypeMirror deserializedType) {
        DeclaredType declaredType;
        return deserializedType instanceof DeclaredType && (declaredType = (DeclaredType)deserializedType).asElement().getAnnotation(ProtobufMessage.class) != null;
    }

    protected boolean isGroup(TypeMirror deserializedType) {
        DeclaredType declaredType;
        return deserializedType instanceof DeclaredType && (declaredType = (DeclaredType)deserializedType).asElement().getAnnotation(ProtobufGroup.class) != null;
    }

    protected boolean isEnum(TypeMirror deserializedType) {
        DeclaredType declaredType;
        return deserializedType instanceof DeclaredType && (declaredType = (DeclaredType)deserializedType).asElement().getAnnotation(ProtobufEnum.class) != null;
    }
}

