/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.method.deserialization;

import it.auties.protobuf.model.ProtobufType;
import it.auties.protobuf.serialization.generator.method.ProtobufMethodGenerator;
import it.auties.protobuf.serialization.model.converter.ProtobufAttributedConverterElement;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyType;
import it.auties.protobuf.serialization.support.JavaWriter;
import java.util.List;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

public abstract class ProtobufDeserializationGenerator
extends ProtobufMethodGenerator {
    public static final String METHOD_NAME = "decode";
    private static final String INPUT_STREAM_NAME = "protoInputStream";

    public ProtobufDeserializationGenerator(ProtobufObjectElement element) {
        super(element);
    }

    protected void writeMapDeserializer(JavaWriter.ClassWriter.SwitchStatementWriter writer, int index, String name, ProtobufPropertyType.MapType mapType) {
        try (JavaWriter.ClassWriter.SwitchBranchWriter switchBranchWriter = writer.printSwitchBranch(String.valueOf(index));){
            String streamName = switchBranchWriter.printVariableDeclaration("%sInputStream".formatted(name), "%s.readLengthDelimited()".formatted(INPUT_STREAM_NAME));
            String keyName = switchBranchWriter.printVariableDeclaration(this.getQualifiedName(mapType.keyType().accessorType()), "%sKey".formatted(name), "null");
            String valueName = switchBranchWriter.printVariableDeclaration(this.getQualifiedName(mapType.valueType().accessorType()), "%sValue".formatted(name), "null");
            String keyReadMethod = this.getDeserializerStreamMethod(mapType.keyType(), false);
            String keyReadFunction = this.getConvertedValue(1, streamName, mapType.keyType(), keyReadMethod);
            String valueReadMethod = this.getDeserializerStreamMethod(mapType.valueType(), false);
            String valueReadFunction = this.getConvertedValue(2, streamName, mapType.valueType(), valueReadMethod);
            try (JavaWriter.ClassWriter.ConditionalStatementWriter whileWriter = switchBranchWriter.printWhileStatement(streamName + ".readTag()");
                 JavaWriter.ClassWriter.SwitchStatementWriter mapSwitchWriter = whileWriter.printSwitchStatement(streamName + ".index()");){
                mapSwitchWriter.printSwitchBranch("1", "%s = %s".formatted(keyName, keyReadFunction));
                mapSwitchWriter.printSwitchBranch("2", "%s = %s".formatted(valueName, valueReadFunction));
            }
            switchBranchWriter.println("%s.put(%s, %s);".formatted(name, keyName, valueName));
        }
    }

    protected void writeDeserializer(JavaWriter.ClassWriter.SwitchStatementWriter writer, String name, int index, ProtobufPropertyType type, boolean repeated, boolean packed, String mapTargetName) {
        String readMethod = this.getDeserializerStreamMethod(type, packed);
        String readFunction = this.getConvertedValue(index, INPUT_STREAM_NAME, type, readMethod);
        String readAssignment = this.getReadAssignment(name, repeated, packed, readFunction, mapTargetName);
        writer.printSwitchBranch(String.valueOf(index), readAssignment);
    }

    private String getReadAssignment(String name, boolean repeated, boolean packed, String readFunction, String mapTargetName) {
        if (mapTargetName != null) {
            if (repeated) {
                return "%s.add(%s)".formatted(name, readFunction);
            }
            return "%s.put(index, %s)".formatted(mapTargetName, readFunction);
        }
        if (!repeated) {
            return "%s = %s".formatted(name, readFunction);
        }
        String repeatedMethod = packed ? "addAll" : "add";
        return "%s.%s(%s)".formatted(name, repeatedMethod, readFunction);
    }

    private String getConvertedValue(int index, String value, ProtobufPropertyType implementation, String readMethod) {
        if (implementation.protobufType() == ProtobufType.MESSAGE) {
            value = "%s.readLengthDelimited()".formatted(value);
        }
        if (!readMethod.isEmpty()) {
            value = "%s.%s()".formatted(value, readMethod);
        }
        block4: for (int i = 0; i < implementation.deserializers().size(); ++i) {
            ProtobufAttributedConverterElement.Deserializer deserializer = implementation.deserializers().get(i);
            TypeElement parent = (TypeElement)deserializer.delegate().getEnclosingElement();
            Name converterMethodName = deserializer.delegate().getSimpleName();
            switch (deserializer.delegate().getParameters().size()) {
                case 1: {
                    value = "%s.%s(%s)".formatted(parent.getQualifiedName(), converterMethodName, value);
                    continue block4;
                }
                case 2: {
                    value = "%s.%s(%s, %s)".formatted(parent.getQualifiedName(), converterMethodName, index, value);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected number of arguments for deserializer " + String.valueOf(deserializer.delegate().getSimpleName()) + " in " + String.valueOf(parent.getQualifiedName()));
                }
            }
        }
        return value;
    }

    private String getDeserializerStreamMethod(ProtobufPropertyType type, boolean packed) {
        return switch (type.protobufType()) {
            default -> throw new MatchException(null, null);
            case ProtobufType.STRING -> "readString";
            case ProtobufType.UNKNOWN -> throw new IllegalArgumentException("Internal bug: unknown types should not reach getDeserializerStreamMethod");
            case ProtobufType.MESSAGE, ProtobufType.GROUP -> "";
            case ProtobufType.ENUM, ProtobufType.INT32, ProtobufType.SINT32, ProtobufType.UINT32 -> {
                if (packed) {
                    yield "readInt32Packed";
                }
                yield "readInt32";
            }
            case ProtobufType.BYTES -> "readBytes";
            case ProtobufType.BOOL -> {
                if (packed) {
                    yield "readBoolPacked";
                }
                yield "readBool";
            }
            case ProtobufType.MAP -> throw new IllegalArgumentException("Internal bug: map types should not reach getDeserializerStreamMethod");
            case ProtobufType.FLOAT -> {
                if (packed) {
                    yield "readFloatPacked";
                }
                yield "readFloat";
            }
            case ProtobufType.DOUBLE -> {
                if (packed) {
                    yield "readDoublePacked";
                }
                yield "readDouble";
            }
            case ProtobufType.FIXED32, ProtobufType.SFIXED32 -> {
                if (packed) {
                    yield "readFixed32Packed";
                }
                yield "readFixed32";
            }
            case ProtobufType.INT64, ProtobufType.SINT64, ProtobufType.UINT64 -> {
                if (packed) {
                    yield "readInt64Packed";
                }
                yield "readInt64";
            }
            case ProtobufType.FIXED64, ProtobufType.SFIXED64 -> packed ? "readFixed64Packed" : "readFixed64";
        };
    }

    @Override
    protected List<String> modifiers() {
        return List.of("public", "static");
    }

    @Override
    protected String name() {
        return METHOD_NAME;
    }
}

