/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.method.deserialization.object;

import it.auties.protobuf.exception.ProtobufDeserializationException;
import it.auties.protobuf.serialization.generator.method.deserialization.ProtobufDeserializationGenerator;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.model.object.ProtobufUnknownFieldsElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyType;
import it.auties.protobuf.serialization.support.JavaWriter;
import it.auties.protobuf.stream.ProtobufInputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class ProtobufObjectDeserializationGenerator
extends ProtobufDeserializationGenerator {
    private static final String INPUT_STREAM_NAME = "protoInputStream";
    private static final String GROUP_INDEX_PARAMETER = "protoGroupIndex";
    private static final String ENUM_INDEX_PARAMETER = "protoEnumIndex";
    private static final String DEFAULT_UNKNOWN_FIELDS = "protoUnknownFields";
    private static final String FIELD_INDEX_VARIABLE = "protoFieldIndex";
    private static final String ENUM_DEFAULT_VALUE_PARAMETER = "defaultValue";
    public static final String ENUM_VALUES_FIELD = "VALUES";

    public ProtobufObjectDeserializationGenerator(ProtobufObjectElement element) {
        super(element);
    }

    @Override
    protected void doInstrumentation(JavaWriter.ClassWriter classWriter, JavaWriter.ClassWriter.MethodWriter writer) {
        if (this.objectElement.type() == ProtobufObjectElement.Type.ENUM) {
            this.createEnumDeserializer(writer);
        } else {
            this.createMessageDeserializer(writer);
        }
    }

    @Override
    public boolean shouldInstrument() {
        return true;
    }

    @Override
    protected String returnType() {
        return this.objectElement.element().getSimpleName().toString();
    }

    @Override
    protected List<String> parametersTypes() {
        if (this.objectElement.type() == ProtobufObjectElement.Type.ENUM) {
            return List.of("int", this.objectElement.element().getSimpleName().toString());
        }
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            return List.of("int", ProtobufInputStream.class.getSimpleName());
        }
        return List.of(ProtobufInputStream.class.getSimpleName());
    }

    @Override
    protected List<String> parametersNames() {
        if (this.objectElement.type() == ProtobufObjectElement.Type.ENUM) {
            return List.of(ENUM_INDEX_PARAMETER, ENUM_DEFAULT_VALUE_PARAMETER);
        }
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            return List.of(GROUP_INDEX_PARAMETER, INPUT_STREAM_NAME);
        }
        return List.of(INPUT_STREAM_NAME);
    }

    private void checkPropertyIndex(JavaWriter.BodyWriter writer, String indexField) {
        ArrayList<String> conditions = new ArrayList<String>();
        block9: for (ProtobufObjectElement.ReservedIndex reservedIndex : this.objectElement.reservedIndexes()) {
            ProtobufObjectElement.ReservedIndex reservedIndex2;
            Objects.requireNonNull(reservedIndex);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProtobufObjectElement.ReservedIndex.Range.class, ProtobufObjectElement.ReservedIndex.Value.class}, (Object)reservedIndex2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ProtobufObjectElement.ReservedIndex.Range range = (ProtobufObjectElement.ReservedIndex.Range)reservedIndex2;
                    conditions.add("(%s >= %s && %s <= %s)".formatted(indexField, range.min(), indexField, range.max()));
                    continue block9;
                }
                case 1: 
            }
            ProtobufObjectElement.ReservedIndex.Value entry = (ProtobufObjectElement.ReservedIndex.Value)reservedIndex2;
            conditions.add("%s == %s".formatted(indexField, entry.value()));
        }
        if (!conditions.isEmpty()) {
            try (JavaWriter.ClassWriter.ConditionalStatementWriter illegalIndexCheck = writer.printIfStatement(String.join((CharSequence)" || ", conditions));){
                illegalIndexCheck.println("throw %s.reservedIndex(%s);".formatted(ProtobufDeserializationException.class.getName(), indexField));
            }
        }
    }

    private void createEnumDeserializer(JavaWriter.ClassWriter.MethodWriter writer) {
        this.checkPropertyIndex(writer, ENUM_INDEX_PARAMETER);
        writer.printReturn("%s.getOrDefault(%s, %s)".formatted(ENUM_VALUES_FIELD, ENUM_INDEX_PARAMETER, ENUM_DEFAULT_VALUE_PARAMETER));
    }

    private void createMessageDeserializer(JavaWriter.ClassWriter.MethodWriter methodWriter) {
        String unknownFieldsArg;
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            methodWriter.println("%s.assertGroupOpened(%s);".formatted(INPUT_STREAM_NAME, GROUP_INDEX_PARAMETER));
        }
        for (ProtobufPropertyElement property : this.objectElement.properties()) {
            if (property.synthetic()) continue;
            String propertyType = property.type().descriptorElementType().toString();
            String propertyName = property.name();
            String propertyDefaultValue = property.type().descriptorDefaultValue();
            methodWriter.printVariableDeclaration(propertyType, propertyName, propertyDefaultValue);
        }
        this.objectElement.unknownFieldsElement().ifPresent(unknownFieldsElement -> methodWriter.printVariableDeclaration(unknownFieldsElement.type().toString(), DEFAULT_UNKNOWN_FIELDS, unknownFieldsElement.defaultValue()));
        ArrayList<String> argumentsList = new ArrayList<String>();
        try (JavaWriter.ClassWriter.ConditionalStatementWriter whileWriter = methodWriter.printWhileStatement("protoInputStream.readTag()");){
            whileWriter.printVariableDeclaration(FIELD_INDEX_VARIABLE, "protoInputStream.index()");
            this.checkPropertyIndex(whileWriter, FIELD_INDEX_VARIABLE);
            try (JavaWriter.ClassWriter.SwitchStatementWriter switchWriter = whileWriter.printSwitchStatement(FIELD_INDEX_VARIABLE);){
                for (ProtobufPropertyElement property : this.objectElement.properties()) {
                    ProtobufPropertyType protobufPropertyType;
                    if (property.synthetic()) continue;
                    Objects.requireNonNull(property.type());
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProtobufPropertyType.MapType.class, ProtobufPropertyType.CollectionType.class}, (Object)protobufPropertyType, n)) {
                        case 0: {
                            ProtobufPropertyType.MapType mapType = (ProtobufPropertyType.MapType)protobufPropertyType;
                            this.writeMapDeserializer(switchWriter, property.index(), property.name(), mapType);
                            break;
                        }
                        case 1: {
                            ProtobufPropertyType.CollectionType collectionType = (ProtobufPropertyType.CollectionType)protobufPropertyType;
                            this.writeDeserializer(switchWriter, property.name(), property.index(), collectionType.valueType(), true, property.packed(), null);
                            break;
                        }
                        default: {
                            this.writeDeserializer(switchWriter, property.name(), property.index(), property.type(), false, property.packed(), null);
                        }
                    }
                    argumentsList.add(property.name());
                }
                this.writeDefaultPropertyDeserializer(switchWriter);
            }
        }
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            methodWriter.println("%s.assertGroupClosed(%s);".formatted(INPUT_STREAM_NAME, GROUP_INDEX_PARAMETER));
        }
        this.objectElement.properties().stream().filter(ProtobufPropertyElement::required).forEach(entry -> this.checkRequiredProperty(methodWriter, (ProtobufPropertyElement)entry));
        String string = unknownFieldsArg = this.objectElement.unknownFieldsElement().isEmpty() ? "" : ", protoUnknownFields";
        if (this.objectElement.deserializer().isPresent()) {
            methodWriter.printReturn("%s.%s(%s%s)".formatted(this.objectElement.element().getQualifiedName(), this.objectElement.deserializer().get().getSimpleName(), String.join((CharSequence)", ", argumentsList), unknownFieldsArg));
        } else {
            methodWriter.printReturn("new %s(%s%s)".formatted(this.objectElement.element().getQualifiedName(), String.join((CharSequence)", ", argumentsList), unknownFieldsArg));
        }
    }

    private void writeDefaultPropertyDeserializer(JavaWriter.ClassWriter.SwitchStatementWriter switchWriter) {
        ProtobufUnknownFieldsElement unknownFieldsElement = this.objectElement.unknownFieldsElement().orElse(null);
        if (unknownFieldsElement == null) {
            switchWriter.printSwitchBranch("default", "%s.readUnknown(false)".formatted(INPUT_STREAM_NAME));
            return;
        }
        ExecutableElement setter = unknownFieldsElement.setter();
        String value = "%s.readUnknown(true)".formatted(INPUT_STREAM_NAME);
        if (setter.getModifiers().contains((Object)Modifier.STATIC)) {
            TypeElement setterWrapperClass = (TypeElement)setter.getEnclosingElement();
            switchWriter.printSwitchBranch("default", "%s.%s(%s, %s, %s)".formatted(setterWrapperClass.getQualifiedName(), setter.getSimpleName(), DEFAULT_UNKNOWN_FIELDS, FIELD_INDEX_VARIABLE, value));
        } else {
            switchWriter.printSwitchBranch("default", "%s.%s(%s, %s)".formatted(DEFAULT_UNKNOWN_FIELDS, setter.getSimpleName(), FIELD_INDEX_VARIABLE, value));
        }
    }

    private void checkRequiredProperty(JavaWriter.ClassWriter.MethodWriter writer, ProtobufPropertyElement property) {
        if (!(property.type() instanceof ProtobufPropertyType.CollectionType)) {
            writer.println("Objects.requireNonNull(%s, \"Missing required property: %s\");".formatted(property.name(), property.name()));
            return;
        }
        try (JavaWriter.ClassWriter.ConditionalStatementWriter ifWriter = writer.printIfStatement("!%s.isEmpty()".formatted(property.name()));){
            ifWriter.println("throw new NullPointerException(\"Missing required property: %s\");".formatted(property.name()));
        }
    }
}

