/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.method.serialization;

import it.auties.protobuf.model.ProtobufType;
import it.auties.protobuf.serialization.generator.method.ProtobufMethodGenerator;
import it.auties.protobuf.serialization.generator.method.serialization.ProtobufSizeGenerator;
import it.auties.protobuf.serialization.model.converter.ProtobufAttributedConverterElement;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyType;
import it.auties.protobuf.serialization.support.JavaWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;

public abstract class ProtobufSerializationGenerator
extends ProtobufMethodGenerator {
    public static final String METHOD_NAME = "encode";
    private static final String OUTPUT_OBJECT_PARAMETER = "protoOutputStream";

    public ProtobufSerializationGenerator(ProtobufObjectElement element) {
        super(element);
    }

    protected void writeRepeatedSerializer(JavaWriter.BodyWriter writer, int index, String name, String accessor, ProtobufPropertyType.CollectionType collectionType, boolean packed, boolean nullCheck, boolean cast) {
        if (packed) {
            Optional<String> writeMethod = this.getStreamMethodName(collectionType.valueType().protobufType(), true);
            writer.println("%s.%s(%s, %s);".formatted(OUTPUT_OBJECT_PARAMETER, writeMethod.orElseThrow(), index, accessor));
        } else {
            JavaWriter.BodyWriter bodyWriter = nullCheck ? writer.printIfStatement("%s != null".formatted(accessor)) : writer;
            String localVariableName = "%sEntry".formatted(name);
            try (JavaWriter.ClassWriter.ForEachWriter forEachWriter = bodyWriter.printForEachStatement(localVariableName, accessor);){
                this.writeNormalSerializer(forEachWriter, index, name, localVariableName, collectionType.valueType(), false, true, cast);
            }
            if (nullCheck) {
                bodyWriter.close();
            }
        }
    }

    protected void writeMapSerializer(JavaWriter.BodyWriter writer, int index, String name, String accessor, ProtobufPropertyType.MapType mapType, boolean nullCheck, boolean cast) {
        JavaWriter.BodyWriter bodyWriter = nullCheck ? writer.printIfStatement("%s != null".formatted(accessor)) : writer;
        String localVariableName = "%sEntry".formatted(name);
        try (JavaWriter.ClassWriter.ForEachWriter forWriter = bodyWriter.printForEachStatement(localVariableName, accessor + ".entrySet()");){
            String methodName = ProtobufSizeGenerator.getMapPropertyMethodName(name);
            forWriter.println("%s.writeMessage(%s, %s(%s%s));".formatted(OUTPUT_OBJECT_PARAMETER, index, methodName, cast ? "(java.util.Map.Entry) " : "", localVariableName));
            this.writeNormalSerializer(forWriter, 1, name + "Key", "%s.getKey()".formatted(localVariableName), mapType.keyType(), false, false, cast);
            this.writeNormalSerializer(forWriter, 2, name + "Value", "%s.getValue()".formatted(localVariableName), mapType.valueType(), true, true, cast);
        }
        if (nullCheck) {
            bodyWriter.close();
        }
    }

    protected void writeNormalSerializer(JavaWriter.BodyWriter writer, int index, String name, String value, ProtobufPropertyType type, boolean declareVariable, boolean variableNullCheck, boolean cast) {
        this.writeCustomSerializer(writer, index, name, value, type, declareVariable, variableNullCheck, cast, (nestedWriter, serializedName, serializerStatements) -> {
            for (String serializerStatement : serializerStatements) {
                nestedWriter.println(serializerStatement);
            }
        }, (nestedWriter, serializedName, serializerStatements) -> {
            for (String serializerStatement : serializerStatements) {
                nestedWriter.println(serializerStatement);
            }
        });
    }

    protected void writeCustomSerializer(JavaWriter.BodyWriter writer, int index, String name, String value, ProtobufPropertyType type, boolean declareVariable, boolean variableNullCheck, boolean cast, CustomSerializerHandler objectWriter, CustomSerializerHandler streamWriter) {
        int i;
        if (cast) {
            String castType = this.getQualifiedName(type.descriptorElementType());
            value = "((%s) %s)".formatted(castType, value);
        }
        Object propertyName = declareVariable ? writer.printVariableDeclaration(name, value) : value;
        Optional<String> writeMethod = this.getStreamMethodName(type.protobufType(), false);
        ArrayList<JavaWriter.BodyWriter> nestedWriters = new ArrayList<JavaWriter.BodyWriter>();
        nestedWriters.add(writer);
        if (variableNullCheck && !(type.accessorType() instanceof PrimitiveType)) {
            nestedWriters.add(writer.printIfStatement("%s != null".formatted(propertyName)));
        }
        List<ProtobufAttributedConverterElement.Serializer> serializers = type.serializers();
        boolean object = this.isObject(type);
        for (i = 0; i < serializers.size(); ++i) {
            boolean lastSerializer;
            ProtobufAttributedConverterElement.Serializer serializer = serializers.get(i);
            String result = this.createSerializerInvocation(serializer, (String)propertyName, index);
            boolean bl = lastSerializer = i == serializers.size() - 1;
            if (lastSerializer && writeMethod.isEmpty() || serializer.returnType().getKind() == TypeKind.VOID) {
                ArrayList<String> statements = new ArrayList<String>();
                if (type.protobufType() == ProtobufType.MESSAGE) {
                    statements.add(this.getMessageMethod(index, serializer, (String)propertyName));
                }
                statements.add("%s;".formatted(result));
                objectWriter.handle((JavaWriter.BodyWriter)nestedWriters.getLast(), (String)propertyName, statements);
                continue;
            }
            propertyName = name + i;
            ((JavaWriter.BodyWriter)nestedWriters.getLast()).printVariableDeclaration((String)propertyName, result);
            if (object && lastSerializer || serializer.returnType() instanceof PrimitiveType) continue;
            JavaWriter.ClassWriter.ConditionalStatementWriter newWriter = ((JavaWriter.BodyWriter)nestedWriters.getLast()).printIfStatement("%s != null".formatted(propertyName));
            nestedWriters.add(newWriter);
        }
        if (writeMethod.isPresent()) {
            String result = "%s.%s(%s, %s%s);".formatted(OUTPUT_OBJECT_PARAMETER, writeMethod.get(), index, cast ? "(%s) ".formatted(type.protobufType().wrapperType().getName()) : "", propertyName);
            streamWriter.handle((JavaWriter.BodyWriter)nestedWriters.getLast(), (String)propertyName, List.of(result));
        }
        for (i = nestedWriters.size() - 1; i >= 1; --i) {
            JavaWriter.BodyWriter nestedWriter = (JavaWriter.BodyWriter)nestedWriters.get(i);
            nestedWriter.close();
        }
    }

    private String getMessageMethod(int index, ProtobufAttributedConverterElement.Serializer serializer, String propertyName) {
        TypeElement parent = (TypeElement)serializer.delegate().getEnclosingElement();
        return "%s.writeMessage(%s, %s.%s(%s));".formatted(OUTPUT_OBJECT_PARAMETER, index, parent.getQualifiedName(), "sizeOf", propertyName);
    }

    private boolean isObject(ProtobufPropertyType type) {
        return type.protobufType() == ProtobufType.MESSAGE || type.protobufType() == ProtobufType.ENUM || type.protobufType() == ProtobufType.GROUP;
    }

    private String createSerializerInvocation(ProtobufAttributedConverterElement.Serializer serializer, String value, int groupIndex) {
        if (!serializer.delegate().getModifiers().contains((Object)Modifier.STATIC)) {
            return "%s.%s()".formatted(value, serializer.delegate().getSimpleName());
        }
        TypeElement parent = (TypeElement)serializer.delegate().getEnclosingElement();
        return switch (serializer.delegate().getParameters().size()) {
            case 1 -> "%s.%s(%s)".formatted(parent.getQualifiedName(), serializer.delegate().getSimpleName(), value);
            case 2 -> "%s.%s(%s, %s)".formatted(parent.getQualifiedName(), serializer.delegate().getSimpleName(), value, OUTPUT_OBJECT_PARAMETER);
            case 3 -> "%s.%s(%s, %s, %s)".formatted(parent.getQualifiedName(), serializer.delegate().getSimpleName(), groupIndex, value, OUTPUT_OBJECT_PARAMETER);
            default -> throw new IllegalArgumentException("Unexpected number of arguments for serializer " + String.valueOf(serializer.delegate().getSimpleName()) + " in " + String.valueOf(parent.getQualifiedName()));
        };
    }

    private Optional<String> getStreamMethodName(ProtobufType protobufType, boolean packed) {
        String result;
        switch (protobufType) {
            default: {
                throw new MatchException(null, null);
            }
            case STRING: {
                String string = "writeString";
                break;
            }
            case UNKNOWN: {
                throw new IllegalArgumentException("Internal bug: unknown types should not reach getSerializerStreamMethod");
            }
            case ENUM: 
            case INT32: 
            case SINT32: {
                String string = "writeInt32";
                break;
            }
            case MESSAGE: 
            case GROUP: {
                String string = null;
                break;
            }
            case BYTES: {
                String string = "writeBytes";
                break;
            }
            case BOOL: {
                String string = "writeBool";
                break;
            }
            case UINT32: {
                String string = "writeUInt32";
                break;
            }
            case MAP: {
                throw new IllegalArgumentException("Internal bug: map types should not reach getSerializerStreamMethod");
            }
            case FLOAT: {
                String string = "writeFloat";
                break;
            }
            case DOUBLE: {
                String string = "writeDouble";
                break;
            }
            case FIXED32: 
            case SFIXED32: {
                String string = "writeFixed32";
                break;
            }
            case INT64: 
            case SINT64: {
                String string = "writeInt64";
                break;
            }
            case UINT64: {
                String string = "writeUInt64";
                break;
            }
            case FIXED64: 
            case SFIXED64: {
                String string = result = "writeFixed64";
            }
        }
        if (result != null && packed) {
            return Optional.of(result + "Packed");
        }
        return Optional.ofNullable(result);
    }

    @Override
    protected String name() {
        return METHOD_NAME;
    }

    protected static interface CustomSerializerHandler {
        public void handle(JavaWriter.BodyWriter var1, String var2, List<String> var3);
    }
}

