/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.method.serialization;

import it.auties.protobuf.model.ProtobufType;
import it.auties.protobuf.serialization.generator.method.serialization.ProtobufSerializationGenerator;
import it.auties.protobuf.serialization.model.converter.ProtobufAttributedConverterElement;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyType;
import it.auties.protobuf.serialization.support.JavaWriter;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public abstract class ProtobufSizeGenerator
extends ProtobufSerializationGenerator {
    public static final String METHOD_NAME = "sizeOf";
    private static final String INPUT_OBJECT_PARAMETER = "protoInputObject";
    private static final String OUTPUT_SIZE_NAME = "protoOutputSize";

    public ProtobufSizeGenerator(ProtobufObjectElement element) {
        super(element);
    }

    public static String getMapPropertyMethodName(String name) {
        return METHOD_NAME + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void writeRepeatedSize(JavaWriter.BodyWriter writer, int index, String name, String accessor, boolean packed, ProtobufPropertyType.CollectionType collectionType, boolean cast) {
        if (packed) {
            String methodName = this.getPackedSizeCalculator(collectionType);
            writer.println("%s += ProtobufOutputStream.%s(%s, %s);".formatted(OUTPUT_SIZE_NAME, methodName, index, accessor));
            return;
        }
        try (JavaWriter.ClassWriter.ConditionalStatementWriter bodyWriter = writer.printIfStatement(accessor + " != null");){
            String repeatedEntryFieldName = name + "Entry";
            try (JavaWriter.ClassWriter.ForEachWriter forEachWriter = bodyWriter.printForEachStatement(repeatedEntryFieldName, accessor);){
                this.writeNormalSize(forEachWriter, index, repeatedEntryFieldName, collectionType.valueType(), cast ? collectionType.valueType().serializedType() : null, null);
            }
        }
    }

    private String getPackedSizeCalculator(ProtobufPropertyType.CollectionType collectionType) {
        return switch (collectionType.valueType().protobufType()) {
            case ProtobufType.FLOAT, ProtobufType.FIXED32, ProtobufType.SFIXED32 -> "getFixed32PackedSize";
            case ProtobufType.DOUBLE, ProtobufType.FIXED64, ProtobufType.SFIXED64 -> "getFixed64PackedSize";
            case ProtobufType.BOOL -> "getFixedBoolPackedSize";
            case ProtobufType.INT32, ProtobufType.SINT32, ProtobufType.UINT32, ProtobufType.INT64, ProtobufType.SINT64, ProtobufType.UINT64 -> "getVarIntPackedSize";
            default -> throw new IllegalArgumentException("Internal bug: unexpected packed type " + String.valueOf(collectionType.valueType().protobufType()));
        };
    }

    protected void writeMapSize(JavaWriter.ClassWriter classWriter, JavaWriter.BodyWriter methodWriter, int index, String name, String accessor, ProtobufPropertyType.MapType mapType, boolean cast) {
        String mapFieldName = name + "MapField";
        methodWriter.printVariableDeclaration(mapFieldName, accessor);
        String methodName = ProtobufSizeGenerator.getMapPropertyMethodName(name);
        this.deferredOperations.add(() -> this.writeMapEntryPropertySizeMethod(classWriter, name, mapType, methodName, cast));
        try (JavaWriter.ClassWriter.ConditionalStatementWriter writer = methodWriter.printIfStatement(mapFieldName + " != null");){
            String mapEntryFieldName = name + "MapEntry";
            try (JavaWriter.ClassWriter.ForEachWriter forEachWriter = writer.printForEachStatement(mapEntryFieldName, mapFieldName + ".entrySet()");){
                this.writeFieldTagSize(forEachWriter, index, ProtobufType.MAP);
                String mapEntrySizeFieldName = mapEntryFieldName + "Size";
                forEachWriter.printVariableDeclaration(mapEntrySizeFieldName, "%s(%s%s)".formatted(methodName, cast ? "(java.util.Map.Entry) " : "", mapEntryFieldName));
                forEachWriter.println("%s += ProtobufOutputStream.getVarIntSize(%s);".formatted(OUTPUT_SIZE_NAME, mapEntrySizeFieldName));
                forEachWriter.println("%s += %s;".formatted(OUTPUT_SIZE_NAME, mapEntrySizeFieldName));
            }
        }
    }

    private void writeMapEntryPropertySizeMethod(JavaWriter.ClassWriter classWriter, String name, ProtobufPropertyType.MapType mapType, String methodName, boolean cast) {
        String keyQualifiedName = this.getQualifiedName(mapType.keyType().accessorType());
        String valueQualifiedName = this.getQualifiedName(mapType.valueType().accessorType());
        String parameter = "java.util.Map.Entry<%s, %s> %s".formatted(keyQualifiedName, valueQualifiedName, INPUT_OBJECT_PARAMETER);
        try (JavaWriter.ClassWriter.MethodWriter methodWriter = classWriter.printMethodDeclaration(List.of("private", "static"), "int", methodName, parameter);){
            methodWriter.printVariableDeclaration(OUTPUT_SIZE_NAME, "0");
            this.writeNormalSize(methodWriter, 1, name + "MapKey", mapType.keyType(), cast ? mapType.keyType().serializedType() : null, "protoInputObject.getKey()");
            this.writeNormalSize(methodWriter, 2, name + "MapValue", mapType.valueType(), cast ? mapType.valueType().serializedType() : null, "protoInputObject.getValue()");
            methodWriter.printReturn(OUTPUT_SIZE_NAME);
        }
    }

    protected void writeNormalSize(JavaWriter.BodyWriter writer, ProtobufPropertyElement property) {
        String accessorCall = this.getAccessorCall(INPUT_OBJECT_PARAMETER, property.accessor());
        this.writeNormalSize(writer, property.index(), property.name(), property.type(), null, accessorCall);
    }

    protected void writeNormalSize(JavaWriter.BodyWriter writer, int index, String name, ProtobufPropertyType normalType, TypeMirror castType, String accessorCall) {
        this.writeCustomSerializer(writer, index, name, accessorCall == null ? name : accessorCall, normalType, accessorCall != null, true, castType != null, (nestedWriter, serializedName, serializedStatements) -> this.writeObjectCalculator(nestedWriter, index, name, normalType, castType, serializedName), (nestedWriter, serializedName, serializedStatements) -> this.writePrimitiveCalculator(nestedWriter, index, normalType.protobufType(), castType, serializedName));
    }

    private void writeObjectCalculator(JavaWriter.BodyWriter writer, int index, String name, ProtobufPropertyType type, TypeMirror castType, String accessor) {
        this.writeFieldTagSize(writer, index, type.protobufType());
        switch (type.protobufType()) {
            case MESSAGE: 
            case ENUM: {
                TypeMirror parameterType = type.serializers().isEmpty() ? type.descriptorElementType() : type.serializers().getLast().parameterType();
                String specName = ProtobufSizeGenerator.getSpecFromObject(parameterType);
                String serializedObjectFieldName = writer.printVariableDeclaration(name + "SerializedSize", "%s.%s(%s)".formatted(specName, this.name(), accessor));
                if (!this.isEnum(parameterType)) {
                    writer.println("%s += ProtobufOutputStream.getVarIntSize(%s);".formatted(OUTPUT_SIZE_NAME, serializedObjectFieldName));
                }
                writer.println("%s += %s;".formatted(OUTPUT_SIZE_NAME, serializedObjectFieldName));
                break;
            }
            case GROUP: {
                ProtobufAttributedConverterElement.Serializer lastSerializer = type.rawGroupSerializer().orElse(null);
                if (lastSerializer != null) {
                    String rawGroupSpecType = ProtobufSizeGenerator.getSpecFromObject(lastSerializer.parameterType());
                    writer.println("%s += %s.%s(%s, %s%s);".formatted(OUTPUT_SIZE_NAME, rawGroupSpecType, this.name(), index, castType != null ? "(java.util.Map) " : "", accessor));
                    break;
                }
                TypeMirror groupType = type.serializers().isEmpty() ? type.descriptorElementType() : type.serializers().getLast().parameterType();
                String groupSpecType = ProtobufSizeGenerator.getSpecFromObject(groupType);
                String serializedObjectFieldName = writer.printVariableDeclaration(name + "SerializedSize", "%s.%s(%s, %s%s)".formatted(groupSpecType, this.name(), index, castType != null ? "(%s) ".formatted(castType) : "", accessor));
                writer.println("%s += %s;".formatted(OUTPUT_SIZE_NAME, serializedObjectFieldName));
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal bug: %s property types should not reach writeObjectCalculator".formatted(type.protobufType().name()));
            }
        }
    }

    private void writePrimitiveCalculator(JavaWriter.BodyWriter writer, int index, ProtobufType protobufType, TypeMirror castType, String accessor) {
        this.writeFieldTagSize(writer, index, protobufType);
        String protobufSize = switch (protobufType) {
            case ProtobufType.BOOL -> "1";
            case ProtobufType.STRING -> "ProtobufOutputStream.getStringSize(%s%s)".formatted(castType != null ? "(%s) ".formatted(castType) : "", accessor);
            case ProtobufType.BYTES -> "ProtobufOutputStream.getBytesSize(%s%s)".formatted(castType != null ? "(%s) ".formatted(castType) : "", accessor);
            case ProtobufType.INT32, ProtobufType.SINT32, ProtobufType.UINT32, ProtobufType.INT64, ProtobufType.SINT64, ProtobufType.UINT64, ProtobufType.ENUM -> "ProtobufOutputStream.getVarIntSize(%s%s)".formatted(castType != null ? "(%s) ".formatted(castType) : "", accessor);
            case ProtobufType.FLOAT, ProtobufType.FIXED32, ProtobufType.SFIXED32 -> "4";
            case ProtobufType.DOUBLE, ProtobufType.FIXED64, ProtobufType.SFIXED64 -> "8";
            default -> throw new IllegalArgumentException("Internal bug: %s property types should not reach writePrimitiveCalculator".formatted(protobufType.name()));
        };
        writer.println("%s += %s;".formatted(OUTPUT_SIZE_NAME, protobufSize));
    }

    private void writeFieldTagSize(JavaWriter.BodyWriter writer, int index, ProtobufType protobufType) {
        if (protobufType == ProtobufType.GROUP) {
            return;
        }
        int wireType = switch (protobufType) {
            default -> throw new MatchException(null, null);
            case ProtobufType.GROUP -> throw new IllegalArgumentException("Internal bug: group property types should not reach writeFieldTagSize");
            case ProtobufType.MESSAGE, ProtobufType.ENUM, ProtobufType.STRING, ProtobufType.BYTES, ProtobufType.MAP -> 2;
            case ProtobufType.FLOAT, ProtobufType.FIXED32, ProtobufType.SFIXED32 -> 5;
            case ProtobufType.DOUBLE, ProtobufType.FIXED64, ProtobufType.SFIXED64 -> 1;
            case ProtobufType.BOOL, ProtobufType.INT32, ProtobufType.SINT32, ProtobufType.UINT32, ProtobufType.INT64, ProtobufType.SINT64, ProtobufType.UINT64 -> 0;
            case ProtobufType.UNKNOWN -> throw new IllegalArgumentException("Internal bug: unknown property types should not reach writeFieldTagSize");
        };
        writer.println("%s += ProtobufOutputStream.getFieldSize(%s, %s);".formatted(OUTPUT_SIZE_NAME, index, wireType));
    }

    @Override
    public boolean shouldInstrument() {
        return true;
    }

    @Override
    protected List<String> modifiers() {
        return List.of("public", "static");
    }

    @Override
    protected String returnType() {
        return "int";
    }

    @Override
    public String name() {
        return METHOD_NAME;
    }
}

