/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.method.serialization.object;

import it.auties.protobuf.serialization.generator.method.serialization.ProtobufSerializationGenerator;
import it.auties.protobuf.serialization.model.object.ProtobufEnumMetadata;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyType;
import it.auties.protobuf.serialization.support.JavaWriter;
import it.auties.protobuf.stream.ProtobufOutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;

public class ProtobufObjectSerializationGenerator
extends ProtobufSerializationGenerator {
    private static final String INPUT_OBJECT_PARAMETER = "protoInputObject";
    private static final String OUTPUT_OBJECT_PARAMETER = "protoOutputStream";
    private static final String GROUP_INDEX_PARAMETER = "protoGroupIndex";

    public ProtobufObjectSerializationGenerator(ProtobufObjectElement element) {
        super(element);
    }

    @Override
    protected void doInstrumentation(JavaWriter.ClassWriter classWriter, JavaWriter.ClassWriter.MethodWriter writer) {
        if (this.objectElement.type() == ProtobufObjectElement.Type.ENUM) {
            this.createEnumSerializer(writer);
        } else {
            this.createMessageSerializer(writer);
        }
    }

    @Override
    public boolean shouldInstrument() {
        return true;
    }

    @Override
    protected List<String> modifiers() {
        return List.of("public", "static");
    }

    @Override
    protected String returnType() {
        return this.objectElement.type() == ProtobufObjectElement.Type.ENUM ? "Integer" : "void";
    }

    @Override
    protected List<String> parametersTypes() {
        String objectType = this.objectElement.element().getSimpleName().toString();
        if (this.objectElement.type() == ProtobufObjectElement.Type.ENUM) {
            return List.of(objectType);
        }
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            return List.of("int", objectType, ProtobufOutputStream.class.getSimpleName());
        }
        return List.of(objectType, ProtobufOutputStream.class.getSimpleName());
    }

    @Override
    protected List<String> parametersNames() {
        if (this.objectElement.type() == ProtobufObjectElement.Type.ENUM) {
            return List.of(INPUT_OBJECT_PARAMETER);
        }
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            return List.of(GROUP_INDEX_PARAMETER, INPUT_OBJECT_PARAMETER, OUTPUT_OBJECT_PARAMETER);
        }
        return List.of(INPUT_OBJECT_PARAMETER, OUTPUT_OBJECT_PARAMETER);
    }

    private void createEnumSerializer(JavaWriter.ClassWriter.MethodWriter writer) {
        try (JavaWriter.ClassWriter.ConditionalStatementWriter ifWriter = writer.printIfStatement("%s == null".formatted(INPUT_OBJECT_PARAMETER));){
            ifWriter.printReturn("null");
        }
        ProtobufEnumMetadata metadata = this.objectElement.enumMetadata().orElseThrow(() -> new NoSuchElementException("Missing metadata from enum"));
        if (metadata.isJavaEnum()) {
            writer.printReturn("%s.ordinal()".formatted(INPUT_OBJECT_PARAMETER));
        } else {
            Name fieldName = metadata.field().getSimpleName();
            writer.printReturn("%s.%s".formatted(INPUT_OBJECT_PARAMETER, fieldName));
        }
    }

    private void createMessageSerializer(JavaWriter.ClassWriter.MethodWriter writer) {
        try (JavaWriter.ClassWriter.ConditionalStatementWriter ifWriter = writer.printIfStatement("%s == null".formatted(INPUT_OBJECT_PARAMETER));){
            ifWriter.printReturn();
        }
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            writer.println("%s.writeGroupStart(%s);".formatted(OUTPUT_OBJECT_PARAMETER, GROUP_INDEX_PARAMETER));
        }
        this.createRequiredPropertiesNullCheck(writer);
        block9: for (ProtobufPropertyElement property : this.objectElement.properties()) {
            ProtobufPropertyType protobufPropertyType;
            Objects.requireNonNull(property.type());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProtobufPropertyType.CollectionType.class, ProtobufPropertyType.MapType.class}, (Object)protobufPropertyType, n)) {
                case 0: {
                    ProtobufPropertyType.CollectionType collectionType = (ProtobufPropertyType.CollectionType)protobufPropertyType;
                    this.writeRepeatedSerializer(writer, property.index(), property.name(), this.getAccessorCall(property.accessor()), collectionType, property.packed(), true, false);
                    continue block9;
                }
                case 1: {
                    ProtobufPropertyType.MapType mapType = (ProtobufPropertyType.MapType)protobufPropertyType;
                    this.writeMapSerializer(writer, property.index(), property.name(), this.getAccessorCall(property.accessor()), mapType, true, false);
                    continue block9;
                }
            }
            this.writeNormalSerializer(writer, property.index(), property.name(), this.getAccessorCall(property.accessor()), property.type(), true, true, false);
        }
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            writer.println("%s.writeGroupEnd(%s);".formatted(OUTPUT_OBJECT_PARAMETER, GROUP_INDEX_PARAMETER));
        }
    }

    private void createRequiredPropertiesNullCheck(JavaWriter.ClassWriter.MethodWriter writer) {
        this.objectElement.properties().stream().filter(ProtobufPropertyElement::required).forEach(entry -> writer.println("Objects.requireNonNull(%s, \"Missing required property: %s\");".formatted(this.getAccessorCall(entry.accessor()), entry.name())));
    }

    private String getAccessorCall(Element accessor) {
        return this.getAccessorCall(INPUT_OBJECT_PARAMETER, accessor);
    }
}

