/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.method.serialization.object;

import it.auties.protobuf.serialization.generator.method.ProtobufMethodGenerator;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.support.JavaWriter;
import java.util.List;

public class ProtobufObjectSerializationOverloadGenerator
extends ProtobufMethodGenerator {
    private static final String INPUT_OBJECT_PARAMETER = "protoInputObject";
    private static final String GROUP_INDEX_PARAMETER = "protoGroupIndex";

    public ProtobufObjectSerializationOverloadGenerator(ProtobufObjectElement element) {
        super(element);
    }

    @Override
    protected void doInstrumentation(JavaWriter.ClassWriter classWriter, JavaWriter.ClassWriter.MethodWriter writer) {
        try (JavaWriter.ClassWriter.ConditionalStatementWriter ifWriter = writer.printIfStatement("%s == null".formatted(INPUT_OBJECT_PARAMETER));){
            ifWriter.printReturn("null");
        }
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            writer.printVariableDeclaration("stream", "ProtobufOutputStream.toBytes(%s(%s, %s))".formatted("sizeOf", GROUP_INDEX_PARAMETER, INPUT_OBJECT_PARAMETER));
            writer.println("encode(%s, %s, stream);".formatted(GROUP_INDEX_PARAMETER, INPUT_OBJECT_PARAMETER));
        } else {
            writer.printVariableDeclaration("stream", "ProtobufOutputStream.toBytes(%s(%s))".formatted("sizeOf", INPUT_OBJECT_PARAMETER));
            writer.println("encode(%s, stream);".formatted(INPUT_OBJECT_PARAMETER));
        }
        writer.printReturn("stream.toOutput()");
    }

    @Override
    public boolean shouldInstrument() {
        return this.objectElement.type() != ProtobufObjectElement.Type.ENUM;
    }

    @Override
    protected List<String> modifiers() {
        return List.of("public", "static");
    }

    @Override
    protected String returnType() {
        return this.objectElement.type() == ProtobufObjectElement.Type.ENUM ? "Integer" : "byte[]";
    }

    @Override
    public String name() {
        return "encode";
    }

    @Override
    protected List<String> parametersTypes() {
        String objectType = this.objectElement.element().getSimpleName().toString();
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            return List.of("int", objectType);
        }
        return List.of(objectType);
    }

    @Override
    protected List<String> parametersNames() {
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            return List.of(GROUP_INDEX_PARAMETER, INPUT_OBJECT_PARAMETER);
        }
        return List.of(INPUT_OBJECT_PARAMETER);
    }
}

