/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.generator.method.serialization.object;

import it.auties.protobuf.serialization.generator.method.serialization.ProtobufSizeGenerator;
import it.auties.protobuf.serialization.model.object.ProtobufEnumMetadata;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyType;
import it.auties.protobuf.serialization.support.JavaWriter;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;

public class ProtobufObjectSizeGenerator
extends ProtobufSizeGenerator {
    private static final String INPUT_OBJECT_PARAMETER = "protoInputObject";
    private static final String OUTPUT_SIZE_NAME = "protoOutputSize";
    private static final String GROUP_INDEX_PARAMETER = "protoGroupIndex";

    public ProtobufObjectSizeGenerator(ProtobufObjectElement element) {
        super(element);
    }

    @Override
    protected void doInstrumentation(JavaWriter.ClassWriter classWriter, JavaWriter.ClassWriter.MethodWriter methodWriter) {
        try (JavaWriter.ClassWriter.ConditionalStatementWriter ifWriter = methodWriter.printIfStatement("%s == null".formatted(INPUT_OBJECT_PARAMETER));){
            ifWriter.printReturn("0");
        }
        if (Objects.requireNonNull(this.objectElement).type() == ProtobufObjectElement.Type.ENUM) {
            this.writeEnumCalculator(methodWriter);
        } else {
            this.writeMessageCalculator(classWriter, methodWriter);
        }
    }

    private void writeEnumCalculator(JavaWriter.ClassWriter.MethodWriter writer) {
        ProtobufEnumMetadata metadata = Objects.requireNonNull(this.objectElement).enumMetadata().orElseThrow(() -> new NoSuchElementException("Missing metadata from enum"));
        if (metadata.isJavaEnum()) {
            writer.printReturn("ProtobufOutputStream.getVarIntSize(%s.ordinal())".formatted(INPUT_OBJECT_PARAMETER));
        } else {
            Name fieldName = metadata.field().getSimpleName();
            writer.printReturn("ProtobufOutputStream.getVarIntSize(%s.%s)".formatted(INPUT_OBJECT_PARAMETER, fieldName));
        }
    }

    private void writeMessageCalculator(JavaWriter.ClassWriter classWriter, JavaWriter.ClassWriter.MethodWriter methodWriter) {
        methodWriter.printVariableDeclaration(OUTPUT_SIZE_NAME, "0");
        if (Objects.requireNonNull(this.objectElement).type() == ProtobufObjectElement.Type.GROUP) {
            methodWriter.println("%s += ProtobufOutputStream.getFieldSize(%s, %s);".formatted(OUTPUT_SIZE_NAME, GROUP_INDEX_PARAMETER, "ProtobufWireType.WIRE_TYPE_START_OBJECT"));
            methodWriter.println("%s += ProtobufOutputStream.getFieldSize(%s, %s);".formatted(OUTPUT_SIZE_NAME, GROUP_INDEX_PARAMETER, "ProtobufWireType.WIRE_TYPE_END_OBJECT"));
        }
        block5: for (ProtobufPropertyElement property : this.objectElement.properties()) {
            ProtobufPropertyType protobufPropertyType;
            Objects.requireNonNull(property.type());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProtobufPropertyType.CollectionType.class, ProtobufPropertyType.MapType.class, ProtobufPropertyType.NormalType.class}, (Object)protobufPropertyType, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ProtobufPropertyType.CollectionType collectionType = (ProtobufPropertyType.CollectionType)protobufPropertyType;
                    this.writeRepeatedSize(methodWriter, property.index(), property.name(), this.getAccessorCall(property.accessor()), property.packed(), collectionType, false);
                    continue block5;
                }
                case 1: {
                    ProtobufPropertyType.MapType mapType = (ProtobufPropertyType.MapType)protobufPropertyType;
                    this.writeMapSize(classWriter, methodWriter, property.index(), property.name(), this.getAccessorCall(property.accessor()), mapType, false);
                    continue block5;
                }
                case 2: 
            }
            ProtobufPropertyType.NormalType ignored = (ProtobufPropertyType.NormalType)protobufPropertyType;
            this.writeNormalSize(methodWriter, property);
        }
        methodWriter.printReturn(OUTPUT_SIZE_NAME);
    }

    @Override
    protected List<String> parametersTypes() {
        String objectType = this.objectElement.element().getSimpleName().toString();
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            return List.of("int", objectType);
        }
        return List.of(objectType);
    }

    @Override
    protected List<String> parametersNames() {
        if (this.objectElement.type() == ProtobufObjectElement.Type.GROUP) {
            return List.of(GROUP_INDEX_PARAMETER, INPUT_OBJECT_PARAMETER);
        }
        return List.of(INPUT_OBJECT_PARAMETER);
    }

    private String getAccessorCall(Element accessor) {
        return this.getAccessorCall(INPUT_OBJECT_PARAMETER, accessor);
    }
}

