/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.model.object;

import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.annotation.ProtobufSerializer;
import it.auties.protobuf.serialization.model.object.ProtobufBuilderElement;
import it.auties.protobuf.serialization.model.object.ProtobufEnumMetadata;
import it.auties.protobuf.serialization.model.object.ProtobufUnknownFieldsElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyElement;
import it.auties.protobuf.serialization.model.property.ProtobufPropertyType;
import it.auties.protobuf.serialization.support.Reserved;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class ProtobufObjectElement {
    private final Type type;
    private final TypeElement typeElement;
    private final Map<Integer, ProtobufPropertyElement> properties;
    private final List<ProtobufBuilderElement> builders;
    private final Map<Integer, String> constants;
    private final ProtobufEnumMetadata enumMetadata;
    private final ExecutableElement serializer;
    private final ExecutableElement deserializer;
    private final Set<String> reservedNames;
    private final Set<? extends ReservedIndex> reservedIndexes;
    private ProtobufUnknownFieldsElement unknownFieldsElement;

    public static ProtobufObjectElement ofEnum(TypeElement typeElement, ProtobufEnumMetadata enumMetadata) {
        return new ProtobufObjectElement(Type.ENUM, typeElement, enumMetadata, null, null);
    }

    public static ProtobufObjectElement ofMessage(TypeElement typeElement, ExecutableElement deserializer) {
        return new ProtobufObjectElement(Type.MESSAGE, typeElement, null, null, deserializer);
    }

    public static ProtobufObjectElement ofGroup(TypeElement typeElement, ExecutableElement deserializer) {
        return new ProtobufObjectElement(Type.GROUP, typeElement, null, null, deserializer);
    }

    public static ProtobufObjectElement ofSynthetic(TypeElement typeElement, ExecutableElement serializer, ExecutableElement deserializer) {
        return new ProtobufObjectElement(Type.SYNTHETIC, typeElement, null, serializer, deserializer);
    }

    private ProtobufObjectElement(Type type, TypeElement typeElement, ProtobufEnumMetadata enumMetadata, ExecutableElement serializer, ExecutableElement deserializer) {
        this.type = type;
        this.typeElement = typeElement;
        this.enumMetadata = enumMetadata;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.reservedNames = Reserved.getNames(this);
        this.reservedIndexes = Reserved.getIndexes(this);
        this.builders = new ArrayList<ProtobufBuilderElement>();
        this.properties = new LinkedHashMap<Integer, ProtobufPropertyElement>();
        this.constants = new LinkedHashMap<Integer, String>();
    }

    public Type type() {
        return this.type;
    }

    public TypeElement element() {
        return this.typeElement;
    }

    public Optional<ProtobufEnumMetadata> enumMetadata() {
        return Optional.of(this.enumMetadata);
    }

    public List<ProtobufPropertyElement> properties() {
        return List.copyOf(this.properties.values());
    }

    public Map<Integer, String> constants() {
        return Collections.unmodifiableMap(this.constants);
    }

    public Optional<String> addConstant(int fieldIndex, String fieldName) {
        return Optional.ofNullable(this.constants.put(fieldIndex, fieldName));
    }

    public Optional<ProtobufPropertyElement> addProperty(Element element, Element accessor, ProtobufPropertyType type, ProtobufProperty property) {
        String fieldName = element.getSimpleName().toString();
        ProtobufPropertyElement result = new ProtobufPropertyElement(fieldName, accessor, type, property, element instanceof ExecutableElement);
        return Optional.ofNullable(this.properties.put(property.index(), result));
    }

    public Optional<ProtobufPropertyElement> addProperty(ProtobufPropertyType type, ProtobufSerializer.GroupProperty property) {
        ProtobufPropertyElement result = new ProtobufPropertyElement(type, property);
        return Optional.ofNullable(this.properties.put(property.index(), result));
    }

    public void addBuilder(String className, List<? extends VariableElement> parameters, ExecutableElement executableElement) {
        ProtobufBuilderElement builderElement = new ProtobufBuilderElement(className, parameters, executableElement);
        this.builders.add(builderElement);
    }

    public List<ProtobufBuilderElement> builders() {
        return Collections.unmodifiableList(this.builders);
    }

    public Optional<ExecutableElement> serializer() {
        return Optional.ofNullable(this.serializer);
    }

    public Optional<ExecutableElement> deserializer() {
        return Optional.ofNullable(this.deserializer);
    }

    public Optional<ProtobufUnknownFieldsElement> unknownFieldsElement() {
        return Optional.ofNullable(this.unknownFieldsElement);
    }

    public void setUnknownFieldsElement(ProtobufUnknownFieldsElement unknownFieldsElement) {
        this.unknownFieldsElement = unknownFieldsElement;
    }

    public Set<String> reservedNames() {
        return this.reservedNames;
    }

    public boolean isNameDisallowed(String name) {
        return this.reservedNames.contains(name);
    }

    public Set<? extends ReservedIndex> reservedIndexes() {
        return this.reservedIndexes;
    }

    public boolean isIndexDisallowed(int index) {
        return !this.reservedIndexes.stream().allMatch(entry -> entry.isAllowed(index));
    }

    public static enum Type {
        MESSAGE,
        ENUM,
        GROUP,
        SYNTHETIC;

    }

    public static sealed interface ReservedIndex {
        public boolean isAllowed(int var1);

        public record Value(int value) implements ReservedIndex
        {
            @Override
            public boolean isAllowed(int index) {
                return index != this.value;
            }
        }

        public record Range(int min, int max) implements ReservedIndex
        {
            @Override
            public boolean isAllowed(int index) {
                return index < this.min || index > this.max;
            }
        }
    }
}

