/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.model.property;

import it.auties.protobuf.annotation.ProtobufGroup;
import it.auties.protobuf.model.ProtobufType;
import it.auties.protobuf.serialization.model.converter.ProtobufAttributedConverterElement;
import it.auties.protobuf.serialization.model.converter.ProtobufConverterElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public sealed interface ProtobufPropertyType {
    public ProtobufType protobufType();

    public List<ProtobufConverterElement> converters();

    public TypeMirror descriptorElementType();

    public TypeMirror accessorType();

    public String descriptorDefaultValue();

    public List<TypeElement> mixins();

    public void addConverter(ProtobufConverterElement var1);

    public void clearConverters();

    default public List<ProtobufAttributedConverterElement.Serializer> serializers() {
        return this.converters().stream().filter(entry -> entry instanceof ProtobufAttributedConverterElement.Serializer).map(entry -> (ProtobufAttributedConverterElement.Serializer)entry).toList();
    }

    default public List<ProtobufAttributedConverterElement.Deserializer> deserializers() {
        return this.converters().stream().filter(entry -> entry instanceof ProtobufAttributedConverterElement.Deserializer).map(entry -> (ProtobufAttributedConverterElement.Deserializer)entry).toList();
    }

    default public TypeMirror serializedType() {
        List<ProtobufAttributedConverterElement.Serializer> serializers = this.serializers();
        if (serializers.isEmpty()) {
            return this.descriptorElementType();
        }
        return serializers.getLast().returnType();
    }

    default public TypeMirror deserializedType() {
        List<ProtobufAttributedConverterElement.Deserializer> deserializers = this.deserializers();
        if (deserializers.isEmpty()) {
            return this.descriptorElementType();
        }
        return deserializers.getLast().returnType();
    }

    default public Optional<ProtobufAttributedConverterElement.Serializer> rawGroupSerializer() {
        TypeElement typeElement;
        DeclaredType declaredType;
        ProtobufAttributedConverterElement.Serializer serializer;
        AnnotatedConstruct annotatedConstruct;
        boolean concreteGroup = false;
        List<ProtobufAttributedConverterElement.Serializer> serializers = this.serializers();
        Iterator<ProtobufAttributedConverterElement.Serializer> iterator = serializers.iterator();
        while (iterator.hasNext() && !(concreteGroup = !((annotatedConstruct = (serializer = iterator.next()).parameterType()) instanceof DeclaredType) || !((annotatedConstruct = (declaredType = (DeclaredType)annotatedConstruct).asElement()) instanceof TypeElement) || (typeElement = (TypeElement)annotatedConstruct).getAnnotation(ProtobufGroup.class) != null)) {
        }
        if (concreteGroup || serializers.size() < 2) {
            return Optional.empty();
        }
        return Optional.ofNullable(serializers.get(serializers.size() - 2));
    }

    public record CollectionType(TypeMirror descriptorElementType, NormalType valueType, String descriptorDefaultValue, List<TypeElement> mixins) implements ProtobufPropertyType
    {
        private final List<TypeElement> mixins;

        @Override
        public TypeMirror accessorType() {
            return this.descriptorElementType;
        }

        @Override
        public ProtobufType protobufType() {
            return this.valueType.protobufType();
        }

        @Override
        public List<ProtobufConverterElement> converters() {
            return List.of();
        }

        @Override
        public List<TypeElement> mixins() {
            return Collections.unmodifiableList(this.mixins);
        }

        @Override
        public void addConverter(ProtobufConverterElement element) {
        }

        @Override
        public void clearConverters() {
        }
    }

    public static final class MapType
    implements ProtobufPropertyType {
        private final TypeMirror descriptorElementType;
        private final NormalType keyType;
        private final NormalType valueType;
        private final String descriptorDefaultValue;
        private final List<TypeElement> mixins;
        private final List<ProtobufConverterElement> converters;

        public MapType(TypeMirror descriptorElementType, NormalType keyType, NormalType valueType, String descriptorDefaultValue, List<TypeElement> mixins) {
            this.descriptorElementType = descriptorElementType;
            this.keyType = keyType;
            this.valueType = valueType;
            this.descriptorDefaultValue = descriptorDefaultValue;
            this.mixins = mixins;
            this.converters = new ArrayList<ProtobufConverterElement>();
        }

        @Override
        public TypeMirror accessorType() {
            return this.descriptorElementType;
        }

        @Override
        public List<ProtobufConverterElement> converters() {
            return Collections.unmodifiableList(this.converters);
        }

        @Override
        public List<TypeElement> mixins() {
            return Collections.unmodifiableList(this.mixins);
        }

        @Override
        public void addConverter(ProtobufConverterElement element) {
            this.converters.add(element);
        }

        @Override
        public void clearConverters() {
            this.converters.clear();
        }

        @Override
        public ProtobufType protobufType() {
            return ProtobufType.MAP;
        }

        @Override
        public TypeMirror descriptorElementType() {
            return this.descriptorElementType;
        }

        public NormalType keyType() {
            return this.keyType;
        }

        public NormalType valueType() {
            return this.valueType;
        }

        @Override
        public String descriptorDefaultValue() {
            return this.descriptorDefaultValue;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            MapType that = (MapType)obj;
            return Objects.equals(this.descriptorElementType, that.descriptorElementType) && Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType) && Objects.equals(this.descriptorDefaultValue, that.descriptorDefaultValue) && Objects.equals(this.mixins, that.mixins) && Objects.equals(this.converters, that.converters);
        }

        public int hashCode() {
            return Objects.hash(this.descriptorElementType, this.keyType, this.valueType, this.descriptorDefaultValue, this.mixins, this.converters);
        }

        public String toString() {
            return "MapType[descriptorElementType=" + String.valueOf(this.descriptorElementType) + ", keyType=" + String.valueOf(this.keyType) + ", valueType=" + String.valueOf(this.valueType) + ", descriptorDefaultValue=" + this.descriptorDefaultValue + ", mixins=" + String.valueOf(this.mixins) + ", converters=" + String.valueOf(this.converters) + "]";
        }
    }

    public static final class NormalType
    implements ProtobufPropertyType {
        private final ProtobufType protobufType;
        private final TypeMirror descriptorElementType;
        private final TypeMirror accessorType;
        private final List<ProtobufConverterElement> converters;
        private final String descriptorDefaultValue;
        private final List<TypeElement> mixins;
        private String deserializedDefaultValue;

        public NormalType(ProtobufType protobufType, TypeMirror descriptorElementType, TypeMirror accessorType, String descriptorDefaultValue, List<TypeElement> mixins) {
            this.protobufType = protobufType;
            this.descriptorElementType = descriptorElementType;
            this.accessorType = accessorType;
            this.converters = new ArrayList<ProtobufConverterElement>();
            this.descriptorDefaultValue = descriptorDefaultValue;
            this.mixins = mixins;
        }

        @Override
        public List<ProtobufConverterElement> converters() {
            return Collections.unmodifiableList(this.converters);
        }

        @Override
        public void addConverter(ProtobufConverterElement element) {
            this.converters.add(element);
        }

        @Override
        public void clearConverters() {
            this.converters.clear();
        }

        @Override
        public ProtobufType protobufType() {
            return this.protobufType;
        }

        @Override
        public TypeMirror descriptorElementType() {
            return this.descriptorElementType;
        }

        @Override
        public TypeMirror accessorType() {
            return this.accessorType;
        }

        @Override
        public String descriptorDefaultValue() {
            return this.descriptorDefaultValue;
        }

        public Optional<String> deserializedDefaultValue() {
            return Optional.ofNullable(this.deserializedDefaultValue);
        }

        public void setDeserializedDefaultValue(String deserializedDefaultValue) {
            this.deserializedDefaultValue = deserializedDefaultValue;
        }

        @Override
        public List<TypeElement> mixins() {
            return Collections.unmodifiableList(this.mixins);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            NormalType that = (NormalType)obj;
            return Objects.equals(this.protobufType, that.protobufType) && Objects.equals(this.descriptorElementType, that.descriptorElementType) && Objects.equals(this.accessorType, that.accessorType) && Objects.equals(this.converters, that.converters) && Objects.equals(this.descriptorDefaultValue, that.descriptorDefaultValue);
        }

        public int hashCode() {
            return Objects.hash(this.protobufType, this.descriptorElementType, this.accessorType, this.converters, this.descriptorDefaultValue);
        }

        public String toString() {
            return "NormalType[protobufType=" + String.valueOf(this.protobufType) + ", descriptorElementType=" + String.valueOf(this.descriptorElementType) + ", accessorType=" + String.valueOf(this.accessorType) + ", defaultValue=" + this.descriptorDefaultValue + "]";
        }
    }
}

