/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.support;

import it.auties.protobuf.annotation.ProtobufBuilder;
import it.auties.protobuf.annotation.ProtobufDefaultValue;
import it.auties.protobuf.annotation.ProtobufDeserializer;
import it.auties.protobuf.annotation.ProtobufEnum;
import it.auties.protobuf.annotation.ProtobufEnumIndex;
import it.auties.protobuf.annotation.ProtobufGetter;
import it.auties.protobuf.annotation.ProtobufGroup;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufMixin;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.annotation.ProtobufReservedRange;
import it.auties.protobuf.annotation.ProtobufSerializer;
import it.auties.protobuf.annotation.ProtobufUnknownFields;
import it.auties.protobuf.model.ProtobufType;
import it.auties.protobuf.serialization.support.Messages;
import it.auties.protobuf.serialization.support.Types;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class Checks {
    private final Types types;
    private final Messages messages;

    public Checks(Types types, Messages messages) {
        this.types = types;
        this.messages = messages;
    }

    public void runChecks(RoundEnvironment roundEnv) {
        this.checkMessages(roundEnv);
        this.checkGroups(roundEnv);
        this.checkMessageProperties(roundEnv);
        this.checkEnums(roundEnv);
        this.checkEnumProperties(roundEnv);
        this.checkAnyGetters(roundEnv);
        this.checkUnknownFields(roundEnv);
        this.checkSerializers(roundEnv);
        this.checkDeserializers(roundEnv);
        this.checkBuilders(roundEnv);
        this.checkDefaultValues(roundEnv);
        this.checkReservedRanges(roundEnv);
    }

    private void checkReservedRanges(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(ProtobufMessage.class)) {
            ProtobufMessage message = element.getAnnotation(ProtobufMessage.class);
            for (ProtobufReservedRange range : message.reservedRanges()) {
                this.checkRange(element, range);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ProtobufEnum.class)) {
            ProtobufEnum enumeration = element.getAnnotation(ProtobufEnum.class);
            for (ProtobufReservedRange range : enumeration.reservedRanges()) {
                this.checkRange(element, range);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ProtobufGroup.class)) {
            ProtobufGroup group = element.getAnnotation(ProtobufGroup.class);
            for (ProtobufReservedRange range : group.reservedRanges()) {
                this.checkRange(element, range);
            }
        }
    }

    private void checkRange(Element element, ProtobufReservedRange range) {
        if (range.min() < 0) {
            this.messages.printError("Illegal annotation: min must be positive", element);
        }
        if (range.max() < 0) {
            this.messages.printError("Illegal annotation: max must be positive", element);
        }
        if (range.min() > range.max()) {
            this.messages.printError("Illegal annotation: max must be equal or bigger than min", element);
        }
    }

    private void checkUnknownFields(RoundEnvironment roundEnv) {
        Set<? extends Element> properties = roundEnv.getElementsAnnotatedWith(ProtobufUnknownFields.class);
        for (Element element : properties) {
            this.checkUnknownField(element);
        }
    }

    private void checkUnknownField(Element property) {
        TypeElement enclosingElement = this.getEnclosingTypeElement(property);
        if (enclosingElement.getAnnotation(ProtobufMessage.class) == null) {
            this.messages.printError("Illegal enclosing class: a method or field annotated with @ProtobufUnknownFields should be enclosed by a class/record annotated with @ProtobufMessage", property);
            return;
        }
        ProtobufUnknownFields annotation = property.getAnnotation(ProtobufUnknownFields.class);
        List<TypeElement> mixins = this.types.getMixins(annotation);
        this.checkMixins(property, mixins);
    }

    private void checkDefaultValues(RoundEnvironment roundEnv) {
        Set<? extends Element> defaultValues = roundEnv.getElementsAnnotatedWith(ProtobufDefaultValue.class);
        for (Element element : defaultValues) {
            this.checkDefaultValue(element);
        }
    }

    private void checkDefaultValue(Element entry) {
        TypeElement enclosingElement = this.getEnclosingTypeElement(entry);
        if (enclosingElement.getAnnotation(ProtobufMessage.class) == null && enclosingElement.getAnnotation(ProtobufEnum.class) == null && enclosingElement.getAnnotation(ProtobufMixin.class) == null) {
            this.messages.printError("Illegal enclosing class: a method or enum constant annotated with @ProtobufDefaultValue should be enclosed by a class/record annotated with @ProtobufMessage, @ProtobufEnum or @ProtobufMixin", entry);
            return;
        }
        if (entry.getKind() != ElementKind.METHOD && (entry.getKind() != ElementKind.ENUM_CONSTANT || this.getEnclosingTypeElement(entry).getAnnotation(ProtobufEnum.class) == null)) {
            this.messages.printError("Invalid delegate: only methods, and enum constants in a ProtobufEnum, can be annotated with @ProtobufDefaultValue", entry);
            return;
        }
        if (entry.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.messages.printError("Weak visibility: a method annotated with @ProtobufDefaultValue must have at least package-private visibility", entry);
            return;
        }
        if (!entry.getModifiers().contains((Object)Modifier.STATIC)) {
            this.messages.printError("Illegal method: a method annotated with @ProtobufDefaultValue must be static", entry);
        }
    }

    private void checkEnumProperties(RoundEnvironment roundEnv) {
        this.checkEnclosing(roundEnv, ProtobufEnumIndex.class, "Illegal enclosing class: a field or parameter annotated with @ProtobufEnumIndex should be enclosed by an enum annotated with @ProtobufEnum", ProtobufEnum.class);
    }

    private void checkAnyGetters(RoundEnvironment roundEnv) {
        this.checkEnclosing(roundEnv, ProtobufGetter.class, "Illegal enclosing class: a method annotated with @ProtobufGetter should be enclosed by a class or record annotated with @ProtobufMessage", ProtobufMessage.class);
    }

    private void checkMessageProperties(RoundEnvironment roundEnv) {
        Set<? extends Element> properties = roundEnv.getElementsAnnotatedWith(ProtobufProperty.class);
        for (Element element : properties) {
            this.processMessageProperty(element);
        }
    }

    private void processMessageProperty(Element property) {
        TypeElement enclosingElement = this.getEnclosingTypeElement(property);
        if (enclosingElement.getAnnotation(ProtobufMessage.class) == null && enclosingElement.getAnnotation(ProtobufGroup.class) == null) {
            this.messages.printError("Illegal enclosing class: a field annotated with @ProtobufProperty should be enclosed by a class or record annotated with @ProtobufMessage or @ProtobufGroup", property);
            return;
        }
        ProtobufProperty annotation = property.getAnnotation(ProtobufProperty.class);
        if (annotation.type() == ProtobufType.UNKNOWN) {
            this.messages.printError("Illegal protobuf type: a field annotated with @ProtobufProperty cannot have an UNKNOWN type", property);
            return;
        }
        List<TypeElement> mixins = this.types.getMixins(annotation);
        this.checkMixins(property, mixins);
    }

    private void checkMixins(Element property, List<TypeElement> mixins) {
        for (TypeElement mixin : mixins) {
            DeclaredType declaredType;
            TypeMirror typeMirror = mixin.asType();
            if (typeMirror instanceof DeclaredType && (declaredType = (DeclaredType)typeMirror).asElement().getAnnotation(ProtobufMixin.class) != null) continue;
            this.messages.printError("Illegal argument: %s is not a valid mixin".formatted(mixin.getSimpleName()), property);
        }
    }

    private void checkEnums(RoundEnvironment roundEnv) {
        this.checkAnnotation(roundEnv, ProtobufEnum.class, "Illegal annotation: only enums can be annotated with @ProtobufEnum", ElementKind.ENUM);
    }

    private void checkMessages(RoundEnvironment roundEnv) {
        this.checkAnnotation(roundEnv, ProtobufMessage.class, "Illegal annotation: only classes and records can be annotated with @ProtobufMessage", ElementKind.CLASS, ElementKind.RECORD);
    }

    private void checkGroups(RoundEnvironment roundEnv) {
        this.checkAnnotation(roundEnv, ProtobufGroup.class, "Illegal annotation: only classes and records can be annotated with @ProtobufMessage", ElementKind.CLASS, ElementKind.RECORD);
    }

    private void checkBuilders(RoundEnvironment roundEnv) {
        Set<? extends Element> builders = roundEnv.getElementsAnnotatedWith(ProtobufBuilder.class);
        for (Element element : builders) {
            this.checkBuilder(element);
        }
    }

    private void checkBuilder(Element element) {
        if (!(element instanceof ExecutableElement)) {
            this.messages.printError("Invalid delegate: only methods can be annotated with @ProtobufBuilder", element);
            return;
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.messages.printError("Weak visibility: a method annotated with @ProtobufBuilder must have at least package-private visibility", element);
            return;
        }
        if (element.getKind() != ElementKind.CONSTRUCTOR && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            this.messages.printError("Illegal method: a method annotated with @ProtobufBuilder must be a constructor or static", element);
        }
    }

    private void checkSerializers(RoundEnvironment roundEnv) {
        Set<? extends Element> serializers = roundEnv.getElementsAnnotatedWith(ProtobufSerializer.class);
        for (Element element : serializers) {
            this.checkSerializer(element);
        }
    }

    private void checkSerializer(Element element) {
        boolean inMixin;
        if (!(element instanceof ExecutableElement)) {
            this.messages.printError("Invalid delegate: only methods can be annotated with @ProtobufSerializer", element);
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.getKind() == ElementKind.CONSTRUCTOR) {
            this.messages.printError("Invalid delegate: constructors cannot be annotated with @ProtobufSerializer", element);
            return;
        }
        TypeMirror enclosingType = executableElement.getEnclosingElement().asType();
        if (enclosingType.getAnnotation(ProtobufMessage.class) != null || enclosingType.getAnnotation(ProtobufEnum.class) != null) {
            this.messages.printError("Illegal method: a method annotated with @ProtobufSerializer cannot be inside a ProtobufMessage or ProtobufEnum", executableElement);
            return;
        }
        if (executableElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.messages.printError("Weak visibility: a method annotated with @ProtobufSerializer must have at least package-private visibility", executableElement);
            return;
        }
        boolean bl = inMixin = enclosingType.getAnnotation(ProtobufMixin.class) != null;
        if (executableElement.getModifiers().contains((Object)Modifier.STATIC) != inMixin) {
            String message = inMixin ? "Illegal method: a method annotated with @ProtobufSerializer in a mixin must be static" : "Illegal method: a method annotated with @ProtobufSerializer must not be static";
            this.messages.printError(message, executableElement);
            return;
        }
        if (executableElement.getParameters().size() != (inMixin ? 1 : 0)) {
            String message = inMixin ? "Illegal method: a method annotated with @ProtobufSerializer in a mixin must take exactly one parameter" : "Illegal method: a method annotated with @ProtobufSerializer must take no parameters";
            this.messages.printError(message, executableElement);
        }
    }

    private void checkDeserializers(RoundEnvironment roundEnv) {
        Set<? extends Element> deserializers = roundEnv.getElementsAnnotatedWith(ProtobufDeserializer.class);
        for (Element element : deserializers) {
            this.checkDeserializer(element);
        }
    }

    private void checkDeserializer(Element element) {
        if (!(element instanceof ExecutableElement)) {
            this.messages.printError("Invalid delegate: only methods can be annotated with @ProtobufDeserializer", element);
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeMirror enclosingType = executableElement.getEnclosingElement().asType();
        if (enclosingType.getAnnotation(ProtobufMessage.class) != null || enclosingType.getAnnotation(ProtobufEnum.class) != null) {
            this.messages.printError("Illegal method: a method annotated with @ProtobufDeserializer cannot be inside a ProtobufMessage or ProtobufEnum", executableElement);
            return;
        }
        if (executableElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.messages.printError("Weak visibility: a method annotated with @ProtobufDeserializer must have at least package-private visibility", executableElement);
            return;
        }
        if (!executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.messages.printError("Illegal method: a method annotated with @ProtobufDeserializer must be static", executableElement);
            return;
        }
        if (executableElement.getKind() == ElementKind.CONSTRUCTOR && enclosingType.getAnnotation(ProtobufMixin.class) != null) {
            this.messages.printError("Illegal method: a method annotated with @ProtobufDeserializer in a mixin cannot be a constructor", executableElement);
            return;
        }
        if (executableElement.getParameters().size() != 1) {
            this.messages.printError("Illegal method: a method annotated with @ProtobufDeserializer must take exactly one parameter", executableElement);
            return;
        }
        if (enclosingType.getAnnotation(ProtobufMixin.class) != null && !this.types.isAssignable(executableElement.getReturnType(), enclosingType)) {
            this.messages.printError("Illegal method: a method annotated with @ProtobufDeserializer must return a type assignable to its parent or be in a mixin", executableElement);
        }
    }

    private TypeElement getEnclosingTypeElement(Element element) {
        Objects.requireNonNull(element);
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return typeElement;
        }
        return this.getEnclosingTypeElement(element.getEnclosingElement());
    }

    @SafeVarargs
    private void checkEnclosing(RoundEnvironment roundEnv, Class<? extends Annotation> annotation, String error, Class<? extends Annotation> ... requiredAnnotations) {
        roundEnv.getElementsAnnotatedWith(annotation).stream().filter(property -> {
            TypeElement enclosingTypeElement = this.getEnclosingTypeElement((Element)property);
            return Arrays.stream(requiredAnnotations).noneMatch(type -> enclosingTypeElement.getAnnotation(type) != null);
        }).forEach(property -> this.messages.printError(error, (Element)property));
    }

    private void checkAnnotation(RoundEnvironment roundEnv, Class<? extends Annotation> protobufMessageClass, String error, ElementKind ... elementKind) {
        Set<ElementKind> kinds = Set.of(elementKind);
        for (Element element : roundEnv.getElementsAnnotatedWith(protobufMessageClass)) {
            if (kinds.contains((Object)element.getKind())) continue;
            this.messages.printError(error, element);
        }
    }

    public boolean isValidRequiredProperty(Element variableElement) {
        if (variableElement.asType().getKind().isPrimitive()) {
            this.messages.printError("Required properties cannot be primitives", variableElement);
            return false;
        }
        return true;
    }

    public boolean isValidPackedProperty(Element variableElement, ProtobufProperty propertyAnnotation) {
        if (!propertyAnnotation.packed() || this.types.isAssignable(variableElement.asType(), Collection.class)) {
            return true;
        }
        this.messages.printError("Only scalar properties can be packed", variableElement);
        return false;
    }
}

