/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.support;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public abstract class JavaWriter
extends PrintWriter {
    int level;

    public JavaWriter(Writer out) {
        super(out);
    }

    @Override
    public void print(String s) {
        super.print("    ".repeat(this.level) + s);
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        return super.format("    ".repeat(this.level) + format, args);
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        return super.format(l, "    ".repeat(this.level) + format, args);
    }

    public void printSeparator() {
        this.println();
    }

    public void printComment(String content) {
        this.println("// " + content);
    }

    public static class ClassWriter
    extends BodyWriter
    implements AutoCloseable {
        public ClassWriter(JavaWriter out) {
            super(out);
            this.level = out.level + 1;
        }

        public void printFieldDeclaration(String fieldType, String fieldName) {
            this.printf("private %s %s;%n", fieldType, fieldName);
        }

        public MethodWriter printConstructorDeclaration(String className, String ... parameters) {
            this.printf("public %s(%s) {%n", className, String.join((CharSequence)" ", parameters));
            return new MethodWriter(this);
        }

        public MethodWriter printMethodDeclaration(String returnType, String methodName, String ... parameters) {
            return this.printMethodDeclaration(List.of("public"), returnType, methodName, parameters);
        }

        public MethodWriter printMethodDeclaration(List<String> modifiers, String returnType, String methodName, String ... parameters) {
            this.printf("%s %s %s(%s) {%n", String.join((CharSequence)" ", modifiers), returnType, methodName, String.join((CharSequence)", ", parameters));
            return new MethodWriter(this);
        }

        public MethodWriter printStaticBlock() {
            this.printf("static {%n", new Object[0]);
            return new MethodWriter(this);
        }

        public static class MethodWriter
        extends BodyWriter
        implements AutoCloseable {
            public MethodWriter(JavaWriter out) {
                super(out);
                this.level = out.level + 1;
            }

            @Override
            public void close() {
                super.close();
                this.println();
            }
        }

        public static class ForWriter
        extends BodyWriter
        implements AutoCloseable {
            public ForWriter(JavaWriter out) {
                super(out);
                this.level = out.level + 1;
            }
        }

        public static class ForEachWriter
        extends BodyWriter
        implements AutoCloseable {
            public ForEachWriter(JavaWriter out) {
                super(out);
                this.level = out.level + 1;
            }
        }

        public static class SwitchBranchWriter
        extends BodyWriter
        implements AutoCloseable {
            public SwitchBranchWriter(JavaWriter out) {
                super(out);
                this.level = out.level + 1;
            }
        }

        public static class SwitchStatementWriter
        extends ConditionalStatementWriter
        implements AutoCloseable {
            public SwitchStatementWriter(JavaWriter out) {
                super(out);
                this.level = out.level + 1;
            }

            public void printSwitchBranch(String condition, String body) {
                this.printf("%s -> %s;%n", this.toCase(condition), body);
            }

            public SwitchBranchWriter printSwitchBranch(String condition) {
                this.printf("%s -> {%n", this.toCase(condition));
                return new SwitchBranchWriter(this);
            }

            private String toCase(String condition) {
                return Objects.equals(condition, "default") ? condition : "case " + condition;
            }
        }

        public static class ConditionalStatementWriter
        extends BodyWriter
        implements AutoCloseable {
            public ConditionalStatementWriter(JavaWriter out) {
                super(out);
                this.level = out.level + 1;
            }
        }
    }

    public static abstract class BodyWriter
    extends JavaWriter
    implements AutoCloseable {
        public BodyWriter(Writer out) {
            super(out);
        }

        public String printVariableDeclaration(String fieldName, String fieldValue) {
            this.printVariableDeclaration(null, fieldName, fieldValue);
            return fieldName;
        }

        public String printVariableDeclaration(String fieldType, String fieldName, String fieldValue) {
            this.printf("%s %s = %s;%n", fieldType == null ? "var" : fieldType, fieldName, fieldValue);
            return fieldName;
        }

        public void printFieldAssignment(String name, String value) {
            this.printf("%s = %s;%n", name, value);
        }

        public ClassWriter.ConditionalStatementWriter printIfStatement(String condition) {
            this.printf("if (%s) {%n", condition);
            return new ClassWriter.ConditionalStatementWriter(this);
        }

        public ClassWriter.ConditionalStatementWriter printWhileStatement(String condition) {
            this.printf("while (%s) {%n", condition);
            return new ClassWriter.ConditionalStatementWriter(this);
        }

        public ClassWriter.SwitchStatementWriter printSwitchStatement(String condition) {
            this.printf("switch (%s) {%n", condition);
            return new ClassWriter.SwitchStatementWriter(this);
        }

        public void printReturn(String value) {
            this.printf("return %s;%n", value);
        }

        public void printReturn() {
            this.println("return;");
        }

        public ClassWriter.ForWriter printForStatement(String initializer, String condition, String body) {
            this.printf("for (%s; %s; %s) { %n", initializer, condition, body);
            return new ClassWriter.ForWriter(this);
        }

        public ClassWriter.ForEachWriter printForEachStatement(String localVariableName, String accessorCall) {
            this.printf("for (var %s : %s) { %n", localVariableName, accessorCall);
            return new ClassWriter.ForEachWriter(this);
        }

        @Override
        public void close() {
            if (this.level > 0) {
                --this.level;
            }
            this.println("}");
        }
    }

    public static final class CompilationUnit
    extends JavaWriter {
        public CompilationUnit(Writer out) {
            super(out);
        }

        public void printPackageDeclaration(String packageName) {
            this.printf("package %s;%n", packageName);
            this.printSeparator();
        }

        public void printImportDeclaration(String importName) {
            this.printf("import %s;%n", importName);
        }

        public ClassWriter printClassDeclaration(String className) {
            this.printf("public class %s {%n", className);
            return new ClassWriter(this);
        }
    }
}

