/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.support;

import it.auties.protobuf.annotation.ProtobufEnum;
import it.auties.protobuf.annotation.ProtobufGroup;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufReservedRange;
import it.auties.protobuf.serialization.model.object.ProtobufObjectElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Reserved {
    public static Set<String> getNames(ProtobufObjectElement objectElement) {
        return switch (objectElement.type()) {
            default -> throw new MatchException(null, null);
            case ProtobufObjectElement.Type.MESSAGE -> {
                ProtobufMessage message = objectElement.element().getAnnotation(ProtobufMessage.class);
                if (message == null) {
                    yield Set.of();
                }
                yield Set.of(message.reservedNames());
            }
            case ProtobufObjectElement.Type.ENUM -> {
                ProtobufEnum enumeration = objectElement.element().getAnnotation(ProtobufEnum.class);
                if (enumeration == null) {
                    yield Set.of();
                }
                yield Set.of(enumeration.reservedNames());
            }
            case ProtobufObjectElement.Type.GROUP -> {
                ProtobufGroup group = objectElement.element().getAnnotation(ProtobufGroup.class);
                if (group == null) {
                    yield Set.of();
                }
                yield Set.of(group.reservedNames());
            }
            case ProtobufObjectElement.Type.SYNTHETIC -> Set.of();
        };
    }

    public static Set<ProtobufObjectElement.ReservedIndex> getIndexes(ProtobufObjectElement objectElement) {
        return switch (objectElement.type()) {
            default -> throw new MatchException(null, null);
            case ProtobufObjectElement.Type.MESSAGE -> {
                ProtobufMessage message = objectElement.element().getAnnotation(ProtobufMessage.class);
                yield Reserved.getReservedIndexes(message.reservedIndexes(), message.reservedRanges());
            }
            case ProtobufObjectElement.Type.ENUM -> {
                ProtobufEnum enumeration = objectElement.element().getAnnotation(ProtobufEnum.class);
                yield Reserved.getReservedIndexes(enumeration.reservedIndexes(), enumeration.reservedRanges());
            }
            case ProtobufObjectElement.Type.GROUP -> {
                ProtobufGroup group = objectElement.element().getAnnotation(ProtobufGroup.class);
                yield Reserved.getReservedIndexes(group.reservedIndexes(), group.reservedRanges());
            }
            case ProtobufObjectElement.Type.SYNTHETIC -> Set.of();
        };
    }

    private static Set<ProtobufObjectElement.ReservedIndex> getReservedIndexes(int[] indexes, ProtobufReservedRange[] ranges) {
        HashSet<Record> results = new HashSet<Record>();
        for (int index : indexes) {
            results.add(new ProtobufObjectElement.ReservedIndex.Value(index));
        }
        for (ProtobufReservedRange range : ranges) {
            results.add(new ProtobufObjectElement.ReservedIndex.Range(range.min(), range.max()));
        }
        return Collections.unmodifiableSet(results);
    }
}

