/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.serialization.support;

import it.auties.protobuf.annotation.ProtobufDeserializer;
import it.auties.protobuf.annotation.ProtobufEnum;
import it.auties.protobuf.annotation.ProtobufGetter;
import it.auties.protobuf.annotation.ProtobufGroup;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.annotation.ProtobufSerializer;
import it.auties.protobuf.annotation.ProtobufUnknownFields;
import it.auties.protobuf.model.ProtobufType;
import java.lang.annotation.Annotation;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;

public class Types {
    private static final String GETTER_PREFIX = "get";
    private final ProcessingEnvironment processingEnv;
    private final TypeMirror rawGroupType;
    private final TypeMirror voidType;

    public Types(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.rawGroupType = this.getType(Map.class, Integer.class, Object.class);
        this.voidType = processingEnv.getTypeUtils().getNoType(TypeKind.VOID);
    }

    public TypeMirror rawGroupType() {
        return this.rawGroupType;
    }

    public TypeMirror voidType() {
        return this.voidType;
    }

    public TypeMirror getType(Class<?> type, Class<?> ... params) {
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            TypeKind kind = TypeKind.valueOf(type.getName().toUpperCase(Locale.ROOT));
            return this.processingEnv.getTypeUtils().getPrimitiveType(kind);
        }
        if (type.isArray()) {
            return this.processingEnv.getTypeUtils().getArrayType(this.getType(type.getComponentType(), new Class[0]));
        }
        TypeElement result = this.processingEnv.getElementUtils().getTypeElement(type.getName());
        if (params.length == 0) {
            return this.erase(result.asType());
        }
        Types types = this;
        TypeMirror[] typeArgs = (TypeMirror[])Arrays.stream(params).map(x$0 -> types.getType((Class<?>)x$0, new Class[0])).toArray(TypeMirror[]::new);
        return this.processingEnv.getTypeUtils().getDeclaredType(result, typeArgs);
    }

    public boolean isGroup(TypeMirror mirror) {
        DeclaredType declaredType;
        TypeMirror typeMirror = this.erase(mirror);
        return typeMirror instanceof DeclaredType && (declaredType = (DeclaredType)typeMirror).asElement().getAnnotation(ProtobufGroup.class) != null;
    }

    public boolean isMessage(TypeMirror mirror) {
        DeclaredType declaredType;
        TypeMirror typeMirror = this.erase(mirror);
        return typeMirror instanceof DeclaredType && (declaredType = (DeclaredType)typeMirror).asElement().getAnnotation(ProtobufMessage.class) != null;
    }

    public boolean isEnum(TypeMirror mirror) {
        DeclaredType declaredType;
        TypeMirror typeMirror = this.erase(mirror);
        return typeMirror instanceof DeclaredType && (declaredType = (DeclaredType)typeMirror).asElement().getAnnotation(ProtobufEnum.class) != null;
    }

    public boolean isObject(TypeMirror mirror) {
        DeclaredType declaredType;
        TypeMirror typeMirror = this.erase(mirror);
        return typeMirror instanceof DeclaredType && ((declaredType = (DeclaredType)typeMirror).asElement().getAnnotation(ProtobufMessage.class) != null || declaredType.asElement().getAnnotation(ProtobufEnum.class) != null || declaredType.asElement().getAnnotation(ProtobufGroup.class) != null);
    }

    public boolean isSameType(TypeMirror firstType, Class<?> secondType) {
        return this.isSameType(firstType, this.getType(secondType, new Class[0]));
    }

    public boolean isSameType(TypeMirror firstType, TypeMirror secondType) {
        return this.isSameType(firstType, secondType, true);
    }

    public boolean isSameType(TypeMirror firstType, TypeMirror secondType, boolean erase) {
        return this.processingEnv.getTypeUtils().isSameType(erase ? this.erase(firstType) : firstType, erase ? this.erase(secondType) : secondType);
    }

    public TypeMirror erase(TypeMirror typeMirror) {
        TypeMirror result = this.processingEnv.getTypeUtils().erasure(typeMirror);
        return result == null ? typeMirror : result;
    }

    public boolean isAssignable(TypeMirror rhs, Class<?> lhs) {
        return this.isAssignable(rhs, lhs, true);
    }

    public boolean isAssignable(TypeMirror rhs, Class<?> lhs, boolean erase) {
        return this.isAssignable(rhs, this.getType(lhs, new Class[0]), erase);
    }

    public boolean isAssignable(TypeMirror rhs, TypeMirror lhs) {
        return this.isAssignable(rhs, lhs, true);
    }

    public boolean isAssignable(TypeMirror rhs, TypeMirror lhs, boolean erase) {
        TypeElement boxed;
        PrimitiveType primitiveType;
        if (rhs instanceof PrimitiveType) {
            primitiveType = (PrimitiveType)rhs;
            boxed = this.processingEnv.getTypeUtils().boxedClass(primitiveType);
            rhs = boxed.asType();
        }
        if (lhs instanceof PrimitiveType) {
            primitiveType = (PrimitiveType)lhs;
            boxed = this.processingEnv.getTypeUtils().boxedClass(primitiveType);
            lhs = boxed.asType();
        }
        return this.processingEnv.getTypeUtils().isAssignable(erase ? this.erase(rhs) : rhs, erase ? this.erase(lhs) : lhs);
    }

    public Optional<TypeElement> getDefaultConstructor(TypeMirror type) {
        TypeElement typeElement;
        DeclaredType declaredType;
        AnnotatedConstruct annotatedConstruct = this.erase(type);
        if (annotatedConstruct instanceof DeclaredType && (annotatedConstruct = (declaredType = (DeclaredType)annotatedConstruct).asElement()) instanceof TypeElement && !(typeElement = (TypeElement)annotatedConstruct).getModifiers().contains((Object)Modifier.ABSTRACT) && this.hasNoArgsConstructor(typeElement)) {
            return Optional.of(typeElement);
        }
        return Optional.empty();
    }

    private boolean hasNoArgsConstructor(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().anyMatch(entry -> entry.getKind() == ElementKind.CONSTRUCTOR && ((ExecutableElement)entry).getParameters().isEmpty());
    }

    public List<TypeElement> getMixins(ProtobufProperty property) {
        return this.getMirroredTypes(() -> ((ProtobufProperty)property).mixins());
    }

    public List<TypeElement> getMixins(ProtobufUnknownFields property) {
        return this.getMirroredTypes(() -> ((ProtobufUnknownFields)property).mixins());
    }

    public List<TypeElement> getMixins(ProtobufGetter property) {
        return this.getMirroredTypes(() -> ((ProtobufGetter)property).mixins());
    }

    public TypeElement getMirroredType(Supplier<Class<?>> supplier) {
        try {
            return this.processingEnv.getElementUtils().getTypeElement(supplier.get().getName());
        }
        catch (MirroredTypeException exception) {
            return (TypeElement)((DeclaredType)exception.getTypeMirror()).asElement();
        }
    }

    public List<TypeElement> getMirroredTypes(Supplier<Class<?>[]> supplier) {
        try {
            return Arrays.stream(supplier.get()).map(mixin -> this.processingEnv.getElementUtils().getTypeElement(mixin.getName())).filter(entry -> entry instanceof DeclaredType).map(entry -> (TypeElement)((DeclaredType)((Object)entry)).asElement()).collect(Collectors.toList());
        }
        catch (MirroredTypesException exception) {
            return exception.getTypeMirrors().stream().filter(entry -> entry instanceof DeclaredType).map(entry -> (TypeElement)((DeclaredType)entry).asElement()).collect(Collectors.toList());
        }
    }

    public boolean isParametrized(ExecutableElement element) {
        TypeElement typeElement;
        Element element2;
        return (!element.getTypeParameters().isEmpty() || (element2 = element.getEnclosingElement()) instanceof TypeElement && !(typeElement = (TypeElement)element2).getTypeParameters().isEmpty()) && element.getParameters().stream().anyMatch(this::isParametrized);
    }

    private boolean isParametrized(VariableElement parameter) {
        TypeElement typeElement;
        DeclaredType declaredType;
        AnnotatedConstruct annotatedConstruct;
        return parameter.asType().getKind() == TypeKind.TYPEVAR || (annotatedConstruct = parameter.asType()) instanceof DeclaredType && (annotatedConstruct = (declaredType = (DeclaredType)annotatedConstruct).asElement()) instanceof TypeElement && this.isParametrized(typeElement = (TypeElement)annotatedConstruct);
    }

    public boolean isParametrized(TypeMirror mirror) {
        DeclaredType declaredType;
        return mirror.getKind() == TypeKind.TYPEVAR || mirror instanceof DeclaredType && (declaredType = (DeclaredType)mirror).getTypeArguments().stream().anyMatch(this::isParametrized);
    }

    public boolean isParametrized(Element element) {
        TypeElement typeElement;
        return element instanceof TypeElement && (typeElement = (TypeElement)element).getTypeParameters().stream().anyMatch(entry -> entry.asType().getKind() == TypeKind.TYPEVAR || this.isParametrized((Element)entry));
    }

    public TypeMirror getReturnType(ExecutableElement method, List<TypeMirror> arguments) {
        TypeMirror returnType = method.getReturnType();
        if (!this.isParametrized(returnType)) {
            return returnType;
        }
        HashMap<String, List> typeParametersArguments = new HashMap<String, List>();
        for (int index = 0; index < method.getParameters().size(); ++index) {
            Map<String, List<TypeMirror>> methodParameterUses = this.getTypeUses(method.getParameters().get(index).asType(), arguments.get(index));
            methodParameterUses.forEach((key, value) -> typeParametersArguments.merge((String)key, (List)value, (first, second) -> {
                ArrayList result = new ArrayList();
                result.addAll(first);
                result.addAll(second);
                return result;
            }));
        }
        HashMap<String, TypeMirror> typeParametersResolvedTypes = new HashMap<String, TypeMirror>();
        typeParametersArguments.forEach((type, values) -> typeParametersResolvedTypes.put((String)type, this.lowerCommonBound((List<TypeMirror>)values)));
        return this.createTypeWithGenericData(returnType, typeParametersResolvedTypes);
    }

    private TypeMirror createTypeWithGenericData(TypeMirror type, Map<String, TypeMirror> typeParametersResolvedTypes) {
        if (type.getKind() == TypeKind.TYPEVAR) {
            return typeParametersResolvedTypes.getOrDefault(type.toString(), type);
        }
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            return this.processingEnv.getTypeUtils().boxedClass(primitiveType).asType();
        }
        if (!(type instanceof DeclaredType)) {
            return type;
        }
        DeclaredType declaredType = (DeclaredType)type;
        TypeMirror[] resultArguments = new TypeMirror[declaredType.getTypeArguments().size()];
        for (int index = 0; index < resultArguments.length; ++index) {
            TypeMirror typeArgument = declaredType.getTypeArguments().get(index);
            resultArguments[index] = this.createTypeWithGenericData(typeArgument, typeParametersResolvedTypes);
        }
        return this.processingEnv.getTypeUtils().getDeclaredType((TypeElement)declaredType.asElement(), resultArguments);
    }

    private TypeMirror lowerCommonBound(List<TypeMirror> types) {
        HashMap<TypeMirror, Integer> counter = new HashMap<TypeMirror, Integer>();
        for (TypeMirror type : types) {
            while (type != null) {
                counter.compute(type, (key, value) -> value == null ? 1 : value + 1);
                type = this.getSuperClass(type).orElse(null);
            }
        }
        TypeMirror bestElement = null;
        int bestCount = 0;
        for (Map.Entry entry : counter.entrySet()) {
            if ((Integer)entry.getValue() > bestCount) {
                bestElement = (TypeMirror)entry.getKey();
                bestCount = (Integer)entry.getValue();
                continue;
            }
            if ((Integer)entry.getValue() != bestCount || !this.isAssignable((TypeMirror)entry.getKey(), bestElement)) continue;
            bestElement = (TypeMirror)entry.getKey();
        }
        return bestElement;
    }

    public Optional<TypeMirror> getSuperClass(TypeMirror mirror) {
        Optional<TypeMirror> optional;
        TypeMirror typeMirror = mirror;
        Objects.requireNonNull(typeMirror);
        TypeMirror typeMirror2 = typeMirror;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayType.class, DeclaredType.class}, (Object)typeMirror2, n)) {
                case 0: {
                    ArrayType ignored = (ArrayType)typeMirror2;
                    optional = Optional.of(this.getType(Object.class, new Class[0]));
                    break block4;
                }
                case 1: {
                    TypeElement typeElement;
                    DeclaredType declaredType = (DeclaredType)typeMirror2;
                    Element element = declaredType.asElement();
                    if (!(element instanceof TypeElement) || (typeElement = (TypeElement)element).getSuperclass() == null || typeElement.getSuperclass().getKind() == TypeKind.NONE) {
                        n = 2;
                        continue block4;
                    }
                    optional = Optional.ofNullable(typeElement.getSuperclass());
                    break block4;
                }
                default: {
                    optional = Optional.empty();
                    break block4;
                }
            }
            break;
        }
        return optional;
    }

    public Optional<TypeElement> getSuperClass(TypeElement typeElement) {
        TypeMirror superClass = typeElement.getSuperclass();
        if (superClass == null || superClass.getKind() == TypeKind.NONE) {
            return Optional.empty();
        }
        Element superClassElement = ((DeclaredType)superClass).asElement();
        return Optional.of((TypeElement)superClassElement);
    }

    public List<? extends TypeMirror> getImplementedInterfaces(TypeMirror mirror) {
        DeclaredType declaredType;
        Element element;
        if (!(mirror instanceof DeclaredType) || !((element = (declaredType = (DeclaredType)mirror).asElement()) instanceof TypeElement)) {
            return List.of();
        }
        TypeElement typeElement = (TypeElement)element;
        return typeElement.getInterfaces();
    }

    private Map<String, List<TypeMirror>> getTypeUses(TypeMirror methodParameterType, TypeMirror methodArgumentType) {
        if (methodParameterType.getKind() == TypeKind.TYPEVAR) {
            return Map.of(methodParameterType.toString(), List.of(methodArgumentType));
        }
        if (!(methodParameterType instanceof DeclaredType)) {
            return Map.of();
        }
        DeclaredType methodDeclaredParameterType = (DeclaredType)methodParameterType;
        HashMap<String, List<TypeMirror>> uses = new HashMap<String, List<TypeMirror>>();
        List<? extends TypeMirror> methodParameterTypeParameters = methodDeclaredParameterType.getTypeArguments();
        for (int index = 0; index < methodParameterTypeParameters.size(); ++index) {
            TypeMirror methodParameterTypeParameter = methodParameterTypeParameters.get(index);
            if (methodParameterTypeParameter.getKind() == TypeKind.TYPEVAR) {
                TypeMirror type = this.getTypeParameter(methodArgumentType, methodParameterType, index).orElseThrow(() -> new IllegalStateException("Cannot determine type"));
                uses.compute(methodParameterTypeParameter.toString(), (key, value) -> {
                    if (value == null) {
                        ArrayList<TypeMirror> data = new ArrayList<TypeMirror>();
                        data.add(type);
                        return data;
                    }
                    value.add(type);
                    return value;
                });
                continue;
            }
            if (!(methodParameterTypeParameter instanceof DeclaredType)) continue;
            DeclaredType methodParameterDeclaredTypeParameter = (DeclaredType)methodParameterTypeParameter;
            TypeMirror methodArgumentTypeParameter = methodDeclaredParameterType.getTypeArguments().get(index);
            if (!(methodArgumentTypeParameter instanceof DeclaredType)) continue;
            DeclaredType methodArgumentDeclaredTypeParameter = (DeclaredType)methodArgumentTypeParameter;
            uses.putAll(this.getTypeUses(methodParameterDeclaredTypeParameter, methodArgumentDeclaredTypeParameter));
        }
        return uses;
    }

    public Optional<TypeMirror> getTypeParameter(TypeMirror concrete, TypeMirror model, int index) {
        if (!(concrete instanceof DeclaredType)) {
            return Optional.empty();
        }
        DeclaredType declaredType = (DeclaredType)concrete;
        if (this.isSameType(concrete, model) && index < declaredType.getTypeArguments().size()) {
            TypeMirror collectionTypeArgument = declaredType.getTypeArguments().get(index);
            return this.getConcreteTypeParameter(collectionTypeArgument, declaredType, index);
        }
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        return typeElement.getInterfaces().stream().filter(implemented -> implemented instanceof DeclaredType).map(implemented -> (DeclaredType)implemented).map(implemented -> this.getTypeParameterByImplement(declaredType, (DeclaredType)implemented, model, index)).flatMap(Optional::stream).findFirst().or(() -> this.getTypeParameterBySuperClass(declaredType, typeElement, model, index));
    }

    private Optional<TypeMirror> getTypeParameterByImplement(DeclaredType declaredType, DeclaredType implemented, TypeMirror targetType, int index) {
        if (this.isSameType((TypeMirror)implemented, targetType)) {
            TypeMirror collectionTypeArgument = implemented.getTypeArguments().get(index);
            return this.getConcreteTypeParameter(collectionTypeArgument, declaredType, index);
        }
        return this.getTypeParameter(implemented, targetType, index).flatMap(result -> this.getConcreteTypeParameter((TypeMirror)result, declaredType, index));
    }

    private Optional<TypeMirror> getTypeParameterBySuperClass(DeclaredType declaredType, TypeElement typeElement, TypeMirror targetType, int index) {
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (!(typeMirror instanceof DeclaredType)) {
            return Optional.empty();
        }
        DeclaredType superDeclaredType = (DeclaredType)typeMirror;
        return this.getTypeParameter(superDeclaredType, targetType, index).flatMap(result -> this.getConcreteTypeParameter((TypeMirror)result, superDeclaredType, index)).flatMap(result -> this.getConcreteTypeParameter((TypeMirror)result, declaredType, index));
    }

    private Optional<TypeMirror> getConcreteTypeParameter(TypeMirror argumentMirror, DeclaredType previousType, int index) {
        TypeMirror typeMirror = argumentMirror;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DeclaredType.class, ArrayType.class, TypeVariable.class}, (Object)typeMirror, n)) {
            case 0 -> {
                DeclaredType declaredTypeArgument = (DeclaredType)typeMirror;
                yield Optional.of(declaredTypeArgument);
            }
            case 1 -> {
                ArrayType arrayType = (ArrayType)typeMirror;
                yield Optional.of(arrayType);
            }
            case 2 -> {
                TypeVariable typeVariableArgument = (TypeVariable)typeMirror;
                yield this.getConcreteTypeFromTypeVariable(typeVariableArgument, previousType, index);
            }
            default -> Optional.empty();
        };
    }

    private Optional<TypeMirror> getConcreteTypeFromTypeVariable(TypeVariable typeVariableArgument, DeclaredType previousType, int index) {
        Name currentTypeVarName = typeVariableArgument.asElement().getSimpleName();
        List<? extends TypeMirror> previousTypeArguments = previousType.getTypeArguments();
        TypeElement previousElement = (TypeElement)previousType.asElement();
        List<? extends TypeParameterElement> previousTypeParameters = previousElement.getTypeParameters();
        while (index < previousTypeParameters.size() && index < previousTypeArguments.size()) {
            if (previousTypeParameters.get(index).getSimpleName().equals(currentTypeVarName)) {
                return Optional.of(previousTypeArguments.get(index));
            }
            ++index;
        }
        return Optional.empty();
    }

    public ExecutableElement createMethodStub(String className, final String methodName, final TypeMirror returnType, TypeMirror ... parameterTypes) {
        final TypeMirror methodType = this.createMethodStubType();
        final List<VariableElement> parameters = Arrays.stream(parameterTypes).map(this::createMethodStubParameter).toList();
        final TypeElement methodStubClass = this.createClassStub(className);
        return new ExecutableElement(){
            final /* synthetic */ Types this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public TypeMirror asType() {
                return methodType;
            }

            @Override
            public List<? extends TypeParameterElement> getTypeParameters() {
                return List.of();
            }

            @Override
            public TypeMirror getReturnType() {
                return returnType;
            }

            @Override
            public List<? extends VariableElement> getParameters() {
                return parameters;
            }

            @Override
            public TypeMirror getReceiverType() {
                return null;
            }

            @Override
            public boolean isVarArgs() {
                return false;
            }

            @Override
            public boolean isDefault() {
                return false;
            }

            @Override
            public List<? extends TypeMirror> getThrownTypes() {
                return List.of();
            }

            @Override
            public AnnotationValue getDefaultValue() {
                return null;
            }

            @Override
            public Element getEnclosingElement() {
                return methodStubClass;
            }

            @Override
            public Name getSimpleName() {
                return this.this$0.processingEnv.getElementUtils().getName(methodName);
            }

            @Override
            public ElementKind getKind() {
                return ElementKind.METHOD;
            }

            @Override
            public Set<Modifier> getModifiers() {
                return Set.of(Modifier.PUBLIC, Modifier.STATIC);
            }

            @Override
            public List<? extends Element> getEnclosedElements() {
                return List.of();
            }

            @Override
            public List<? extends AnnotationMirror> getAnnotationMirrors() {
                return List.of();
            }

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                return this.this$0.getMethodStubAnnotation(annotationType);
            }

            @Override
            public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                return new Annotation[]{this.getAnnotation(annotationType)};
            }

            @Override
            public <R, P> R accept(ElementVisitor<R, P> v, P p) {
                return null;
            }
        };
    }

    private <A extends Annotation> A getMethodStubAnnotation(Class<A> annotationType) {
        if (annotationType.getName().equals(ProtobufDeserializer.class.getName())) {
            return (A)new ProtobufDeserializer(this){

                public Class<? extends Annotation> annotationType() {
                    return ProtobufDeserializer.class;
                }

                public ProtobufDeserializer.BuilderBehaviour builderBehaviour() {
                    return ProtobufDeserializer.BuilderBehaviour.DISCARD;
                }

                public String warning() {
                    return "";
                }
            };
        }
        if (annotationType.getName().equals(ProtobufSerializer.class.getName())) {
            return (A)new ProtobufSerializer(this){

                public Class<? extends Annotation> annotationType() {
                    return ProtobufSerializer.class;
                }

                public ProtobufSerializer.GroupProperty[] groupProperties() {
                    return new ProtobufSerializer.GroupProperty[0];
                }

                public String warning() {
                    return "";
                }
            };
        }
        return null;
    }

    private VariableElement createMethodStubParameter(final TypeMirror from) {
        return new VariableElement(){
            final /* synthetic */ Types this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public TypeMirror asType() {
                return from;
            }

            @Override
            public Object getConstantValue() {
                return null;
            }

            @Override
            public Name getSimpleName() {
                return this.this$0.processingEnv.getElementUtils().getName("input");
            }

            @Override
            public Element getEnclosingElement() {
                return null;
            }

            @Override
            public ElementKind getKind() {
                return ElementKind.PARAMETER;
            }

            @Override
            public Set<Modifier> getModifiers() {
                return Set.of();
            }

            @Override
            public List<? extends Element> getEnclosedElements() {
                return List.of();
            }

            @Override
            public List<? extends AnnotationMirror> getAnnotationMirrors() {
                return List.of();
            }

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                return null;
            }

            @Override
            public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                return null;
            }

            @Override
            public <R, P> R accept(ElementVisitor<R, P> v, P p) {
                return null;
            }
        };
    }

    private TypeMirror createMethodStubType() {
        return new TypeMirror(this){

            @Override
            public TypeKind getKind() {
                return TypeKind.EXECUTABLE;
            }

            @Override
            public List<? extends AnnotationMirror> getAnnotationMirrors() {
                return List.of();
            }

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                return null;
            }

            @Override
            public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                return null;
            }

            @Override
            public <R, P> R accept(TypeVisitor<R, P> v, P p) {
                return null;
            }
        };
    }

    public ProtobufProperty getProperty(final ProtobufGetter getter) {
        return new ProtobufProperty(){

            public Class<? extends Annotation> annotationType() {
                return ProtobufProperty.class;
            }

            public int index() {
                return getter.index();
            }

            public ProtobufType type() {
                return getter.type();
            }

            public ProtobufType mapKeyType() {
                return ProtobufType.UNKNOWN;
            }

            public ProtobufType mapValueType() {
                return ProtobufType.UNKNOWN;
            }

            public Class<?>[] mixins() {
                return getter.mixins();
            }

            public boolean required() {
                return false;
            }

            public boolean ignored() {
                return false;
            }

            public boolean packed() {
                return getter.packed();
            }
        };
    }

    public ProtobufProperty getProperty(final ProtobufSerializer.GroupProperty property) {
        return new ProtobufProperty(){

            public Class<? extends Annotation> annotationType() {
                return ProtobufProperty.class;
            }

            public int index() {
                return property.index();
            }

            public ProtobufType type() {
                return property.type();
            }

            public ProtobufType mapKeyType() {
                return property.mapKeyType();
            }

            public ProtobufType mapValueType() {
                return property.mapValueType();
            }

            public Class<?>[] mixins() {
                return property.mixins();
            }

            public boolean required() {
                return false;
            }

            public boolean ignored() {
                return false;
            }

            public boolean packed() {
                return property.packed();
            }
        };
    }

    public String getPropertyName(String string) {
        if (string.toLowerCase().startsWith(GETTER_PREFIX)) {
            return string.length() < GETTER_PREFIX.length() + 1 ? "" : string.substring(GETTER_PREFIX.length() + 1);
        }
        return string;
    }

    public TypeElement createClassStub(String name) {
        return new StubTypeElement(name);
    }

    public List<TypeElement> getMixins(ProtobufSerializer.GroupProperty groupProperty) {
        return this.getMirroredTypes(() -> ((ProtobufSerializer.GroupProperty)groupProperty).mixins());
    }

    private final class StubTypeElement
    implements TypeElement {
        private final String name;

        private StubTypeElement(String name) {
            this.name = name;
        }

        @Override
        public TypeMirror asType() {
            return new DeclaredType(){

                @Override
                public Element asElement() {
                    return StubTypeElement.this;
                }

                @Override
                public TypeMirror getEnclosingType() {
                    return null;
                }

                @Override
                public List<? extends TypeMirror> getTypeArguments() {
                    return List.of();
                }

                @Override
                public TypeKind getKind() {
                    return TypeKind.DECLARED;
                }

                @Override
                public List<? extends AnnotationMirror> getAnnotationMirrors() {
                    return List.of();
                }

                @Override
                public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                    return null;
                }

                @Override
                public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                    return null;
                }

                @Override
                public <R, P> R accept(TypeVisitor<R, P> v, P p) {
                    return null;
                }
            };
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return List.of();
        }

        @Override
        public NestingKind getNestingKind() {
            return NestingKind.TOP_LEVEL;
        }

        @Override
        public Name getQualifiedName() {
            return Types.this.processingEnv.getElementUtils().getName(this.name);
        }

        @Override
        public Name getSimpleName() {
            String[] parts = this.name.split("\\.");
            return Types.this.processingEnv.getElementUtils().getName(parts[parts.length - 1]);
        }

        @Override
        public TypeMirror getSuperclass() {
            return Types.this.getType(Object.class, new Class[0]);
        }

        @Override
        public List<? extends TypeMirror> getInterfaces() {
            return List.of();
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            return List.of();
        }

        @Override
        public Element getEnclosingElement() {
            return null;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Set.of(Modifier.PUBLIC);
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            return List.of();
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            return null;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return null;
        }
    }
}

