/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import com.fasterxml.jackson.annotation.JsonIgnore;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.util.Json;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Controller<T extends Controller<T>> {
    @NonNull
    protected UUID uuid;
    private PhoneNumber phoneNumber;
    @JsonIgnore
    protected ControllerSerializer serializer;
    @NonNull
    protected ClientType clientType;
    @NonNull
    protected List<String> alias;

    public abstract void serialize(boolean var1);

    public abstract void dispose();

    public ControllerSerializer serializer() {
        return this.serializer;
    }

    public T serializer(ControllerSerializer serializer) {
        this.serializer = serializer;
        return (T)this;
    }

    public Optional<PhoneNumber> phoneNumber() {
        return Optional.ofNullable(this.phoneNumber);
    }

    public T phoneNumber(@NonNull PhoneNumber phoneNumber) {
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        this.phoneNumber = phoneNumber;
        this.serializer.linkMetadata(this);
        return (T)this;
    }

    public Collection<String> alias() {
        return Collections.unmodifiableList(this.alias);
    }

    public void addAlias(@NonNull String entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.alias.add(entry);
    }

    public void removeAlias(@NonNull String entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.alias.remove(entry);
    }

    public void removeAlias() {
        this.alias.clear();
    }

    public String toJson() {
        return Json.writeValueAsString(this, true);
    }

    public void deleteSession() {
        this.serializer.deleteSession(this);
    }

    private static <T extends Controller<T>> List<String> $default$alias() {
        return new ArrayList<String>();
    }

    protected Controller(ControllerBuilder<T, ?, ?> b) {
        this.uuid = b.uuid;
        if (this.uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.phoneNumber = b.phoneNumber;
        this.serializer = b.serializer;
        this.clientType = b.clientType;
        if (this.clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        this.alias = b.alias$set ? b.alias$value : Controller.$default$alias();
        if (this.alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
    }

    @NonNull
    public UUID uuid() {
        return this.uuid;
    }

    @NonNull
    public ClientType clientType() {
        return this.clientType;
    }

    public static abstract class ControllerBuilder<T extends Controller<T>, C extends Controller<T>, B extends ControllerBuilder<T, C, B>> {
        private UUID uuid;
        private PhoneNumber phoneNumber;
        private ControllerSerializer serializer;
        private ClientType clientType;
        private boolean alias$set;
        private List<String> alias$value;

        public B uuid(@NonNull UUID uuid) {
            if (uuid == null) {
                throw new NullPointerException("uuid is marked non-null but is null");
            }
            this.uuid = uuid;
            return this.self();
        }

        public B phoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this.self();
        }

        @JsonIgnore
        public B serializer(ControllerSerializer serializer) {
            this.serializer = serializer;
            return this.self();
        }

        public B clientType(@NonNull ClientType clientType) {
            if (clientType == null) {
                throw new NullPointerException("clientType is marked non-null but is null");
            }
            this.clientType = clientType;
            return this.self();
        }

        public B alias(@NonNull List<String> alias) {
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            this.alias$value = alias;
            this.alias$set = true;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Controller.ControllerBuilder(uuid=" + this.uuid + ", phoneNumber=" + this.phoneNumber + ", serializer=" + this.serializer + ", clientType=" + this.clientType + ", alias$value=" + this.alias$value + ")";
        }
    }
}

