/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.controller.Controller;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.util.Smile;
import it.auties.whatsapp.util.Validate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.NonNull;

public class DefaultControllerSerializer
implements ControllerSerializer {
    private static final Path DEFAULT_DIRECTORY = Path.of(System.getProperty("user.home") + "/.whatsapp4j/", new String[0]);
    private static final String CHAT_PREFIX = "chat_";
    private static final ControllerSerializer DEFAULT_SERIALIZER = new DefaultControllerSerializer();
    private final Path baseDirectory;
    private final System.Logger logger;
    private final Map<UUID, CompletableFuture<Void>> attributeStoreSerializers;
    private LinkedList<UUID> cachedUuids;
    private LinkedList<PhoneNumber> cachedPhoneNumbers;

    public static ControllerSerializer instance() {
        return DEFAULT_SERIALIZER;
    }

    private DefaultControllerSerializer() {
        this(DEFAULT_DIRECTORY);
    }

    public DefaultControllerSerializer(@NonNull Path baseDirectory) {
        if (baseDirectory == null) {
            throw new NullPointerException("baseDirectory is marked non-null but is null");
        }
        this.baseDirectory = baseDirectory;
        this.logger = System.getLogger("DefaultSerializer");
        this.attributeStoreSerializers = new ConcurrentHashMap<UUID, CompletableFuture<Void>>();
        try {
            Files.createDirectories(baseDirectory, new FileAttribute[0]);
            Validate.isTrue(Files.isDirectory(baseDirectory, new LinkOption[0]), "Expected a directory as base path: %s", baseDirectory);
        }
        catch (IOException exception) {
            this.logger.log(System.Logger.Level.WARNING, "Cannot create base directory at %s: %s".formatted(baseDirectory, exception.getMessage()));
        }
    }

    @Override
    public LinkedList<UUID> listIds(@NonNull ClientType type) {
        LinkedList linkedList;
        block10: {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (this.cachedUuids != null) {
                return this.cachedUuids;
            }
            Stream<Path> walker = Files.walk(this.getHome(type), 1, new FileVisitOption[0]).sorted(Comparator.comparing(this::getLastModifiedTime));
            try {
                linkedList = this.cachedUuids = walker.map(this::parsePathAsId).flatMap(Optional::stream).collect(Collectors.toCollection(LinkedList::new));
                if (walker == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new UncheckedIOException("Cannot list known ids", exception);
                }
            }
            walker.close();
        }
        return linkedList;
    }

    @Override
    public LinkedList<PhoneNumber> listPhoneNumbers(@NonNull ClientType type) {
        LinkedList linkedList;
        block10: {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (this.cachedPhoneNumbers != null) {
                return this.cachedPhoneNumbers;
            }
            Stream<Path> walker = Files.walk(this.getHome(type), 1, new FileVisitOption[0]).sorted(Comparator.comparing(this::getLastModifiedTime));
            try {
                linkedList = this.cachedPhoneNumbers = walker.map(this::parsePathAsPhoneNumber).flatMap(Optional::stream).collect(Collectors.toCollection(LinkedList::new));
                if (walker == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new UncheckedIOException("Cannot list known ids", exception);
                }
            }
            walker.close();
        }
        return linkedList;
    }

    private FileTime getLastModifiedTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]);
        }
        catch (IOException exception) {
            return FileTime.fromMillis(0L);
        }
    }

    private Optional<UUID> parsePathAsId(Path file) {
        try {
            return Optional.of(UUID.fromString(file.getFileName().toString()));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    private Optional<PhoneNumber> parsePathAsPhoneNumber(Path file) {
        try {
            long longValue = Long.parseLong(file.getFileName().toString());
            return PhoneNumber.ofNullable(longValue);
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    @Override
    public void serializeKeys(Keys keys, boolean async) {
        if (this.cachedUuids != null && !this.cachedUuids.contains(keys.uuid())) {
            this.cachedUuids.add(keys.uuid());
        }
        Path path = this.getSessionFile(keys.clientType(), keys.uuid().toString(), "keys.smile");
        SmileFile preferences = SmileFile.of(path);
        preferences.write(keys, async);
    }

    @Override
    public void serializeStore(Store store, boolean async) {
        CompletableFuture<Void> task;
        if (this.cachedUuids != null && !this.cachedUuids.contains(store.uuid())) {
            this.cachedUuids.add(store.uuid());
        }
        PhoneNumber phoneNumber = store.phoneNumber().orElse(null);
        if (this.cachedPhoneNumbers != null && !this.cachedPhoneNumbers.contains(phoneNumber)) {
            this.cachedPhoneNumbers.add(phoneNumber);
        }
        if ((task = this.attributeStoreSerializers.get(store.uuid())) != null && !task.isDone()) {
            return;
        }
        Path path = this.getSessionFile(store, "store.smile");
        SmileFile preferences = SmileFile.of(path);
        preferences.write(store, async);
        if (async) {
            store.chats().forEach(chat -> this.serializeChat(store, (Chat)chat));
            return;
        }
        CompletableFuture[] futures = (CompletableFuture[])store.chats().stream().map(chat -> this.serializeChat(store, (Chat)chat)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
    }

    private CompletableFuture<Void> serializeChat(Store store, Chat chat) {
        Path path = this.getSessionFile(store, "%s%s.smile".formatted(CHAT_PREFIX, chat.jid().toString()));
        SmileFile preferences = SmileFile.of(path);
        return preferences.write(chat, true);
    }

    @Override
    public Optional<Keys> deserializeKeys(@NonNull ClientType type, UUID id) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.deserializeKeysFromId(type, id.toString());
    }

    @Override
    public Optional<Keys> deserializeKeys(@NonNull ClientType type, String alias) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Path file = this.getSessionDirectory(type, alias);
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeKeysFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot read %s".formatted(alias), exception);
        }
    }

    @Override
    public Optional<Keys> deserializeKeys(@NonNull ClientType type, long phoneNumber) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Path file = this.getSessionDirectory(type, String.valueOf(phoneNumber));
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeKeysFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot read %s".formatted(phoneNumber), exception);
        }
    }

    private Optional<Keys> deserializeKeysFromId(ClientType type, String id) {
        Path path = this.getSessionFile(type, id, "keys.smile");
        SmileFile preferences = SmileFile.of(path);
        Optional<Keys> result = preferences.read(Keys.class);
        result.ifPresent(entry -> entry.serializer(this));
        return result;
    }

    @Override
    public Optional<Store> deserializeStore(@NonNull ClientType type, UUID id) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.deserializeStoreFromId(type, id.toString());
    }

    @Override
    public Optional<Store> deserializeStore(@NonNull ClientType type, String alias) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Path file = this.getSessionDirectory(type, alias);
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeStoreFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot read %s".formatted(alias), exception);
        }
    }

    @Override
    public Optional<Store> deserializeStore(@NonNull ClientType type, long phoneNumber) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Path file = this.getSessionDirectory(type, String.valueOf(phoneNumber));
        if (Files.notExists(file, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return this.deserializeStoreFromId(type, Files.readString(file));
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot read %s".formatted(phoneNumber), exception);
        }
    }

    private Optional<Store> deserializeStoreFromId(ClientType type, String id) {
        Path path = this.getSessionFile(type, id, "store.smile");
        SmileFile preferences = SmileFile.of(path);
        Optional<Store> store = preferences.read(Store.class);
        store.ifPresent(entry -> entry.serializer(this));
        return store;
    }

    @Override
    public synchronized CompletableFuture<Void> attributeStore(Store store) {
        CompletableFuture<Void> completableFuture;
        block10: {
            CompletableFuture<Void> oldTask = this.attributeStoreSerializers.get(store.uuid());
            if (oldTask != null) {
                return oldTask;
            }
            Path directory = this.getSessionDirectory(store.clientType(), store.uuid().toString());
            if (Files.notExists(directory, new LinkOption[0])) {
                return CompletableFuture.completedFuture(null);
            }
            Stream<Path> walker = Files.walk(directory, new FileVisitOption[0]);
            try {
                CompletableFuture[] futures = (CompletableFuture[])walker.filter(entry -> entry.getFileName().toString().startsWith(CHAT_PREFIX)).map(entry -> CompletableFuture.runAsync(() -> this.deserializeChat(store, (Path)entry))).toArray(CompletableFuture[]::new);
                CompletableFuture<Void> result = CompletableFuture.allOf(futures);
                this.attributeStoreSerializers.put(store.uuid(), result);
                completableFuture = result;
                if (walker == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new UncheckedIOException("Cannot deserialize store", exception);
                }
            }
            walker.close();
        }
        return completableFuture;
    }

    @Override
    public void deleteSession(@NonNull Controller<?> controller) {
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        Path folderPath = this.getSessionDirectory(controller.clientType(), controller.uuid().toString());
        this.deleteDirectory(folderPath.toFile());
        PhoneNumber phoneNumber = controller.phoneNumber().orElse(null);
        if (phoneNumber == null) {
            return;
        }
        Path linkedFolderPath = this.getSessionDirectory(controller.clientType(), phoneNumber.toString());
        this.deleteDirectory(linkedFolderPath.toFile());
    }

    @Override
    public void linkMetadata(@NonNull Controller<?> controller) {
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        controller.phoneNumber().ifPresent(phoneNumber -> this.linkToUuid(controller.clientType(), controller.uuid(), phoneNumber.toString()));
        controller.alias().forEach(alias -> this.linkToUuid(controller.clientType(), controller.uuid(), (String)alias));
    }

    private void linkToUuid(ClientType type, UUID uuid, String string) {
        try {
            Path link = this.getSessionDirectory(type, string);
            Files.writeString(link, (CharSequence)uuid.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException exception) {
            this.logger.log(System.Logger.Level.WARNING, "Cannot link %s to %s".formatted(string, uuid), (Throwable)exception);
        }
    }

    private void deleteDirectory(File directory) {
        if (directory == null || !directory.exists()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            if (directory.delete()) {
                return;
            }
            this.logger.log(System.Logger.Level.WARNING, "Cannot delete folder %s".formatted(directory));
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.deleteDirectory(file);
                continue;
            }
            if (file.delete()) continue;
            this.logger.log(System.Logger.Level.WARNING, "Cannot delete file %s".formatted(directory));
        }
        if (directory.delete()) {
            return;
        }
        this.logger.log(System.Logger.Level.WARNING, "Cannot delete folder %s".formatted(directory));
    }

    private void deserializeChat(Store baseStore, Path entry) {
        SmileFile chatPreferences = SmileFile.of(entry);
        Chat chat = chatPreferences.read(Chat.class).orElseGet(() -> this.fixChat(entry));
        baseStore.addChatDirect(chat);
    }

    private Chat fixChat(Path entry) {
        String chatName = entry.getFileName().toString().replaceFirst(CHAT_PREFIX, "").replace(".smile", "");
        this.logger.log(System.Logger.Level.ERROR, "Chat at %s is corrupted, resetting it".formatted(chatName));
        try {
            Files.deleteIfExists(entry);
        }
        catch (IOException deleteException) {
            this.logger.log(System.Logger.Level.WARNING, "Cannot delete chat file");
        }
        return Chat.ofJid(ContactJid.of(chatName));
    }

    private Path getHome(ClientType type) {
        Path directory = this.baseDirectory.resolve(type == ClientType.MOBILE ? "mobile" : "web");
        if (!Files.exists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new UncheckedIOException("Cannot create directory", exception);
            }
        }
        return directory;
    }

    private Path getSessionDirectory(ClientType clientType, String uuid) {
        return this.getHome(clientType).resolve(uuid);
    }

    private Path getSessionFile(Store store, String fileName) {
        return this.getSessionFile(store.clientType(), store.uuid().toString(), fileName);
    }

    private Path getSessionFile(ClientType clientType, String uuid, String fileName) {
        return this.getSessionDirectory(clientType, uuid).resolve(fileName);
    }

    private record SmileFile(Path file, Semaphore semaphore) {
        private static final ConcurrentHashMap<Path, SmileFile> instances = new ConcurrentHashMap();
        private static final System.Logger logger = System.getLogger("SmileFile");

        private SmileFile {
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new UncheckedIOException("Cannot create smile file", exception);
            }
        }

        private static synchronized SmileFile of(@NonNull Path file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            SmileFile knownInstance = instances.get(file);
            if (knownInstance != null) {
                return knownInstance;
            }
            SmileFile instance = new SmileFile(file, new Semaphore(1));
            instances.put(file, instance);
            return instance;
        }

        private <T> Optional<T> read(final Class<T> clazz) {
            return this.read(new TypeReference<T>(){

                public Class<T> getType() {
                    return clazz;
                }
            });
        }

        private <T> Optional<T> read(TypeReference<T> reference) {
            Optional<T> optional;
            if (Files.notExists(this.file, new LinkOption[0])) {
                return Optional.empty();
            }
            GZIPInputStream input = new GZIPInputStream(Files.newInputStream(this.file, new OpenOption[0]));
            try {
                optional = Optional.of(Smile.readValue((InputStream)input, reference));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return Optional.empty();
                }
            }
            input.close();
            return optional;
        }

        private CompletableFuture<Void> write(Object input, boolean async) {
            if (!async) {
                this.writeSync(input);
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.runAsync(() -> this.writeSync(input)).exceptionallyAsync(throwable -> {
                logger.log(System.Logger.Level.ERROR, "Cannot serialize smile file", (Throwable)throwable);
                return null;
            });
        }

        private void writeSync(Object input) {
            try {
                if (input == null) {
                    return;
                }
                this.semaphore.acquire();
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                     GZIPOutputStream stream = new GZIPOutputStream(byteArrayOutputStream);){
                    Smile.writeValueAsBytes(stream, input);
                    Files.write(this.file, byteArrayOutputStream.toByteArray(), new OpenOption[0]);
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException("Cannot complete file write", exception);
            }
            catch (InterruptedException exception) {
                throw new RuntimeException("Cannot acquire lock", exception);
            }
            finally {
                this.semaphore.release();
            }
        }
    }
}

