/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.crypto.AesGmc;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Spec;
import java.util.Arrays;
import lombok.NonNull;

public class Handshake {
    private final Keys keys;
    private byte[] hash;
    private byte[] salt;
    private byte[] cryptoKey;
    private long counter;

    public Handshake(Keys keys) {
        this.keys = keys;
        this.hash = Spec.Whatsapp.PROTOCOL;
        this.salt = Spec.Whatsapp.PROTOCOL;
        this.cryptoKey = Spec.Whatsapp.PROTOCOL;
        this.counter = 0L;
        this.updateHash(keys.prologue());
    }

    public void updateHash(byte @NonNull [] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        byte[] input = BytesHelper.concat(this.hash, data);
        this.hash = Sha256.calculate(input);
    }

    public byte[] cipher(byte @NonNull [] bytes, boolean encrypt) {
        byte[] cyphered;
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        byte[] byArray = cyphered = encrypt ? AesGmc.encrypt(this.counter++, bytes, this.cryptoKey, this.hash) : AesGmc.decrypt(this.counter++, bytes, this.cryptoKey, this.hash);
        if (!encrypt) {
            this.updateHash(bytes);
            return cyphered;
        }
        this.updateHash(cyphered);
        return cyphered;
    }

    public void finish() {
        byte[] expanded = Hkdf.extractAndExpand(new byte[0], this.salt, null, 64);
        this.keys.writeKey(Arrays.copyOfRange(expanded, 0, 32));
        this.keys.readKey(Arrays.copyOfRange(expanded, 32, 64));
        this.dispose();
    }

    private void dispose() {
        this.hash = null;
        this.salt = null;
        this.cryptoKey = null;
        this.counter = 0L;
    }

    public void mixIntoKey(byte @NonNull [] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        byte[] expanded = Hkdf.extractAndExpand(bytes, this.salt, null, 64);
        this.salt = Arrays.copyOfRange(expanded, 0, 32);
        this.cryptoKey = Arrays.copyOfRange(expanded, 32, 64);
        this.counter = 0L;
    }
}

