/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public final class Hmac {
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private static final String HMAC_SHA_512 = "HmacSHA512";

    public static byte[] calculateSha256(byte @NonNull [] plain, byte @NonNull [] key) {
        if (plain == null) {
            throw new NullPointerException("plain is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Hmac.calculate(HMAC_SHA_256, plain, key);
    }

    private static byte[] calculate(String algorithm, byte[] plain, byte[] key) {
        Mac localMac = Mac.getInstance(algorithm);
        localMac.init(new SecretKeySpec(key, algorithm));
        return localMac.doFinal(plain);
    }

    public static byte[] calculateSha512(byte @NonNull [] plain, byte @NonNull [] key) {
        if (plain == null) {
            throw new NullPointerException("plain is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Hmac.calculate(HMAC_SHA_512, plain, key);
    }

    private Hmac() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

